/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.DocumentContext;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.SyntaxNodeAnalysisTask;
import io.ballerina.projects.SyntaxTreeVisitor;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class SyntaxNodeAnalysisTaskRunner {
    private final Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap;
    private final Package currentPackage;
    private final PackageCompilation compilation;

    public SyntaxNodeAnalysisTaskRunner(Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap, Package currentPackage, PackageCompilation compilation) {
        this.syntaxNodeAnalysisTaskMap = syntaxNodeAnalysisTaskMap;
        this.currentPackage = currentPackage;
        this.compilation = compilation;
    }

    List<Diagnostic> runTasks() {
        ArrayList<Diagnostic> reportedDiagnostics = new ArrayList<Diagnostic>();
        PackageContext packageContext = this.currentPackage.packageContext();
        for (ModuleId moduleId : packageContext.moduleIds()) {
            this.runTasks(packageContext.moduleContext(moduleId), reportedDiagnostics);
        }
        return reportedDiagnostics;
    }

    private void runTasks(ModuleContext moduleContext, List<Diagnostic> reportedDiagnostics) {
        for (DocumentId srcDocumentId : moduleContext.srcDocumentIds()) {
            DocumentContext documentContext = moduleContext.documentContext(srcDocumentId);
            this.runTasks(documentContext.syntaxTree(), moduleContext.moduleId(), srcDocumentId, reportedDiagnostics);
        }
        for (DocumentId testSrcDocumentId : moduleContext.testSrcDocumentIds()) {
            DocumentContext testSrcDocumentContext = moduleContext.documentContext(testSrcDocumentId);
            this.runTasks(testSrcDocumentContext.syntaxTree(), moduleContext.moduleId(), testSrcDocumentId, reportedDiagnostics);
        }
    }

    private void runTasks(SyntaxTree syntaxTree, ModuleId moduleId, DocumentId documentId, List<Diagnostic> reportedDiagnostics) {
        SyntaxTreeVisitor syntaxTreeVisitor = new SyntaxTreeVisitor(this.syntaxNodeAnalysisTaskMap, this.currentPackage, this.compilation, moduleId, documentId, syntaxTree, this.compilation.getSemanticModel(moduleId));
        reportedDiagnostics.addAll(syntaxTreeVisitor.runAnalysisTasks());
    }
}

