/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.SyntaxNodeAnalysisContextImpl;
import io.ballerina.projects.SyntaxNodeAnalysisTask;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class SyntaxTreeVisitor
extends NodeVisitor {
    private final Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap;
    private final Package currentPackage;
    private final PackageCompilation compilation;
    private final ModuleId moduleId;
    private final DocumentId documentId;
    private final SyntaxTree syntaxTree;
    private final SemanticModel semanticModel;
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    SyntaxTreeVisitor(Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap, Package currentPackage, PackageCompilation compilation, ModuleId moduleId, DocumentId documentId, SyntaxTree syntaxTree, SemanticModel semanticModel) {
        this.syntaxNodeAnalysisTaskMap = syntaxNodeAnalysisTaskMap;
        this.currentPackage = currentPackage;
        this.compilation = compilation;
        this.moduleId = moduleId;
        this.documentId = documentId;
        this.syntaxTree = syntaxTree;
        this.semanticModel = semanticModel;
    }

    List<Diagnostic> runAnalysisTasks() {
        ModulePartNode modulePartNode = (ModulePartNode)this.syntaxTree.rootNode();
        this.visit(modulePartNode);
        return this.diagnostics;
    }

    protected void visitSyntaxNode(Node node) {
        if (node instanceof Token) {
            return;
        }
        SyntaxKind syntaxKind = node.kind();
        if (this.syntaxNodeAnalysisTaskMap.containsKey(syntaxKind)) {
            this.runAnalysisTasks(node, this.syntaxNodeAnalysisTaskMap.get(syntaxKind));
        }
        NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
        for (Node child : nonTerminalNode.children()) {
            child.accept((NodeVisitor)this);
        }
    }

    private void runAnalysisTasks(Node node, List<SyntaxNodeAnalysisTask> syntaxNodeAnalysisTasks) {
        for (SyntaxNodeAnalysisTask syntaxNodeAnalysisTask : syntaxNodeAnalysisTasks) {
            SyntaxNodeAnalysisContextImpl analysisContext = new SyntaxNodeAnalysisContextImpl(node, this.moduleId, this.documentId, this.syntaxTree, this.semanticModel, this.currentPackage, this.compilation);
            syntaxNodeAnalysisTask.perform(analysisContext);
            this.diagnostics.addAll(analysisContext.reportedDiagnostics());
        }
    }
}

