/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.buildtools;

import io.ballerina.projects.Package;
import io.ballerina.projects.PackageManifest;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ToolContext {
    private final Package currentPackage;
    private final String toolId;
    private final String filePath;
    private final String targetModule;
    private final Map<String, Option> options;
    private final String type;
    private final PrintStream printStream;
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    ToolContext(Package currentPackage, String toolId, String filePath, String targetModule, TomlTableNode optionsTable, String type, PrintStream printStream) {
        this.currentPackage = currentPackage;
        this.toolId = toolId;
        this.filePath = filePath;
        this.targetModule = targetModule;
        this.options = this.getOptions(optionsTable);
        this.type = type;
        this.printStream = printStream;
    }

    public static ToolContext from(PackageManifest.Tool tool, Package currentPackage, PrintStream printStream) {
        return new ToolContext(currentPackage, tool.id().value(), tool.filePath().value(), tool.targetModule().value(), tool.optionsTable(), tool.type().value(), printStream);
    }

    public String toolId() {
        return this.toolId;
    }

    public String filePath() {
        return this.filePath;
    }

    public String targetModule() {
        return this.targetModule;
    }

    public Map<String, Option> options() {
        return this.options;
    }

    public String type() {
        return this.type;
    }

    public Path cachePath() {
        Path sourceRoot = this.currentPackage.project().sourceRoot();
        return sourceRoot.resolve("target").resolve("tool-cache").resolve(this.toolId);
    }

    public Path outputPath() {
        Path sourceRoot = this.currentPackage.project().sourceRoot();
        if (this.targetModule == null || this.targetModule.isEmpty()) {
            return sourceRoot.resolve("generated");
        }
        return sourceRoot.resolve("generated").resolve(this.targetModule);
    }

    public Package currentPackage() {
        return this.currentPackage;
    }

    public List<Diagnostic> diagnostics() {
        return this.diagnostics;
    }

    public void reportDiagnostic(Diagnostic diagnostic) {
        this.diagnostics.add(diagnostic);
    }

    public void println(String message) {
        this.printStream.printf("\t\t%s%n", message);
    }

    private Map<String, Option> getOptions(TomlTableNode optionsTable) {
        HashMap<String, Option> options = new HashMap<String, Option>();
        if (null == optionsTable) {
            return options;
        }
        for (String option : optionsTable.entries().keySet()) {
            options.put(option, new Option((TopLevelNode)optionsTable.entries().get(option)));
        }
        return options;
    }

    public static class Option {
        private final Object value;
        private final TomlNodeLocation location;

        public Option(TopLevelNode optionNode) {
            this.value = optionNode.toNativeObject();
            this.location = optionNode.location();
        }

        public Object value() {
            return this.value;
        }

        public TomlNodeLocation location() {
            return this.location;
        }
    }
}

