/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.directory;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.bala.BalaProject;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.repos.TempDirCompilationCache;
import io.ballerina.projects.util.ProjectPaths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;

public final class ProjectLoader {
    private ProjectLoader() {
    }

    public static Project loadProject(Path path) {
        return ProjectLoader.loadProject(path, ProjectEnvironmentBuilder.getDefaultBuilder(), BuildOptions.builder().build());
    }

    public static Project loadProject(Path path, BuildOptions buildOptions) {
        return ProjectLoader.loadProject(path, ProjectEnvironmentBuilder.getDefaultBuilder(), buildOptions);
    }

    public static Project loadProject(Path path, ProjectEnvironmentBuilder projectEnvironmentBuilder) {
        return ProjectLoader.loadProject(path, projectEnvironmentBuilder, BuildOptions.builder().build());
    }

    public static Project loadProject(Path path, ProjectEnvironmentBuilder projectEnvironmentBuilder, BuildOptions buildOptions) throws ProjectException {
        Path projectRoot;
        Path absFilePath = Optional.of(path.toAbsolutePath()).get();
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ProjectException("provided file path does not exist");
        }
        if (absFilePath.toFile().isDirectory()) {
            Path projectRoot2 = "modules".equals(Optional.of(absFilePath.getParent()).get().toFile().getName()) ? Optional.of(Optional.of(absFilePath.getParent()).get().getParent()).get() : ("generated".equals(absFilePath.toFile().getName()) ? Optional.of(absFilePath.getParent()).get() : ("generated".equals(Optional.of(absFilePath.getParent()).get().toFile().getName()) ? Optional.of(Optional.of(absFilePath.getParent()).get().getParent()).get() : absFilePath));
            if (Files.exists(projectRoot2.resolve("Ballerina.toml"), new LinkOption[0])) {
                return BuildProject.load(projectEnvironmentBuilder, projectRoot2, buildOptions);
            }
            if (Files.exists(projectRoot2.resolve("package.json"), new LinkOption[0])) {
                projectEnvironmentBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
                return BalaProject.loadProject(projectEnvironmentBuilder, projectRoot2, buildOptions);
            }
            throw new ProjectException("provided directory does not belong to any supported project types");
        }
        if (absFilePath.toString().endsWith(".bala")) {
            projectEnvironmentBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
            return BalaProject.loadProject(projectEnvironmentBuilder, absFilePath);
        }
        if (!ProjectPaths.isBalFile(absFilePath)) {
            throw new ProjectException("'" + String.valueOf(absFilePath) + "' is not a valid Ballerina source file");
        }
        try {
            projectRoot = ProjectPaths.packageRoot(absFilePath);
        }
        catch (ProjectException e) {
            return SingleFileProject.load(projectEnvironmentBuilder, path, buildOptions);
        }
        try {
            return BuildProject.load(projectEnvironmentBuilder, projectRoot, buildOptions);
        }
        catch (ProjectException e) {
            projectEnvironmentBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
            return BalaProject.loadProject(projectEnvironmentBuilder, projectRoot);
        }
    }
}

