/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.directory;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.PackageConfigCreator;
import io.ballerina.projects.repos.TempDirCompilationCache;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public class SingleFileProject
extends Project {
    private Path targetDir;

    public static SingleFileProject load(ProjectEnvironmentBuilder environmentBuilder, Path filePath) {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        return SingleFileProject.load(environmentBuilder, filePath, buildOptionsBuilder.build());
    }

    public static SingleFileProject load(ProjectEnvironmentBuilder environmentBuilder, Path filePath, BuildOptions buildOptions) {
        PackageConfig packageConfig = PackageConfigCreator.createSingleFileProjectConfig(filePath);
        SingleFileProject singleFileProject = new SingleFileProject(environmentBuilder, filePath, buildOptions);
        singleFileProject.addPackage(packageConfig);
        return singleFileProject;
    }

    public static SingleFileProject load(Path filePath) {
        return SingleFileProject.load(filePath, BuildOptions.builder().build());
    }

    public static SingleFileProject load(Path filePath, BuildOptions buildOptions) {
        PackageConfig packageConfig = PackageConfigCreator.createSingleFileProjectConfig(filePath, buildOptions.disableSyntaxTree());
        ProjectEnvironmentBuilder environmentBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        SingleFileProject singleFileProject = new SingleFileProject(environmentBuilder, filePath, buildOptions);
        singleFileProject.addPackage(packageConfig);
        return singleFileProject;
    }

    private SingleFileProject(ProjectEnvironmentBuilder environmentBuilder, Path filePath, BuildOptions buildOptions) {
        super(ProjectKind.SINGLE_FILE_PROJECT, filePath, environmentBuilder, buildOptions);
        try {
            this.targetDir = Files.createTempDirectory("ballerina-cache" + System.nanoTime(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.populateCompilerContext();
    }

    @Override
    public void clearCaches() {
        this.resetPackage(this);
        ProjectEnvironmentBuilder projectEnvironmentBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        projectEnvironmentBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
        this.projectEnvironment = projectEnvironmentBuilder.build(this);
    }

    @Override
    public Project duplicate() {
        BuildOptions duplicateBuildOptions = BuildOptions.builder().build().acceptTheirs(this.buildOptions());
        SingleFileProject singleFileProject = new SingleFileProject(ProjectEnvironmentBuilder.getDefaultBuilder(), this.sourceRoot, duplicateBuildOptions);
        return this.resetPackage(singleFileProject);
    }

    @Override
    public DocumentId documentId(Path file) {
        if (!this.sourceRoot.toAbsolutePath().normalize().toString().equals(file.toAbsolutePath().normalize().toString())) {
            throw new ProjectException("'" + String.valueOf(file) + "' does not belong to the current project");
        }
        return this.currentPackage().getDefaultModule().documentIds().iterator().next();
    }

    @Override
    public Optional<Path> documentPath(DocumentId documentId) {
        if (this.currentPackage().getDefaultModule().documentIds().iterator().next().equals(documentId)) {
            return Optional.of(this.sourceRoot.toAbsolutePath());
        }
        return Optional.empty();
    }

    @Override
    public void save() {
    }

    @Override
    public Path targetDir() {
        return this.targetDir;
    }

    @Override
    public Path generatedResourcesDir() {
        Path generatedResourcesPath = this.targetDir.resolve("resources");
        if (!Files.exists(generatedResourcesPath, new LinkOption[0])) {
            try {
                Files.createDirectories(generatedResourcesPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return generatedResourcesPath;
    }
}

