/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.environment;

import io.ballerina.projects.DependencyResolutionType;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.environment.PackageLockingMode;
import java.util.Objects;
import java.util.Optional;

public final class ResolutionRequest {
    private final PackageDescriptor packageDesc;
    private final PackageDependencyScope scope;
    private final DependencyResolutionType dependencyResolutionType;
    private final PackageLockingMode packageLockingMode;

    private ResolutionRequest(PackageDescriptor packageDescriptor, PackageDependencyScope scope, DependencyResolutionType dependencyResolutionType, PackageLockingMode packageLockingMode) {
        this.packageDesc = packageDescriptor;
        this.scope = scope;
        this.dependencyResolutionType = dependencyResolutionType;
        this.packageLockingMode = packageLockingMode;
    }

    public static ResolutionRequest from(PackageDescriptor packageDescriptor) {
        return new ResolutionRequest(packageDescriptor, PackageDependencyScope.DEFAULT, DependencyResolutionType.SOURCE, PackageLockingMode.MEDIUM);
    }

    public static ResolutionRequest from(PackageDescriptor packageDescriptor, PackageDependencyScope scope) {
        return new ResolutionRequest(packageDescriptor, scope, DependencyResolutionType.SOURCE, PackageLockingMode.MEDIUM);
    }

    public static ResolutionRequest from(PackageDescriptor packageDescriptor, PackageDependencyScope scope, DependencyResolutionType resolutionType) {
        return new ResolutionRequest(packageDescriptor, scope, resolutionType, PackageLockingMode.MEDIUM);
    }

    public static ResolutionRequest from(PackageDescriptor packageDescriptor, PackageDependencyScope scope, DependencyResolutionType dependencyResolutionType, PackageLockingMode packageLockingMode) {
        return new ResolutionRequest(packageDescriptor, scope, dependencyResolutionType, packageLockingMode);
    }

    public PackageOrg orgName() {
        return this.packageDesc.org();
    }

    public PackageName packageName() {
        return this.packageDesc.name();
    }

    public Optional<PackageVersion> version() {
        return Optional.ofNullable(this.packageDesc.version());
    }

    public PackageDescriptor packageDescriptor() {
        return this.packageDesc;
    }

    public PackageDependencyScope scope() {
        return this.scope;
    }

    public Optional<String> repositoryName() {
        return this.packageDesc.repository();
    }

    public PackageLockingMode packageLockingMode() {
        return this.packageLockingMode;
    }

    public DependencyResolutionType resolutionType() {
        return this.dependencyResolutionType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResolutionRequest that = (ResolutionRequest)other;
        return Objects.equals(this.packageDesc, that.packageDesc);
    }

    public int hashCode() {
        return Objects.hash(this.packageDesc);
    }
}

