/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Diagnostics;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.ManifestUtils;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.internal.model.BalToolDescriptor;
import io.ballerina.projects.internal.model.CompilerPluginDescriptor;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlArrayValueNode;
import io.ballerina.toml.semantic.ast.TomlBooleanValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.validator.TomlValidator;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.ballerinalang.compiler.CompilerOptionName;

public class ManifestBuilder {
    private final TomlDocument ballerinaToml;
    private final TomlDocument compilerPluginToml;
    private final TomlDocument balToolToml;
    private DiagnosticResult diagnostics;
    private final List<Diagnostic> diagnosticList;
    private final PackageManifest packageManifest;
    private final BuildOptions buildOptions;
    private final Path projectPath;
    Set<String> toolIdsSet = new HashSet<String>();
    Set<String> targetModuleSet = new HashSet<String>();
    private static final String PACKAGE = "package";
    private static final String VERSION = "version";
    public static final String ORG = "org";
    public static final String NAME = "name";
    private static final String LICENSE = "license";
    private static final String AUTHORS = "authors";
    private static final String REPOSITORY = "repository";
    private static final String KEYWORDS = "keywords";
    private static final String EXPORT = "export";
    private static final String INCLUDE = "include";
    private static final String PLATFORM = "platform";
    private static final String SCOPE = "scope";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String GROUP_ID = "groupId";
    private static final String PATH = "path";
    private static final String TEMPLATE = "template";
    public static final String ICON = "icon";
    public static final String GRAALVM_COMPATIBLE = "graalvmCompatible";
    public static final String DISTRIBUTION = "distribution";
    public static final String VISIBILITY = "visibility";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String URL = "url";
    private static final String DEPENDENCY = "dependency";
    private static final String ID = "id";
    private static final String TARGETMODULE = "targetModule";
    private static final String OPTIONS = "options";
    private static final String TOOL = "tool";
    private static final String DESCRIPTION = "description";
    private static final String README = "readme";
    private boolean isOldStructure;

    private ManifestBuilder(TomlDocument ballerinaToml, TomlDocument compilerPluginToml, TomlDocument balToolToml, Path projectPath) {
        this.projectPath = projectPath;
        this.ballerinaToml = ballerinaToml;
        this.compilerPluginToml = compilerPluginToml;
        this.balToolToml = balToolToml;
        this.diagnosticList = new ArrayList<Diagnostic>();
        this.packageManifest = this.parseAsPackageManifest();
        this.buildOptions = this.parseBuildOptions();
    }

    public static ManifestBuilder from(TomlDocument ballerinaToml, TomlDocument compilerPluginToml, TomlDocument balToolToml, Path projectPath) {
        return new ManifestBuilder(ballerinaToml, compilerPluginToml, balToolToml, projectPath);
    }

    public DiagnosticResult diagnostics() {
        if (this.diagnostics != null) {
            return this.diagnostics;
        }
        this.diagnosticList.addAll(this.ballerinaToml.toml().diagnostics());
        this.diagnostics = new DefaultDiagnosticResult(this.diagnosticList);
        return this.diagnostics;
    }

    public String getErrorMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Ballerina.toml contains errors\n");
        for (Diagnostic diagnostic : this.diagnostics().errors()) {
            message.append(ManifestUtils.convertDiagnosticToString(diagnostic));
            message.append("\n");
        }
        return message.toString();
    }

    public PackageManifest packageManifest() {
        return this.packageManifest;
    }

    public BuildOptions buildOptions() {
        return this.buildOptions;
    }

    private PackageManifest parseAsPackageManifest() {
        TopLevelNode topLevelPkgNode;
        TomlValidator ballerinaTomlValidator;
        try {
            ballerinaTomlValidator = new TomlValidator(Schema.from((String)FileUtils.readFileAsString("ballerina-toml-schema.json")));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the Ballerina.toml validator schema file.");
        }
        ballerinaTomlValidator.validate(this.ballerinaToml.toml());
        TomlTableNode tomlAstNode = this.ballerinaToml.toml().rootNode();
        PackageDescriptor packageDescriptor = this.getPackageDescriptor(tomlAstNode);
        List<String> license = Collections.emptyList();
        List<String> authors = Collections.emptyList();
        List<String> keywords = Collections.emptyList();
        List<String> exported = Collections.emptyList();
        List<String> includes = Collections.emptyList();
        String repository = "";
        String ballerinaVersion = "";
        String visibility = "";
        boolean template = false;
        String icon = "";
        String readme = null;
        String description = "";
        List<PackageManifest.Module> moduleEntries = new ArrayList<PackageManifest.Module>();
        if (!tomlAstNode.entries().isEmpty() && (topLevelPkgNode = (TopLevelNode)tomlAstNode.entries().get(PACKAGE)) != null && topLevelPkgNode.kind() == TomlType.TABLE) {
            TomlTableNode pkgNode = (TomlTableNode)topLevelPkgNode;
            license = this.getStringArrayFromPackageNode(pkgNode, LICENSE);
            authors = this.getStringArrayFromPackageNode(pkgNode, AUTHORS);
            keywords = this.getStringArrayFromPackageNode(pkgNode, KEYWORDS);
            exported = this.getStringArrayFromPackageNode(pkgNode, EXPORT);
            includes = this.getStringArrayFromPackageNode(pkgNode, INCLUDE);
            repository = ManifestBuilder.getStringValueFromTomlTableNode(pkgNode, REPOSITORY, "");
            ballerinaVersion = ManifestBuilder.getStringValueFromTomlTableNode(pkgNode, DISTRIBUTION, "");
            visibility = ManifestBuilder.getStringValueFromTomlTableNode(pkgNode, VISIBILITY, "");
            template = this.getBooleanFromTemplateNode(pkgNode, TEMPLATE);
            icon = ManifestBuilder.getStringValueFromTomlTableNode(pkgNode, ICON, "");
            this.validateIconPathForPng(icon, pkgNode);
            String customReadmeVal = ManifestBuilder.getStringValueFromTomlTableNode(pkgNode, README, null);
            readme = this.validateAndGetReadmePath(pkgNode, customReadmeVal, packageDescriptor.name());
            description = ManifestBuilder.getStringValueFromTomlTableNode(pkgNode, DESCRIPTION, "");
            moduleEntries = this.getModuleEntries(pkgNode, customReadmeVal, packageDescriptor.name());
            if (!exported.isEmpty()) {
                this.reportDiagnostic((TopLevelNode)pkgNode.entries().get(EXPORT), "'export' under [package] is deprecated. Add the exports using the 'export' field under '[[package.modules]]'", ProjectDiagnosticErrorCode.DEPRECATED_BALLERINA_TOML_ENTRY, DiagnosticSeverity.WARNING);
            }
            if (!this.isOldStructure) {
                if (!exported.contains(packageDescriptor.name().toString())) {
                    exported.add(packageDescriptor.name().toString());
                }
                for (PackageManifest.Module moduleEntry : moduleEntries) {
                    String name;
                    if (!moduleEntry.export() || exported.contains(name = moduleEntry.name())) continue;
                    exported.add(name);
                }
            }
        }
        HashMap<String, Object> otherEntries = new HashMap<String, Object>();
        if (!tomlAstNode.entries().isEmpty()) {
            Map tomlMap = this.ballerinaToml.toml().toMap();
            for (Map.Entry entry : tomlMap.entrySet()) {
                if (((String)entry.getKey()).equals(PACKAGE) || ((String)entry.getKey()).equals(PLATFORM)) continue;
                otherEntries.put((String)entry.getKey(), entry.getValue());
            }
        }
        TopLevelNode platformNode = (TopLevelNode)tomlAstNode.entries().get(PLATFORM);
        Map<String, PackageManifest.Platform> platforms = this.getPlatforms(platformNode);
        List<PackageManifest.Dependency> localRepoDependencies = this.getLocalRepoDependencies();
        List<PackageManifest.Tool> tools = this.getTools();
        CompilerPluginDescriptor pluginDescriptor = null;
        if (this.compilerPluginToml != null) {
            pluginDescriptor = CompilerPluginDescriptor.from(this.compilerPluginToml);
        }
        BalToolDescriptor balToolDescriptor = null;
        if (this.balToolToml != null) {
            balToolDescriptor = BalToolDescriptor.from(this.balToolToml, this.projectPath);
        }
        return PackageManifest.from(packageDescriptor, pluginDescriptor, balToolDescriptor, platforms, localRepoDependencies, otherEntries, this.diagnostics(), license, authors, keywords, exported, includes, repository, ballerinaVersion, visibility, template, icon, tools, readme, description, moduleEntries);
    }

    private List<PackageManifest.Module> getModuleEntries(TomlTableNode pkgNode, String customReadmeVal, PackageName packageName) {
        Map<String, Path> moduleDirs;
        TopLevelNode dependencyEntries = this.validateAndGetModuleNodes(pkgNode, packageName);
        ArrayList<PackageManifest.Module> moduleList = new ArrayList<PackageManifest.Module>();
        Path modulesRoot = this.projectPath.resolve("modules");
        if (!Files.exists(modulesRoot, new LinkOption[0])) {
            return moduleList;
        }
        try (Stream<Path> stream = Files.walk(modulesRoot, 1, new FileVisitOption[0]);){
            moduleDirs = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !path.equals(modulesRoot)).collect(Collectors.toMap(path -> Optional.of(path.getFileName()).get().toString(), path -> path));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the module README:", e);
        }
        if (customReadmeVal == null && Files.exists(this.projectPath.resolve("Package.md"), new LinkOption[0])) {
            for (Map.Entry<String, Path> pathEntry : moduleDirs.entrySet()) {
                Path path2 = pathEntry.getValue().resolve("Module.md");
                String modReadme = null;
                if (Files.exists(path2, new LinkOption[0])) {
                    modReadme = Paths.get("modules", new String[0]).resolve(pathEntry.getKey()).resolve("Module.md").toString();
                }
                PackageManifest.Module module = new PackageManifest.Module(String.valueOf(packageName) + "." + String.valueOf(Optional.of(pathEntry.getValue().getFileName()).get()), false, "", modReadme);
                moduleList.add(module);
            }
            return moduleList;
        }
        if (dependencyEntries == null || dependencyEntries.kind() == TomlType.NONE) {
            for (Map.Entry<String, Path> pathEntry : moduleDirs.entrySet()) {
                Path path3 = pathEntry.getValue().resolve("README.md");
                String modReadme = "";
                if (Files.exists(path3, new LinkOption[0])) {
                    modReadme = Paths.get("modules", new String[0]).resolve(pathEntry.getKey()).resolve("README.md").toString();
                }
                PackageManifest.Module module = new PackageManifest.Module(String.valueOf(packageName) + "." + String.valueOf(Optional.of(pathEntry.getValue().getFileName()).get()), false, "", modReadme);
                moduleList.add(module);
            }
            return moduleList;
        }
        if (dependencyEntries.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode dependencyTableArray = (TomlTableArrayNode)dependencyEntries;
            for (TomlTableNode tomlTableNode : dependencyTableArray.children()) {
                String moduleName = ManifestBuilder.getStringValueFromTomlTableNode(tomlTableNode, NAME, null);
                if (moduleName == null || !moduleName.contains(".")) continue;
                String moduleNamepart = moduleName.substring(packageName.toString().length() + 1);
                boolean export = Boolean.TRUE.equals(this.getBooleanValueFromTomlTableNode(tomlTableNode, EXPORT));
                String description = ManifestBuilder.getStringValueFromTomlTableNode(tomlTableNode, DESCRIPTION, null);
                String modReadme = ManifestBuilder.getStringValueFromTomlTableNode(tomlTableNode, README, null);
                if (modReadme == null) {
                    Path defaultReadme = modulesRoot.resolve(moduleNamepart).resolve("README.md");
                    if (Files.exists(defaultReadme, new LinkOption[0])) {
                        modReadme = defaultReadme.toString();
                    }
                } else if (!Paths.get(modReadme, new String[0]).isAbsolute()) {
                    modReadme = this.projectPath.resolve(modReadme).toString();
                }
                PackageManifest.Module module = new PackageManifest.Module(moduleName, export, description, modReadme);
                moduleList.add(module);
                moduleDirs.remove(moduleNamepart);
            }
            for (Map.Entry entry : moduleDirs.entrySet()) {
                Path modReadmePath = ((Path)entry.getValue()).resolve("README.md");
                String modReadme = "";
                if (Files.exists(modReadmePath, new LinkOption[0])) {
                    modReadme = modReadmePath.toString();
                }
                PackageManifest.Module module = new PackageManifest.Module(String.valueOf(packageName) + "." + String.valueOf(Optional.of(((Path)entry.getValue()).getFileName()).get()), false, "", modReadme);
                moduleList.add(module);
            }
        }
        return moduleList;
    }

    private TopLevelNode validateAndGetModuleNodes(TomlTableNode pkgNode, PackageName packageName) {
        TopLevelNode dependencyEntries = (TopLevelNode)pkgNode.entries().get("modules");
        if (dependencyEntries != null && dependencyEntries.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode dependencyTableArray = (TomlTableArrayNode)dependencyEntries;
            for (TomlTableNode modulesNode : dependencyTableArray.children()) {
                String warning;
                String moduleName = ManifestBuilder.getStringValueFromTomlTableNode(modulesNode, NAME, null);
                if (moduleName == null) continue;
                if (moduleName.equals(packageName.toString())) {
                    warning = "module '" + moduleName + "' is not allowed\n";
                    this.reportDiagnostic((TopLevelNode)modulesNode.entries().get(NAME), warning, ProjectDiagnosticErrorCode.INVALID_MODULE, DiagnosticSeverity.ERROR);
                    continue;
                }
                try {
                    if (!Files.notExists(this.projectPath.resolve("modules").resolve(moduleName.split(String.valueOf(packageName) + ".")[1]), new LinkOption[0])) continue;
                    warning = "module '" + moduleName + "' not found";
                    this.reportDiagnostic((TopLevelNode)modulesNode.entries().get(NAME), warning, ProjectDiagnosticErrorCode.INVALID_MODULE, DiagnosticSeverity.ERROR);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    String warning2 = "module '" + moduleName + "' not found";
                    this.reportDiagnostic((TopLevelNode)modulesNode.entries().get(NAME), warning2, ProjectDiagnosticErrorCode.INVALID_MODULE, DiagnosticSeverity.ERROR);
                }
            }
        }
        return dependencyEntries;
    }

    private String validateAndGetReadmePath(TomlTableNode pkgNode, String readme, PackageName name) {
        if (readme == null) {
            Path readmeMdPath = this.projectPath.resolve("Package.md");
            if (Files.exists(readmeMdPath, new LinkOption[0])) {
                String warning = "The default file for package documentation is changed to README.md. If you prefer to use the Package.md, add the following line under the '[package]' section in your Ballerina.toml file:\n\treadme = \"Package.md\"\n";
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.DEPRECATED_DOC_FILE.diagnosticId(), warning, DiagnosticSeverity.WARNING);
                PackageDiagnostic packageDiagnostic = new PackageDiagnostic(diagnosticInfo, name.toString());
                ProjectUtils.addMiscellaneousProjectDiagnostics(packageDiagnostic);
                this.isOldStructure = true;
                return readmeMdPath.toString();
            }
            readmeMdPath = this.projectPath.resolve("README.md");
            if (Files.exists(readmeMdPath, new LinkOption[0])) {
                return readmeMdPath.toString();
            }
            return null;
        }
        Path readmeMdPath = Paths.get(readme, new String[0]);
        if (!readmeMdPath.isAbsolute()) {
            readmeMdPath = this.projectPath.resolve(readmeMdPath);
        }
        if (Files.notExists(readmeMdPath, new LinkOption[0])) {
            this.reportDiagnostic((TopLevelNode)pkgNode.entries().get(README), "could not locate the readme file '" + String.valueOf(readmeMdPath) + "'", ProjectDiagnosticErrorCode.INVALID_PATH, DiagnosticSeverity.ERROR);
        }
        if (!FilenameUtils.getExtension((String)readme).equals("md")) {
            this.reportDiagnostic((TopLevelNode)pkgNode.entries().get(README), "invalid 'readme' under [package]: 'readme' can only have '.md' files", ProjectDiagnosticErrorCode.INVALID_FILE_FORMAT, DiagnosticSeverity.ERROR);
        }
        return readmeMdPath.toString();
    }

    private List<PackageManifest.Tool> getTools() {
        TomlTableNode rootNode = this.ballerinaToml.toml().rootNode();
        if (rootNode.entries().isEmpty()) {
            return Collections.emptyList();
        }
        TopLevelNode toolEntries = (TopLevelNode)rootNode.entries().get(TOOL);
        ArrayList<PackageManifest.Tool> tools = new ArrayList<PackageManifest.Tool>();
        if (toolEntries == null || toolEntries.kind() != TomlType.TABLE) {
            return Collections.emptyList();
        }
        TomlTableNode toolTable = (TomlTableNode)toolEntries;
        Set toolCodes = toolTable.entries().keySet();
        for (String toolCode : toolCodes) {
            this.addToolAndSubTools(tools, toolCode, (TopLevelNode)toolTable.entries().get(toolCode), "");
        }
        return tools;
    }

    private void addToolAndSubTools(List<PackageManifest.Tool> tools, String toolCode, TopLevelNode toolCodeNode, String toolCodePrefix) {
        if (toolCodeNode.kind() == TomlType.TABLE) {
            TomlTableNode toolEntry = (TomlTableNode)toolCodeNode;
            this.addSubTools(tools, toolEntry, toolCode, toolCodePrefix);
        } else if (toolCodeNode.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode toolEntriesArray = (TomlTableArrayNode)toolCodeNode;
            for (TomlTableNode toolEntry : toolEntriesArray.children()) {
                this.addSubTools(tools, toolEntry, toolCode, toolCodePrefix);
                this.addTool(tools, toolEntry, toolCode, toolCodePrefix);
            }
        }
    }

    private void addSubTools(List<PackageManifest.Tool> tools, TomlTableNode toolEntry, String toolCode, String toolCodePrefix) {
        if (toolEntry.entries().isEmpty()) {
            return;
        }
        Set toolFields = toolEntry.entries().keySet();
        for (String field : toolFields) {
            if (field.equals(OPTIONS) || field.equals(ID) || field.equals(VERSION) || field.equals(TARGETMODULE) || field.equals("filePath")) continue;
            this.addToolAndSubTools(tools, field, (TopLevelNode)toolEntry.entries().get(field), toolCodePrefix + toolCode + ".");
        }
    }

    private void addTool(List<PackageManifest.Tool> tools, TomlTableNode toolEntry, String toolCode, String toolCodePrefix) {
        PackageManifest.Tool.Field id = this.getValueFromPreBuildToolNode(toolEntry, ID, toolCode);
        PackageManifest.Tool.Field filePath = this.getValueFromPreBuildToolNode(toolEntry, "filePath", toolCode);
        PackageManifest.Tool.Field targetModule = this.getValueFromPreBuildToolNode(toolEntry, TARGETMODULE, toolCode);
        Toml optionsToml = this.getToml(toolEntry, OPTIONS);
        TopLevelNode topLevelNode = (TopLevelNode)toolEntry.entries().get(OPTIONS);
        TomlTableNode optionsNode = null;
        if (topLevelNode != null && topLevelNode.kind() == TomlType.TABLE) {
            optionsNode = (TomlTableNode)topLevelNode;
        }
        if (!this.toolIdsSet.add(id.value())) {
            this.reportDiagnostic((TopLevelNode)toolEntry, "recurring tool id '" + id.value() + "' found in Ballerina.toml. Tool id must be unique for each tool", ProjectDiagnosticErrorCode.RECURRING_TOOL_PROPERTIES, DiagnosticSeverity.ERROR);
        }
        if (!this.targetModuleSet.add(targetModule.value())) {
            this.reportDiagnostic((TopLevelNode)toolEntry, "recurring target module found in Ballerina.toml. Target module must be unique for each tool", ProjectDiagnosticErrorCode.RECURRING_TOOL_PROPERTIES, DiagnosticSeverity.ERROR);
        }
        boolean hasErrorDiagnostic = !Diagnostics.filterErrors(toolEntry.diagnostics()).isEmpty();
        String typeValue = toolCodePrefix + toolCode;
        PackageManifest.Tool.Field type = new PackageManifest.Tool.Field(typeValue, toolEntry.location());
        PackageManifest.Tool tool = new PackageManifest.Tool(type, id, filePath, targetModule, optionsToml, optionsNode, hasErrorDiagnostic);
        tools.add(tool);
    }

    private PackageDescriptor getPackageDescriptor(TomlTableNode tomlTableNode) {
        boolean isValidPkg;
        boolean isValidOrg;
        String errorMessage = "missing table '[package]' in 'Ballerina.toml'. Defaulting to:\n[package]\norg = \"" + ProjectUtils.defaultOrg().value() + "\"\nname = \"" + ProjectUtils.defaultName(this.projectPath).value() + "\"\nversion = \"" + ProjectUtils.defaultVersion().value().toString() + "\"";
        if (tomlTableNode.entries().isEmpty()) {
            this.reportDiagnostic((TopLevelNode)tomlTableNode, errorMessage, ProjectDiagnosticErrorCode.MISSING_PKG_INFO_IN_BALLERINA_TOML, DiagnosticSeverity.WARNING);
            return PackageDescriptor.from(ProjectUtils.defaultOrg(), ProjectUtils.defaultName(this.projectPath), ProjectUtils.defaultVersion());
        }
        TopLevelNode topLevelPkgNode = (TopLevelNode)tomlTableNode.entries().get(PACKAGE);
        if (topLevelPkgNode == null || topLevelPkgNode.kind() != TomlType.TABLE) {
            this.reportDiagnostic((TopLevelNode)tomlTableNode, errorMessage, ProjectDiagnosticErrorCode.MISSING_PKG_INFO_IN_BALLERINA_TOML, DiagnosticSeverity.WARNING);
            return PackageDescriptor.from(ProjectUtils.defaultOrg(), ProjectUtils.defaultName(this.projectPath), ProjectUtils.defaultVersion());
        }
        TomlTableNode pkgNode = (TomlTableNode)topLevelPkgNode;
        String org = ManifestBuilder.getStringValueFromTomlTableNode(pkgNode, ORG, "");
        if (pkgNode.entries().get(ORG) == null) {
            org = ProjectUtils.defaultOrg().value();
            this.reportDiagnostic((TopLevelNode)pkgNode, "missing key 'org' in table '[package]' in 'Ballerina.toml'. Defaulting to 'org = \"" + org + "\"'", ProjectDiagnosticErrorCode.MISSING_PKG_INFO_IN_BALLERINA_TOML, DiagnosticSeverity.WARNING);
        }
        String name = ManifestBuilder.getStringValueFromTomlTableNode(pkgNode, NAME, "");
        if (pkgNode.entries().get(NAME) == null) {
            name = ProjectUtils.defaultName(this.projectPath).value();
            this.reportDiagnostic((TopLevelNode)pkgNode, "missing key 'name' in table '[package]' in 'Ballerina.toml'. Defaulting to 'name = \"" + name + "\"'", ProjectDiagnosticErrorCode.MISSING_PKG_INFO_IN_BALLERINA_TOML, DiagnosticSeverity.WARNING);
        }
        String version = ManifestBuilder.getStringValueFromTomlTableNode(pkgNode, VERSION, "");
        if (pkgNode.entries().get(VERSION) == null) {
            version = ProjectUtils.defaultVersion().value().toString();
            this.reportDiagnostic((TopLevelNode)pkgNode, "missing key 'version' in table '[package]' in 'Ballerina.toml'. Defaulting to 'version = \"" + version + "\"'", ProjectDiagnosticErrorCode.MISSING_PKG_INFO_IN_BALLERINA_TOML, DiagnosticSeverity.WARNING);
        }
        if (!(isValidOrg = ProjectUtils.validateOrgName(org))) {
            org = ProjectUtils.defaultOrg().value();
        }
        if (!(isValidPkg = ProjectUtils.validatePackageName(org, name))) {
            name = ProjectUtils.defaultName(this.projectPath).value();
        }
        try {
            SemanticVersion.from(version);
        }
        catch (ProjectException e) {
            version = ProjectUtils.defaultVersion().value().toString();
        }
        return PackageDescriptor.from(PackageOrg.from(org), PackageName.from(name), PackageVersion.from(version));
    }

    private void validateIconPathForPng(String icon, TomlTableNode pkgNode) {
        if (icon != null && this.hasPngExtension(icon)) {
            Path iconPath = Path.of(icon, new String[0]);
            if (!iconPath.isAbsolute()) {
                iconPath = this.projectPath.resolve(iconPath);
            }
            if (Files.notExists(iconPath, new LinkOption[0])) {
                this.reportDiagnostic((TopLevelNode)pkgNode.entries().get(ICON), "could not locate icon path '" + icon + "'", ProjectDiagnosticErrorCode.INVALID_PATH, DiagnosticSeverity.ERROR);
            } else {
                try {
                    if (!FileUtils.isValidPng(iconPath)) {
                        this.reportDiagnostic((TopLevelNode)pkgNode.entries().get(ICON), "invalid 'icon' under [package]: 'icon' can only have 'png' images", ProjectDiagnosticErrorCode.INVALID_FILE_FORMAT, DiagnosticSeverity.ERROR);
                    }
                }
                catch (IOException e) {
                    throw new ProjectException("failed to read icon: '" + icon + "'");
                }
            }
        }
    }

    private BuildOptions parseBuildOptions() {
        TomlTableNode tomlTableNode = this.ballerinaToml.toml().rootNode();
        return this.setBuildOptions(tomlTableNode);
    }

    private Map<String, PackageManifest.Platform> getPlatforms(TopLevelNode platformNode) {
        HashMap<String, PackageManifest.Platform> platforms = new HashMap();
        if (platformNode == null || platformNode.kind() == TomlType.NONE) {
            platforms = Collections.emptyMap();
        } else if (platformNode.kind() == TomlType.TABLE) {
            TomlTableNode platformTable = (TomlTableNode)platformNode;
            Set platformCodes = platformTable.entries().keySet();
            for (String platformCode : platformCodes) {
                PackageManifest.Platform platform;
                PackageManifest.Platform newPlatform;
                TopLevelNode topLevelNode;
                PackageManifest.Platform newPlatform2;
                TopLevelNode platformCodeNode = (TopLevelNode)platformTable.entries().get(platformCode);
                if (platformCodeNode.kind() != TomlType.TABLE) continue;
                TomlTableNode platformCodeTable = (TomlTableNode)platformCodeNode;
                TopLevelNode graalvmCompatibleNode = (TopLevelNode)platformCodeTable.entries().get(GRAALVM_COMPATIBLE);
                if (graalvmCompatibleNode != null && graalvmCompatibleNode.kind() != TomlType.NONE && (newPlatform2 = this.getGraalvmCompatibilityPlatform(graalvmCompatibleNode)) != null) {
                    if (platforms.get(platformCode) != null) {
                        newPlatform2 = new PackageManifest.Platform(((PackageManifest.Platform)platforms.get(platformCode)).dependencies(), ((PackageManifest.Platform)platforms.get(platformCode)).repositories(), newPlatform2.graalvmCompatible());
                    }
                    platforms.put(platformCode, newPlatform2);
                }
                if ((topLevelNode = (TopLevelNode)platformCodeTable.entries().get(DEPENDENCY)) != null && topLevelNode.kind() != TomlType.NONE && (newPlatform = this.getDependencyPlatform(topLevelNode)) != null) {
                    if (platforms.get(platformCode) != null) {
                        newPlatform = new PackageManifest.Platform(newPlatform.dependencies(), ((PackageManifest.Platform)platforms.get(platformCode)).repositories(), ((PackageManifest.Platform)platforms.get(platformCode)).graalvmCompatible());
                    }
                    platforms.put(platformCode, newPlatform);
                }
                if ((topLevelNode = (TopLevelNode)platformCodeTable.entries().get(REPOSITORY)) == null || topLevelNode.kind() == TomlType.NONE || (platform = this.getRepositoryPlatform(topLevelNode)) == null) continue;
                if (platforms.get(platformCode) != null) {
                    platform = new PackageManifest.Platform(((PackageManifest.Platform)platforms.get(platformCode)).dependencies(), platform.repositories(), ((PackageManifest.Platform)platforms.get(platformCode)).graalvmCompatible());
                }
                platforms.put(platformCode, platform);
            }
        }
        return platforms;
    }

    private PackageManifest.Platform getRepositoryPlatform(TopLevelNode dependencyNode) {
        TomlTableArrayNode dependencyTableArray;
        List children;
        PackageManifest.Platform platform = null;
        if (dependencyNode.kind() == TomlType.TABLE_ARRAY && !(children = (dependencyTableArray = (TomlTableArrayNode)dependencyNode).children()).isEmpty()) {
            ArrayList<Map<String, Object>> platformEntry = new ArrayList<Map<String, Object>>();
            for (TomlTableNode platformEntryTable : children) {
                HashMap<String, String> platformEntryMap = new HashMap<String, String>();
                String username = this.getStringValueFromPlatformEntry(platformEntryTable, USERNAME);
                String password = this.getStringValueFromPlatformEntry(platformEntryTable, PASSWORD);
                platformEntryMap.put(ID, this.getStringValueFromPlatformEntry(platformEntryTable, ID));
                platformEntryMap.put(URL, this.getStringValueFromPlatformEntry(platformEntryTable, URL));
                if (username != null) {
                    platformEntryMap.put(USERNAME, username);
                }
                if (password != null) {
                    platformEntryMap.put(PASSWORD, password);
                }
                platformEntry.add(platformEntryMap);
            }
            platform = new PackageManifest.Platform(Collections.emptyList(), platformEntry, null);
        }
        return platform;
    }

    private PackageManifest.Platform getDependencyPlatform(TopLevelNode dependencyNode) {
        TomlTableArrayNode dependencyTableArray;
        List children;
        PackageManifest.Platform platform = null;
        if (dependencyNode.kind() == TomlType.TABLE_ARRAY && !(children = (dependencyTableArray = (TomlTableArrayNode)dependencyNode).children()).isEmpty()) {
            ArrayList<Map<String, Object>> platformEntry = new ArrayList<Map<String, Object>>();
            for (TomlTableNode platformEntryTable : children) {
                if (platformEntryTable.entries().isEmpty()) continue;
                HashMap<String, Object> platformEntryMap = new HashMap<String, Object>();
                String pathValue = this.getStringValueFromPlatformEntry(platformEntryTable, PATH);
                if (pathValue != null) {
                    Path path = Path.of(pathValue, new String[0]);
                    if (!path.isAbsolute()) {
                        path = this.projectPath.resolve(path);
                    }
                    if (Files.notExists(path, new LinkOption[0])) {
                        this.reportDiagnostic((TopLevelNode)platformEntryTable.entries().get(PATH), "could not locate dependency path '" + pathValue + "'", ProjectDiagnosticErrorCode.INVALID_PATH, DiagnosticSeverity.ERROR);
                    }
                }
                String groupId = this.getStringValueFromPlatformEntry(platformEntryTable, GROUP_ID);
                String artifactId = this.getStringValueFromPlatformEntry(platformEntryTable, ARTIFACT_ID);
                String version = this.getStringValueFromPlatformEntry(platformEntryTable, VERSION);
                String scope = this.getStringValueFromPlatformEntry(platformEntryTable, SCOPE);
                Boolean graalvmCompatibility = this.getBooleanValueFromTomlTableNode(platformEntryTable, GRAALVM_COMPATIBLE);
                if (PlatformLibraryScope.PROVIDED.getStringValue().equals(scope) && !this.providedPlatformDependencyIsValid(artifactId, groupId, version)) {
                    this.reportDiagnostic((TopLevelNode)platformEntryTable, "artifactId, groupId and version must be provided for platform dependencies with provided scope", ProjectDiagnosticErrorCode.INVALID_PROVIDED_DEPENDENCY, DiagnosticSeverity.ERROR);
                }
                platformEntryMap.put(PATH, pathValue);
                platformEntryMap.put(GROUP_ID, groupId);
                platformEntryMap.put(ARTIFACT_ID, artifactId);
                platformEntryMap.put(VERSION, version);
                platformEntryMap.put(SCOPE, scope);
                platformEntryMap.put(GRAALVM_COMPATIBLE, graalvmCompatibility);
                platformEntry.add(platformEntryMap);
            }
            platform = new PackageManifest.Platform(platformEntry);
        }
        return platform;
    }

    private PackageManifest.Platform getGraalvmCompatibilityPlatform(TopLevelNode graalvmCompatibleNode) {
        TomlKeyValueNode keyValueNode;
        if (graalvmCompatibleNode.kind() == TomlType.KEY_VALUE && (keyValueNode = (TomlKeyValueNode)graalvmCompatibleNode).value().kind() == TomlType.BOOLEAN) {
            Boolean graalvmCompatible = (Boolean)((TomlBooleanValueNode)keyValueNode.value()).getValue();
            return new PackageManifest.Platform(Collections.emptyList(), Collections.emptyList(), graalvmCompatible);
        }
        return null;
    }

    private List<PackageManifest.Dependency> getLocalRepoDependencies() {
        TomlTableNode rootNode = this.ballerinaToml.toml().rootNode();
        if (rootNode.entries().isEmpty()) {
            return Collections.emptyList();
        }
        TopLevelNode dependencyEntries = (TopLevelNode)rootNode.entries().get(DEPENDENCY);
        if (dependencyEntries == null || dependencyEntries.kind() == TomlType.NONE) {
            return Collections.emptyList();
        }
        ArrayList<PackageManifest.Dependency> dependencies = new ArrayList<PackageManifest.Dependency>();
        if (dependencyEntries.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode dependencyTableArray = (TomlTableArrayNode)dependencyEntries;
            for (TomlTableNode dependencyNode : dependencyTableArray.children()) {
                PackageVersion depVersion;
                String name = this.getStringValueFromDependencyNode(dependencyNode, NAME);
                String org = this.getStringValueFromDependencyNode(dependencyNode, ORG);
                String version = this.getStringValueFromDependencyNode(dependencyNode, VERSION);
                String repository = this.getStringValueFromDependencyNode(dependencyNode, REPOSITORY);
                PackageName depName = PackageName.from(name);
                PackageOrg depOrg = PackageOrg.from(org);
                try {
                    depVersion = PackageVersion.from(version);
                }
                catch (ProjectException e) {
                    continue;
                }
                dependencies.add(new PackageManifest.Dependency(depName, depOrg, depVersion, repository, (Location)dependencyNode.location()));
            }
        }
        return dependencies;
    }

    private void reportDiagnostic(TopLevelNode tomlTableNode, String message, ProjectDiagnosticErrorCode errorCode, DiagnosticSeverity severity) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(errorCode.diagnosticId(), errorCode.messageKey(), severity);
        TomlDiagnostic tomlDiagnostic = new TomlDiagnostic(tomlTableNode.location(), diagnosticInfo, message);
        tomlTableNode.addDiagnostic((Diagnostic)tomlDiagnostic);
    }

    private BuildOptions setBuildOptions(TomlTableNode tomlTableNode) {
        TopLevelNode topLevelBuildOptionsNode = (TopLevelNode)tomlTableNode.entries().get("build-options");
        if (topLevelBuildOptionsNode == null || topLevelBuildOptionsNode.kind() != TomlType.TABLE) {
            return null;
        }
        TomlTableNode tableNode = (TomlTableNode)topLevelBuildOptionsNode;
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        Boolean offline = this.getBooleanFromBuildOptionsTableNode(tableNode, CompilerOptionName.OFFLINE.toString());
        Boolean experimental = this.getBooleanFromBuildOptionsTableNode(tableNode, CompilerOptionName.EXPERIMENTAL.toString());
        Boolean observabilityIncluded = this.getBooleanFromBuildOptionsTableNode(tableNode, CompilerOptionName.OBSERVABILITY_INCLUDED.toString());
        Boolean testReport = this.getBooleanFromBuildOptionsTableNode(tableNode, BuildOptions.OptionName.TEST_REPORT.toString());
        Boolean codeCoverage = this.getBooleanFromBuildOptionsTableNode(tableNode, BuildOptions.OptionName.CODE_COVERAGE.toString());
        TopLevelNode topLevelNode = (TopLevelNode)tableNode.entries().get(CompilerOptionName.CLOUD.toString());
        Boolean dumpBuildTime = this.getBooleanFromBuildOptionsTableNode(tableNode, BuildOptions.OptionName.DUMP_BUILD_TIME.toString());
        Boolean sticky = this.getBooleanFromBuildOptionsTableNode(tableNode, CompilerOptionName.STICKY.toString());
        String cloud = "";
        if (topLevelNode != null) {
            cloud = ManifestUtils.getStringFromTomlTableNode(topLevelNode);
        }
        Boolean listConflictedClasses = this.getBooleanFromBuildOptionsTableNode(tableNode, CompilerOptionName.LIST_CONFLICTED_CLASSES.toString());
        String targetDir = this.getStringFromBuildOptionsTableNode(tableNode, BuildOptions.OptionName.TARGET_DIR.toString());
        Boolean enableCache = this.getBooleanFromBuildOptionsTableNode(tableNode, CompilerOptionName.ENABLE_CACHE.toString());
        Boolean nativeImage = this.getBooleanFromBuildOptionsTableNode(tableNode, BuildOptions.OptionName.NATIVE_IMAGE.toString());
        Boolean exportComponentModel = this.getBooleanFromBuildOptionsTableNode(tableNode, BuildOptions.OptionName.EXPORT_COMPONENT_MODEL.toString());
        String graalVMBuildOptions = this.getStringFromBuildOptionsTableNode(tableNode, BuildOptions.OptionName.GRAAL_VM_BUILD_OPTIONS.toString());
        Boolean remoteManagement = this.getBooleanFromBuildOptionsTableNode(tableNode, CompilerOptionName.REMOTE_MANAGEMENT.toString());
        Boolean showDependencyDiagnostics = this.getBooleanFromBuildOptionsTableNode(tableNode, BuildOptions.OptionName.SHOW_DEPENDENCY_DIAGNOSTICS.toString());
        Boolean optimizeDependencyCompilation = this.getBooleanFromBuildOptionsTableNode(tableNode, BuildOptions.OptionName.OPTIMIZE_DEPENDENCY_COMPILATION.toString());
        String lockingMode = this.getStringFromBuildOptionsTableNode(tableNode, CompilerOptionName.LOCKING_MODE.toString());
        buildOptionsBuilder.setOffline(offline).setExperimental(experimental).setObservabilityIncluded(observabilityIncluded).setTestReport(testReport).setCodeCoverage(codeCoverage).setCloud(cloud).setListConflictedClasses(listConflictedClasses).setDumpBuildTime(dumpBuildTime).setSticky(sticky).setEnableCache(enableCache).setNativeImage(nativeImage).setExportComponentModel(exportComponentModel).setGraalVMBuildOptions(graalVMBuildOptions).setRemoteManagement(remoteManagement).setShowDependencyDiagnostics(showDependencyDiagnostics).setOptimizeDependencyCompilation(optimizeDependencyCompilation).setLockingMode(lockingMode);
        if (targetDir != null) {
            buildOptionsBuilder.targetDir(targetDir);
        }
        return buildOptionsBuilder.build();
    }

    private Boolean getBooleanFromBuildOptionsTableNode(TomlTableNode tableNode, String key) {
        TomlKeyValueNode keyValueNode;
        TomlValueNode value;
        TopLevelNode topLevelNode = (TopLevelNode)tableNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return null;
        }
        if (topLevelNode.kind() == TomlType.KEY_VALUE && (value = (keyValueNode = (TomlKeyValueNode)topLevelNode).value()).kind() == TomlType.BOOLEAN) {
            TomlBooleanValueNode tomlBooleanValueNode = (TomlBooleanValueNode)value;
            return (Boolean)tomlBooleanValueNode.getValue();
        }
        return null;
    }

    private String getStringFromBuildOptionsTableNode(TomlTableNode tableNode, String key) {
        TomlKeyValueNode keyValueNode;
        TomlValueNode value;
        TopLevelNode topLevelNode = (TopLevelNode)tableNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return null;
        }
        if (topLevelNode.kind() == TomlType.KEY_VALUE && (value = (keyValueNode = (TomlKeyValueNode)topLevelNode).value()).kind() == TomlType.STRING) {
            TomlStringValueNode tomlStringValueNode = (TomlStringValueNode)value;
            return (String)tomlStringValueNode.getValue();
        }
        return null;
    }

    private boolean getBooleanFromTemplateNode(TomlTableNode tableNode, String key) {
        TomlKeyValueNode keyValueNode;
        TomlValueNode value;
        TopLevelNode topLevelNode = (TopLevelNode)tableNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return false;
        }
        if (topLevelNode.kind() == TomlType.KEY_VALUE && (value = (keyValueNode = (TomlKeyValueNode)topLevelNode).value()).kind() == TomlType.BOOLEAN) {
            TomlBooleanValueNode tomlBooleanValueNode = (TomlBooleanValueNode)value;
            return (Boolean)tomlBooleanValueNode.getValue();
        }
        return false;
    }

    public static String getStringValueFromTomlTableNode(TomlTableNode tomlTableNode, String key) {
        TopLevelNode topLevelNode = (TopLevelNode)tomlTableNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return null;
        }
        return ManifestUtils.getStringFromTomlTableNode(topLevelNode);
    }

    public static String getStringValueFromTomlTableNode(TomlTableNode tomlTableNode, String key, String defaultValue) {
        TopLevelNode topLevelNode = (TopLevelNode)tomlTableNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return defaultValue;
        }
        String value = ManifestUtils.getStringFromTomlTableNode(topLevelNode);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private List<String> getStringArrayFromPackageNode(TomlTableNode pkgNode, String key) {
        ArrayList<String> elements = new ArrayList<String>();
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return elements;
        }
        TomlValueNode valueNode = ((TomlKeyValueNode)topLevelNode).value();
        if (valueNode.kind() == TomlType.NONE) {
            return elements;
        }
        if (valueNode.kind() == TomlType.ARRAY) {
            TomlArrayValueNode arrayValueNode = (TomlArrayValueNode)valueNode;
            for (TomlValueNode value : arrayValueNode.elements()) {
                if (value.kind() != TomlType.STRING) continue;
                elements.add((String)((TomlStringValueNode)value).getValue());
            }
        }
        return elements;
    }

    private String getStringValueFromPlatformEntry(TomlTableNode pkgNode, String key) {
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return null;
        }
        return ManifestUtils.getStringFromTomlTableNode(topLevelNode);
    }

    private Boolean getBooleanValueFromTomlTableNode(TomlTableNode pkgNode, String key) {
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return null;
        }
        return ManifestUtils.getBooleanFromTomlTableNode(topLevelNode);
    }

    private String getStringValueFromDependencyNode(TomlTableNode pkgNode, String key) {
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get(key);
        if (topLevelNode == null) {
            return null;
        }
        return ManifestUtils.getStringFromTomlTableNode(topLevelNode);
    }

    private PackageManifest.Tool.Field getValueFromPreBuildToolNode(TomlTableNode toolNode, String key, String toolCode) {
        TopLevelNode topLevelNode = (TopLevelNode)toolNode.entries().get(key);
        if (topLevelNode == null) {
            String errorMessage = "missing key '[" + key + "]' in table '[tool." + toolCode + "]'.";
            if (key.equals(ID)) {
                this.reportDiagnostic((TopLevelNode)toolNode, errorMessage, ProjectDiagnosticErrorCode.MISSING_TOOL_PROPERTIES_IN_BALLERINA_TOML, DiagnosticSeverity.ERROR);
            }
            return new PackageManifest.Tool.Field(null, toolNode.location());
        }
        ManifestUtils.ToolNodeValueType toolNodeValueType = ManifestUtils.getBuildToolTomlValueType(topLevelNode);
        if (ManifestUtils.ToolNodeValueType.STRING.equals((Object)toolNodeValueType)) {
            String value = ManifestUtils.getStringFromTomlTableNode(topLevelNode);
            TomlNodeLocation location = topLevelNode.location();
            return new PackageManifest.Tool.Field(value, location);
        }
        if (ManifestUtils.ToolNodeValueType.EMPTY.equals((Object)toolNodeValueType)) {
            if (!key.equals(TARGETMODULE)) {
                this.reportDiagnostic((TopLevelNode)toolNode, "empty string found for key '[" + key + "]' in table '[tool." + toolCode + "]'.", ProjectDiagnosticErrorCode.EMPTY_TOOL_PROPERTY, DiagnosticSeverity.ERROR);
            }
            return new PackageManifest.Tool.Field(null, toolNode.location());
        }
        if (ManifestUtils.ToolNodeValueType.NON_STRING.equals((Object)toolNodeValueType)) {
            this.reportDiagnostic((TopLevelNode)toolNode, "incompatible type found for key '[" + key + "]': expected 'STRING'", ProjectDiagnosticErrorCode.INCOMPATIBLE_TYPE_FOR_TOOL_PROPERTY, DiagnosticSeverity.ERROR);
            return new PackageManifest.Tool.Field(null, toolNode.location());
        }
        return new PackageManifest.Tool.Field(null, toolNode.location());
    }

    private Toml getToml(TomlTableNode toolNode, String key) {
        TopLevelNode topLevelNode = (TopLevelNode)toolNode.entries().get(key);
        if (topLevelNode == null) {
            return null;
        }
        if (topLevelNode.kind() != TomlType.TABLE) {
            return null;
        }
        TomlTableNode optionsNode = (TomlTableNode)topLevelNode;
        return new Toml(optionsNode);
    }

    private boolean providedPlatformDependencyIsValid(String artifactId, String groupId, String version) {
        return artifactId != null && !artifactId.isEmpty() && groupId != null && !groupId.isEmpty() && version != null && !version.isEmpty();
    }

    private boolean hasPngExtension(String fileName) {
        String pngExtensionPattern = ".*.png$";
        Pattern pattern = Pattern.compile(pngExtensionPattern);
        Matcher matcher = pattern.matcher(fileName);
        return matcher.find();
    }
}

