/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlBooleanValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;

public final class ManifestUtils {
    private ManifestUtils() {
    }

    static String convertDiagnosticToString(Diagnostic diagnostic) {
        LineRange lineRange = diagnostic.location().lineRange();
        LineRange oneBasedLineRange = LineRange.from((String)lineRange.fileName(), (LinePosition)LinePosition.from((int)lineRange.startLine().line(), (int)(lineRange.startLine().offset() + 1)), (LinePosition)LinePosition.from((int)lineRange.endLine().line(), (int)(lineRange.endLine().offset() + 1)));
        return diagnostic.diagnosticInfo().severity().toString() + " [" + oneBasedLineRange.fileName() + ":" + String.valueOf(oneBasedLineRange) + "] " + diagnostic.message();
    }

    public static String getStringFromTomlTableNode(TopLevelNode topLevelNode) {
        TomlKeyValueNode keyValueNode;
        TomlValueNode value;
        if (topLevelNode.kind() != null && topLevelNode.kind() == TomlType.KEY_VALUE && (value = (keyValueNode = (TomlKeyValueNode)topLevelNode).value()).kind() == TomlType.STRING) {
            TomlStringValueNode stringValueNode = (TomlStringValueNode)value;
            return (String)stringValueNode.getValue();
        }
        return null;
    }

    public static ToolNodeValueType getBuildToolTomlValueType(TopLevelNode topLevelNode) {
        if (topLevelNode.kind() != null && topLevelNode.kind() == TomlType.KEY_VALUE) {
            TomlKeyValueNode keyValueNode = (TomlKeyValueNode)topLevelNode;
            TomlValueNode value = keyValueNode.value();
            if (value.kind() == TomlType.STRING) {
                TomlStringValueNode stringValueNode = (TomlStringValueNode)value;
                if (((String)stringValueNode.getValue()).isEmpty()) {
                    return ToolNodeValueType.EMPTY;
                }
                return ToolNodeValueType.STRING;
            }
            return ToolNodeValueType.NON_STRING;
        }
        return ToolNodeValueType.INVALID;
    }

    static boolean getBooleanFromTomlTableNode(TopLevelNode topLevelNode) {
        TomlKeyValueNode keyValueNode;
        TomlValueNode value;
        if (topLevelNode.kind() != null && topLevelNode.kind() == TomlType.KEY_VALUE && (value = (keyValueNode = (TomlKeyValueNode)topLevelNode).value()).kind() == TomlType.BOOLEAN) {
            TomlBooleanValueNode booleanValueNode = (TomlBooleanValueNode)value;
            return (Boolean)booleanValueNode.getValue();
        }
        return false;
    }

    static enum ToolNodeValueType {
        STRING,
        NON_STRING,
        EMPTY,
        INVALID;

    }
}

