/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.internal.DocumentData;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class ModuleData {
    private final Path moduleDirPath;
    private final String moduleName;
    private final List<DocumentData> srcDocs;
    private final List<DocumentData> testSrcDocs;
    private final DocumentData readmeMd;

    private ModuleData(Path moduleDirPath, String moduleName, List<DocumentData> srcDocs, List<DocumentData> testSrcDocs, DocumentData readmeMd) {
        this.moduleDirPath = moduleDirPath;
        this.moduleName = moduleName;
        this.srcDocs = srcDocs;
        this.testSrcDocs = testSrcDocs;
        this.readmeMd = readmeMd;
    }

    public static ModuleData from(Path path, String moduleName, List<DocumentData> srcDocuments, List<DocumentData> testSrcDocuments, DocumentData readmeMd) {
        return new ModuleData(path, moduleName, srcDocuments, testSrcDocuments, readmeMd);
    }

    public Path moduleDirectoryPath() {
        return this.moduleDirPath;
    }

    public String moduleName() {
        return this.moduleName;
    }

    public List<DocumentData> sourceDocs() {
        return this.srcDocs;
    }

    public void addSourceDocs(List<DocumentData> docs) {
        this.srcDocs.addAll(docs);
    }

    public List<DocumentData> testSourceDocs() {
        return this.testSrcDocs;
    }

    public void addTestSourceDocs(List<DocumentData> docs) {
        this.testSrcDocs.addAll(docs);
    }

    @Deprecated(forRemoval=true)
    public Optional<DocumentData> moduleMd() {
        return Optional.ofNullable(this.readmeMd);
    }

    public Optional<DocumentData> readmeMd() {
        return Optional.ofNullable(this.readmeMd);
    }
}

