/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DependencyResolutionType;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.internal.ResolutionEngine;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PackageDependencyGraphBuilder {
    private final Map<Vertex, ResolutionEngine.DependencyNode> vertices = new HashMap<Vertex, ResolutionEngine.DependencyNode>();
    private final Map<Vertex, Set<Vertex>> depGraph = new HashMap<Vertex, Set<Vertex>>();
    private final DependencyGraph.DependencyGraphBuilder<ResolutionEngine.DependencyNode> rawGraphBuilder;
    private final ResolutionOptions resolutionOptions;
    private Set<Vertex> unresolvedVertices = new HashSet<Vertex>();
    private final ResolutionEngine.DependencyNode rootDepNode;
    private final Vertex rootNodeVertex;
    private final List<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();

    public PackageDependencyGraphBuilder(PackageDescriptor rootNode, ResolutionOptions resolutionOptions) {
        this.rootNodeVertex = new Vertex(rootNode.org(), rootNode.name());
        this.rootDepNode = new ResolutionEngine.DependencyNode(rootNode, PackageDependencyScope.DEFAULT, DependencyResolutionType.SOURCE);
        this.resolutionOptions = resolutionOptions;
        this.rawGraphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder(this.rootDepNode);
        Vertex dependentVertex = new Vertex(this.rootDepNode.pkgDesc().org(), this.rootDepNode.pkgDesc().name());
        this.addNewVertex(dependentVertex, this.rootDepNode, false);
    }

    public NodeStatus addUnresolvedNode(PackageDescriptor node, PackageDependencyScope scope, DependencyResolutionType dependencyResolvedType) {
        Vertex dependentVertex = new Vertex(node.org(), node.name());
        return this.addNewVertex(dependentVertex, new ResolutionEngine.DependencyNode(node, scope, dependencyResolvedType), true);
    }

    public NodeStatus addResolvedNode(PackageDescriptor node, PackageDependencyScope scope, DependencyResolutionType dependencyResolvedType) {
        Vertex dependentVertex = new Vertex(node.org(), node.name());
        return this.addNewVertex(dependentVertex, new ResolutionEngine.DependencyNode(node, scope, dependencyResolvedType), false);
    }

    public NodeStatus addErrorNode(PackageDescriptor node, PackageDependencyScope scope, DependencyResolutionType dependencyResolvedType) {
        Vertex dependentVertex = new Vertex(node.org(), node.name());
        return this.addNewVertex(dependentVertex, new ResolutionEngine.DependencyNode(node, scope, dependencyResolvedType, true), false);
    }

    public NodeStatus addUnresolvedDependency(PackageDescriptor dependent, PackageDescriptor dependency, PackageDependencyScope dependencyScope, DependencyResolutionType dependencyResolvedType) {
        return this.addDependencyInternal(dependent, new ResolutionEngine.DependencyNode(dependency, dependencyScope, dependencyResolvedType), true);
    }

    public NodeStatus addErroneousDependency(PackageDescriptor dependent, PackageDescriptor dependency, PackageDependencyScope dependencyScope, DependencyResolutionType dependencyResolvedType) {
        return this.addDependencyInternal(dependent, new ResolutionEngine.DependencyNode(dependency, dependencyScope, dependencyResolvedType, true), false);
    }

    public NodeStatus addResolvedDependency(PackageDescriptor dependent, PackageDescriptor dependency, PackageDependencyScope dependencyScope, DependencyResolutionType dependencyResolvedType) {
        return this.addDependencyInternal(dependent, new ResolutionEngine.DependencyNode(dependency, dependencyScope, dependencyResolvedType), false);
    }

    public boolean containsNode(PackageDescriptor node) {
        ResolutionEngine.DependencyNode dependencyNode = this.vertices.get(new Vertex(node.org(), node.name()));
        if (dependencyNode == null) {
            return false;
        }
        return dependencyNode.pkgDesc().version().equals(node.version());
    }

    public Collection<ResolutionEngine.DependencyNode> getAllDependencies() {
        return this.vertices.values().stream().filter(vertex -> !vertex.equals(this.rootDepNode)).toList();
    }

    public DependencyGraph<ResolutionEngine.DependencyNode> buildGraph() {
        this.removeDanglingNodes();
        DependencyGraph.DependencyGraphBuilder<ResolutionEngine.DependencyNode> graphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder(this.rootDepNode);
        for (Map.Entry<Vertex, Set<Vertex>> dependencyMapEntry : this.depGraph.entrySet()) {
            Set pkgDescValues;
            Vertex graphNodeKey = dependencyMapEntry.getKey();
            Set<Vertex> graphNodeValues = dependencyMapEntry.getValue();
            ResolutionEngine.DependencyNode pkgDescKey = this.vertices.get(graphNodeKey);
            if (graphNodeValues.isEmpty()) {
                pkgDescValues = Collections.emptySet();
            } else {
                pkgDescValues = new HashSet(graphNodeValues.size());
                for (Vertex vertex : graphNodeValues) {
                    pkgDescValues.add(this.vertices.get(vertex));
                }
            }
            graphBuilder.addDependencies(pkgDescKey, pkgDescValues);
        }
        return graphBuilder.build();
    }

    public Collection<ResolutionEngine.DependencyNode> getUnresolvedNodes() {
        List<ResolutionEngine.DependencyNode> unresolvedNodes = this.unresolvedVertices.stream().map(this.vertices::get).toList();
        this.unresolvedVertices = new HashSet<Vertex>();
        return unresolvedNodes;
    }

    List<Diagnostic> diagnostics() {
        return this.diagnosticList;
    }

    public void removeDanglingNodes() {
        HashSet<Vertex> danglingVertices = new HashSet<Vertex>(this.vertices.keySet());
        this.removeDanglingNodes(this.rootNodeVertex, danglingVertices);
        for (Vertex danglingVertex : danglingVertices) {
            this.vertices.remove(danglingVertex);
            this.depGraph.remove(danglingVertex);
            this.unresolvedVertices.remove(danglingVertex);
        }
    }

    public DependencyGraph<ResolutionEngine.DependencyNode> rawGraph() {
        return this.rawGraphBuilder.build();
    }

    void addUnresolvedDirectDepToRawGraph(ResolutionEngine.DependencyNode unresolvedDirectDep) {
        this.rawGraphBuilder.addDependency(this.rootDepNode, unresolvedDirectDep);
    }

    private NodeStatus addDependencyInternal(PackageDescriptor dependent, ResolutionEngine.DependencyNode dependencyNode, boolean unresolved) {
        Vertex dependentVertex = new Vertex(dependent.org(), dependent.name());
        if (!this.depGraph.containsKey(dependentVertex)) {
            throw new IllegalStateException("Dependent node does not exist in the graph: " + String.valueOf(dependent));
        }
        Vertex dependencyVertex = new Vertex(dependencyNode.pkgDesc().org(), dependencyNode.pkgDesc().name());
        NodeStatus nodeStatus = this.addNewVertex(dependencyVertex, dependencyNode, unresolved);
        this.depGraph.get(dependentVertex).add(dependencyVertex);
        if (this.resolutionOptions.dumpRawGraphs()) {
            ResolutionEngine.DependencyNode dependentNode = this.vertices.get(dependentVertex);
            this.rawGraphBuilder.addDependency(dependentNode, dependencyNode);
        }
        return nodeStatus;
    }

    private void removeDanglingNodes(Vertex nodeVertex, Set<Vertex> danglingVertices) {
        danglingVertices.remove(nodeVertex);
        Set<Vertex> dependencies = this.depGraph.get(nodeVertex);
        for (Vertex dep : dependencies) {
            if (!danglingVertices.contains(dep)) continue;
            this.removeDanglingNodes(dep, danglingVertices);
        }
    }

    private NodeStatus addNewVertex(Vertex vertex, ResolutionEngine.DependencyNode newPkgDep, boolean unresolved) {
        NodeStatus nodeStatus;
        ResolutionEngine.DependencyNode resolvedPkgDep;
        if (this.resolutionOptions.dumpRawGraphs()) {
            this.rawGraphBuilder.add(newPkgDep);
        }
        if (!this.vertices.containsKey(vertex)) {
            this.vertices.put(vertex, newPkgDep);
            this.depGraph.put(vertex, new HashSet());
            if (unresolved) {
                this.unresolvedVertices.add(vertex);
            }
            return NodeStatus.ACCEPTED;
        }
        ResolutionEngine.DependencyNode existingPkgDep = this.vertices.get(vertex);
        if (existingPkgDep.errorNode()) {
            return NodeStatus.REJECTED;
        }
        if (newPkgDep.errorNode()) {
            resolvedPkgDep = newPkgDep;
            nodeStatus = NodeStatus.ACCEPTED;
        } else {
            PackageDescriptor resolvedPkgDesc = this.handleDependencyConflict(newPkgDep, existingPkgDep);
            if (resolvedPkgDesc == null) {
                resolvedPkgDep = new ResolutionEngine.DependencyNode(existingPkgDep.pkgDesc(), existingPkgDep.scope(), existingPkgDep.resolutionType(), true);
                nodeStatus = NodeStatus.ACCEPTED;
            } else {
                PackageDependencyScope depScope = existingPkgDep.scope() == PackageDependencyScope.DEFAULT ? PackageDependencyScope.DEFAULT : newPkgDep.scope();
                DependencyResolutionType resolutionType = existingPkgDep.resolutionType() == DependencyResolutionType.SOURCE ? DependencyResolutionType.SOURCE : newPkgDep.resolutionType();
                resolvedPkgDep = new ResolutionEngine.DependencyNode(resolvedPkgDesc, depScope, resolutionType);
                nodeStatus = this.getNodeStatus(vertex, existingPkgDep, newPkgDep, unresolved);
            }
        }
        if (nodeStatus == NodeStatus.ACCEPTED) {
            this.vertices.put(vertex, resolvedPkgDep);
            this.depGraph.put(vertex, new HashSet());
        } else {
            this.vertices.put(vertex, resolvedPkgDep);
            if (this.resolutionOptions.dumpRawGraphs()) {
                this.rawGraphBuilder.add(resolvedPkgDep);
            }
            if (resolvedPkgDep.scope() == PackageDependencyScope.DEFAULT) {
                for (Vertex depVertex : this.depGraph.get(vertex)) {
                    ResolutionEngine.DependencyNode dependencyNode = this.vertices.get(depVertex);
                    ResolutionEngine.DependencyNode newDependencyNode = new ResolutionEngine.DependencyNode(dependencyNode.pkgDesc(), resolvedPkgDep.scope(), dependencyNode.resolutionType());
                    this.vertices.put(depVertex, newDependencyNode);
                    if (!this.resolutionOptions.dumpRawGraphs()) continue;
                    this.rawGraphBuilder.addDependency(resolvedPkgDep, newDependencyNode);
                }
            }
        }
        return nodeStatus;
    }

    private NodeStatus getNodeStatus(Vertex vertex, ResolutionEngine.DependencyNode existingPkgDep, ResolutionEngine.DependencyNode newPkgDep, boolean unresolved) {
        SemanticVersion existingSemVer;
        if (newPkgDep.equals(existingPkgDep)) {
            return NodeStatus.ACCEPTED;
        }
        SemanticVersion newSemVer = newPkgDep.pkgDesc().version().value();
        if (newSemVer.greaterThan(existingSemVer = existingPkgDep.pkgDesc().version().value())) {
            if (unresolved) {
                this.unresolvedVertices.add(vertex);
            }
            return NodeStatus.ACCEPTED;
        }
        if (newSemVer.lessThan(existingSemVer)) {
            return NodeStatus.REJECTED;
        }
        Optional<String> newRepoOptional = newPkgDep.pkgDesc().repository();
        Optional<String> existingRepoOptional = existingPkgDep.pkgDesc().repository();
        if (newRepoOptional.isPresent() && newRepoOptional.get().equals("local")) {
            return NodeStatus.ACCEPTED;
        }
        if (existingRepoOptional.isPresent() && existingRepoOptional.get().equals("local")) {
            return NodeStatus.REJECTED;
        }
        return NodeStatus.ACCEPTED;
    }

    private PackageDescriptor handleDependencyConflict(ResolutionEngine.DependencyNode newPkgDep, ResolutionEngine.DependencyNode existingPkgDep) {
        PackageDescriptor newPkgDesc = newPkgDep.pkgDesc();
        PackageDescriptor existingPkgDesc = existingPkgDep.pkgDesc();
        SemanticVersion.VersionCompatibilityResult compatibilityResult = newPkgDesc.version().compareTo(existingPkgDesc.version());
        switch (compatibilityResult) {
            case EQUAL: {
                String repository = existingPkgDesc.repository().isPresent() ? existingPkgDesc.repository().get() : (String)newPkgDesc.repository().orElse(null);
                return PackageDescriptor.from(existingPkgDesc.org(), existingPkgDesc.name(), existingPkgDesc.version(), repository);
            }
            case LESS_THAN: {
                return existingPkgDesc;
            }
            case GREATER_THAN: {
                return newPkgDesc;
            }
            case INCOMPATIBLE: {
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.INCOMPATIBLE_DEPENDENCY_VERSIONS.diagnosticId(), "Two incompatible versions exist in the dependency graph: " + String.valueOf(existingPkgDesc.org()) + "/" + String.valueOf(existingPkgDesc.name()) + " versions: " + String.valueOf(existingPkgDesc.version()) + ", " + String.valueOf(newPkgDesc.version()), DiagnosticSeverity.ERROR);
                PackageDiagnostic diagnostic = new PackageDiagnostic(diagnosticInfo, this.rootDepNode.pkgDesc().name().toString());
                this.diagnosticList.add(diagnostic);
                return null;
            }
        }
        throw new IllegalStateException("Unsupported VersionCompatibilityResult: " + String.valueOf((Object)compatibilityResult));
    }

    private static class Vertex {
        private final PackageOrg org;
        private final PackageName name;

        Vertex(PackageOrg org, PackageName name) {
            this.org = org;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vertex vertex = (Vertex)o;
            return this.org.equals(vertex.org) && this.name.equals(vertex.name);
        }

        public int hashCode() {
            return Objects.hash(this.org, this.name);
        }
    }

    public static enum NodeStatus {
        ACCEPTED,
        REJECTED;

    }
}

