/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PackageVersionContainer<T> {
    private final Map<PackageOrg, Map<PackageName, Map<PackageVersion, T>>> pkgOrgMap = new HashMap<PackageOrg, Map<PackageName, Map<PackageVersion, T>>>();

    public void add(PackageOrg pkgOrg, PackageName pkgName, PackageVersion pkgVersion, T t) {
        Map pkgNameMap = this.pkgOrgMap.computeIfAbsent(pkgOrg, orgName -> new HashMap());
        Map pkgVersionMap = pkgNameMap.computeIfAbsent(pkgName, name -> new HashMap());
        pkgVersionMap.put(pkgVersion, t);
    }

    public Optional<T> get(PackageOrg pkgOrg, PackageName pkgName, PackageVersion pkgVersion) {
        Map<PackageName, Map<PackageVersion, T>> pkgNameMap = this.pkgOrgMap.get(pkgOrg);
        if (pkgNameMap == null) {
            return Optional.empty();
        }
        Map<PackageVersion, T> pkgVersionMap = pkgNameMap.get(pkgName);
        if (pkgVersionMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(pkgVersionMap.get(pkgVersion));
    }

    public Collection<T> get(PackageOrg pkgOrg, PackageName pkgName) {
        Map<PackageName, Map<PackageVersion, T>> pkgNameMap = this.pkgOrgMap.get(pkgOrg);
        if (pkgNameMap == null) {
            return Collections.emptyList();
        }
        Map<PackageVersion, T> pkgVersionMap = pkgNameMap.get(pkgName);
        if (pkgVersionMap == null) {
            return Collections.emptyList();
        }
        return pkgVersionMap.values();
    }

    public Collection<T> getAll() {
        return this.pkgOrgMap.values().stream().map(Map::values).flatMap(Collection::stream).map(Map::values).flatMap(Collection::stream).toList();
    }
}

