/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.compiler.syntax.tree.CommitActionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.RetryStatementNode;
import io.ballerina.compiler.syntax.tree.RollbackStatementNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TransactionStatementNode;
import io.ballerina.compiler.syntax.tree.TransactionalExpressionNode;
import java.util.List;

public class TransactionImportValidator
extends NodeVisitor {
    private boolean importTransactionPackage;

    public boolean shouldImportTransactionPackage(ModulePartNode modulePartNode) {
        modulePartNode.accept((NodeVisitor)this);
        return this.importTransactionPackage;
    }

    public void visit(TransactionStatementNode transactionStatementNode) {
        this.importTransactionPackage = true;
    }

    public void visit(CommitActionNode commitActionNode) {
        this.importTransactionPackage = true;
    }

    public void visit(RollbackStatementNode rollbackStatementNode) {
        this.importTransactionPackage = true;
    }

    public void visit(RetryStatementNode retryStatementNode) {
        StatementNode statementNode = retryStatementNode.retryBody();
        if (statementNode.kind() == SyntaxKind.TRANSACTION_STATEMENT) {
            this.importTransactionPackage = true;
        }
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        List<String> qualifiers = functionDefinitionNode.qualifierList().stream().map(Token::text).toList();
        if (qualifiers.contains(SyntaxKind.TRANSACTIONAL_KEYWORD.stringValue()) && qualifiers.contains(SyntaxKind.RESOURCE_KEYWORD.stringValue())) {
            this.importTransactionPackage = true;
        }
        super.visit(functionDefinitionNode);
    }

    public void visit(TransactionalExpressionNode transactionalExpressionNode) {
        this.importTransactionPackage = true;
    }

    protected void visitSyntaxNode(Node node) {
        if (this.importTransactionPackage) {
            return;
        }
        super.visitSyntaxNode(node);
    }
}

