/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.model;

import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.bala.BalToolJson;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class BalToolDescriptor {
    public static final String ID = "id";
    private static final String TOOL = "tool";
    private static final String DEPENDENCY = "dependency";
    public static final String PATH = "path";
    private final Tool tool;
    private final List<Dependency> dependencies;

    private BalToolDescriptor(Tool tool, List<Dependency> dependencies) {
        this.tool = tool;
        this.dependencies = dependencies;
    }

    public static BalToolDescriptor from(TomlDocument tomlDocument, Path sourceRoot) {
        TomlTableNode tomlTableNode = tomlDocument.toml().rootNode();
        if (tomlTableNode.entries().isEmpty()) {
            return new BalToolDescriptor(null, Collections.emptyList());
        }
        return new BalToolDescriptor(new Tool(BalToolDescriptor.getToolID(tomlTableNode)), BalToolDescriptor.getDependencies(tomlTableNode, sourceRoot));
    }

    public static BalToolDescriptor from(BalToolJson balToolJson) {
        ArrayList<Dependency> dependencyList = new ArrayList<Dependency>();
        for (String path : balToolJson.dependencyPaths()) {
            dependencyList.add(new Dependency(path));
        }
        return new BalToolDescriptor(new Tool(balToolJson.toolId()), dependencyList);
    }

    public Tool tool() {
        return this.tool;
    }

    public List<Dependency> dependencies() {
        return this.dependencies;
    }

    public List<String> getBalToolDependencies() {
        ArrayList<String> balToolDependencies = new ArrayList<String>();
        for (Dependency dependency : this.dependencies) {
            balToolDependencies.add(dependency.getPath());
        }
        return balToolDependencies;
    }

    private static List<Dependency> getDependencies(TomlTableNode tomlTableNode, Path sourceRoot) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        TopLevelNode dependenciesNode = (TopLevelNode)tomlTableNode.entries().get(DEPENDENCY);
        if (dependenciesNode != null && dependenciesNode.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode dependencyTableArray = (TomlTableArrayNode)dependenciesNode;
            for (TomlTableNode dependencyNode : dependencyTableArray.children()) {
                TopLevelNode pathNode = (TopLevelNode)dependencyNode.entries().get(PATH);
                String path = BalToolDescriptor.getStringFromTomlTableNode(pathNode);
                if (path == null) continue;
                Path absoluteJarPath = BalToolDescriptor.getAbsoluteJarPath(sourceRoot, path);
                if (absoluteJarPath.toFile().exists()) {
                    dependencies.add(new Dependency(absoluteJarPath.toString()));
                    continue;
                }
                dependencies.addAll(BalToolDescriptor.getDependenciesInDir(absoluteJarPath.toString()));
            }
        }
        return dependencies;
    }

    private static String getToolID(TomlTableNode tomlTableNode) {
        TopLevelNode topLevelNode;
        TomlTableNode toolNode = (TomlTableNode)tomlTableNode.entries().get(TOOL);
        if (toolNode != null && toolNode.kind() != TomlType.NONE && toolNode.kind() == TomlType.TABLE && (topLevelNode = (TopLevelNode)toolNode.entries().get(ID)) != null && topLevelNode.kind() != TomlType.NONE) {
            return BalToolDescriptor.getStringFromTomlTableNode(topLevelNode);
        }
        return null;
    }

    private static String getStringFromTomlTableNode(TopLevelNode topLevelNode) {
        TomlKeyValueNode keyValueNode;
        TomlValueNode value;
        if (topLevelNode != null && topLevelNode.kind() == TomlType.KEY_VALUE && (value = (keyValueNode = (TomlKeyValueNode)topLevelNode).value()).kind() == TomlType.STRING) {
            TomlStringValueNode stringValueNode = (TomlStringValueNode)value;
            return (String)stringValueNode.getValue();
        }
        return null;
    }

    private static Path getAbsoluteJarPath(Path sourceRoot, String path) {
        Path relativePath = Path.of(path, new String[0]);
        if (relativePath.isAbsolute()) {
            return relativePath;
        }
        return sourceRoot.toAbsolutePath().resolve(relativePath);
    }

    private static List<Dependency> getDependenciesInDir(String path) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        Path dependencyPath = Path.of(path, new String[0]);
        Optional<Path> patternPath = Optional.ofNullable(dependencyPath.getFileName());
        if (patternPath.isEmpty()) {
            return dependencies;
        }
        String pattern = patternPath.get().toString();
        Optional<Path> parentPath = Optional.ofNullable(dependencyPath.getParent());
        if (parentPath.isEmpty() || !parentPath.get().toFile().exists()) {
            return dependencies;
        }
        return BalToolDescriptor.getToolJarsMatchingPattern(pattern, parentPath.get()).stream().map(path1 -> new Dependency(path1.toString())).toList();
    }

    private static List<Path> getToolJarsMatchingPattern(String pattern, Path parentPath) {
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        ArrayList<Path> matchingPaths = new ArrayList<Path>();
        try (Stream<Path> paths = Files.list(parentPath);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                Path fileName = path.getFileName();
                return fileName != null && fileName.toString().endsWith(".jar");
            }).filter(path -> pathMatcher.matches(path.getFileName())).forEach(matchingPaths::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return matchingPaths;
    }

    public static class Tool {
        private String id;

        Tool(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class Dependency {
        private String path;

        Dependency(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

