/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.model;

import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.bala.CompilerPluginJson;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompilerPluginDescriptor {
    private static final String DEPENDENCY = "dependency";
    private static final String CLASS = "class";
    private final Plugin plugin;
    private final List<Dependency> dependencies;

    private CompilerPluginDescriptor(Plugin plugin, List<Dependency> dependencies) {
        this.plugin = plugin;
        this.dependencies = dependencies;
    }

    public static CompilerPluginDescriptor from(TomlDocument tomlDocument) {
        TomlTableNode tomlTableNode = tomlDocument.toml().rootNode();
        if (tomlTableNode.entries().isEmpty()) {
            return new CompilerPluginDescriptor(null, Collections.emptyList());
        }
        return new CompilerPluginDescriptor(new Plugin(CompilerPluginDescriptor.getPluginID(tomlTableNode), CompilerPluginDescriptor.getPluginClass(tomlTableNode)), CompilerPluginDescriptor.getDependencies(tomlTableNode));
    }

    public static CompilerPluginDescriptor from(CompilerPluginJson compilerPluginJson) {
        ArrayList<Dependency> dependencyList = new ArrayList<Dependency>();
        for (String path : compilerPluginJson.dependencyPaths()) {
            dependencyList.add(new Dependency(path));
        }
        return new CompilerPluginDescriptor(new Plugin(compilerPluginJson.pluginId(), compilerPluginJson.pluginClass()), dependencyList);
    }

    public Plugin plugin() {
        return this.plugin;
    }

    public List<Dependency> dependencies() {
        return this.dependencies;
    }

    public List<String> getCompilerPluginDependencies() {
        ArrayList<String> compilerPluginDependencies = new ArrayList<String>();
        for (Dependency dependency : this.dependencies) {
            compilerPluginDependencies.add(dependency.getPath());
        }
        return compilerPluginDependencies;
    }

    private static List<Dependency> getDependencies(TomlTableNode tomlTableNode) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        TopLevelNode dependenciesNode = (TopLevelNode)tomlTableNode.entries().get(DEPENDENCY);
        if (dependenciesNode != null && dependenciesNode.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode dependencyTableArray = (TomlTableArrayNode)dependenciesNode;
            for (TomlTableNode dependencyNode : dependencyTableArray.children()) {
                TopLevelNode pathNode = (TopLevelNode)dependencyNode.entries().get("path");
                dependencies.add(new Dependency(CompilerPluginDescriptor.getStringFromTomlTableNode(pathNode)));
            }
        }
        return dependencies;
    }

    private static String getPluginID(TomlTableNode tomlTableNode) {
        TopLevelNode topLevelNode;
        TomlTableNode pluginNode = (TomlTableNode)tomlTableNode.entries().get("plugin");
        if (pluginNode != null && pluginNode.kind() != TomlType.NONE && pluginNode.kind() == TomlType.TABLE && (topLevelNode = (TopLevelNode)pluginNode.entries().get("id")) != null && topLevelNode.kind() != TomlType.NONE) {
            return CompilerPluginDescriptor.getStringFromTomlTableNode(topLevelNode);
        }
        return null;
    }

    private static String getPluginClass(TomlTableNode tomlTableNode) {
        TopLevelNode topLevelNode;
        TomlTableNode pluginNode = (TomlTableNode)tomlTableNode.entries().get("plugin");
        if (pluginNode != null && pluginNode.kind() != TomlType.NONE && pluginNode.kind() == TomlType.TABLE && (topLevelNode = (TopLevelNode)pluginNode.entries().get(CLASS)) != null && topLevelNode.kind() != TomlType.NONE) {
            return CompilerPluginDescriptor.getStringFromTomlTableNode(topLevelNode);
        }
        return null;
    }

    private static String getStringFromTomlTableNode(TopLevelNode topLevelNode) {
        TomlKeyValueNode keyValueNode;
        TomlValueNode value;
        if (topLevelNode != null && topLevelNode.kind() == TomlType.KEY_VALUE && (value = (keyValueNode = (TomlKeyValueNode)topLevelNode).value()).kind() == TomlType.STRING) {
            TomlStringValueNode stringValueNode = (TomlStringValueNode)value;
            return (String)stringValueNode.getValue();
        }
        return null;
    }

    public static class Plugin {
        private String id;
        private String className;

        Plugin(String id, String className) {
            this.id = id;
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class Dependency {
        private String path;

        Dependency(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

