/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.repositories;

import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.internal.repositories.FileSystemRepository;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class LocalPackageRepository
extends FileSystemRepository {
    public LocalPackageRepository(Environment environment, Path cacheDirectory) {
        super(environment, cacheDirectory);
    }

    public LocalPackageRepository(Environment environment, Path cacheDirectory, String distributionVersion) {
        super(environment, cacheDirectory, distributionVersion);
    }

    @Override
    protected List<PackageVersion> getPackageVersions(PackageOrg org, PackageName name, PackageVersion version) {
        if (version == null) {
            return Collections.emptyList();
        }
        Path balaPath = this.getPackagePath(org.toString(), name.toString(), version.toString());
        if (Files.exists(balaPath, new LinkOption[0])) {
            return Collections.singletonList(version);
        }
        return Collections.emptyList();
    }
}

