/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class FileUtils {
    private static final String PNG_HEX_HEADER = "89504E470D0A1A0A";
    private static final PathMatcher FILE_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/Ballerina.toml");

    private FileUtils() {
    }

    public static String getFileNameWithoutExtension(String filePath) {
        Path fileName = Path.of(filePath, new String[0]).getFileName();
        if (null != fileName) {
            int index = FileUtils.indexOfExtension(fileName.toString());
            return index == -1 ? fileName.toString() : fileName.toString().substring(0, index);
        }
        return null;
    }

    public static boolean hasExtension(Path filePath) {
        Path fileName = filePath.getFileName();
        if (null != fileName) {
            int index = FileUtils.indexOfExtension(fileName.toString());
            return index != -1;
        }
        return false;
    }

    private static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    private static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String path) throws IOException {
        InputStream is = FileUtils.class.getClassLoader().getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Schema file not found: " + path);
        }
        InputStreamReader inputStreamReader = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            inputStreamReader = new InputStreamReader(is, StandardCharsets.UTF_8);
            br = new BufferedReader(inputStreamReader);
            String content = br.readLine();
            if (content == null) {
                String string = sb.toString();
                return string;
            }
            sb.append(content);
            while ((content = br.readLine()) != null) {
                sb.append('\n').append(content);
            }
            sb.append('\n');
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static void deletePath(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> paths = Files.list(path);){
                for (Path dir : paths.toList()) {
                    FileUtils.deletePath(dir);
                }
            }
        }
        Files.delete(path);
    }

    public static boolean isValidPng(Path filePath) throws IOException {
        return FileUtils.isMatchingImageFormat(filePath, PNG_HEX_HEADER, 8);
    }

    public static long lastModifiedTimeOfBalProject(Path projectRoot) {
        File[] files = projectRoot.toAbsolutePath().toFile().listFiles();
        long latestDate = 0L;
        if (files != null) {
            for (File file : files) {
                long fileModifiedDate = latestDate;
                Path filename = Optional.of(Optional.of(file.toPath()).orElseThrow()).orElseThrow();
                if (file.isDirectory()) {
                    if (file.toPath().equals(projectRoot.resolve("modules")) || file.toPath().equals(projectRoot.resolve("tests")) || file.toPath().equals(projectRoot.resolve("resources"))) {
                        fileModifiedDate = file.lastModified();
                    }
                } else if (file.toPath().equals(projectRoot.resolve("Ballerina.toml")) || file.toPath().equals(projectRoot.resolve("CompilerPlugin.toml"))) {
                    fileModifiedDate = file.lastModified();
                } else if (filename.toString().endsWith(".bal") && file.toPath().equals(projectRoot.resolve(filename))) {
                    fileModifiedDate = file.lastModified();
                }
                if (fileModifiedDate <= latestDate) continue;
                latestDate = fileModifiedDate;
            }
        }
        return latestDate;
    }

    /*
     * Loose catch block
     */
    private static boolean isMatchingImageFormat(Path imgPath, String formatHexValue, int formatOffset) throws IOException {
        FileInputStream fileInputStream;
        block10: {
            byte[] imgHeaderByteArray;
            block9: {
                fileInputStream = new FileInputStream(String.valueOf(imgPath));
                imgHeaderByteArray = new byte[formatOffset];
                int bytesRead = fileInputStream.read(imgHeaderByteArray, 0, formatOffset);
                if (bytesRead == 8) break block9;
                boolean bl = false;
                fileInputStream.close();
                return bl;
            }
            byte[] formatHeaderByteArray = Arrays.copyOfRange(new BigInteger(formatHexValue, 16).toByteArray(), 1, formatOffset + 1);
            if (!Arrays.equals(imgHeaderByteArray, formatHeaderByteArray)) break block10;
            boolean bl = true;
            fileInputStream.close();
            return bl;
        }
        try {
            block11: {
                break block11;
                catch (Exception e) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            fileInputStream.close();
        }
    }

    public static void addDeprecatedMetaFile(Path metaFilePath, String message) {
        if (!metaFilePath.toFile().exists()) {
            try {
                Files.createFile(metaFilePath, new FileAttribute[0]);
            }
            catch (IOException ignored) {
                return;
            }
        }
        if (metaFilePath.toFile().exists()) {
            try (FileWriter fileWriter = new FileWriter(metaFilePath.toAbsolutePath().toString(), Charset.defaultCharset());
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                bufferedWriter.write(message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void deleteDeprecatedMetaFile(Path metaFilePath) {
        try {
            Files.deleteIfExists(metaFilePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void replaceTemplateName(Path path, String templateName, String packageName) {
        Optional<Path> fileName = Optional.ofNullable(path.getFileName());
        if (fileName.isPresent() && fileName.get().toString().endsWith(".bal")) {
            try {
                String content = Files.readString(path);
                String oldImportStatementStart = "import " + templateName + ".";
                String newImportStatementStart = "import " + packageName + ".";
                if (content.contains(oldImportStatementStart)) {
                    content = content.replaceAll(oldImportStatementStart, newImportStatementStart);
                    Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while replacing template name in module import statements: " + String.valueOf(path), e);
            }
        }
    }

    public static List<Path> getFilesInDirectory(Path directoryPath) {
        ArrayList<Path> files = new ArrayList<Path>();
        try (Stream<Path> paths = Files.list(directoryPath);){
            paths.forEach(files::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return files;
    }

    public static boolean checkBallerinaTomlInExistingDir(Path startingDir) {
        BallerinaTomlChecker ballerinaTomlChecker = new BallerinaTomlChecker(startingDir);
        try {
            Files.walkFileTree(startingDir, ballerinaTomlChecker);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ballerinaTomlChecker.isBallerinaTomlFound();
    }

    public static class BallerinaTomlChecker
    extends SimpleFileVisitor<Path> {
        private final Path startingPath;
        private boolean ballerinaTomlFound = false;

        public boolean isBallerinaTomlFound() {
            return this.ballerinaTomlFound;
        }

        public void setBallerinaTomlFound(boolean ballerinaTomlFound) {
            this.ballerinaTomlFound = ballerinaTomlFound;
        }

        public BallerinaTomlChecker(Path startingPath) {
            this.startingPath = startingPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            int depth = dir.getNameCount() - this.startingPath.getNameCount();
            if (depth >= 10) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (FILE_MATCHER.matches(file)) {
                this.setBallerinaTomlFound(true);
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public static class Copy
    extends SimpleFileVisitor<Path> {
        private final Path fromPath;
        private final Path toPath;
        private final String templateName;
        private final String packageName;
        private final StandardCopyOption copyOption;

        public Copy(Path fromPath, Path toPath, String templateName, String packageName, StandardCopyOption copyOption) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.templateName = templateName;
            this.packageName = packageName;
            this.copyOption = copyOption;
        }

        public Copy(Path fromPath, Path toPath) {
            this(fromPath, toPath, "", "", StandardCopyOption.REPLACE_EXISTING);
        }

        public Copy(Path fromPath, Path toPath, String templateName, String packageName) {
            this(fromPath, toPath, templateName, packageName, StandardCopyOption.REPLACE_EXISTING);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir).toString());
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file).toString()), this.copyOption);
            if (!(this.packageName.equals("") || this.templateName.equals("") || this.packageName.equals(this.templateName))) {
                FileUtils.replaceTemplateName(this.toPath.resolve(this.fromPath.relativize(file).toString()), this.templateName, this.packageName);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

