/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.compiler;

public enum CompilerPhase {
    DEFINE("define"),
    TYPE_CHECK("typeCheck"),
    CODE_ANALYZE("codeAnalyze"),
    DATAFLOW_ANALYZE("dataflowAnalyze"),
    ISOLATION_ANALYZE("isolationAnalyze"),
    DOCUMENTATION_ANALYZE("documentationAnalyze"),
    CONSTANT_PROPAGATION("constantPropagation"),
    COMPILER_PLUGIN("compilerPlugin"),
    DESUGAR("desugar"),
    BIR_GEN("birGen"),
    BIR_EMIT("birEmit"),
    CODE_GEN("codeGen");

    private final String value;

    private CompilerPhase(String value) {
        this.value = value;
    }

    public static CompilerPhase fromValue(String value) {
        return switch (value) {
            case "define" -> DEFINE;
            case "typeCheck" -> TYPE_CHECK;
            case "codeAnalyze" -> CODE_ANALYZE;
            case "documentationAnalyze" -> DOCUMENTATION_ANALYZE;
            case "constantPropagation" -> CONSTANT_PROPAGATION;
            case "compilerPlugin" -> COMPILER_PLUGIN;
            case "desugar" -> DESUGAR;
            case "codeGen" -> CODE_GEN;
            case "birGen" -> BIR_GEN;
            case "birEmit" -> BIR_EMIT;
            default -> throw new IllegalArgumentException("invalid compiler phase: " + value);
        };
    }

    public String toString() {
        return this.value;
    }
}

