/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.model.types.TypeKind;

public final class TreeUtils {
    private static final Map<String, TypeKind> STRING_TYPE_KIND_MAP = new HashMap<String, TypeKind>();

    private TreeUtils() {
    }

    public static TypeKind stringToTypeKind(String typeName) {
        return STRING_TYPE_KIND_MAP.get(typeName);
    }

    static {
        STRING_TYPE_KIND_MAP.put("int", TypeKind.INT);
        STRING_TYPE_KIND_MAP.put("byte", TypeKind.BYTE);
        STRING_TYPE_KIND_MAP.put("float", TypeKind.FLOAT);
        STRING_TYPE_KIND_MAP.put("decimal", TypeKind.DECIMAL);
        STRING_TYPE_KIND_MAP.put("boolean", TypeKind.BOOLEAN);
        STRING_TYPE_KIND_MAP.put("string", TypeKind.STRING);
        STRING_TYPE_KIND_MAP.put("json", TypeKind.JSON);
        STRING_TYPE_KIND_MAP.put("xml", TypeKind.XML);
        STRING_TYPE_KIND_MAP.put("stream", TypeKind.STREAM);
        STRING_TYPE_KIND_MAP.put("table", TypeKind.TABLE);
        STRING_TYPE_KIND_MAP.put("any", TypeKind.ANY);
        STRING_TYPE_KIND_MAP.put("anydata", TypeKind.ANYDATA);
        STRING_TYPE_KIND_MAP.put("map", TypeKind.MAP);
        STRING_TYPE_KIND_MAP.put("future", TypeKind.FUTURE);
        STRING_TYPE_KIND_MAP.put("typedesc", TypeKind.TYPEDESC);
        STRING_TYPE_KIND_MAP.put("error", TypeKind.ERROR);
        STRING_TYPE_KIND_MAP.put("()", TypeKind.NIL);
        STRING_TYPE_KIND_MAP.put("null", TypeKind.NIL);
        STRING_TYPE_KIND_MAP.put("never", TypeKind.NEVER);
        STRING_TYPE_KIND_MAP.put("channel", TypeKind.CHANNEL);
        STRING_TYPE_KIND_MAP.put("service", TypeKind.SERVICE);
        STRING_TYPE_KIND_MAP.put("handle", TypeKind.HANDLE);
        STRING_TYPE_KIND_MAP.put("readonly", TypeKind.READONLY);
    }
}

