/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.Atom;
import io.ballerina.types.AtomicType;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Bdd;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.CellSemType;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.EnumerableCharString;
import io.ballerina.types.EnumerableDecimal;
import io.ballerina.types.EnumerableFloat;
import io.ballerina.types.EnumerableString;
import io.ballerina.types.Env;
import io.ballerina.types.FixedLengthArray;
import io.ballerina.types.FunctionAtomicType;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.PredefinedTypeEnv;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.TypeAtom;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.BooleanSubtype;
import io.ballerina.types.subtypedata.CharStringSubtype;
import io.ballerina.types.subtypedata.DecimalSubtype;
import io.ballerina.types.subtypedata.FloatSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.NonCharStringSubtype;
import io.ballerina.types.subtypedata.Range;
import io.ballerina.types.subtypedata.StringSubtype;
import io.ballerina.types.subtypedata.XmlSubtype;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.Annotatable;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.types.ConstrainedType;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationAttachmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BEnumSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.semantics.model.types.SemNamedType;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;
import org.wso2.ballerinalang.util.Flags;
import org.wso2.ballerinalang.util.LambdaExceptionUtils;

public class BIRPackageSymbolEnter {
    private final PackageCache packageCache;
    private final SymbolResolver symbolResolver;
    private final SymbolTable symTable;
    private final Names names;
    private final TypeParamAnalyzer typeParamAnalyzer;
    private final Types types;
    private BIRTypeReader typeReader;
    private BIRPackageSymbolEnv env;
    private List<BStructureTypeSymbol> structureTypes;
    private BStructureTypeSymbol currentStructure = null;
    private final LinkedList<Object> compositeStack = new LinkedList();
    private final Env typeEnv;
    private AtomOffsets offsets;
    private static final CompilerContext.Key<BIRPackageSymbolEnter> COMPILED_PACKAGE_SYMBOL_ENTER_KEY = new CompilerContext.Key();
    private final Map<String, BVarSymbol> globalVarMap = new HashMap<String, BVarSymbol>();

    public static BIRPackageSymbolEnter getInstance(CompilerContext context) {
        BIRPackageSymbolEnter packageReader = context.get(COMPILED_PACKAGE_SYMBOL_ENTER_KEY);
        if (packageReader == null) {
            packageReader = new BIRPackageSymbolEnter(context);
        }
        return packageReader;
    }

    private BIRPackageSymbolEnter(CompilerContext context) {
        context.put(COMPILED_PACKAGE_SYMBOL_ENTER_KEY, this);
        this.packageCache = PackageCache.getInstance(context);
        this.symbolResolver = SymbolResolver.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.types = Types.getInstance(context);
        this.typeEnv = this.symTable.typeEnv();
        this.offsets = null;
    }

    public BPackageSymbol definePackage(PackageID packageId, byte[] packageBinaryContent) {
        BPackageSymbol pkgSymbol = this.definePackage(packageId, new ByteArrayInputStream(packageBinaryContent));
        byte[] modifiedPkgBinaryContent = Arrays.copyOfRange(packageBinaryContent, 8, packageBinaryContent.length);
        pkgSymbol.birPackageFile = new CompiledBinaryFile.BIRPackageFile(modifiedPkgBinaryContent);
        SymbolEnv builtinEnv = this.symTable.pkgEnvMap.get(this.symTable.langAnnotationModuleSymbol);
        SymbolEnv pkgEnv = SymbolEnv.createPkgEnv(null, pkgSymbol.scope, builtinEnv);
        this.symTable.pkgEnvMap.put(pkgSymbol, pkgEnv);
        return pkgSymbol;
    }

    private BPackageSymbol definePackage(PackageID packageId, InputStream programFileInStream) {
        BPackageSymbol bPackageSymbol;
        DataInputStream dataInStream = new DataInputStream(programFileInStream);
        try {
            BIRPackageSymbolEnv prevEnv = this.env;
            this.env = new BIRPackageSymbolEnv();
            this.env.requestedPackageId = packageId;
            BPackageSymbol pkgSymbol = this.definePackage(dataInStream);
            this.env = prevEnv;
            bPackageSymbol = pkgSymbol;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new BLangCompilerException("failed to load the module '" + packageId.toString() + "' from its BIR" + (String)(e.getMessage() != null ? " due to: " + e.getMessage() : ""), e);
            }
        }
        dataInStream.close();
        return bPackageSymbol;
    }

    private BPackageSymbol definePackage(DataInputStream dataInStream) throws IOException {
        byte[] magic = new byte[4];
        dataInStream.read(magic, 0, 4);
        if (!Arrays.equals(magic, CompiledBinaryFile.BIRPackageFile.BIR_MAGIC)) {
            throw new BLangCompilerException("invalid magic number " + Arrays.toString(magic));
        }
        int version = dataInStream.readInt();
        if (version != 74) {
            throw new BLangCompilerException("unsupported program file version " + version);
        }
        this.env.constantPool = this.readConstantPool(dataInStream);
        int pkgCPIndex = dataInStream.readInt();
        return this.definePackage(dataInStream, pkgCPIndex);
    }

    private BPackageSymbol definePackage(DataInputStream dataInStream, int pkgCpIndex) throws IOException {
        CPEntry.PackageCPEntry pkgCpEntry = (CPEntry.PackageCPEntry)this.env.constantPool[pkgCpIndex];
        String orgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.orgNameCPIndex]).value;
        String pkgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.pkgNameCPIndex]).value;
        String moduleName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.moduleNameCPIndex]).value;
        String pkgVersion = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.versionCPIndex]).value;
        PackageID pkgId = this.createPackageID(orgName, pkgName, moduleName, pkgVersion);
        this.env.pkgSymbol = Symbols.createPackageSymbol(pkgId, this.symTable, SymbolOrigin.COMPILED_SOURCE);
        this.offsets = AtomOffsets.from(this.typeEnv);
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineImportPackage));
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineConstant));
        this.structureTypes = new ArrayList<BStructureTypeSymbol>();
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineTypeDef));
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::definePackageLevelVariables));
        this.readTypeDefBodies(dataInStream);
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineFunction));
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineAnnotations));
        this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineServiceDeclarations));
        this.populateReferencedFunctions();
        this.typeReader = null;
        this.offsets = null;
        return this.env.pkgSymbol;
    }

    private void populateReferencedFunctions() {
        for (BStructureTypeSymbol structureTypeSymbol : this.structureTypes) {
            BType referredStructureTypeSymbol = Types.getImpliedType(structureTypeSymbol.type);
            if (referredStructureTypeSymbol.tag != 34) continue;
            BObjectType objectType = (BObjectType)referredStructureTypeSymbol;
            for (BType ref : objectType.typeInclusions) {
                BType typeRef = Types.getImpliedType(ref);
                if (typeRef.tsymbol == null || typeRef.tsymbol.kind != SymbolKind.OBJECT) continue;
                List attachedFunctions = ((BObjectTypeSymbol)typeRef.tsymbol).attachedFuncs;
                for (BAttachedFunction function : attachedFunctions) {
                    String referencedFuncName;
                    Name funcName;
                    Scope.ScopeEntry matchingObjFuncSym;
                    if (Symbols.isPrivate(function.symbol) || (matchingObjFuncSym = objectType.tsymbol.scope.lookup(funcName = Names.fromString(Symbols.getAttachedFuncSymbolName(structureTypeSymbol.name.value, referencedFuncName = function.funcName.value)))) != Scope.NOT_FOUND_ENTRY) continue;
                    structureTypeSymbol.attachedFuncs.add(function);
                    ((BObjectTypeSymbol)structureTypeSymbol).referencedFunctions.add(function);
                }
            }
        }
    }

    private void readTypeDefBodies(DataInputStream dataInStream) throws IOException {
        dataInStream.readInt();
        Iterator<BStructureTypeSymbol> iterator = this.structureTypes.iterator();
        while (iterator.hasNext()) {
            BStructureTypeSymbol structureTypeSymbol;
            this.currentStructure = structureTypeSymbol = iterator.next();
            this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::defineFunction));
            this.defineSymbols(dataInStream, LambdaExceptionUtils.rethrow(this::readBType));
        }
        this.currentStructure = null;
    }

    private CPEntry[] readConstantPool(DataInputStream dataInStream) throws IOException {
        int constantPoolSize = dataInStream.readInt();
        CPEntry[] constantPool = new CPEntry[constantPoolSize];
        this.env.constantPool = constantPool;
        for (int i = 0; i < constantPoolSize; ++i) {
            byte cpTag = dataInStream.readByte();
            CPEntry.Type cpEntryType = CPEntry.Type.values()[cpTag - 1];
            constantPool[i] = this.readCPEntry(dataInStream, constantPool, cpEntryType, i);
        }
        return constantPool;
    }

    private CPEntry readCPEntry(DataInputStream dataInStream, CPEntry[] constantPool, CPEntry.Type cpEntryType, int i) throws IOException {
        switch (cpEntryType) {
            case CP_ENTRY_INTEGER: {
                return new CPEntry.IntegerCPEntry(dataInStream.readLong());
            }
            case CP_ENTRY_FLOAT: {
                return new CPEntry.FloatCPEntry(dataInStream.readDouble());
            }
            case CP_ENTRY_BOOLEAN: {
                return new CPEntry.BooleanCPEntry(dataInStream.readBoolean());
            }
            case CP_ENTRY_STRING: {
                int length = dataInStream.readInt();
                String strValue = null;
                if (length >= 0) {
                    byte[] bytes = new byte[length];
                    dataInStream.read(bytes, 0, length);
                    strValue = new String(bytes);
                }
                return new CPEntry.StringCPEntry(strValue);
            }
            case CP_ENTRY_PACKAGE: {
                return new CPEntry.PackageCPEntry(dataInStream.readInt(), dataInStream.readInt(), dataInStream.readInt(), dataInStream.readInt());
            }
            case CP_ENTRY_SHAPE: {
                this.env.unparsedBTypeCPs.put(i, this.readByteArray(dataInStream));
                return null;
            }
            case CP_ENTRY_BYTE: {
                return new CPEntry.ByteCPEntry(dataInStream.readInt());
            }
        }
        throw new IllegalStateException("unsupported constant pool entry type: " + cpEntryType.name());
    }

    private byte[] readByteArray(DataInputStream dataInStream) throws IOException {
        int length = dataInStream.readInt();
        byte[] bytes = new byte[length];
        dataInStream.readFully(bytes);
        return bytes;
    }

    private void defineSymbols(DataInputStream dataInStream, Consumer<DataInputStream> symbolDefineFunc) throws IOException {
        int symbolCount = dataInStream.readInt();
        for (int i = 0; i < symbolCount; ++i) {
            symbolDefineFunc.accept(dataInStream);
        }
    }

    private void defineImportPackage(DataInputStream dataInStream) throws IOException {
        String pkgVersion;
        String moduleName;
        String pkgName;
        String orgName = this.getStringCPEntryValue(dataInStream);
        PackageID importPkgID = this.createPackageID(orgName, pkgName = this.getStringCPEntryValue(dataInStream), moduleName = this.getStringCPEntryValue(dataInStream), pkgVersion = this.getStringCPEntryValue(dataInStream));
        BPackageSymbol importPackageSymbol = this.packageCache.getSymbol(importPkgID);
        if (importPackageSymbol == null) {
            throw new BLangCompilerException("cannot resolve module " + String.valueOf(importPkgID));
        }
        this.env.pkgSymbol.scope.define(importPkgID.name, importPackageSymbol);
        this.env.pkgSymbol.imports.add(importPackageSymbol);
    }

    private void defineFunction(DataInputStream dataInStream) throws IOException {
        Location pos = this.readPosition(dataInStream);
        String funcName = this.getStringCPEntryValue(dataInStream);
        String funcOrigName = this.getStringCPEntryValue(dataInStream);
        String workerName = this.getStringCPEntryValue(dataInStream);
        long flags = dataInStream.readLong();
        byte origin = dataInStream.readByte();
        BInvokableType funcType = (BInvokableType)this.readBType(dataInStream);
        BInvokableSymbol invokableSymbol = Symbols.createFunctionSymbol(flags, Names.fromString(funcName), Names.fromString(funcOrigName), this.env.pkgSymbol.pkgID, funcType, this.env.pkgSymbol, Symbols.isFlagOn(flags, 2L), pos, SymbolOrigin.toOrigin(origin));
        invokableSymbol.source = pos.lineRange().fileName();
        invokableSymbol.retType = funcType.retType;
        Scope scopeToDefine = this.env.pkgSymbol.scope;
        boolean isResourceFunction = dataInStream.readBoolean();
        if (this.currentStructure != null) {
            BType attachedType = Types.getImpliedType(this.currentStructure.type);
            invokableSymbol.owner = attachedType.tsymbol;
            invokableSymbol.name = Names.fromString(Symbols.getAttachedFuncSymbolName(attachedType.tsymbol.name.value, funcName));
            if (attachedType.tag == 34 || attachedType.tag == 12) {
                scopeToDefine = attachedType.tsymbol.scope;
                if (isResourceFunction) {
                    int pathParamCount = dataInStream.readInt();
                    ArrayList<BVarSymbol> pathParams = new ArrayList<BVarSymbol>(pathParamCount);
                    for (int i = 0; i < pathParamCount; ++i) {
                        Name pathParamName = Names.fromString(this.getStringCPEntryValue(dataInStream));
                        BType paramType = this.readBType(dataInStream);
                        BVarSymbol varSymbol = new BVarSymbol(0L, pathParamName, this.env.pkgSymbol.pkgID, paramType, null, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                        pathParams.add(varSymbol);
                    }
                    boolean restPathParamExist = dataInStream.readBoolean();
                    BVarSymbol restPathParam = null;
                    if (restPathParamExist) {
                        Name pathParamName = Names.fromString(this.getStringCPEntryValue(dataInStream));
                        BType paramType = this.readBType(dataInStream);
                        restPathParam = new BVarSymbol(0L, pathParamName, this.env.pkgSymbol.pkgID, paramType, null, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    }
                    int resourcePathCount = dataInStream.readInt();
                    ArrayList<Name> resourcePath = new ArrayList<Name>(resourcePathCount);
                    ArrayList<Location> resourcePathSegmentPosList = new ArrayList<Location>(resourcePathCount);
                    ArrayList<BType> pathSegmentTypeList = new ArrayList<BType>(resourcePathCount);
                    for (int i = 0; i < resourcePathCount; ++i) {
                        resourcePath.add(Names.fromString(this.getStringCPEntryValue(dataInStream)));
                        resourcePathSegmentPosList.add(this.readPosition(dataInStream));
                        pathSegmentTypeList.add(this.readBType(dataInStream));
                    }
                    Name accessor = Names.fromString(this.getStringCPEntryValue(dataInStream));
                    BResourceFunction resourceFunction = new BResourceFunction(Names.fromString(funcName), invokableSymbol, funcType, accessor, pathParams, restPathParam, this.symTable.builtinPos);
                    BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)attachedType.tsymbol;
                    ArrayList<BResourcePathSegmentSymbol> pathSegmentSymbols = new ArrayList<BResourcePathSegmentSymbol>(resourcePathCount);
                    BResourcePathSegmentSymbol parentResource = null;
                    for (int i = 0; i < resourcePathCount; ++i) {
                        Name resourcePathSymbolName = (Name)resourcePath.get(i);
                        BType resourcePathSegmentType = (BType)pathSegmentTypeList.get(i);
                        BResourcePathSegmentSymbol pathSym = Symbols.createResourcePathSegmentSymbol(resourcePathSymbolName, this.env.pkgSymbol.pkgID, resourcePathSegmentType, objectTypeSymbol, (Location)resourcePathSegmentPosList.get(i), parentResource, resourceFunction, SymbolOrigin.COMPILED_SOURCE);
                        objectTypeSymbol.resourcePathSegmentScope.define(pathSym.name, pathSym);
                        pathSegmentSymbols.add(pathSym);
                        parentResource = pathSym;
                    }
                    resourceFunction.pathSegmentSymbols = pathSegmentSymbols;
                    objectTypeSymbol.attachedFuncs.add(resourceFunction);
                } else {
                    BAttachedFunction attachedFunc = new BAttachedFunction(Names.fromString(funcName), invokableSymbol, funcType, this.symTable.builtinPos);
                    BStructureTypeSymbol structureTypeSymbol = (BStructureTypeSymbol)attachedType.tsymbol;
                    if (Names.USER_DEFINED_INIT_SUFFIX.value.equals(funcName) || funcName.equals(Names.INIT_FUNCTION_SUFFIX.value)) {
                        ((BObjectTypeSymbol)structureTypeSymbol).initializerFunc = attachedFunc;
                    } else if (funcName.equals(Names.GENERATED_INIT_SUFFIX.value)) {
                        ((BObjectTypeSymbol)structureTypeSymbol).generatedInitializerFunc = attachedFunc;
                    } else {
                        structureTypeSymbol.attachedFuncs.add(attachedFunc);
                    }
                }
            }
        }
        this.defineAnnotAttachmentSymbols(dataInStream, invokableSymbol);
        this.defineAnnotAttachmentSymbolsOnExternal(dataInStream, invokableSymbol);
        BTypeSymbol tsymbol = invokableSymbol.type.tsymbol;
        if (tsymbol == null) {
            dataInStream.skip(dataInStream.readLong());
        } else {
            ((BInvokableTypeSymbol)tsymbol).returnTypeAnnots.addAll(this.readAnnotAttachmentSymbols(dataInStream, invokableSymbol));
        }
        this.setParamSymbols(invokableSymbol, dataInStream);
        this.defineMarkDownDocAttachment(invokableSymbol, this.readDocBytes(dataInStream));
        this.defineGlobalVarDependencies(invokableSymbol, dataInStream);
        dataInStream.skip(dataInStream.readLong());
        dataInStream.skip(dataInStream.readLong());
        scopeToDefine.define(invokableSymbol.name, invokableSymbol);
    }

    private void defineGlobalVarDependencies(BInvokableSymbol invokableSymbol, DataInputStream dataInStream) throws IOException {
        long length = dataInStream.readInt();
        int i = 0;
        while ((long)i < length) {
            String globalVarName = this.getStringCPEntryValue(dataInStream.readInt());
            invokableSymbol.dependentGlobalVars.add(this.globalVarMap.get(globalVarName));
            ++i;
        }
    }

    private void defineTypeDef(DataInputStream dataInStream) throws IOException {
        BSymbol symbol;
        boolean isClass;
        Location pos = this.readPosition(dataInStream);
        String typeDefName = this.getStringCPEntryValue(dataInStream);
        String typeDefOrigName = this.getStringCPEntryValue(dataInStream);
        long flags = dataInStream.readLong();
        byte origin = dataInStream.readByte();
        byte[] docBytes = this.readDocBytes(dataInStream);
        BType type = this.readBType(dataInStream);
        BTypeReferenceType referenceType = null;
        boolean hasReferenceType = dataInStream.readBoolean();
        if (hasReferenceType) {
            if (type.tag == 14 && Objects.equals(type.tsymbol.name.value, typeDefName) && type.tsymbol.owner == this.env.pkgSymbol) {
                referenceType = (BTypeReferenceType)type;
                referenceType.tsymbol.pos = pos;
            } else {
                BTypeSymbol typeSymbol = new BTypeSymbol(0x20000000L, flags, Names.fromString(typeDefName), this.env.pkgSymbol.pkgID, type, this.env.pkgSymbol, pos, SymbolOrigin.COMPILED_SOURCE);
                referenceType = new BTypeReferenceType(type, typeSymbol, flags);
            }
        }
        if (type.tag == 17) {
            this.setInvokableTypeSymbol((BInvokableType)type);
        }
        flags = (isClass = Symbols.isFlagOn(type.tsymbol.flags, 0x10000000L)) ? flags | 0x10000000L : flags;
        flags = Symbols.isFlagOn(type.tsymbol.flags, 65536L) ? flags | 0x10000L : flags;
        boolean isEnum = Symbols.isFlagOn(type.tsymbol.flags, 0x200000000L);
        if (isClass || isEnum) {
            symbol = type.tsymbol;
            symbol.pos = pos;
        } else {
            symbol = Symbols.createTypeDefinitionSymbol(flags, Names.fromString(typeDefName), this.env.pkgSymbol.pkgID, type, this.env.pkgSymbol, pos, SymbolOrigin.COMPILED_SOURCE);
            ((BTypeDefinitionSymbol)symbol).referenceType = referenceType;
        }
        symbol.originalName = Names.fromString(typeDefOrigName);
        symbol.origin = SymbolOrigin.toOrigin(origin);
        symbol.flags = flags;
        this.defineMarkDownDocAttachment(symbol, docBytes);
        this.defineAnnotAttachmentSymbols(dataInStream, isClass || isEnum || symbol.tag == 32796L ? (Annotatable)((Object)symbol) : null);
        if (type.tsymbol.name == Names.EMPTY && type.tag != 17) {
            type.tsymbol.name = symbol.name;
            type.tsymbol.originalName = symbol.originalName;
        }
        if (type.tag == 12 || type.tag == 34) {
            if (!isClass) {
                ((BStructureTypeSymbol)type.tsymbol).typeDefinitionSymbol = (BTypeDefinitionSymbol)symbol;
            }
            type.tsymbol.origin = SymbolOrigin.toOrigin(origin);
            this.structureTypes.add((BStructureTypeSymbol)type.tsymbol);
        }
        this.env.pkgSymbol.scope.define(symbol.name, symbol);
    }

    private void skipPosition(DataInputStream dataInStream) throws IOException {
        for (int i = 0; i < 4; ++i) {
            dataInStream.readInt();
        }
    }

    private void setInvokableTypeSymbol(BInvokableType invokableType) {
        if (Symbols.isFlagOn(invokableType.getFlags(), 0x8000000000L)) {
            return;
        }
        BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)invokableType.tsymbol;
        if (invokableType.restType != null) {
            tsymbol.restParam = new BVarSymbol(0L, Names.EMPTY, this.env.pkgSymbol.pkgID, invokableType.restType, null, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        }
        tsymbol.returnType = invokableType.retType;
    }

    private void defineMarkDownDocAttachment(BSymbol symbol, byte[] docBytes) throws IOException {
        DataInputStream dataInStream = new DataInputStream(new ByteArrayInputStream(docBytes));
        boolean docPresent = dataInStream.readBoolean();
        if (!docPresent) {
            return;
        }
        int descCPIndex = dataInStream.readInt();
        int retDescCPIndex = dataInStream.readInt();
        int paramLength = dataInStream.readInt();
        MarkdownDocAttachment markdownDocAttachment = new MarkdownDocAttachment(paramLength);
        markdownDocAttachment.description = descCPIndex >= 0 ? this.getStringCPEntryValue(descCPIndex) : null;
        markdownDocAttachment.returnValueDescription = retDescCPIndex >= 0 ? this.getStringCPEntryValue(retDescCPIndex) : null;
        this.readAndSetParamDocumentation(dataInStream, markdownDocAttachment.parameters, paramLength);
        int deprecatedDescCPIndex = dataInStream.readInt();
        int deprecatedParamLength = dataInStream.readInt();
        markdownDocAttachment.deprecatedDocumentation = deprecatedDescCPIndex >= 0 ? this.getStringCPEntryValue(deprecatedDescCPIndex) : null;
        this.readAndSetParamDocumentation(dataInStream, markdownDocAttachment.deprecatedParams, deprecatedParamLength);
        symbol.markdownDocumentation = markdownDocAttachment;
    }

    private void readAndSetParamDocumentation(DataInputStream inputStream, List<MarkdownDocAttachment.Parameter> params, int nParams) throws IOException {
        for (int i = 0; i < nParams; ++i) {
            int nameCPIndex = inputStream.readInt();
            int paramDescCPIndex = inputStream.readInt();
            String name = nameCPIndex >= 0 ? this.getStringCPEntryValue(nameCPIndex) : null;
            String description = paramDescCPIndex >= 0 ? this.getStringCPEntryValue(paramDescCPIndex) : null;
            MarkdownDocAttachment.Parameter parameter = new MarkdownDocAttachment.Parameter(name, description);
            params.add(parameter);
        }
    }

    private BType readBType(DataInputStream dataInStream) throws IOException {
        int typeCpIndex = dataInStream.readInt();
        CPEntry cpEntry = this.env.constantPool[typeCpIndex];
        BType type = null;
        if (cpEntry != null) {
            type = ((CPEntry.ShapeCPEntry)cpEntry).shape;
            if (type.tag != 17) {
                return type;
            }
        }
        if (type == null) {
            byte[] e = this.env.unparsedBTypeCPs.get(typeCpIndex);
            type = new BIRTypeReader(new DataInputStream(new ByteArrayInputStream(e))).readType(typeCpIndex);
            this.addShapeCP(type, typeCpIndex);
        }
        return type;
    }

    private void addShapeCP(BType bType, int typeCpIndex) {
        this.env.constantPool[typeCpIndex] = new CPEntry.ShapeCPEntry(bType);
    }

    private void defineAnnotations(DataInputStream dataInStream) throws IOException {
        BAnnotationSymbol annotationSymbol = this.defineAnnotation(dataInStream);
        this.env.pkgSymbol.scope.define(annotationSymbol.name, annotationSymbol);
    }

    private BAnnotationSymbol defineAnnotation(DataInputStream dataInStream) throws IOException {
        int pkgCpIndex = dataInStream.readInt();
        PackageID pkgId = this.getPackageId(pkgCpIndex);
        String name = this.getStringCPEntryValue(dataInStream);
        String originalName = this.getStringCPEntryValue(dataInStream);
        long flags = dataInStream.readLong();
        byte origin = dataInStream.readByte();
        Location pos = this.readPosition(dataInStream);
        int attachPointCount = dataInStream.readInt();
        HashSet<AttachPoint> attachPoints = new HashSet<AttachPoint>(attachPointCount);
        for (int i = 0; i < attachPointCount; ++i) {
            attachPoints.add(AttachPoint.getAttachmentPoint(this.getStringCPEntryValue(dataInStream), dataInStream.readBoolean()));
        }
        BType annotationType = this.readBType(dataInStream);
        BPackageSymbol pkgSymbol = pkgId.equals(this.env.pkgSymbol.pkgID) ? this.env.pkgSymbol : this.packageCache.getSymbol(pkgId);
        BAnnotationSymbol annotationSymbol = Symbols.createAnnotationSymbol(flags, attachPoints, Names.fromString(name), Names.fromString(originalName), pkgId, null, pkgSymbol, pos, SymbolOrigin.toOrigin(origin));
        annotationSymbol.type = new BAnnotationType(annotationSymbol);
        this.defineMarkDownDocAttachment(annotationSymbol, this.readDocBytes(dataInStream));
        this.defineAnnotAttachmentSymbols(dataInStream, annotationSymbol);
        if (annotationType != this.symTable.noType) {
            annotationSymbol.attachedType = annotationType;
        }
        return annotationSymbol;
    }

    private BAnnotationAttachmentSymbol defineAnnotationAttachmentSymbol(DataInputStream dataInStream, BSymbol owner) throws IOException {
        PackageID pkgId = this.getPackageId(dataInStream.readInt());
        Location pos = this.readPosition(dataInStream);
        Name annotTagRef = Names.fromString(this.getStringCPEntryValue(dataInStream.readInt()));
        boolean constAnnotation = dataInStream.readBoolean();
        if (!constAnnotation) {
            return new BAnnotationAttachmentSymbol(pkgId, annotTagRef, this.env.pkgSymbol.pkgID, owner, pos, SymbolOrigin.COMPILED_SOURCE, null);
        }
        BType constantValType = this.readBType(dataInStream);
        BConstantSymbol constantSymbol = new BConstantSymbol(0L, Names.EMPTY, Names.EMPTY, this.env.pkgSymbol.pkgID, null, constantValType, owner, pos, SymbolOrigin.COMPILED_SOURCE);
        constantSymbol.value = this.readConstLiteralValue(constantValType, dataInStream);
        constantSymbol.literalType = constantSymbol.value.type;
        return new BAnnotationAttachmentSymbol.BConstAnnotationAttachmentSymbol(pkgId, annotTagRef, this.env.pkgSymbol.pkgID, owner, pos, SymbolOrigin.COMPILED_SOURCE, constantSymbol, null);
    }

    private void defineConstant(DataInputStream dataInStream) throws IOException {
        String constantName = this.getStringCPEntryValue(dataInStream);
        long flags = dataInStream.readLong();
        byte origin = dataInStream.readByte();
        Location pos = this.readPosition(dataInStream);
        byte[] docBytes = this.readDocBytes(dataInStream);
        BType type = this.readBType(dataInStream);
        Scope enclScope = this.env.pkgSymbol.scope;
        BConstantSymbol constantSymbol = new BConstantSymbol(flags, Names.fromString(constantName), this.env.pkgSymbol.pkgID, null, type, enclScope.owner, pos, SymbolOrigin.toOrigin(origin));
        this.defineMarkDownDocAttachment(constantSymbol, docBytes);
        this.defineAnnotAttachmentSymbols(dataInStream, constantSymbol);
        dataInStream.readLong();
        BType constantValType = this.readBType(dataInStream);
        constantSymbol.value = this.readConstLiteralValue(constantValType, dataInStream);
        constantSymbol.literalType = constantSymbol.value.type;
        enclScope.define(constantSymbol.name, constantSymbol);
    }

    private BLangConstantValue readConstLiteralValue(BType valueType, DataInputStream dataInStream) throws IOException {
        switch (valueType.tag) {
            case 1: {
                return new BLangConstantValue(this.getIntCPEntryValue(dataInStream), this.symTable.intType);
            }
            case 2: {
                return new BLangConstantValue(this.getByteCPEntryValue(dataInStream), this.symTable.byteType);
            }
            case 3: {
                return new BLangConstantValue(this.getFloatCPEntryValue(dataInStream), this.symTable.floatType);
            }
            case 5: {
                return new BLangConstantValue(this.getStringCPEntryValue(dataInStream), this.symTable.stringType);
            }
            case 4: {
                return new BLangConstantValue(this.getStringCPEntryValue(dataInStream), this.symTable.decimalType);
            }
            case 6: {
                return new BLangConstantValue(dataInStream.readBoolean(), this.symTable.booleanType);
            }
            case 10: {
                return new BLangConstantValue(null, this.symTable.nilType);
            }
            case 12: {
                int size = dataInStream.readInt();
                LinkedHashMap<String, BLangConstantValue> keyValuePairs = new LinkedHashMap<String, BLangConstantValue>();
                for (int i = 0; i < size; ++i) {
                    String key = this.getStringCPEntryValue(dataInStream);
                    BType type = this.readBType(dataInStream);
                    BLangConstantValue value = this.readConstLiteralValue(type, dataInStream);
                    keyValuePairs.put(key, value);
                }
                return new BLangConstantValue(keyValuePairs, valueType);
            }
            case 31: {
                int tupleSize = dataInStream.readInt();
                ArrayList<BLangConstantValue> members = new ArrayList<BLangConstantValue>(tupleSize);
                for (int i = 0; i < tupleSize; ++i) {
                    BType type = this.readBType(dataInStream);
                    BLangConstantValue value = this.readConstLiteralValue(type, dataInStream);
                    members.add(value);
                }
                return new BLangConstantValue(members, valueType);
            }
            case 22: {
                return this.readConstLiteralValue(((BIntersectionType)valueType).effectiveType, dataInStream);
            }
            case 14: {
                return this.readConstLiteralValue(Types.getImpliedType(valueType), dataInStream);
            }
        }
        throw new RuntimeException("unexpected type: " + String.valueOf(valueType));
    }

    private void defineServiceDeclarations(DataInputStream inputStream) throws IOException {
        String serviceName = this.getStringCPEntryValue(inputStream);
        String associatedClassName = this.getStringCPEntryValue(inputStream);
        long flags = inputStream.readLong();
        byte origin = inputStream.readByte();
        Location pos = this.readPosition(inputStream);
        BType type = null;
        if (inputStream.readBoolean()) {
            type = this.readBType(inputStream);
        }
        ArrayList<String> attachPoint = null;
        if (inputStream.readBoolean()) {
            attachPoint = new ArrayList<String>();
            int nSegments = inputStream.readInt();
            for (int i = 0; i < nSegments; ++i) {
                attachPoint.add(this.getStringCPEntryValue(inputStream));
            }
        }
        String attachPointLiteral = null;
        if (inputStream.readBoolean()) {
            attachPointLiteral = this.getStringCPEntryValue(inputStream);
        }
        BSymbol classSymbol = this.env.pkgSymbol.scope.lookup((Name)Names.fromString((String)associatedClassName)).symbol;
        BServiceSymbol serviceDecl = new BServiceSymbol((BClassSymbol)classSymbol, flags, Names.fromString(serviceName), this.env.pkgSymbol.pkgID, type, (BSymbol)this.env.pkgSymbol, pos, SymbolOrigin.toOrigin(origin));
        int nListeners = inputStream.readInt();
        for (int i = 0; i < nListeners; ++i) {
            serviceDecl.addListenerType(this.readBType(inputStream));
        }
        serviceDecl.setAttachPointStringLiteral(attachPointLiteral);
        serviceDecl.setAbsResourcePath(attachPoint);
        this.env.pkgSymbol.scope.define(Names.fromString(serviceName), serviceDecl);
    }

    private void definePackageLevelVariables(DataInputStream dataInStream) throws IOException {
        BVarSymbol varSymbol;
        Location pos = this.readPosition(dataInStream);
        dataInStream.readByte();
        String varName = this.getStringCPEntryValue(dataInStream);
        long flags = dataInStream.readLong();
        byte origin = dataInStream.readByte();
        byte[] docBytes = this.readDocBytes(dataInStream);
        BType varType = this.readBType(dataInStream);
        BType referredVarType = Types.getImpliedType(varType);
        Scope enclScope = this.env.pkgSymbol.scope;
        if (referredVarType.tag == 17) {
            BInvokableTypeSymbol bInvokableTypeSymbol = (BInvokableTypeSymbol)referredVarType.tsymbol;
            BInvokableSymbol invokableSymbol = new BInvokableSymbol(52L, flags, Names.fromString(varName), this.env.pkgSymbol.pkgID, referredVarType, enclScope.owner, this.symTable.builtinPos, SymbolOrigin.toOrigin(origin));
            invokableSymbol.kind = SymbolKind.FUNCTION;
            if (bInvokableTypeSymbol != null) {
                invokableSymbol.params = bInvokableTypeSymbol.params;
                invokableSymbol.restParam = bInvokableTypeSymbol.restParam;
            }
            invokableSymbol.retType = ((BInvokableType)invokableSymbol.type).retType;
            varSymbol = invokableSymbol;
        } else {
            varSymbol = new BVarSymbol(flags, Names.fromString(varName), this.env.pkgSymbol.pkgID, varType, enclScope.owner, this.symTable.builtinPos, SymbolOrigin.toOrigin(origin));
            if (varType.tsymbol != null && Symbols.isFlagOn(varType.tsymbol.flags, 65536L)) {
                varSymbol.tag = 16436L;
            }
        }
        varSymbol.pos = pos;
        this.globalVarMap.put(varName, varSymbol);
        this.defineMarkDownDocAttachment(varSymbol, docBytes);
        this.defineAnnotAttachmentSymbols(dataInStream, varSymbol);
        enclScope.define(varSymbol.name, varSymbol);
    }

    private void setParamSymbols(BInvokableSymbol invokableSymbol, DataInputStream dataInStream) throws IOException {
        int requiredParamCount = dataInStream.readInt();
        BInvokableType invokableType = (BInvokableType)invokableSymbol.type;
        for (int i = 0; i < requiredParamCount; ++i) {
            String paramName = this.getStringCPEntryValue(dataInStream);
            long flags = dataInStream.readLong();
            BVarSymbol varSymbol = new BVarSymbol(flags, Names.fromString(paramName), this.env.pkgSymbol.pkgID, invokableType.paramTypes.get(i), invokableSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
            varSymbol.isDefaultable = (flags & 0x1000L) == 4096L;
            this.defineAnnotAttachmentSymbols(dataInStream, varSymbol);
            invokableSymbol.params.add(varSymbol);
        }
        if (dataInStream.readBoolean()) {
            Object restParam;
            String paramName = this.getStringCPEntryValue(dataInStream);
            invokableSymbol.restParam = restParam = new BVarSymbol(0L, Names.fromString(paramName), this.env.pkgSymbol.pkgID, invokableType.restType, invokableSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
            this.defineAnnotAttachmentSymbols(dataInStream, (Annotatable)restParam);
        }
        if (Symbols.isFlagOn(invokableSymbol.retType.getFlags(), 0x4000000L)) {
            HashMap<Name, BVarSymbol> paramsMap = new HashMap<Name, BVarSymbol>();
            for (BVarSymbol param : invokableSymbol.params) {
                if (paramsMap.put(param.getName(), param) == null) continue;
                throw new IllegalStateException("duplicate key: " + String.valueOf(param.getName()));
            }
            this.populateParameterizedType(invokableSymbol.retType, paramsMap, invokableSymbol);
        }
        BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)invokableType.tsymbol;
        tsymbol.flags = invokableSymbol.flags;
        tsymbol.params = invokableSymbol.params;
        tsymbol.restParam = invokableSymbol.restParam;
        tsymbol.returnType = invokableSymbol.retType;
        boolean hasReceiver = dataInStream.readBoolean();
        if (hasReceiver) {
            dataInStream.readByte();
            this.readBType(dataInStream);
            this.getStringCPEntryValue(dataInStream);
        }
    }

    private void defineAnnotAttachmentSymbols(DataInputStream dataInStream, Annotatable owner) throws IOException {
        owner.getAnnotations().addAll(this.readAnnotAttachmentSymbols(dataInStream, (BSymbol)((Object)owner)));
    }

    private void defineAnnotAttachmentSymbolsOnExternal(DataInputStream dataInStream, BInvokableSymbol owner) throws IOException {
        if (Symbols.isFlagOn(owner.flags, 2L)) {
            owner.setAnnotationAttachmentsOnExternal(this.readAnnotAttachmentSymbols(dataInStream, owner));
        }
    }

    private List<BAnnotationAttachmentSymbol> readAnnotAttachmentSymbols(DataInputStream dataInStream, BSymbol owner) throws IOException {
        dataInStream.readLong();
        int annotSymbolCount = dataInStream.readInt();
        if (annotSymbolCount == 0) {
            return new ArrayList<BAnnotationAttachmentSymbol>(0);
        }
        ArrayList<BAnnotationAttachmentSymbol> annotationAttachmentSymbols = new ArrayList<BAnnotationAttachmentSymbol>(annotSymbolCount);
        for (int j = 0; j < annotSymbolCount; ++j) {
            annotationAttachmentSymbols.add(this.defineAnnotationAttachmentSymbol(dataInStream, owner));
        }
        return annotationAttachmentSymbols;
    }

    private void populateParameterizedType(BType type, Map<Name, BVarSymbol> paramsMap, BInvokableSymbol invSymbol) {
        if (type == null) {
            return;
        }
        type = Types.getImpliedType(type);
        switch (type.tag) {
            case 52: {
                BParameterizedType varType = (BParameterizedType)type;
                varType.paramSymbol = paramsMap.get(varType.name);
                varType.tsymbol = new BTypeSymbol(12L, 0x4000000L | varType.paramSymbol.flags, varType.paramSymbol.name, varType.paramSymbol.originalName, varType.paramSymbol.pkgID, varType, invSymbol, varType.paramSymbol.pos, SymbolOrigin.VIRTUAL);
                break;
            }
            case 13: 
            case 16: 
            case 32: {
                ConstrainedType constrainedType = (ConstrainedType)((Object)type);
                this.populateParameterizedType((BType)constrainedType.getConstraint(), paramsMap, invSymbol);
                break;
            }
            case 8: {
                this.populateParameterizedType(((BXMLType)type).constraint, paramsMap, invSymbol);
                break;
            }
            case 20: {
                this.populateParameterizedType(((BArrayType)type).eType, paramsMap, invSymbol);
                break;
            }
            case 31: {
                BTupleType tupleType = (BTupleType)type;
                for (BType tupleMemberType : tupleType.getTupleTypes()) {
                    this.populateParameterizedType(tupleMemberType, paramsMap, invSymbol);
                }
                this.populateParameterizedType(tupleType.restType, paramsMap, invSymbol);
                break;
            }
            case 15: {
                BStreamType streamType = (BStreamType)type;
                this.populateParameterizedType(streamType.constraint, paramsMap, invSymbol);
                this.populateParameterizedType(streamType.completionType, paramsMap, invSymbol);
                break;
            }
            case 9: {
                BTableType tableType = (BTableType)type;
                this.populateParameterizedType(tableType.constraint, paramsMap, invSymbol);
                this.populateParameterizedType(tableType.keyTypeConstraint, paramsMap, invSymbol);
                break;
            }
            case 17: {
                BInvokableType invokableType = (BInvokableType)type;
                if (Symbols.isFlagOn(invokableType.getFlags(), 0x8000000000L)) break;
                for (BType t : invokableType.paramTypes) {
                    this.populateParameterizedType(t, paramsMap, invSymbol);
                }
                this.populateParameterizedType(invokableType.restType, paramsMap, invSymbol);
                this.populateParameterizedType(invokableType.retType, paramsMap, invSymbol);
                break;
            }
            case 21: {
                BUnionType unionType = (BUnionType)type;
                for (BType t : unionType.getMemberTypes()) {
                    this.populateParameterizedType(t, paramsMap, invSymbol);
                }
                break;
            }
        }
    }

    private Location readPosition(DataInputStream dataInStream) throws IOException {
        String cUnitName = this.getStringCPEntryValue(dataInStream);
        int sLine = dataInStream.readInt();
        int sCol = dataInStream.readInt();
        int eLine = dataInStream.readInt();
        int eCol = dataInStream.readInt();
        return new BLangDiagnosticLocation(cUnitName, sLine, eLine, sCol, eCol);
    }

    private String getStringCPEntryValue(DataInputStream dataInStream) throws IOException {
        int pkgNameCPIndex = dataInStream.readInt();
        CPEntry.StringCPEntry stringCPEntry = (CPEntry.StringCPEntry)this.env.constantPool[pkgNameCPIndex];
        return stringCPEntry.value;
    }

    private String getStringCPEntryValue(int cpIndex) {
        CPEntry.StringCPEntry stringCPEntry = (CPEntry.StringCPEntry)this.env.constantPool[cpIndex];
        return stringCPEntry.value;
    }

    private long getIntCPEntryValue(DataInputStream dataInStream) throws IOException {
        int pkgNameCPIndex = dataInStream.readInt();
        CPEntry.IntegerCPEntry intCPEntry = (CPEntry.IntegerCPEntry)this.env.constantPool[pkgNameCPIndex];
        return intCPEntry.value;
    }

    private int getByteCPEntryValue(DataInputStream dataInStream) throws IOException {
        int byteCpIndex = dataInStream.readInt();
        CPEntry.ByteCPEntry byteCPEntry = (CPEntry.ByteCPEntry)this.env.constantPool[byteCpIndex];
        return byteCPEntry.value;
    }

    private String getFloatCPEntryValue(DataInputStream dataInStream) throws IOException {
        int floatCpIndex = dataInStream.readInt();
        CPEntry.FloatCPEntry floatCPEntry = (CPEntry.FloatCPEntry)this.env.constantPool[floatCpIndex];
        return Double.toString(floatCPEntry.value);
    }

    private PackageID createPackageID(String orgName, String pkgName, String moduleName, String pkgVersion) {
        if (orgName == null || orgName.isEmpty()) {
            throw new BLangCompilerException("invalid module name '" + moduleName + "' in compiled package file");
        }
        return new PackageID(Names.fromString(orgName), Names.fromString(pkgName), Names.fromString(moduleName), Names.fromString(pkgVersion), null);
    }

    private BType lookupSymbolInMainSpace(SymbolEnv pkgEnv, Name name) {
        return this.symbolResolver.lookupSymbolInMainSpace((SymbolEnv)pkgEnv, (Name)name).type;
    }

    private byte[] readDocBytes(DataInputStream inputStream) throws IOException {
        byte[] docBytes;
        int noOfBytesRead;
        int docLength = inputStream.readInt();
        if (docLength != (noOfBytesRead = inputStream.read(docBytes = new byte[docLength]))) {
            throw new RuntimeException("failed to read Markdown Documentation");
        }
        return docBytes;
    }

    private PackageID getPackageId(int pkgCPIndex) {
        CPEntry.PackageCPEntry pkgCpEntry = (CPEntry.PackageCPEntry)this.env.constantPool[pkgCPIndex];
        String orgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.orgNameCPIndex]).value;
        String pkgName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.pkgNameCPIndex]).value;
        String moduleName = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.moduleNameCPIndex]).value;
        String version = ((CPEntry.StringCPEntry)this.env.constantPool[pkgCpEntry.versionCPIndex]).value;
        return new PackageID(Names.fromString(orgName), Names.fromString(pkgName), Names.fromString(moduleName), Names.fromString(version), null);
    }

    private boolean isImmutable(long flags) {
        return Symbols.isFlagOn(flags, 32L);
    }

    private BType getEffectiveImmutableType(BType type) {
        return ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, type, type.tsymbol.pkgID, type.tsymbol.owner, this.symTable, null, this.names);
    }

    private BType getEffectiveImmutableType(BType type, PackageID pkgID, BSymbol owner) {
        return ImmutableTypeCloner.getEffectiveImmutableType(null, this.types, type, pkgID, owner, this.symTable, null, this.names);
    }

    private record AtomOffsets(int atomOffset, int listOffset, int functionOffset, int mappingOffset, int distinctOffset) {
        static AtomOffsets from(Env env) {
            PredefinedTypeEnv predefinedTypeEnv = PredefinedTypeEnv.getInstance();
            int recAtomOffset = predefinedTypeEnv.reservedRecAtomCount();
            return new AtomOffsets(env.atomCount(), env.recListAtomCount() - recAtomOffset, env.recFunctionAtomCount(), env.recMappingAtomCount() - recAtomOffset, env.distinctAtomCount());
        }
    }

    private static class BIRPackageSymbolEnv {
        PackageID requestedPackageId;
        Map<Integer, byte[]> unparsedBTypeCPs = new HashMap<Integer, byte[]>();
        BPackageSymbol pkgSymbol;
        CPEntry[] constantPool;
        List<UnresolvedType> unresolvedTypes = new ArrayList<UnresolvedType>();

        BIRPackageSymbolEnv() {
        }
    }

    private class BIRTypeReader {
        private final DataInputStream inputStream;
        private final PredefinedTypeEnv predefinedTypeEnv = PredefinedTypeEnv.getInstance();

        public BIRTypeReader(DataInputStream inputStream) {
            this.inputStream = inputStream;
        }

        private BType readTypeFromCp() throws IOException {
            return BIRPackageSymbolEnter.this.readBType(this.inputStream);
        }

        private BInvokableType setTSymbolForInvokableType(BInvokableType bInvokableType, BType retType) throws IOException {
            BVarSymbol varSymbol;
            BType fieldType;
            byte[] docBytes;
            BInvokableTypeSymbol tSymbol = (BInvokableTypeSymbol)bInvokableType.tsymbol;
            boolean hasTSymbol = this.inputStream.readBoolean();
            if (!hasTSymbol) {
                return bInvokableType;
            }
            int params = this.inputStream.readInt();
            for (int i = 0; i < params; ++i) {
                String paramName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                long paramFlags = this.inputStream.readLong();
                docBytes = BIRPackageSymbolEnter.this.readDocBytes(this.inputStream);
                fieldType = this.readTypeFromCp();
                varSymbol = new BVarSymbol(paramFlags, Names.fromString(paramName), tSymbol.pkgID, fieldType, tSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                varSymbol.isDefaultable = (paramFlags & 0x1000L) == 4096L;
                BIRPackageSymbolEnter.this.defineMarkDownDocAttachment(varSymbol, docBytes);
                tSymbol.params.add(varSymbol);
            }
            boolean hasRestParam = this.inputStream.readBoolean();
            if (hasRestParam) {
                String fieldName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                long fieldFlags = this.inputStream.readLong();
                docBytes = BIRPackageSymbolEnter.this.readDocBytes(this.inputStream);
                fieldType = this.readTypeFromCp();
                varSymbol = new BVarSymbol(fieldFlags, Names.fromString(fieldName), tSymbol.pkgID, fieldType, tSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                BIRPackageSymbolEnter.this.defineMarkDownDocAttachment(varSymbol, docBytes);
                tSymbol.restParam = varSymbol;
            }
            tSymbol.returnType = retType;
            int defaultValues = this.inputStream.readInt();
            for (int i = 0; i < defaultValues; ++i) {
                String paramName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                BInvokableSymbol invokableSymbol = this.getSymbolOfClosure();
                tSymbol.defaultValues.put(paramName, invokableSymbol);
            }
            return bInvokableType;
        }

        private BInvokableSymbol getSymbolOfClosure() throws IOException {
            String name = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
            long flags = this.inputStream.readLong();
            BType type = this.readTypeFromCp();
            int pkgCpIndex = this.inputStream.readInt();
            PackageID pkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
            BInvokableSymbol invokableSymbol = Symbols.createFunctionSymbol(flags, Names.fromString(name), Names.fromString(name), pkgId, type, null, false, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
            invokableSymbol.retType = invokableSymbol.type.getReturnType();
            int parameters = this.inputStream.readInt();
            for (int i = 0; i < parameters; ++i) {
                String fieldName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                long fieldFlags = this.inputStream.readLong();
                byte[] docBytes = BIRPackageSymbolEnter.this.readDocBytes(this.inputStream);
                BType fieldType = this.readTypeFromCp();
                BVarSymbol varSymbol = new BVarSymbol(fieldFlags, Names.fromString(fieldName), pkgId, fieldType, null, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                BIRPackageSymbolEnter.this.defineMarkDownDocAttachment(varSymbol, docBytes);
                invokableSymbol.params.add(varSymbol);
            }
            return invokableSymbol;
        }

        public BType readType(int cpI) throws IOException {
            byte tag = this.inputStream.readByte();
            Name name = Names.fromString(BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream));
            long flags = this.inputStream.readLong();
            switch (tag) {
                case 1: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.intType, name, flags);
                }
                case 2: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.byteType, name, flags);
                }
                case 3: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.floatType, name, flags);
                }
                case 4: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.decimalType, name, flags);
                }
                case 5: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.stringType, name, flags);
                }
                case 6: {
                    return BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.booleanType, name, flags);
                }
                case 7: {
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(BIRPackageSymbolEnter.this.symTable.jsonType) : BIRPackageSymbolEnter.this.symTable.jsonType;
                }
                case 8: {
                    BType constraintType = this.readTypeFromCp();
                    BXMLType mutableXmlType = new BXMLType(constraintType, BIRPackageSymbolEnter.this.symTable.xmlType.tsymbol);
                    if (Symbols.isFlagOn(flags, 0x4000000L)) {
                        mutableXmlType.addFlags(0x4000000L);
                    }
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(mutableXmlType) : mutableXmlType;
                }
                case 10: {
                    return BIRPackageSymbolEnter.this.symTable.nilType;
                }
                case 50: {
                    return BIRPackageSymbolEnter.this.symTable.neverType;
                }
                case 11: {
                    if (name.getValue().equals(Names.ANYDATA.getValue())) {
                        name = Names.EMPTY;
                    }
                    BType anydataNominalType = BIRPackageSymbolEnter.this.typeParamAnalyzer.getNominalType(BIRPackageSymbolEnter.this.symTable.anydataType, name, flags);
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(anydataNominalType, BIRPackageSymbolEnter.this.symTable.anydataType.tsymbol.pkgID, BIRPackageSymbolEnter.this.symTable.anydataType.tsymbol.owner) : anydataNominalType;
                }
                case 12: {
                    int pkgCpIndex = this.inputStream.readInt();
                    PackageID pkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
                    String recordName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.fromString(recordName), BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    recordSymbol.scope = new Scope(recordSymbol);
                    BRecordType recordType = new BRecordType(BIRPackageSymbolEnter.this.symTable.typeEnv(), (BTypeSymbol)recordSymbol, flags);
                    recordSymbol.type = recordType;
                    BIRPackageSymbolEnter.this.compositeStack.push(recordType);
                    BIRPackageSymbolEnter.this.addShapeCP(recordType, cpI);
                    recordType.sealed = this.inputStream.readBoolean();
                    recordType.restFieldType = this.readTypeFromCp();
                    int recordFields = this.inputStream.readInt();
                    for (int i = 0; i < recordFields; ++i) {
                        String fieldName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                        long fieldFlags = this.inputStream.readLong();
                        byte[] docBytes = BIRPackageSymbolEnter.this.readDocBytes(this.inputStream);
                        BType fieldType = this.readTypeFromCp();
                        BVarSymbol varSymbol = new BVarSymbol(fieldFlags, Names.fromString(fieldName), recordSymbol.pkgID, fieldType, recordSymbol.scope.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                        BIRPackageSymbolEnter.this.defineAnnotAttachmentSymbols(this.inputStream, varSymbol);
                        BIRPackageSymbolEnter.this.defineMarkDownDocAttachment(varSymbol, docBytes);
                        BField structField = new BField(varSymbol.name, varSymbol.pos, varSymbol);
                        recordType.fields.put(structField.name.value, structField);
                        recordSymbol.scope.define(varSymbol.name, varSymbol);
                    }
                    recordType.typeInclusions = this.readTypeInclusions();
                    int defaultValues = this.inputStream.readInt();
                    for (int i = 0; i < defaultValues; ++i) {
                        recordSymbol.defaultValues.put(BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream), this.getSymbolOfClosure());
                    }
                    Object poppedRecordType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedRecordType == recordType);
                    if (pkgId.equals(BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID)) {
                        return recordType;
                    }
                    SymbolEnv pkgEnv = BIRPackageSymbolEnter.this.symTable.pkgEnvMap.get(BIRPackageSymbolEnter.this.packageCache.getSymbol(pkgId));
                    return BIRPackageSymbolEnter.this.lookupSymbolInMainSpace(pkgEnv, Names.fromString(recordName));
                }
                case 13: {
                    BTypedescType typedescType = new BTypedescType(BIRPackageSymbolEnter.this.symTable.typeEnv(), null, BIRPackageSymbolEnter.this.symTable.typeDesc.tsymbol);
                    typedescType.constraint = this.readTypeFromCp();
                    typedescType.setFlags(flags);
                    return typedescType;
                }
                case 14: {
                    int pkgIndex = this.inputStream.readInt();
                    PackageID pkg = BIRPackageSymbolEnter.this.getPackageId(pkgIndex);
                    BPackageSymbol pkgSymbol = pkg.equals(BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID) ? BIRPackageSymbolEnter.this.env.pkgSymbol : BIRPackageSymbolEnter.this.packageCache.getSymbol(pkg);
                    String typeDefName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    BTypeSymbol typeSymbol = Symbols.createTypeSymbol(0x20000000L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.fromString(typeDefName), pkg, null, pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    BTypeReferenceType typeReferenceType = new BTypeReferenceType(null, typeSymbol, flags);
                    BIRPackageSymbolEnter.this.addShapeCP(typeReferenceType, cpI);
                    BIRPackageSymbolEnter.this.compositeStack.push(typeReferenceType);
                    typeReferenceType.referredType = this.readTypeFromCp();
                    Object poppedRefType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedRefType == typeReferenceType);
                    return typeReferenceType;
                }
                case 52: {
                    BParameterizedType type = new BParameterizedType(null, null, null, name, -1);
                    type.paramValueType = this.readTypeFromCp();
                    type.setFlags(flags);
                    type.paramIndex = this.inputStream.readInt();
                    return type;
                }
                case 15: {
                    BStreamType bStreamType = new BStreamType(BIRPackageSymbolEnter.this.symTable.typeEnv(), 15, null, null, BIRPackageSymbolEnter.this.symTable.streamType.tsymbol);
                    bStreamType.constraint = this.readTypeFromCp();
                    bStreamType.completionType = this.readTypeFromCp();
                    bStreamType.setFlags(flags);
                    return bStreamType;
                }
                case 9: {
                    boolean hasKeyConstraint;
                    boolean hasFieldNameList;
                    BTableType bTableType = new BTableType(BIRPackageSymbolEnter.this.symTable.typeEnv(), null, BIRPackageSymbolEnter.this.symTable.tableType.tsymbol, flags);
                    bTableType.constraint = this.readTypeFromCp();
                    boolean bl = hasFieldNameList = this.inputStream.readByte() == 1;
                    if (hasFieldNameList) {
                        int fieldNameListSize = this.inputStream.readInt();
                        bTableType.fieldNameList = new ArrayList<String>(fieldNameListSize);
                        for (int i = 0; i < fieldNameListSize; ++i) {
                            String fieldName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                            bTableType.fieldNameList.add(fieldName);
                        }
                    }
                    boolean bl2 = hasKeyConstraint = this.inputStream.readByte() == 1;
                    if (hasKeyConstraint) {
                        bTableType.keyTypeConstraint = this.readTypeFromCp();
                        if (bTableType.keyTypeConstraint.tsymbol == null) {
                            bTableType.keyTypeConstraint.tsymbol = Symbols.createTypeSymbol(12L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, bTableType.keyTypeConstraint, BIRPackageSymbolEnter.this.env.pkgSymbol.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                        }
                    }
                    return bTableType;
                }
                case 16: {
                    BMapType bMapType = new BMapType(BIRPackageSymbolEnter.this.symTable.typeEnv(), 16, null, BIRPackageSymbolEnter.this.symTable.mapType.tsymbol, flags);
                    bMapType.constraint = this.readTypeFromCp();
                    return bMapType;
                }
                case 17: {
                    BInvokableType bInvokableType = new BInvokableType(BIRPackageSymbolEnter.this.typeEnv, List.of(), null, null, null);
                    bInvokableType.tsymbol = Symbols.createInvokableTypeSymbol(33587228L, flags, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    bInvokableType.setFlags(flags);
                    if (this.inputStream.readBoolean()) {
                        return bInvokableType;
                    }
                    int paramCount = this.inputStream.readInt();
                    ArrayList<BType> paramTypes = new ArrayList<BType>(paramCount);
                    for (int i = 0; i < paramCount; ++i) {
                        paramTypes.add(this.readTypeFromCp());
                    }
                    bInvokableType.paramTypes = paramTypes;
                    if (this.inputStream.readBoolean()) {
                        bInvokableType.restType = this.readTypeFromCp();
                    }
                    bInvokableType.retType = this.readTypeFromCp();
                    return this.setTSymbolForInvokableType(bInvokableType, bInvokableType.retType);
                }
                case 18: {
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BAnyType.newImmutableBAnyType() : new BAnyType(name, flags);
                }
                case 37: {
                    return BIRPackageSymbolEnter.this.symTable.handleType;
                }
                case 38: {
                    return BIRPackageSymbolEnter.this.symTable.readonlyType;
                }
                case 19: {
                    break;
                }
                case 20: {
                    byte state = this.inputStream.readByte();
                    int size = this.inputStream.readInt();
                    BTypeSymbol arrayTypeSymbol = Symbols.createTypeSymbol(8421404L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    BArrayType bArrayType = new BArrayType(BIRPackageSymbolEnter.this.symTable.typeEnv(), null, arrayTypeSymbol, size, BArrayState.valueOf(state), flags);
                    bArrayType.eType = this.readTypeFromCp();
                    return bArrayType;
                }
                case 21: {
                    boolean isCyclic = this.inputStream.readByte() == 1;
                    boolean hasName = this.inputStream.readByte() == 1;
                    PackageID unionsPkgId = BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID;
                    Name unionName = Names.EMPTY;
                    if (hasName) {
                        int pkgCpIndex = this.inputStream.readInt();
                        unionsPkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
                        String unionNameStr = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                        unionName = Names.fromString(unionNameStr);
                    }
                    BTypeSymbol unionTypeSymbol = Symbols.createTypeSymbol(1081372L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), unionName, unionsPkgId, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    int unionMemberCount = this.inputStream.readInt();
                    BUnionType unionType = BUnionType.create(BIRPackageSymbolEnter.this.types.typeEnv(), unionTypeSymbol, new LinkedHashSet<BType>(unionMemberCount));
                    unionType.name = unionName;
                    BIRPackageSymbolEnter.this.addShapeCP(unionType, cpI);
                    BIRPackageSymbolEnter.this.compositeStack.push(unionType);
                    unionType.setFlags(flags);
                    unionType.isCyclic = isCyclic;
                    for (int i = 0; i < unionMemberCount; ++i) {
                        unionType.add(this.readTypeFromCp());
                    }
                    int unionOriginalMemberCount = this.inputStream.readInt();
                    LinkedHashSet<BType> originalMemberTypes = new LinkedHashSet<BType>(unionOriginalMemberCount);
                    for (int i = 0; i < unionOriginalMemberCount; ++i) {
                        originalMemberTypes.add(this.readTypeFromCp());
                    }
                    unionType.setOriginalMemberTypes(originalMemberTypes);
                    Object poppedUnionType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedUnionType == unionType);
                    boolean isEnum = this.inputStream.readBoolean();
                    if (isEnum) {
                        this.readAndSetEnumSymbol(unionType, flags);
                    }
                    if (hasName) {
                        BType existingUnionType;
                        if (unionsPkgId.equals(BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID)) {
                            return unionType;
                        }
                        SymbolEnv pkgEnv = BIRPackageSymbolEnter.this.symTable.pkgEnvMap.get(BIRPackageSymbolEnter.this.packageCache.getSymbol(unionsPkgId));
                        if (pkgEnv != null && (existingUnionType = BIRPackageSymbolEnter.this.lookupSymbolInMainSpace(pkgEnv, unionName)) != BIRPackageSymbolEnter.this.symTable.noType) {
                            return existingUnionType;
                        }
                    }
                    return unionType;
                }
                case 22: {
                    BTypeSymbol intersectionTypeSymbol = Symbols.createTypeSymbol(2129948L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    int intersectionMemberCount = this.inputStream.readInt();
                    LinkedHashSet<BType> constituentTypes = new LinkedHashSet<BType>(intersectionMemberCount);
                    for (int i = 0; i < intersectionMemberCount; ++i) {
                        constituentTypes.add(this.readTypeFromCp());
                    }
                    BType effectiveType = this.readTypeFromCp();
                    return new BIntersectionType(intersectionTypeSymbol, constituentTypes, effectiveType, flags);
                }
                case 23: {
                    break;
                }
                case 24: {
                    return BIRPackageSymbolEnter.this.symTable.noType;
                }
                case 25: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    break;
                }
                case 28: {
                    break;
                }
                case 29: {
                    BType detailsType;
                    int pkgCpIndex = this.inputStream.readInt();
                    PackageID pkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
                    BPackageSymbol owner = BIRPackageSymbolEnter.this.packageCache.getSymbol(pkgId);
                    BErrorTypeSymbol errorSymbol = owner != null ? new BErrorTypeSymbol(294940L, 1L, Names.EMPTY, owner.pkgID, null, owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE) : new BErrorTypeSymbol(294940L, 1L, Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    BErrorType errorType = new BErrorType(BIRPackageSymbolEnter.this.symTable.typeEnv(), (BTypeSymbol)errorSymbol);
                    BIRPackageSymbolEnter.this.addShapeCP(errorType, cpI);
                    BIRPackageSymbolEnter.this.compositeStack.push(errorType);
                    String errorName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    errorType.detailType = detailsType = this.readTypeFromCp();
                    errorType.setFlags(flags);
                    errorSymbol.type = errorType;
                    errorSymbol.pkgID = pkgId;
                    errorSymbol.originalName = errorSymbol.name = Names.fromString(errorName);
                    Object poppedErrorType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedErrorType == errorType);
                    if (!BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID.equals(PackageID.ANNOTATIONS) && Symbols.isFlagOn(flags, 2L)) {
                        return BIRPackageSymbolEnter.this.symTable.errorType;
                    }
                    errorType.typeIdSet = this.readTypeIdSet(this.inputStream);
                    return errorType;
                }
                case 30: {
                    break;
                }
                case 31: {
                    BTypeSymbol tupleTypeSymbol = Symbols.createTypeSymbol(4227100L, Flags.asMask(EnumSet.of(Flag.PUBLIC)), Names.EMPTY, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    int tupleMemberCount = this.inputStream.readInt();
                    ArrayList<BTupleMember> tupleMembers = new ArrayList<BTupleMember>(tupleMemberCount);
                    BSymbol tupleOwner = tupleTypeSymbol.owner;
                    PackageID tuplePkg = tupleTypeSymbol.pkgID;
                    for (int i = 0; i < tupleMemberCount; ++i) {
                        String index = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                        long fieldFlags = this.inputStream.readLong();
                        BType memberType = this.readTypeFromCp();
                        BVarSymbol varSymbol = new BVarSymbol(fieldFlags, Names.fromString(index), tuplePkg, memberType, tupleOwner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                        BIRPackageSymbolEnter.this.defineAnnotAttachmentSymbols(this.inputStream, varSymbol);
                        tupleMembers.add(new BTupleMember(memberType, varSymbol));
                    }
                    BTupleType bTupleType = new BTupleType(BIRPackageSymbolEnter.this.symTable.typeEnv(), tupleTypeSymbol, tupleMembers);
                    bTupleType.setFlags(flags);
                    if (this.inputStream.readBoolean()) {
                        bTupleType.restType = this.readTypeFromCp();
                    }
                    return bTupleType;
                }
                case 32: {
                    BFutureType bFutureType = new BFutureType(BIRPackageSymbolEnter.this.symTable.typeEnv(), null, BIRPackageSymbolEnter.this.symTable.futureType.tsymbol);
                    bFutureType.constraint = this.readTypeFromCp();
                    bFutureType.setFlags(flags);
                    return bFutureType;
                }
                case 33: {
                    String finiteTypeName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    long finiteTypeFlags = this.inputStream.readLong();
                    BTypeSymbol symbol = Symbols.createTypeSymbol(557084L, finiteTypeFlags, Names.fromString(finiteTypeName), BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    symbol.scope = new Scope(symbol);
                    int valueSpaceLength = this.inputStream.readInt();
                    SemNamedType[] valueSpace = new SemNamedType[valueSpaceLength];
                    for (int i = 0; i < valueSpaceLength; ++i) {
                        valueSpace[i] = this.readSemNamedType();
                    }
                    BFiniteType finiteType = new BFiniteType(symbol, valueSpace);
                    finiteType.setFlags(flags);
                    symbol.type = finiteType;
                    return finiteType;
                }
                case 34: {
                    boolean constructorPresent;
                    int pkgCpIndex = this.inputStream.readInt();
                    PackageID pkgId = BIRPackageSymbolEnter.this.getPackageId(pkgCpIndex);
                    String objName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                    long objSymFlags = this.inputStream.readLong();
                    BObjectTypeSymbol objectSymbol = Symbols.isFlagOn(objSymFlags, 0x10000000L) ? Symbols.createClassSymbol(objSymFlags, Names.fromString(objName), BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE, false) : Symbols.createObjectSymbol(objSymFlags, Names.fromString(objName), BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, null, BIRPackageSymbolEnter.this.env.pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                    objectSymbol.scope = new Scope(objectSymbol);
                    BObjectType objectType = new BObjectType(BIRPackageSymbolEnter.this.symTable.typeEnv(), (BTypeSymbol)objectSymbol);
                    objectType.setFlags(flags);
                    objectSymbol.type = objectType;
                    BIRPackageSymbolEnter.this.addShapeCP(objectType, cpI);
                    BIRPackageSymbolEnter.this.compositeStack.push(objectType);
                    int fieldCount = this.inputStream.readInt();
                    for (int i = 0; i < fieldCount; ++i) {
                        String fieldName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                        long fieldFlags = this.inputStream.readLong();
                        boolean defaultable = this.inputStream.readBoolean();
                        byte[] docBytes = BIRPackageSymbolEnter.this.readDocBytes(this.inputStream);
                        BType fieldType = this.readTypeFromCp();
                        BVarSymbol objectVarSymbol = new BVarSymbol(fieldFlags, Names.fromString(fieldName), objectSymbol.pkgID, fieldType, objectSymbol.scope.owner, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
                        objectVarSymbol.isDefaultable = defaultable;
                        BIRPackageSymbolEnter.this.defineMarkDownDocAttachment(objectVarSymbol, docBytes);
                        BField structField = new BField(objectVarSymbol.name, null, objectVarSymbol);
                        objectType.fields.put(structField.name.value, structField);
                        objectSymbol.scope.define(objectVarSymbol.name, objectVarSymbol);
                    }
                    boolean generatedConstructorPresent = this.inputStream.readBoolean();
                    if (generatedConstructorPresent) {
                        this.ignoreAttachedFunc();
                    }
                    if (constructorPresent = this.inputStream.readBoolean()) {
                        this.ignoreAttachedFunc();
                    }
                    int funcCount = this.inputStream.readInt();
                    boolean isImmutable = BIRPackageSymbolEnter.this.isImmutable(objectSymbol.flags);
                    for (int i = 0; i < funcCount; ++i) {
                        if (isImmutable) {
                            this.populateIntersectionTypeReferencedFunctions(this.inputStream, objectSymbol);
                            continue;
                        }
                        this.ignoreAttachedFunc();
                    }
                    objectType.typeInclusions = this.readTypeInclusions();
                    objectType.typeIdSet = this.readTypeIdSet(this.inputStream);
                    Object poppedObjType = BIRPackageSymbolEnter.this.compositeStack.pop();
                    assert (poppedObjType == objectType);
                    if (pkgId.equals(BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID)) {
                        return objectType;
                    }
                    SymbolEnv pkgEnv = BIRPackageSymbolEnter.this.symTable.pkgEnvMap.get(BIRPackageSymbolEnter.this.packageCache.getSymbol(pkgId));
                    return BIRPackageSymbolEnter.this.lookupSymbolInMainSpace(pkgEnv, Names.fromString(objName));
                }
                case 35: {
                    break;
                }
                case 36: {
                    break;
                }
                case 39: {
                    return BIRPackageSymbolEnter.this.symTable.signed32IntType;
                }
                case 40: {
                    return BIRPackageSymbolEnter.this.symTable.signed16IntType;
                }
                case 41: {
                    return BIRPackageSymbolEnter.this.symTable.signed8IntType;
                }
                case 42: {
                    return BIRPackageSymbolEnter.this.symTable.unsigned32IntType;
                }
                case 43: {
                    return BIRPackageSymbolEnter.this.symTable.unsigned16IntType;
                }
                case 44: {
                    return BIRPackageSymbolEnter.this.symTable.unsigned8IntType;
                }
                case 45: {
                    return BIRPackageSymbolEnter.this.symTable.charStringType;
                }
                case 46: {
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(BIRPackageSymbolEnter.this.symTable.xmlElementType) : BIRPackageSymbolEnter.this.symTable.xmlElementType;
                }
                case 47: {
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(BIRPackageSymbolEnter.this.symTable.xmlPIType) : BIRPackageSymbolEnter.this.symTable.xmlPIType;
                }
                case 48: {
                    return BIRPackageSymbolEnter.this.isImmutable(flags) ? BIRPackageSymbolEnter.this.getEffectiveImmutableType(BIRPackageSymbolEnter.this.symTable.xmlCommentType) : BIRPackageSymbolEnter.this.symTable.xmlCommentType;
                }
                case 49: {
                    return BIRPackageSymbolEnter.this.symTable.xmlTextType;
                }
                case 53: {
                    return BIRPackageSymbolEnter.this.symTable.regExpType;
                }
            }
            return null;
        }

        private BTypeIdSet readTypeIdSet(DataInputStream inputStream) throws IOException {
            HashSet<BTypeIdSet.BTypeId> primary = new HashSet<BTypeIdSet.BTypeId>();
            int primaryTypeIdCount = inputStream.readInt();
            for (int i = 0; i < primaryTypeIdCount; ++i) {
                primary.add(this.readTypeId(inputStream));
            }
            HashSet<BTypeIdSet.BTypeId> secondary = new HashSet<BTypeIdSet.BTypeId>();
            int secondaryTypeIdCount = inputStream.readInt();
            for (int i = 0; i < secondaryTypeIdCount; ++i) {
                secondary.add(this.readTypeId(inputStream));
            }
            return new BTypeIdSet(primary, secondary);
        }

        private BTypeIdSet.BTypeId readTypeId(DataInputStream inputStream) throws IOException {
            int pkgCPIndex = inputStream.readInt();
            PackageID packageId = BIRPackageSymbolEnter.this.getPackageId(pkgCPIndex);
            String name = BIRPackageSymbolEnter.this.getStringCPEntryValue(inputStream);
            boolean isPublicTypeId = inputStream.readBoolean();
            return new BTypeIdSet.BTypeId(packageId, name, isPublicTypeId);
        }

        private void ignoreAttachedFunc() throws IOException {
            BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
            BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
            this.inputStream.readLong();
            this.readTypeFromCp();
        }

        private List<BType> readTypeInclusions() throws IOException {
            int nTypeInclusions = this.inputStream.readInt();
            ArrayList<BType> typeInclusions = new ArrayList<BType>(nTypeInclusions);
            for (int i = 0; i < nTypeInclusions; ++i) {
                BType inclusion = this.readTypeFromCp();
                typeInclusions.add(inclusion);
            }
            return typeInclusions;
        }

        private void readAndSetEnumSymbol(BUnionType unionType, long flags) throws IOException {
            SymbolEnv enumPkgEnv;
            PackageID enumPkgId = BIRPackageSymbolEnter.this.getPackageId(this.inputStream.readInt());
            String enumName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
            int memberCount = this.inputStream.readInt();
            BPackageSymbol pkgSymbol = BIRPackageSymbolEnter.this.packageCache.getSymbol(enumPkgId);
            if (pkgSymbol == null) {
                pkgSymbol = BIRPackageSymbolEnter.this.env.pkgSymbol;
            }
            if ((enumPkgEnv = BIRPackageSymbolEnter.this.symTable.pkgEnvMap.get(pkgSymbol)) == null) {
                enumPkgEnv = SymbolEnv.createPkgEnv(null, BIRPackageSymbolEnter.this.env.pkgSymbol.scope, null);
            }
            ArrayList<BConstantSymbol> members = new ArrayList<BConstantSymbol>();
            for (int i = 0; i < memberCount; ++i) {
                String memName = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
                BSymbol sym = BIRPackageSymbolEnter.this.symbolResolver.lookupSymbolInMainSpace(enumPkgEnv, Names.fromString(memName));
                members.add((BConstantSymbol)sym);
            }
            unionType.tsymbol = new BEnumSymbol(members, flags, Names.fromString(enumName), pkgSymbol.pkgID, (BType)unionType, (BSymbol)pkgSymbol, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        }

        private void populateIntersectionTypeReferencedFunctions(DataInputStream inputStream, BObjectTypeSymbol objectSymbol) throws IOException {
            String attachedFuncName = BIRPackageSymbolEnter.this.getStringCPEntryValue(inputStream);
            String attachedFuncOrigName = BIRPackageSymbolEnter.this.getStringCPEntryValue(inputStream);
            long attachedFuncFlags = inputStream.readLong();
            BInvokableType attachedFuncType = (BInvokableType)this.readTypeFromCp();
            Name funcName = Names.fromString(Symbols.getAttachedFuncSymbolName(objectSymbol.name.value, attachedFuncName));
            Name funcOrigName = Names.fromString(attachedFuncOrigName);
            BInvokableSymbol attachedFuncSymbol = Symbols.createFunctionSymbol(attachedFuncFlags, funcName, funcOrigName, BIRPackageSymbolEnter.this.env.pkgSymbol.pkgID, attachedFuncType, BIRPackageSymbolEnter.this.env.pkgSymbol, false, BIRPackageSymbolEnter.this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
            BAttachedFunction attachedFunction = new BAttachedFunction(Names.fromString(attachedFuncName), attachedFuncSymbol, attachedFuncType, BIRPackageSymbolEnter.this.symTable.builtinPos);
            BIRPackageSymbolEnter.this.setInvokableTypeSymbol(attachedFuncType);
            if (!Symbols.isFlagOn(attachedFuncType.getFlags(), 0x8000000000L)) {
                BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)attachedFuncType.tsymbol;
                attachedFuncSymbol.params = tsymbol.params;
                attachedFuncSymbol.restParam = tsymbol.restParam;
                attachedFuncSymbol.retType = tsymbol.returnType;
            }
            objectSymbol.referencedFunctions.add(attachedFunction);
            objectSymbol.attachedFuncs.add(attachedFunction);
            objectSymbol.scope.define(funcName, attachedFuncSymbol);
        }

        private Optional<String> readNullableString() throws IOException {
            boolean hasNonNullString = this.inputStream.readBoolean();
            if (hasNonNullString) {
                return Optional.of(BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream));
            }
            return Optional.empty();
        }

        private SemNamedType readSemNamedType() throws IOException {
            SemType semType = this.readSemType();
            Optional<String> optName = this.readNullableString();
            return new SemNamedType(semType, optName);
        }

        private SemType readSemType() throws IOException {
            if (!this.inputStream.readBoolean()) {
                return null;
            }
            if (this.inputStream.readBoolean()) {
                int bitset = this.inputStream.readInt();
                return BasicTypeBitSet.from((int)bitset);
            }
            int all = this.inputStream.readInt();
            int some = this.inputStream.readInt();
            int subtypeDataListLength = this.inputStream.readByte();
            ProperSubtypeData[] subtypeList = new ProperSubtypeData[subtypeDataListLength];
            for (int i = 0; i < subtypeDataListLength; ++i) {
                subtypeList[i] = this.readProperSubtypeData();
            }
            return BIRTypeReader.createSemType(all, some, subtypeList);
        }

        private ProperSubtypeData readProperSubtypeData() throws IOException {
            switch (this.inputStream.readByte()) {
                case 1: {
                    return this.readBdd();
                }
                case 2: {
                    return this.readIntSubtype();
                }
                case 3: {
                    return BooleanSubtype.from((boolean)this.inputStream.readBoolean());
                }
                case 4: {
                    return this.readFloatSubtype();
                }
                case 5: {
                    return this.readDecimalSubType();
                }
                case 6: {
                    return this.readStringSubtype();
                }
                case 7: {
                    return this.readXmlSubtype();
                }
            }
            throw new IllegalStateException("Unexpected ProperSubtypeData kind");
        }

        private Bdd readBdd() throws IOException {
            boolean isBddNode = this.inputStream.readBoolean();
            if (isBddNode) {
                return this.readBddNode();
            }
            boolean isAll = this.inputStream.readBoolean();
            return isAll ? BddAllOrNothing.bddAll() : BddAllOrNothing.bddNothing();
        }

        private AtomKind readAtomKind() throws IOException {
            return switch (this.inputStream.readByte()) {
                case 0 -> AtomKind.REC;
                case 1 -> AtomKind.INLINED;
                case 2 -> AtomKind.TYPE;
                default -> throw new IllegalStateException("Unexpected AtomKind kind");
            };
        }

        private BddNode readBddNode() throws IOException {
            AtomKind atomKind = this.readAtomKind();
            RecAtom atom = switch (atomKind.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.readRecAtom();
                case 1 -> this.readInlinedAtom();
                case 2 -> {
                    TypeAtom typeAtom = this.readTypeAtom();
                    BIRPackageSymbolEnter.this.typeEnv.deserializeTypeAtom(typeAtom);
                    yield typeAtom;
                }
            };
            Bdd left = this.readBdd();
            Bdd middle = this.readBdd();
            Bdd right = this.readBdd();
            return BddNode.create((Atom)atom, (Bdd)left, (Bdd)middle, (Bdd)right);
        }

        private Atom readInlinedAtom() throws IOException {
            Atom.Kind kind;
            int recAtomIndex = this.inputStream.readInt();
            assert (recAtomIndex != 0);
            AtomicType atomicType = this.readTypeAtom().atomicType();
            if (atomicType instanceof MappingAtomicType) {
                recAtomIndex += BIRPackageSymbolEnter.this.offsets.mappingOffset();
                kind = Atom.Kind.MAPPING_ATOM;
            } else if (atomicType instanceof ListAtomicType) {
                recAtomIndex += BIRPackageSymbolEnter.this.offsets.listOffset();
                kind = Atom.Kind.LIST_ATOM;
            } else if (atomicType instanceof FunctionAtomicType) {
                recAtomIndex += BIRPackageSymbolEnter.this.offsets.functionOffset();
                kind = Atom.Kind.FUNCTION_ATOM;
            } else {
                throw new IllegalStateException("Unexpected inlined atomicType kind");
            }
            BIRPackageSymbolEnter.this.typeEnv.insertRecAtomAtIndex(recAtomIndex, atomicType);
            RecAtom recAtom = RecAtom.createRecAtom((int)recAtomIndex);
            recAtom.setKind(kind);
            return recAtom;
        }

        private TypeAtom readTypeAtom() throws IOException {
            int index = this.inputStream.readInt() + BIRPackageSymbolEnter.this.offsets.atomOffset();
            MappingAtomicType atomicType = switch (this.inputStream.readByte()) {
                case 1 -> this.readMappingAtomicType();
                case 2 -> this.readListAtomicType();
                case 3 -> this.readFunctionAtomicType();
                case 4 -> this.readCellAtomicType();
                default -> throw new IllegalStateException("Unexpected atomicType kind");
            };
            return TypeAtom.createTypeAtom((int)index, (AtomicType)atomicType);
        }

        private RecAtom readRecAtom() throws IOException {
            int index = this.inputStream.readInt();
            Optional predefinedRecAtom = this.predefinedTypeEnv.getPredefinedRecAtom(index);
            if (predefinedRecAtom.isPresent()) {
                return (RecAtom)predefinedRecAtom.get();
            }
            int kindOrdinal = this.inputStream.readInt();
            Atom.Kind kind = Atom.Kind.values()[kindOrdinal];
            int offset = switch (kind) {
                default -> throw new MatchException(null, null);
                case Atom.Kind.LIST_ATOM -> BIRPackageSymbolEnter.this.offsets.listOffset();
                case Atom.Kind.FUNCTION_ATOM -> BIRPackageSymbolEnter.this.offsets.functionOffset();
                case Atom.Kind.MAPPING_ATOM -> BIRPackageSymbolEnter.this.offsets.mappingOffset();
                case Atom.Kind.DISTINCT_ATOM -> -BIRPackageSymbolEnter.this.offsets.distinctOffset();
                case Atom.Kind.XML_ATOM -> 0;
                case Atom.Kind.CELL_ATOM -> throw new IllegalStateException("Cell atom cannot be recursive");
            };
            RecAtom recAtom = RecAtom.createRecAtom((int)(index += offset));
            recAtom.setKind(kind);
            return recAtom;
        }

        private CellAtomicType readCellAtomicType() throws IOException {
            SemType ty = this.readSemType();
            byte ordinal = this.inputStream.readByte();
            CellAtomicType.CellMutability mut = CellAtomicType.CellMutability.values()[ordinal];
            return CellAtomicType.from((SemType)ty, (CellAtomicType.CellMutability)mut);
        }

        private MappingAtomicType readMappingAtomicType() throws IOException {
            int namesLength = this.inputStream.readInt();
            String[] names = new String[namesLength];
            for (int i = 0; i < namesLength; ++i) {
                names[i] = BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream);
            }
            int typesLength = this.inputStream.readInt();
            CellSemType[] types = new CellSemType[typesLength];
            for (int i = 0; i < typesLength; ++i) {
                types[i] = (CellSemType)this.readSemType();
            }
            CellSemType rest = (CellSemType)this.readSemType();
            return MappingAtomicType.from((String[])names, (CellSemType[])types, (CellSemType)rest);
        }

        private ListAtomicType readListAtomicType() throws IOException {
            int initialLength = this.inputStream.readInt();
            ArrayList<CellSemType> initial = new ArrayList<CellSemType>(initialLength);
            for (int i = 0; i < initialLength; ++i) {
                initial.add((CellSemType)this.readSemType());
            }
            int fixedLength = this.inputStream.readInt();
            FixedLengthArray members = FixedLengthArray.from(initial, (int)fixedLength);
            CellSemType rest = (CellSemType)this.readSemType();
            return ListAtomicType.from((FixedLengthArray)members, (CellSemType)rest);
        }

        private static ComplexSemType createSemType(int all, int some, ProperSubtypeData[] subtypeList) {
            if (some == PredefinedType.CELL.bitset && all == 0) {
                return CellSemType.from((ProperSubtypeData[])subtypeList);
            }
            return ComplexSemType.createComplexSemType((int)all, (int)some, (ProperSubtypeData[])subtypeList);
        }

        private FunctionAtomicType readFunctionAtomicType() throws IOException {
            SemType paramType = this.readSemType();
            SemType retType = this.readSemType();
            SemType qualifiers = this.readSemType();
            boolean isGeneric = this.inputStream.readBoolean();
            return isGeneric ? FunctionAtomicType.genericFrom((SemType)paramType, (SemType)retType, (SemType)qualifiers) : FunctionAtomicType.from((SemType)paramType, (SemType)retType, (SemType)qualifiers);
        }

        private IntSubtype readIntSubtype() throws IOException {
            int rangesLength = this.inputStream.readInt();
            Range[] ranges = new Range[rangesLength];
            for (int i = 0; i < rangesLength; ++i) {
                long min = this.inputStream.readLong();
                long max = this.inputStream.readLong();
                ranges[i] = new Range(min, max);
            }
            return IntSubtype.createIntSubtype((Range[])ranges);
        }

        private FloatSubtype readFloatSubtype() throws IOException {
            boolean allowed = this.inputStream.readBoolean();
            int valuesLength = this.inputStream.readInt();
            EnumerableFloat[] values = new EnumerableFloat[valuesLength];
            for (int i = 0; i < valuesLength; ++i) {
                values[i] = EnumerableFloat.from((double)this.inputStream.readDouble());
            }
            return (FloatSubtype)FloatSubtype.createFloatSubtype((boolean)allowed, (EnumerableFloat[])values);
        }

        private DecimalSubtype readDecimalSubType() throws IOException {
            boolean allowed = this.inputStream.readBoolean();
            int valuesLength = this.inputStream.readInt();
            EnumerableDecimal[] values = new EnumerableDecimal[valuesLength];
            for (int i = 0; i < valuesLength; ++i) {
                int scale = this.inputStream.readInt();
                int byteLen = this.inputStream.readInt();
                byte[] unscaleValueBytes = this.inputStream.readNBytes(byteLen);
                BigDecimal bigDecimal = new BigDecimal(new BigInteger(unscaleValueBytes), scale);
                values[i] = EnumerableDecimal.from((BigDecimal)bigDecimal);
            }
            return (DecimalSubtype)DecimalSubtype.createDecimalSubtype((boolean)allowed, (EnumerableDecimal[])values);
        }

        private StringSubtype readStringSubtype() throws IOException {
            CharStringSubtype charStringSubtype = this.readCharStringSubtype();
            NonCharStringSubtype nonCharStringSubtype = this.readNonCharStringSubtype();
            return StringSubtype.from((CharStringSubtype)charStringSubtype, (NonCharStringSubtype)nonCharStringSubtype);
        }

        private CharStringSubtype readCharStringSubtype() throws IOException {
            boolean allowed = this.inputStream.readBoolean();
            int valuesLength = this.inputStream.readInt();
            EnumerableCharString[] values = new EnumerableCharString[valuesLength];
            for (int i = 0; i < valuesLength; ++i) {
                values[i] = EnumerableCharString.from((String)BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream));
            }
            return CharStringSubtype.from((boolean)allowed, (EnumerableCharString[])values);
        }

        private NonCharStringSubtype readNonCharStringSubtype() throws IOException {
            boolean allowed = this.inputStream.readBoolean();
            int valuesLength = this.inputStream.readInt();
            EnumerableString[] values = new EnumerableString[valuesLength];
            for (int i = 0; i < valuesLength; ++i) {
                values[i] = EnumerableString.from((String)BIRPackageSymbolEnter.this.getStringCPEntryValue(this.inputStream));
            }
            return NonCharStringSubtype.from((boolean)allowed, (EnumerableString[])values);
        }

        private XmlSubtype readXmlSubtype() throws IOException {
            int primitives = this.inputStream.readInt();
            Bdd sequence = this.readBdd();
            return XmlSubtype.from((int)primitives, (Bdd)sequence);
        }

        static enum AtomKind {
            REC,
            INLINED,
            TYPE;

        }
    }

    private static class UnresolvedType {
        String typeSig;
        Consumer<BType> completer;

        UnresolvedType(String typeSig, Consumer<BType> completer) {
            this.typeSig = typeSig;
            this.completer = completer;
        }
    }
}

