/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.util.HashMap;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.BIRGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.CompiledJarFile;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmDesugarPhase;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmObservabilityGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class CodeGenerator {
    private static final CompilerContext.Key<CodeGenerator> CODE_GEN = new CompilerContext.Key();
    private final SymbolTable symbolTable;
    private final PackageCache packageCache;
    private final BLangDiagnosticLog dlog;
    private final Types types;

    private CodeGenerator(CompilerContext compilerContext) {
        compilerContext.put(CODE_GEN, this);
        this.symbolTable = SymbolTable.getInstance(compilerContext);
        this.packageCache = PackageCache.getInstance(compilerContext);
        this.dlog = BLangDiagnosticLog.getInstance(compilerContext);
        this.types = Types.getInstance(compilerContext);
    }

    public static CodeGenerator getInstance(CompilerContext context) {
        CodeGenerator codeGenerator = context.get(CODE_GEN);
        if (codeGenerator == null) {
            codeGenerator = new CodeGenerator(context);
        }
        return codeGenerator;
    }

    public CompiledJarFile generate(BLangPackage bLangPackage, boolean isRemoteMgtEnabled) {
        return this.generate(bLangPackage.symbol, isRemoteMgtEnabled);
    }

    public CompiledJarFile generateTestModule(BLangPackage bLangTestablePackage, boolean isRemoteMgtEnabled) {
        return this.generate(bLangTestablePackage.symbol, isRemoteMgtEnabled);
    }

    private CompiledJarFile generate(BPackageSymbol packageSymbol, boolean isRemoteMgtEnabled) {
        JvmObservabilityGen jvmObservabilityGen = new JvmObservabilityGen(this.packageCache, this.symbolTable);
        jvmObservabilityGen.instrumentPackage(packageSymbol.bir);
        BIRGenUtils.rearrangeBasicBlocks(packageSymbol.bir);
        this.dlog.setCurrentPackageId(packageSymbol.pkgID);
        JvmPackageGen jvmPackageGen = new JvmPackageGen(this.symbolTable, this.packageCache, this.dlog, this.types, isRemoteMgtEnabled);
        HashMap<String, String> originalIdentifierMap = JvmDesugarPhase.encodeModuleIdentifiers(packageSymbol.bir);
        CompiledJarFile compiledJarFile = jvmPackageGen.generate(packageSymbol.bir);
        CodeGenerator.cleanUpBirPackage(packageSymbol);
        JvmDesugarPhase.replaceEncodedModuleIdentifiers(packageSymbol.bir, originalIdentifierMap);
        return compiledJarFile;
    }

    private static void cleanUpBirPackage(BPackageSymbol packageSymbol) {
        packageSymbol.birPackageFile = null;
        BIRNode.BIRPackage bir = packageSymbol.bir;
        for (BIRNode.BIRTypeDefinition typeDef : bir.typeDefs) {
            for (BIRNode.BIRFunction attachedFunc : typeDef.attachedFuncs) {
                CodeGenerator.cleanUpBirFunction(attachedFunc);
            }
            typeDef.annotAttachments = null;
        }
        bir.importedGlobalVarsDummyVarDcls.clear();
        for (BIRNode.BIRFunction function : bir.functions) {
            CodeGenerator.cleanUpBirFunction(function);
        }
        bir.annotations.clear();
        bir.constants.clear();
        bir.serviceDecls.clear();
    }

    private static void cleanUpBirFunction(BIRNode.BIRFunction function) {
        function.receiver = null;
        function.localVars = null;
        function.returnVariable = null;
        function.parameters = null;
        function.basicBlocks = null;
        function.errorTable = null;
        function.workerChannels = null;
        function.annotAttachments = null;
        function.returnTypeAnnots = null;
        function.dependentGlobalVars = null;
        function.pathParams = null;
        function.restPathParam = null;
    }
}

