/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.identifier.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeTestGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LambdaFunction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JCast;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JInstruction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JLargeArrayInstruction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JLargeMapInstruction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodCallInstruction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JType;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.SchedulerPolicy;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmInstructionGen {
    public static final String TO_UNSIGNED_LONG = "toUnsignedLong";
    public static final String ANON_METHOD_DELEGATE = "$anon$method$delegate$";
    static BType anyType;
    private final MethodVisitor mv;
    private final BIRVarToJVMIndexMap indexMap;
    private final String currentPackageName;
    private final JvmPackageGen jvmPackageGen;
    private final JvmTypeGen jvmTypeGen;
    private final JvmCastGen jvmCastGen;
    private final JvmConstantsGen jvmConstantsGen;
    private final SymbolTable symbolTable;
    private final AsyncDataCollector asyncDataCollector;
    private final JvmTypeTestGen typeTestGen;
    private final Map<String, LambdaFunction> functions;
    private final String moduleInitClass;

    public JvmInstructionGen(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, PackageID currentPackage, JvmPackageGen jvmPackageGen, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, AsyncDataCollector asyncDataCollector, Types types) {
        this.mv = mv;
        this.indexMap = indexMap;
        this.jvmPackageGen = jvmPackageGen;
        this.jvmTypeGen = jvmTypeGen;
        this.symbolTable = jvmPackageGen.symbolTable;
        this.currentPackageName = JvmCodeGenUtil.getPackageName(currentPackage);
        this.asyncDataCollector = asyncDataCollector;
        this.jvmCastGen = jvmCastGen;
        this.jvmConstantsGen = jvmConstantsGen;
        this.typeTestGen = new JvmTypeTestGen(this, types, mv, jvmTypeGen, jvmCastGen);
        this.functions = new HashMap<String, LambdaFunction>();
        this.moduleInitClass = JvmCodeGenUtil.getModuleLevelClassName(currentPackage, "$_init");
    }

    private void generateJVarLoad(MethodVisitor mv, JType jType, int valueIndex) {
        switch (jType.jTag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                mv.visitVarInsn(21, valueIndex);
                break;
            }
            case 5: {
                mv.visitVarInsn(22, valueIndex);
                break;
            }
            case 6: {
                mv.visitVarInsn(23, valueIndex);
                break;
            }
            case 7: {
                mv.visitVarInsn(24, valueIndex);
                break;
            }
            case 9: 
            case 10: {
                mv.visitVarInsn(25, valueIndex);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(jType));
            }
        }
    }

    private void generateJVarStore(MethodVisitor mv, JType jType, int valueIndex) {
        switch (jType.jTag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                mv.visitVarInsn(54, valueIndex);
                break;
            }
            case 5: {
                mv.visitVarInsn(55, valueIndex);
                break;
            }
            case 6: {
                mv.visitVarInsn(56, valueIndex);
                break;
            }
            case 7: {
                mv.visitVarInsn(57, valueIndex);
                break;
            }
            case 9: 
            case 10: {
                mv.visitVarInsn(58, valueIndex);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(jType));
            }
        }
    }

    private void generateIntToUnsignedIntConversion(MethodVisitor mv, BType targetType) {
        targetType = JvmCodeGenUtil.getImpliedType(targetType);
        switch (targetType.tag) {
            case 2: 
            case 44: {
                mv.visitInsn(136);
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", TO_UNSIGNED_LONG, "(B)J", false);
                break;
            }
            case 43: {
                mv.visitInsn(136);
                mv.visitInsn(147);
                mv.visitMethodInsn(184, "java/lang/Short", TO_UNSIGNED_LONG, "(S)J", false);
                break;
            }
            case 42: {
                mv.visitInsn(136);
                mv.visitMethodInsn(184, "java/lang/Integer", TO_UNSIGNED_LONG, "(I)J", false);
            }
        }
    }

    public void generateVarLoad(MethodVisitor mv, BIRNode.BIRVariableDcl varDcl, int valueIndex) {
        BType bType = JvmCodeGenUtil.getImpliedType(varDcl.type);
        switch (varDcl.kind) {
            case SELF: {
                mv.visitVarInsn(25, this.indexMap.get("self"));
                return;
            }
            case CONSTANT: 
            case GLOBAL: {
                String varName = varDcl.name.value;
                PackageID moduleId = ((BIRNode.BIRGlobalVariableDcl)varDcl).pkgId;
                String pkgName = JvmCodeGenUtil.getPackageName(moduleId);
                String className = this.jvmPackageGen.lookupGlobalVarClassName(pkgName, varName);
                String typeSig = JvmTypeGen.getTypeDesc(bType);
                mv.visitFieldInsn(178, className, varName, typeSig);
                return;
            }
        }
        this.generateVarLoadForType(mv, bType, valueIndex);
    }

    private void generateVarLoadForType(MethodVisitor mv, BType bType, int valueIndex) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitVarInsn(22, valueIndex);
            return;
        }
        if (TypeTags.isXMLTypeTag(bType.tag) || TypeTags.isStringTypeTag(bType.tag) || 53 == bType.tag) {
            mv.visitVarInsn(25, valueIndex);
            return;
        }
        switch (bType.tag) {
            case 2: {
                mv.visitVarInsn(21, valueIndex);
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                break;
            }
            case 3: {
                mv.visitVarInsn(24, valueIndex);
                break;
            }
            case 6: {
                mv.visitVarInsn(21, valueIndex);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 50: {
                mv.visitVarInsn(25, valueIndex);
                break;
            }
            case 0x7FFFFFFF: {
                this.generateJVarLoad(mv, (JType)bType, valueIndex);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(bType));
            }
        }
    }

    public void generateVarStore(MethodVisitor mv, BIRNode.BIRVariableDcl varDcl, int valueIndex) {
        BType bType = JvmCodeGenUtil.getImpliedType(varDcl.type);
        if (varDcl.kind == VarKind.GLOBAL || varDcl.kind == VarKind.CONSTANT) {
            String varName = varDcl.name.value;
            PackageID moduleId = ((BIRNode.BIRGlobalVariableDcl)varDcl).pkgId;
            String pkgName = JvmCodeGenUtil.getPackageName(moduleId);
            String className = this.jvmPackageGen.lookupGlobalVarClassName(pkgName, varName);
            String typeSig = JvmTypeGen.getTypeDesc(bType);
            mv.visitFieldInsn(179, className, varName, typeSig);
            return;
        }
        this.generateVarStoreForType(mv, bType, valueIndex);
    }

    private void generateVarStoreForType(MethodVisitor mv, BType bType, int valueIndex) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            mv.visitVarInsn(55, valueIndex);
            return;
        }
        if (TypeTags.isStringTypeTag(bType.tag) || TypeTags.isXMLTypeTag(bType.tag) || bType.tag == 53) {
            mv.visitVarInsn(58, valueIndex);
            return;
        }
        switch (bType.tag) {
            case 2: 
            case 6: {
                mv.visitVarInsn(54, valueIndex);
                break;
            }
            case 3: {
                mv.visitVarInsn(57, valueIndex);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 50: {
                mv.visitVarInsn(58, valueIndex);
                break;
            }
            case 0x7FFFFFFF: {
                this.generateJVarStore(mv, (JType)bType, valueIndex);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(bType));
            }
        }
    }

    private BType getSmallestBuiltInUnsignedIntSubTypeContainingTypes(BType lhsType, BType rhsType) {
        if (TypeTags.isSignedIntegerTypeTag(lhsType.tag) || TypeTags.isSignedIntegerTypeTag(rhsType.tag)) {
            throw new BLangCompilerException("expected two unsigned int subtypes, found '" + String.valueOf(lhsType) + "' and '" + String.valueOf(rhsType) + "'");
        }
        if (lhsType.tag == 42 || rhsType.tag == 42) {
            return this.symbolTable.unsigned32IntType;
        }
        if (lhsType.tag == 43 || rhsType.tag == 43) {
            return this.symbolTable.unsigned16IntType;
        }
        if (lhsType.tag == 44 || rhsType.tag == 44) {
            return this.symbolTable.unsigned8IntType;
        }
        return this.symbolTable.byteType;
    }

    void generatePlatformIns(JInstruction ins, int localVarOffset) {
        switch (ins.jKind) {
            case J_CAST: {
                this.generateJCastIns((JCast)ins);
                break;
            }
            case CALL: {
                this.generateJMethodCallIns(localVarOffset, (JMethodCallInstruction)ins);
                break;
            }
            case LARGE_ARRAY: {
                this.generateJLargeArrayIns(localVarOffset, (JLargeArrayInstruction)ins);
                break;
            }
            default: {
                this.generateJLargeMapIns(localVarOffset, (JLargeMapInstruction)ins);
            }
        }
    }

    private void generateJLargeMapIns(int localVarOffset, JLargeMapInstruction mapNewIns) {
        this.loadVar(mapNewIns.rhsOp.variableDcl);
        this.mv.visitVarInsn(25, localVarOffset);
        this.loadVar(mapNewIns.initialValues.variableDcl);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
        this.mv.visitTypeInsn(192, "[Lio/ballerina/runtime/api/values/BMapInitialValueEntry;");
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/TypedescValue", "instantiate", "(Lio/ballerina/runtime/internal/scheduling/Strand;[Lio/ballerina/runtime/api/values/BInitialValueEntry;)Ljava/lang/Object;", true);
        this.storeToVar(mapNewIns.lhsOp.variableDcl);
    }

    private void generateJLargeArrayIns(int localVarOffset, JLargeArrayInstruction inst) {
        BType instType = JvmCodeGenUtil.getImpliedType(inst.type);
        if (instType.tag == 20) {
            this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ArrayValueImpl");
            this.mv.visitInsn(89);
            this.jvmTypeGen.loadType(this.mv, inst.type);
            this.loadListInitialValues(inst);
            BType elementType = JvmCodeGenUtil.getImpliedType(((BArrayType)instType).eType);
            if (elementType.tag == 12 || elementType.tag == 22 && ((BIntersectionType)elementType).effectiveType.tag == 12) {
                this.visitNewRecordArray(elementType);
            } else {
                this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ArrayValueImpl", "<init>", "(Lio/ballerina/runtime/api/types/Type;[Lio/ballerina/runtime/api/values/BListInitialValueEntry;)V", false);
            }
            this.storeToVar(inst.lhsOp.variableDcl);
        } else {
            this.loadVar(inst.typedescOp.variableDcl);
            this.mv.visitVarInsn(25, localVarOffset);
            this.loadListInitialValues(inst);
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/TypedescValue", "instantiate", "(Lio/ballerina/runtime/internal/scheduling/Strand;[Lio/ballerina/runtime/api/values/BInitialValueEntry;)Ljava/lang/Object;", true);
            this.storeToVar(inst.lhsOp.variableDcl);
        }
    }

    private void generateJMethodCallIns(int localVarOffset, JMethodCallInstruction callIns) {
        boolean isInterface = callIns.invocationType == 185;
        int argIndex = 0;
        String jMethodVMSig = callIns.jMethodVMSig;
        boolean hasBalEnvParam = jMethodVMSig.startsWith("(Lio/ballerina/runtime/api/Environment;");
        if (hasBalEnvParam) {
            this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/BalEnvironment");
            this.mv.visitInsn(89);
            this.mv.visitVarInsn(25, localVarOffset);
            this.mv.visitFieldInsn(178, this.moduleInitClass, "$currentModule", "Lio/ballerina/runtime/api/Module;");
            this.mv.visitInsn(1);
            this.mv.visitInsn(1);
            this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/BalEnvironment", "<init>", "(Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/api/Module;Ljava/lang/String;[Lio/ballerina/runtime/api/types/Parameter;)V", false);
        }
        while (argIndex < callIns.args.size()) {
            BIROperand arg = callIns.args.get(argIndex);
            this.loadVar(arg.variableDcl);
            ++argIndex;
        }
        this.mv.visitMethodInsn(callIns.invocationType, callIns.jClassName, callIns.name, jMethodVMSig, isInterface);
        if (callIns.lhsOp != null) {
            this.storeToVar(callIns.lhsOp.variableDcl);
        }
    }

    private void generateJCastIns(JCast castIns) {
        BType targetType = castIns.targetType;
        this.loadVar(castIns.rhsOp.variableDcl);
        this.jvmCastGen.generatePlatformCheckCast(this.mv, this.indexMap, castIns.rhsOp.variableDcl.type, targetType);
        this.storeToVar(castIns.lhsOp.variableDcl);
    }

    void generateMoveIns(BIRNonTerminator.Move moveIns) {
        this.loadVar(moveIns.rhsOp.variableDcl);
        this.storeToVar(moveIns.lhsOp.variableDcl);
    }

    void generateBinaryOpIns(BIRNonTerminator.BinaryOp binaryIns) {
        InstructionKind insKind = binaryIns.kind;
        switch (insKind) {
            case ADD: {
                this.generateAddIns(binaryIns);
                break;
            }
            case SUB: {
                this.generateSubIns(binaryIns);
                break;
            }
            case MUL: {
                this.generateMulIns(binaryIns);
                break;
            }
            case DIV: {
                this.generateDivIns(binaryIns);
                break;
            }
            case MOD: {
                this.generateRemIns(binaryIns);
                break;
            }
            case EQUAL: {
                this.generateEqualIns(binaryIns);
                break;
            }
            case NOT_EQUAL: {
                this.generateNotEqualIns(binaryIns);
                break;
            }
            case GREATER_THAN: {
                this.generateGreaterThanIns(binaryIns);
                break;
            }
            case GREATER_EQUAL: {
                this.generateGreaterEqualIns(binaryIns);
                break;
            }
            case LESS_THAN: {
                this.generateLessThanIns(binaryIns);
                break;
            }
            case LESS_EQUAL: {
                this.generateLessEqualIns(binaryIns);
                break;
            }
            case REF_EQUAL: {
                this.generateRefEqualIns(binaryIns);
                break;
            }
            case REF_NOT_EQUAL: {
                this.generateRefNotEqualIns(binaryIns);
                break;
            }
            case CLOSED_RANGE: 
            case HALF_OPEN_RANGE: {
                this.generateClosedRangeIns(binaryIns);
                break;
            }
            case ANNOT_ACCESS: {
                this.generateAnnotAccessIns(binaryIns);
                break;
            }
            case BITWISE_AND: {
                this.generateBitwiseAndIns(binaryIns);
                break;
            }
            case BITWISE_OR: {
                this.generateBitwiseOrIns(binaryIns);
                break;
            }
            case BITWISE_XOR: {
                this.generateBitwiseXorIns(binaryIns);
                break;
            }
            case BITWISE_LEFT_SHIFT: {
                this.generateBitwiseLeftShiftIns(binaryIns);
                break;
            }
            case BITWISE_RIGHT_SHIFT: {
                this.generateBitwiseRightShiftIns(binaryIns);
                break;
            }
            case BITWISE_UNSIGNED_RIGHT_SHIFT: {
                this.generateBitwiseUnsignedRightShiftIns(binaryIns);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for instruction kind : " + String.valueOf((Object)insKind));
            }
        }
    }

    private void generateBinaryRhsAndLhsLoad(BIRNonTerminator.BinaryOp binaryIns) {
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
    }

    private void generateLessThanIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryCompareIns(binaryIns, 155);
    }

    private void generateGreaterThanIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryCompareIns(binaryIns, 157);
    }

    private void generateLessEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryCompareIns(binaryIns, 158);
    }

    private void generateGreaterEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.generateBinaryCompareIns(binaryIns, 156);
    }

    private void generateBinaryCompareIns(BIRNonTerminator.BinaryOp binaryIns, int opcode) {
        if (opcode != 155 && opcode != 157 && opcode != 158 && opcode != 156) {
            throw new BLangCompilerException("Unsupported opcode '" + opcode + "' for binary operator.");
        }
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        Label label1 = new Label();
        Label label2 = new Label();
        BType lhsOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        BType rhsOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
            this.mv.visitInsn(148);
            this.mv.visitJumpInsn(opcode, label1);
        } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
            if (opcode == 155) {
                this.mv.visitJumpInsn(161, label1);
            } else if (opcode == 157) {
                this.mv.visitJumpInsn(163, label1);
            } else if (opcode == 158) {
                this.mv.visitJumpInsn(164, label1);
            } else {
                this.mv.visitJumpInsn(162, label1);
            }
        } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
            if (opcode == 155) {
                this.mv.visitJumpInsn(161, label1);
            } else if (opcode == 157) {
                this.mv.visitJumpInsn(163, label1);
            } else if (opcode == 158) {
                this.mv.visitJumpInsn(164, label1);
            } else {
                this.mv.visitJumpInsn(162, label1);
            }
        } else {
            if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
                String compareFuncName = this.getCompareFuncName(opcode);
                this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/ValueComparisonUtils", compareFuncName, "(DD)Z", false);
                this.storeToVar(binaryIns.lhsOp.variableDcl);
                return;
            }
            String compareFuncName = this.getCompareFuncName(opcode);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/ValueComparisonUtils", compareFuncName, "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
            return;
        }
        this.mv.visitInsn(3);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(4);
        this.mv.visitLabel(label2);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private String getCompareFuncName(int opcode) {
        return switch (opcode) {
            case 157 -> "compareValueGreaterThan";
            case 156 -> "compareValueGreaterThanOrEqual";
            case 155 -> "compareValueLessThan";
            case 158 -> "compareValueLessThanOrEqual";
            default -> throw new BLangCompilerException("Opcode: '" + opcode + "' is not a comparison opcode.");
        };
    }

    private void generateEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        Label label1 = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        BType lhsOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        BType rhsOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitInsn(148);
            this.mv.visitJumpInsn(154, label1);
        } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitJumpInsn(160, label1);
        } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.mv.visitMethodInsn(184, "java/lang/Double", "isNaN", "(D)Z", false);
            this.mv.visitJumpInsn(153, label3);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            this.mv.visitMethodInsn(184, "java/lang/Double", "isNaN", "(D)Z", false);
            this.mv.visitJumpInsn(153, label3);
            this.mv.visitInsn(4);
            this.mv.visitJumpInsn(167, label2);
            this.mv.visitLabel(label3);
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitInsn(151);
            this.mv.visitJumpInsn(154, label1);
        } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitJumpInsn(160, label1);
        } else {
            if (lhsOpType.tag == 4 && rhsOpType.tag == 4) {
                this.generateBinaryRhsAndLhsLoad(binaryIns);
                this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkDecimalEqual", "(Lio/ballerina/runtime/internal/values/DecimalValue;Lio/ballerina/runtime/internal/values/DecimalValue;)Z", false);
                this.storeToVar(binaryIns.lhsOp.variableDcl);
                return;
            }
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "isEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
            return;
        }
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(3);
        this.mv.visitLabel(label2);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateNotEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        Label label1 = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        BType lhsOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        BType rhsOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitInsn(148);
            this.mv.visitJumpInsn(153, label1);
        } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitJumpInsn(159, label1);
        } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.mv.visitMethodInsn(184, "java/lang/Double", "isNaN", "(D)Z", false);
            this.mv.visitJumpInsn(153, label3);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            this.mv.visitMethodInsn(184, "java/lang/Double", "isNaN", "(D)Z", false);
            this.mv.visitJumpInsn(153, label3);
            this.mv.visitInsn(3);
            this.mv.visitJumpInsn(167, label2);
            this.mv.visitLabel(label3);
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitInsn(151);
            this.mv.visitJumpInsn(153, label1);
        } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitJumpInsn(159, label1);
        } else if (lhsOpType.tag == 4 && rhsOpType.tag == 4) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkDecimalEqual", "(Lio/ballerina/runtime/internal/values/DecimalValue;Lio/ballerina/runtime/internal/values/DecimalValue;)Z", false);
            this.mv.visitJumpInsn(154, label1);
        } else {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "isEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
            this.mv.visitJumpInsn(154, label1);
        }
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(3);
        this.mv.visitLabel(label2);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateRefEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        Label label1 = new Label();
        Label label2 = new Label();
        BType lhsOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        BType rhsOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitInsn(148);
            this.mv.visitJumpInsn(154, label1);
        } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitJumpInsn(160, label1);
        } else {
            if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
                this.loadVar(binaryIns.rhsOp1.variableDcl);
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                this.loadVar(binaryIns.rhsOp2.variableDcl);
                this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                this.mv.visitMethodInsn(182, "java/lang/Double", "equals", "(Ljava/lang/Object;)Z", false);
                this.storeToVar(binaryIns.lhsOp.variableDcl);
                return;
            }
            if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
                this.generateBinaryRhsAndLhsLoad(binaryIns);
                this.mv.visitJumpInsn(160, label1);
            } else {
                if (lhsOpType.tag == 4 && rhsOpType.tag == 4) {
                    this.generateBinaryRhsAndLhsLoad(binaryIns);
                    this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkDecimalExactEqual", "(Lio/ballerina/runtime/internal/values/DecimalValue;Lio/ballerina/runtime/internal/values/DecimalValue;)Z", false);
                    this.storeToVar(binaryIns.lhsOp.variableDcl);
                    return;
                }
                this.generateBinaryRhsAndLhsLoad(binaryIns);
                this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "isReferenceEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
                this.storeToVar(binaryIns.lhsOp.variableDcl);
                return;
            }
        }
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(3);
        this.mv.visitLabel(label2);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateRefNotEqualIns(BIRNonTerminator.BinaryOp binaryIns) {
        Label label1 = new Label();
        Label label2 = new Label();
        BType lhsOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        BType rhsOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(lhsOpType.tag) && TypeTags.isIntegerTypeTag(rhsOpType.tag)) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitInsn(148);
            this.mv.visitJumpInsn(153, label1);
        } else if (lhsOpType.tag == 2 && rhsOpType.tag == 2) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitJumpInsn(159, label1);
        } else if (lhsOpType.tag == 3 && rhsOpType.tag == 3) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
            this.mv.visitMethodInsn(182, "java/lang/Double", "equals", "(Ljava/lang/Object;)Z", false);
            this.mv.visitJumpInsn(154, label1);
        } else if (lhsOpType.tag == 6 && rhsOpType.tag == 6) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitJumpInsn(159, label1);
        } else if (lhsOpType.tag == 4 && rhsOpType.tag == 4) {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkDecimalExactEqual", "(Lio/ballerina/runtime/internal/values/DecimalValue;Lio/ballerina/runtime/internal/values/DecimalValue;)Z", false);
            this.mv.visitJumpInsn(154, label1);
        } else {
            this.generateBinaryRhsAndLhsLoad(binaryIns);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "isReferenceEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
            this.mv.visitJumpInsn(154, label1);
        }
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(3);
        this.mv.visitLabel(label2);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateClosedRangeIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ArrayValueImpl");
        this.mv.visitInsn(89);
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        this.mv.visitMethodInsn(184, "java/util/stream/LongStream", "rangeClosed", "(JJ)Ljava/util/stream/LongStream;", true);
        this.mv.visitMethodInsn(185, "java/util/stream/LongStream", "toArray", "()[J", true);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ArrayValueImpl", "<init>", "([J)V", false);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateAnnotAccessIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "getAnnotValue", "(Lio/ballerina/runtime/internal/values/TypedescValue;Lio/ballerina/runtime/api/values/BString;)Ljava/lang/Object;", false);
        BType targetType = JvmCodeGenUtil.getImpliedType(binaryIns.lhsOp.variableDcl.type);
        this.jvmCastGen.addUnboxInsn(this.mv, targetType);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateAddIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType bType = JvmCodeGenUtil.getImpliedType(binaryIns.lhsOp.variableDcl.type);
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/MathUtils", "addExact", "(JJ)J", false);
        } else if (bType.tag == 2) {
            this.mv.visitInsn(96);
        } else if (TypeTags.isStringTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BString", "concat", "(Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/api/values/BString;", true);
        } else if (bType.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "add", "(Lio/ballerina/runtime/internal/values/DecimalValue;)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
        } else if (bType.tag == 3) {
            this.mv.visitInsn(99);
        } else if (TypeTags.isXMLTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/xml/XmlFactory", "concatenate", "(Lio/ballerina/runtime/internal/values/XmlValue;Lio/ballerina/runtime/internal/values/XmlValue;)Lio/ballerina/runtime/internal/values/XmlValue;", false);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(binaryIns.lhsOp.variableDcl.type));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateSubIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType bType = JvmCodeGenUtil.getImpliedType(binaryIns.lhsOp.variableDcl.type);
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/MathUtils", "subtractExact", "(JJ)J", false);
        } else if (bType.tag == 3) {
            this.mv.visitInsn(103);
        } else if (bType.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "subtract", "(Lio/ballerina/runtime/internal/values/DecimalValue;)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(binaryIns.lhsOp.variableDcl.type));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateDivIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType bType = JvmCodeGenUtil.getImpliedType(binaryIns.lhsOp.variableDcl.type);
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/MathUtils", "divide", "(JJ)J", false);
        } else if (bType.tag == 3) {
            this.mv.visitInsn(111);
        } else if (bType.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "divide", "(Lio/ballerina/runtime/internal/values/DecimalValue;)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(binaryIns.lhsOp.variableDcl.type));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateMulIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType bType = JvmCodeGenUtil.getImpliedType(binaryIns.lhsOp.variableDcl.type);
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/MathUtils", "multiplyExact", "(JJ)J", false);
        } else if (bType.tag == 3) {
            this.mv.visitInsn(107);
        } else if (bType.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "multiply", "(Lio/ballerina/runtime/internal/values/DecimalValue;)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(binaryIns.lhsOp.variableDcl.type));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateRemIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType bType = JvmCodeGenUtil.getImpliedType(binaryIns.lhsOp.variableDcl.type);
        this.generateBinaryRhsAndLhsLoad(binaryIns);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/MathUtils", "remainder", "(JJ)J", false);
        } else if (bType.tag == 3) {
            this.mv.visitInsn(115);
        } else if (bType.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "remainder", "(Lio/ballerina/runtime/internal/values/DecimalValue;)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
        } else {
            throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(binaryIns.lhsOp.variableDcl.type));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseAndIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType opType1 = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        BType opType2 = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        int opType1Tag = opType1.tag;
        int opType2Tag = opType2.tag;
        if (opType1Tag == 2 && opType2Tag == 2) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.jvmCastGen.generateCheckCastToByte(this.mv, opType1);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            this.jvmCastGen.generateCheckCastToByte(this.mv, opType2);
            this.mv.visitInsn(126);
        } else {
            boolean byteResult = false;
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            if (opType1Tag == 2) {
                this.mv.visitMethodInsn(184, "java/lang/Integer", TO_UNSIGNED_LONG, "(I)J", false);
                byteResult = true;
            } else {
                this.jvmCastGen.generateCheckCast(this.mv, opType1, this.symbolTable.intType, this.indexMap);
            }
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            if (opType2Tag == 2) {
                this.mv.visitMethodInsn(184, "java/lang/Integer", TO_UNSIGNED_LONG, "(I)J", false);
                byteResult = true;
            } else {
                this.jvmCastGen.generateCheckCast(this.mv, opType2, this.symbolTable.intType, this.indexMap);
            }
            this.mv.visitInsn(127);
            if (byteResult) {
                this.jvmCastGen.generateCheckCastToByte(this.mv, this.symbolTable.intType);
            }
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseOrIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType opType1 = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        BType opType2 = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        if (opType1.tag == 2 && opType2.tag == 2) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            this.mv.visitInsn(128);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
            return;
        }
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.jvmCastGen.generateCheckCast(this.mv, opType1, this.symbolTable.intType, this.indexMap);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        this.jvmCastGen.generateCheckCast(this.mv, opType2, this.symbolTable.intType, this.indexMap);
        this.mv.visitInsn(129);
        if (!TypeTags.isSignedIntegerTypeTag(opType1.tag) && !TypeTags.isSignedIntegerTypeTag(opType2.tag) && opType1.tag != 21 && opType2.tag != 21) {
            this.generateIntToUnsignedIntConversion(this.mv, this.getSmallestBuiltInUnsignedIntSubTypeContainingTypes(opType1, opType2));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseXorIns(BIRNonTerminator.BinaryOp binaryIns) {
        BType opType1 = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        BType opType2 = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        if (opType1.tag == 2 && opType2.tag == 2) {
            this.loadVar(binaryIns.rhsOp1.variableDcl);
            this.loadVar(binaryIns.rhsOp2.variableDcl);
            this.mv.visitInsn(130);
            this.storeToVar(binaryIns.lhsOp.variableDcl);
            return;
        }
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.jvmCastGen.generateCheckCast(this.mv, opType1, this.symbolTable.intType, this.indexMap);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        this.jvmCastGen.generateCheckCast(this.mv, opType2, this.symbolTable.intType, this.indexMap);
        this.mv.visitInsn(131);
        if (!TypeTags.isSignedIntegerTypeTag(opType1.tag) && !TypeTags.isSignedIntegerTypeTag(opType2.tag) && opType1.tag != 21 && opType2.tag != 21) {
            this.generateIntToUnsignedIntConversion(this.mv, this.getSmallestBuiltInUnsignedIntSubTypeContainingTypes(opType1, opType2));
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseLeftShiftIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        BType firstOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        if (firstOpType.tag == 2) {
            this.mv.visitInsn(133);
        }
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        BType secondOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(secondOpType.tag)) {
            this.mv.visitInsn(136);
        }
        this.mv.visitInsn(121);
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseRightShiftIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        BType secondOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(secondOpType.tag)) {
            this.mv.visitInsn(136);
        }
        BType firstOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(firstOpType.tag)) {
            this.mv.visitInsn(123);
        } else {
            this.mv.visitInsn(122);
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private void generateBitwiseUnsignedRightShiftIns(BIRNonTerminator.BinaryOp binaryIns) {
        this.loadVar(binaryIns.rhsOp1.variableDcl);
        this.loadVar(binaryIns.rhsOp2.variableDcl);
        BType secondOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp2.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(secondOpType.tag)) {
            this.mv.visitInsn(136);
        }
        BType firstOpType = JvmCodeGenUtil.getImpliedType(binaryIns.rhsOp1.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(firstOpType.tag)) {
            this.mv.visitInsn(125);
        } else {
            this.mv.visitInsn(124);
        }
        this.storeToVar(binaryIns.lhsOp.variableDcl);
    }

    private int getJVMIndexOfVarRef(BIRNode.BIRVariableDcl varDcl) {
        return this.indexMap.addIfNotExists(varDcl.name.value, varDcl.type);
    }

    void generateMapNewIns(BIRNonTerminator.NewStructure mapNewIns, int localVarOffset) {
        this.loadVar(mapNewIns.rhsOp.variableDcl);
        this.mv.visitVarInsn(25, localVarOffset);
        List<BIRNode.BIRMappingConstructorEntry> initialValues = mapNewIns.initialValues;
        this.mv.visitLdcInsn((Object)initialValues.size());
        this.mv.visitInsn(136);
        this.mv.visitTypeInsn(189, "io/ballerina/runtime/api/values/BMapInitialValueEntry");
        int i = 0;
        for (BIRNode.BIRMappingConstructorEntry initialValue : initialValues) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn((Object)i);
            this.mv.visitInsn(136);
            ++i;
            if (initialValue.isKeyValuePair()) {
                this.createKeyValueEntry(this.mv, (BIRNode.BIRMappingConstructorKeyValueEntry)initialValue);
            } else {
                this.createSpreadFieldEntry(this.mv, (BIRNode.BIRMappingConstructorSpreadFieldEntry)initialValue);
            }
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/TypedescValue", "instantiate", "(Lio/ballerina/runtime/internal/scheduling/Strand;[Lio/ballerina/runtime/api/values/BInitialValueEntry;)Ljava/lang/Object;", true);
        this.storeToVar(mapNewIns.lhsOp.variableDcl);
    }

    private void createKeyValueEntry(MethodVisitor mv, BIRNode.BIRMappingConstructorKeyValueEntry keyValueEntry) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/MappingInitialValueEntry$KeyValueEntry");
        mv.visitInsn(89);
        BIRNode.BIRVariableDcl keyOpVarDecl = keyValueEntry.keyOp.variableDcl;
        this.loadVar(keyOpVarDecl);
        this.jvmCastGen.addBoxInsn(this.mv, keyOpVarDecl.type);
        BIRNode.BIRVariableDcl valueOpVarDecl = keyValueEntry.valueOp.variableDcl;
        this.loadVar(valueOpVarDecl);
        this.jvmCastGen.addBoxInsn(this.mv, valueOpVarDecl.type);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MappingInitialValueEntry$KeyValueEntry", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", false);
    }

    private void createSpreadFieldEntry(MethodVisitor mv, BIRNode.BIRMappingConstructorSpreadFieldEntry spreadFieldEntry) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/MappingInitialValueEntry$SpreadFieldEntry");
        mv.visitInsn(89);
        BIRNode.BIRVariableDcl variableDcl = spreadFieldEntry.exprOp.variableDcl;
        this.loadVar(variableDcl);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MappingInitialValueEntry$SpreadFieldEntry", "<init>", "(Lio/ballerina/runtime/api/values/BMap;)V", false);
    }

    void generateMapStoreIns(BIRNonTerminator.FieldAccess mapStoreIns) {
        this.loadVar(mapStoreIns.lhsOp.variableDcl);
        BType varRefType = JvmCodeGenUtil.getImpliedType(mapStoreIns.lhsOp.variableDcl.type);
        this.loadVar(mapStoreIns.keyOp.variableDcl);
        BType valueType = mapStoreIns.rhsOp.variableDcl.type;
        this.loadVar(mapStoreIns.rhsOp.variableDcl);
        this.jvmCastGen.addBoxInsn(this.mv, valueType);
        if (varRefType.tag == 7) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/json/JsonInternalUtils", "setElement", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V", false);
        } else if (mapStoreIns.onInitialization) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/MapValue", "populateInitialValue", "(Ljava/lang/Object;Ljava/lang/Object;)V", true);
        } else {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/MapUtils", "handleMapStore", "(Lio/ballerina/runtime/internal/values/MapValue;Lio/ballerina/runtime/api/values/BString;Ljava/lang/Object;)V", false);
        }
    }

    void generateMapLoadIns(BIRNonTerminator.FieldAccess mapLoadIns) {
        this.loadVar(mapLoadIns.rhsOp.variableDcl);
        BType varRefType = JvmCodeGenUtil.getImpliedType(mapLoadIns.rhsOp.variableDcl.type);
        this.jvmCastGen.addUnboxInsn(this.mv, varRefType);
        this.loadVar(mapLoadIns.keyOp.variableDcl);
        BType targetType = mapLoadIns.lhsOp.variableDcl.type;
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
        boolean shouldUnbox = true;
        if (varRefType.tag == 7) {
            if (mapLoadIns.optionalFieldAccess) {
                this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/json/JsonInternalUtils", "getElementOrNil", "(Ljava/lang/Object;Lio/ballerina/runtime/api/values/BString;)Ljava/lang/Object;", false);
            } else {
                this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/json/JsonInternalUtils", "getElement", "(Ljava/lang/Object;Lio/ballerina/runtime/api/values/BString;)Ljava/lang/Object;", false);
            }
        } else if (mapLoadIns.fillingRead) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/MapValue", "fillAndGet", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        } else {
            shouldUnbox = this.generateMapGet(varRefType, targetType);
        }
        if (shouldUnbox) {
            this.jvmCastGen.addUnboxInsn(this.mv, targetType);
        }
        this.storeToVar(mapLoadIns.lhsOp.variableDcl);
    }

    boolean generateMapGet(BType mapType, BType expectedType) {
        if (mapType.getKind() != TypeKind.RECORD) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/MapValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            return true;
        }
        return switch (expectedType.getKind()) {
            case TypeKind.INT -> {
                this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/MapValueImpl", "getUnboxedIntValue", "(Lio/ballerina/runtime/api/values/BString;)J", false);
                yield false;
            }
            case TypeKind.FLOAT -> {
                this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/MapValueImpl", "getUnboxedFloatValue", "(Lio/ballerina/runtime/api/values/BString;)D", false);
                yield false;
            }
            case TypeKind.STRING -> {
                this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/MapValueImpl", "getStringValue", "(Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/api/values/BString;", false);
                yield true;
            }
            case TypeKind.BOOLEAN -> {
                this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/MapValueImpl", "getUnboxedBooleanValue", "(Lio/ballerina/runtime/api/values/BString;)Z", false);
                yield false;
            }
            default -> {
                this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/MapValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                yield true;
            }
        };
    }

    void generateObjectLoadIns(BIRNonTerminator.FieldAccess objectLoadIns) {
        this.loadVar(objectLoadIns.rhsOp.variableDcl);
        this.loadVar(objectLoadIns.keyOp.variableDcl);
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BObject", "get", "(Lio/ballerina/runtime/api/values/BString;)Ljava/lang/Object;", true);
        BType targetType = objectLoadIns.lhsOp.variableDcl.type;
        this.jvmCastGen.addUnboxInsn(this.mv, targetType);
        this.storeToVar(objectLoadIns.lhsOp.variableDcl);
    }

    void generateObjectStoreIns(BIRNonTerminator.FieldAccess objectStoreIns) {
        this.loadVar(objectStoreIns.lhsOp.variableDcl);
        if (objectStoreIns.onInitialization) {
            BObjectType objectType = (BObjectType)objectStoreIns.lhsOp.variableDcl.type;
            String className = JvmValueGen.getTypeValueClassName(JvmCodeGenUtil.getPackageName(objectType.tsymbol.pkgID), JvmCodeGenUtil.toNameString(objectType));
            this.mv.visitTypeInsn(192, className);
            this.visitKeyValueExpressions(objectStoreIns);
            this.mv.visitMethodInsn(182, className, "setOnInitialization", "(Lio/ballerina/runtime/api/values/BString;Ljava/lang/Object;)V", false);
            return;
        }
        this.visitKeyValueExpressions(objectStoreIns);
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BObject", "set", "(Lio/ballerina/runtime/api/values/BString;Ljava/lang/Object;)V", true);
    }

    private void visitKeyValueExpressions(BIRNonTerminator.FieldAccess objectStoreIns) {
        this.loadVar(objectStoreIns.keyOp.variableDcl);
        BType valueType = objectStoreIns.rhsOp.variableDcl.type;
        this.loadVar(objectStoreIns.rhsOp.variableDcl);
        this.jvmCastGen.addBoxInsn(this.mv, valueType);
    }

    void generateStringLoadIns(BIRNonTerminator.FieldAccess stringLoadIns) {
        this.loadVar(stringLoadIns.rhsOp.variableDcl);
        this.loadVar(stringLoadIns.keyOp.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/api/utils/StringUtils", "getStringAt", "(Lio/ballerina/runtime/api/values/BString;J)Lio/ballerina/runtime/api/values/BString;", false);
        this.storeToVar(stringLoadIns.lhsOp.variableDcl);
    }

    void generateArrayNewIns(BIRNonTerminator.NewArray inst, int localVarOffset) {
        BType instType = JvmCodeGenUtil.getImpliedType(inst.type);
        if (instType.tag == 20) {
            this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ArrayValueImpl");
            this.mv.visitInsn(89);
            this.jvmTypeGen.loadType(this.mv, inst.type);
            this.loadListInitialValues(inst);
            BType elementType = JvmCodeGenUtil.getImpliedType(((BArrayType)instType).eType);
            if (elementType.tag == 12) {
                this.visitNewRecordArray(elementType);
            } else {
                this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ArrayValueImpl", "<init>", "(Lio/ballerina/runtime/api/types/Type;[Lio/ballerina/runtime/api/values/BListInitialValueEntry;)V", false);
            }
            this.storeToVar(inst.lhsOp.variableDcl);
        } else {
            this.loadVar(inst.typedescOp.variableDcl);
            this.mv.visitVarInsn(25, localVarOffset);
            this.loadListInitialValues(inst);
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/TypedescValue", "instantiate", "(Lio/ballerina/runtime/internal/scheduling/Strand;[Lio/ballerina/runtime/api/values/BInitialValueEntry;)Ljava/lang/Object;", true);
            this.storeToVar(inst.lhsOp.variableDcl);
        }
    }

    private void visitNewRecordArray(BType type) {
        BType elementType = JvmCodeGenUtil.getImpliedType(type);
        String typeOwner = JvmCodeGenUtil.getPackageName(type.tsymbol.pkgID) + "$_init";
        String typedescFieldName = this.jvmTypeGen.getTypedescFieldName(JvmCodeGenUtil.toNameString(elementType));
        this.mv.visitFieldInsn(178, typeOwner, typedescFieldName, "Lio/ballerina/runtime/internal/values/TypedescValue;");
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ArrayValueImpl", "<init>", "(Lio/ballerina/runtime/api/types/Type;[Lio/ballerina/runtime/api/values/BListInitialValueEntry;Lio/ballerina/runtime/internal/values/TypedescValue;)V", false);
    }

    void generateArrayStoreIns(BIRNonTerminator.FieldAccess inst) {
        this.loadVar(inst.lhsOp.variableDcl);
        this.loadVar(inst.keyOp.variableDcl);
        this.loadVar(inst.rhsOp.variableDcl);
        BType valueType = JvmCodeGenUtil.getImpliedType(inst.rhsOp.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(valueType.tag)) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "add", "(JJ)V", true);
        } else if (valueType.tag == 3) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "add", "(JD)V", true);
        } else if (TypeTags.isStringTypeTag(valueType.tag)) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "add", "(JLio/ballerina/runtime/api/values/BString;)V", true);
        } else if (valueType.tag == 6) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "add", "(JZ)V", true);
        } else if (valueType.tag == 2) {
            this.mv.visitInsn(145);
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "add", "(JB)V", true);
        } else {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "add", "(JLjava/lang/Object;)V", true);
        }
    }

    void generateArrayValueLoad(BIRNonTerminator.FieldAccess inst) {
        this.loadVar(inst.rhsOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/ArrayValue");
        this.loadVar(inst.keyOp.variableDcl);
        BType bType = inst.lhsOp.variableDcl.type;
        BType varRefType = JvmCodeGenUtil.getImpliedType(inst.rhsOp.variableDcl.type);
        if (varRefType.tag == 31) {
            if (inst.fillingRead) {
                this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "fillAndGetRefValue", "(J)Ljava/lang/Object;", true);
            } else {
                this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getRefValue", "(J)Ljava/lang/Object;", true);
            }
            this.jvmCastGen.addUnboxInsn(this.mv, bType);
        } else if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getInt", "(J)J", true);
        } else if (TypeTags.isStringTypeTag(bType.tag)) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getBString", "(J)Lio/ballerina/runtime/api/values/BString;", true);
        } else if (bType.tag == 6) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getBoolean", "(J)Z", true);
        } else if (bType.tag == 2) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getByte", "(J)B", true);
            this.mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
        } else if (bType.tag == 3) {
            this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getFloat", "(J)D", true);
        } else {
            if (inst.fillingRead) {
                this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "fillAndGetRefValue", "(J)Ljava/lang/Object;", true);
            } else {
                this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/ArrayValue", "getRefValue", "(J)Ljava/lang/Object;", true);
            }
            String targetTypeClass = JvmCastGen.getTargetClass(bType);
            if (targetTypeClass != null) {
                this.mv.visitTypeInsn(192, targetTypeClass);
            } else {
                this.jvmCastGen.addUnboxInsn(this.mv, bType);
            }
        }
        this.storeToVar(inst.lhsOp.variableDcl);
    }

    void generateTableNewIns(BIRNonTerminator.NewTable inst) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/TableValueImpl");
        this.mv.visitInsn(89);
        this.jvmTypeGen.loadType(this.mv, inst.type);
        this.loadVar(inst.dataOp.variableDcl);
        this.loadVar(inst.keyColOp.variableDcl);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/TableValueImpl", "<init>", "(Lio/ballerina/runtime/api/types/Type;Lio/ballerina/runtime/internal/values/ArrayValue;Lio/ballerina/runtime/internal/values/ArrayValue;)V", false);
        this.storeToVar(inst.lhsOp.variableDcl);
    }

    void generateTableLoadIns(BIRNonTerminator.FieldAccess inst) {
        this.loadVar(inst.rhsOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/TableValue");
        this.loadVar(inst.keyOp.variableDcl);
        this.jvmCastGen.addBoxInsn(this.mv, inst.keyOp.variableDcl.type);
        BType bType = inst.lhsOp.variableDcl.type;
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/internal/values/TableValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        String targetTypeClass = JvmCastGen.getTargetClass(bType);
        if (targetTypeClass != null) {
            this.mv.visitTypeInsn(192, targetTypeClass);
        } else {
            this.jvmCastGen.addUnboxInsn(this.mv, bType);
        }
        this.storeToVar(inst.lhsOp.variableDcl);
    }

    void generateTableStoreIns(BIRNonTerminator.FieldAccess inst) {
        this.loadVar(inst.lhsOp.variableDcl);
        this.loadVar(inst.keyOp.variableDcl);
        BType keyType = inst.keyOp.variableDcl.type;
        this.jvmCastGen.addBoxInsn(this.mv, keyType);
        BType valueType = inst.rhsOp.variableDcl.type;
        this.loadVar(inst.rhsOp.variableDcl);
        this.jvmCastGen.addBoxInsn(this.mv, valueType);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/TableUtils", "handleTableStore", "(Lio/ballerina/runtime/internal/values/TableValue;Ljava/lang/Object;Ljava/lang/Object;)V", false);
    }

    void generateNewErrorIns(BIRNonTerminator.NewError newErrorIns) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ErrorValue");
        this.mv.visitInsn(89);
        this.jvmTypeGen.loadType(this.mv, newErrorIns.type);
        this.loadVar(newErrorIns.messageOp.variableDcl);
        this.loadVar(newErrorIns.causeOp.variableDcl);
        this.loadVar(newErrorIns.detailOp.variableDcl);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ErrorValue", "<init>", "(Lio/ballerina/runtime/api/types/Type;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BError;Lio/ballerina/runtime/api/values/BMap;)V", false);
        this.storeToVar(newErrorIns.lhsOp.variableDcl);
    }

    void generateCastIns(BIRNonTerminator.TypeCast typeCastIns) {
        this.loadVar(typeCastIns.rhsOp.variableDcl);
        if (typeCastIns.checkTypes) {
            this.jvmCastGen.generateCheckCast(this.mv, typeCastIns.rhsOp.variableDcl.type, typeCastIns.type, this.indexMap);
        } else {
            this.jvmCastGen.generateCast(this.mv, typeCastIns.rhsOp.variableDcl.type, typeCastIns.type);
        }
        this.storeToVar(typeCastIns.lhsOp.variableDcl);
    }

    void generateIsLikeIns(BIRNonTerminator.IsLike isLike) {
        this.loadVar(isLike.rhsOp.variableDcl);
        this.jvmTypeGen.loadType(this.mv, isLike.type);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkIsLikeType", "(Ljava/lang/Object;Lio/ballerina/runtime/api/types/Type;)Z", false);
        this.storeToVar(isLike.lhsOp.variableDcl);
    }

    void generateObjectNewIns(BIRNonTerminator.NewInstance objectNewIns, int strandIndex) {
        BType type = this.jvmPackageGen.lookupTypeDef(objectNewIns);
        String className = objectNewIns.isExternalDef ? JvmValueGen.getTypeValueClassName(JvmCodeGenUtil.getPackageName(objectNewIns.externalPackageId), objectNewIns.objectName) : JvmValueGen.getTypeValueClassName(JvmCodeGenUtil.getPackageName(type.tsymbol.pkgID), objectNewIns.def.internalName.value);
        this.mv.visitTypeInsn(187, className);
        this.mv.visitInsn(89);
        this.jvmTypeGen.loadType(this.mv, objectNewIns.expectedType);
        this.reloadObjectCtorAnnots(type, strandIndex);
        this.mv.visitMethodInsn(183, className, "<init>", "(Lio/ballerina/runtime/api/types/Type;)V", false);
        this.storeToVar(objectNewIns.lhsOp.variableDcl);
    }

    private void reloadObjectCtorAnnots(BType type, int strandIndex) {
        if ((type.getFlags() & 0x100000000L) == 0x100000000L) {
            this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "duplicate", "()Lio/ballerina/runtime/internal/types/BObjectType;", false);
            this.mv.visitInsn(89);
            String pkgClassName = this.currentPackageName.equals(".") || this.currentPackageName.isEmpty() ? "$_init" : this.jvmPackageGen.lookupGlobalVarClassName(this.currentPackageName, "$annotation_data");
            this.mv.visitFieldInsn(178, pkgClassName, "$annotation_data", "Lio/ballerina/runtime/internal/values/MapValue;");
            this.mv.visitVarInsn(25, strandIndex);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/AnnotationUtils", "processObjectCtorAnnotations", "(Lio/ballerina/runtime/internal/types/BObjectType;Lio/ballerina/runtime/internal/values/MapValue;Lio/ballerina/runtime/internal/scheduling/Strand;)V", false);
        }
    }

    void generateFPLoadIns(BIRNonTerminator.FPLoad inst) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/FPValue");
        this.mv.visitInsn(89);
        String name = inst.funcName.value;
        String funcKey = inst.pkgId.toString() + ":" + name;
        BType type = JvmCodeGenUtil.getImpliedType(inst.type);
        if (type.tag != 17) {
            throw new BLangCompilerException("Expected BInvokableType, found " + String.valueOf(type));
        }
        for (BIROperand operand : inst.closureMaps) {
            if (operand == null) continue;
            this.loadVar(operand.variableDcl);
        }
        LambdaFunction lambdaFunction = this.functions.get(funcKey);
        if (lambdaFunction == null) {
            lambdaFunction = this.asyncDataCollector.addAndGetLambda(name, inst, false);
            this.functions.put(funcKey, lambdaFunction);
        }
        JvmCodeGenUtil.visitInvokeDynamic(this.mv, lambdaFunction.enclosingClass, lambdaFunction.lambdaName, inst.closureMaps.size());
        type = inst.lhsOp.variableDcl.type.tag == 14 ? inst.lhsOp.variableDcl.type : type;
        this.jvmTypeGen.loadType(this.mv, type);
        if (inst.strandName != null) {
            this.mv.visitLdcInsn((Object)inst.strandName);
        } else {
            this.mv.visitInsn(1);
        }
        if (inst.schedulerPolicy == SchedulerPolicy.ANY) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/FPValue", "<init>", "(Ljava/util/function/Function;Lio/ballerina/runtime/api/types/Type;Ljava/lang/String;Z)V", false);
        PackageID boundMethodPkgId = inst.boundMethodPkgId;
        String funcPkgName = JvmCodeGenUtil.getPackageName(boundMethodPkgId == null ? inst.pkgId : boundMethodPkgId);
        this.mv.visitInsn(89);
        String pkgClassName = funcPkgName.isEmpty() ? "$_init" : this.jvmPackageGen.lookupGlobalVarClassName(funcPkgName, "$annotation_data");
        this.mv.visitFieldInsn(178, pkgClassName, "$annotation_data", "Lio/ballerina/runtime/internal/values/MapValue;");
        this.mv.visitLdcInsn((Object)(name.startsWith(ANON_METHOD_DELEGATE) ? name.subSequence(ANON_METHOD_DELEGATE.length(), name.lastIndexOf("$")) : name));
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/AnnotationUtils", "processFPValueAnnotations", "(Lio/ballerina/runtime/internal/values/FPValue;Lio/ballerina/runtime/internal/values/MapValue;Ljava/lang/String;)V", false);
        this.storeToVar(inst.lhsOp.variableDcl);
    }

    private void generateRecordDefaultFPLoadIns(BIRNonTerminator.RecordDefaultFPLoad inst) {
        this.jvmTypeGen.loadType(this.mv, inst.enclosedType);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BRecordType");
        this.mv.visitLdcInsn((Object)Utils.unescapeBallerina((String)inst.fieldName));
        this.loadVar(inst.lhsOp.variableDcl);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BRecordType", "setDefaultValue", "(Ljava/lang/String;Lio/ballerina/runtime/api/values/BFunctionPointer;)V", false);
        Optional<BIntersectionType> immutableType = Types.getImmutableType(this.symbolTable, inst.enclosedType.tsymbol.pkgID, (SelectivelyImmutableReferenceType)((Object)inst.enclosedType));
        if (immutableType.isEmpty()) {
            return;
        }
        BRecordType effectiveType = (BRecordType)immutableType.get().effectiveType;
        this.jvmTypeGen.loadType(this.mv, effectiveType);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BRecordType");
        this.mv.visitLdcInsn((Object)Utils.unescapeBallerina((String)inst.fieldName));
        this.loadVar(inst.lhsOp.variableDcl);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BRecordType", "setDefaultValue", "(Ljava/lang/String;Lio/ballerina/runtime/api/values/BFunctionPointer;)V", false);
    }

    void generateNewXMLElementIns(BIRNonTerminator.NewXMLElement newXMLElement) {
        this.loadVar(newXMLElement.startTagOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/XmlQName");
        this.loadVar(newXMLElement.defaultNsURIOp.variableDcl);
        if (newXMLElement.readonly) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/xml/XmlFactory", "createXMLElement", "(Lio/ballerina/runtime/api/values/BXmlQName;Lio/ballerina/runtime/api/values/BString;Z)Lio/ballerina/runtime/internal/values/XmlValue;", false);
        this.storeToVar(newXMLElement.lhsOp.variableDcl);
    }

    void generateNewXMLQNameIns(BIRNonTerminator.NewXMLQName newXMLQName) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/XmlQName");
        this.mv.visitInsn(89);
        this.loadVar(newXMLQName.localnameOp.variableDcl);
        this.loadVar(newXMLQName.nsURIOp.variableDcl);
        this.loadVar(newXMLQName.prefixOp.variableDcl);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/XmlQName", "<init>", "(Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;)V", false);
        this.storeToVar(newXMLQName.lhsOp.variableDcl);
    }

    void generateNewStringXMLQNameIns(BIRNonTerminator.NewStringXMLQName newStringXMLQName) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/XmlQName");
        this.mv.visitInsn(89);
        this.loadVar(newStringXMLQName.stringQNameOP.variableDcl);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/XmlQName", "<init>", "(Ljava/lang/String;)V", false);
        this.storeToVar(newStringXMLQName.lhsOp.variableDcl);
    }

    void generateNewXMLTextIns(BIRNonTerminator.NewXMLText newXMLText) {
        this.loadVar(newXMLText.textOp.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/xml/XmlFactory", "createXMLText", "(Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/internal/values/XmlValue;", false);
        this.storeToVar(newXMLText.lhsOp.variableDcl);
    }

    void generateNewXMLCommentIns(BIRNonTerminator.NewXMLComment newXMLComment) {
        this.loadVar(newXMLComment.textOp.variableDcl);
        if (newXMLComment.readonly) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/xml/XmlFactory", "createXMLComment", "(Lio/ballerina/runtime/api/values/BString;Z)Lio/ballerina/runtime/internal/values/XmlValue;", false);
        this.storeToVar(newXMLComment.lhsOp.variableDcl);
    }

    void generateNewXMLProcIns(BIRNonTerminator.NewXMLProcIns newXMLPI) {
        this.loadVar(newXMLPI.targetOp.variableDcl);
        this.loadVar(newXMLPI.dataOp.variableDcl);
        if (newXMLPI.readonly) {
            this.mv.visitInsn(4);
        } else {
            this.mv.visitInsn(3);
        }
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/xml/XmlFactory", "createXMLProcessingInstruction", "(Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;Z)Lio/ballerina/runtime/internal/values/XmlValue;", false);
        this.storeToVar(newXMLPI.lhsOp.variableDcl);
    }

    void generateNewXMLSequenceIns(BIRNonTerminator.NewXMLSequence xmlSequenceIns) {
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/xml/XmlFactory", "createXmlSequence", "()Lio/ballerina/runtime/internal/values/XmlSequence;", false);
        this.storeToVar(xmlSequenceIns.lhsOp.variableDcl);
    }

    void generateXMLStoreIns(BIRNonTerminator.XMLAccess xmlStoreIns) {
        this.loadVar(xmlStoreIns.lhsOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/XmlValue");
        this.loadVar(xmlStoreIns.rhsOp.variableDcl);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "addChildren", "(Lio/ballerina/runtime/internal/values/XmlValue;)V", false);
    }

    void generateXMLLoadAllIns(BIRNonTerminator.XMLAccess xmlLoadAllIns) {
        this.loadVar(xmlLoadAllIns.rhsOp.variableDcl);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "children", "()Lio/ballerina/runtime/internal/values/XmlValue;", false);
        this.storeToVar(xmlLoadAllIns.lhsOp.variableDcl);
    }

    void generateXMLAttrLoadIns(BIRNonTerminator.FieldAccess xmlAttrStoreIns) {
        this.loadVar(xmlAttrStoreIns.rhsOp.variableDcl);
        this.loadVar(xmlAttrStoreIns.keyOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/XmlQName");
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "getAttribute", "(Lio/ballerina/runtime/api/values/BXmlQName;)Ljava/lang/String;", false);
        this.storeToVar(xmlAttrStoreIns.lhsOp.variableDcl);
    }

    void generateXMLAttrStoreIns(BIRNonTerminator.FieldAccess xmlAttrStoreIns) {
        this.loadVar(xmlAttrStoreIns.lhsOp.variableDcl);
        this.loadVar(xmlAttrStoreIns.keyOp.variableDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/internal/values/XmlQName");
        this.loadVar(xmlAttrStoreIns.rhsOp.variableDcl);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "setAttribute", "(Lio/ballerina/runtime/api/values/BXmlQName;Lio/ballerina/runtime/api/values/BString;)V", false);
    }

    void generateXMLLoadIns(BIRNonTerminator.FieldAccess xmlLoadIns) {
        this.loadVar(xmlLoadIns.rhsOp.variableDcl);
        this.loadVar(xmlLoadIns.keyOp.variableDcl);
        if (TypeTags.isStringTypeTag(JvmCodeGenUtil.getImpliedType((BType)xmlLoadIns.keyOp.variableDcl.type).tag)) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "children", "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/XmlValue;", false);
        } else {
            this.mv.visitInsn(136);
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "getItem", "(I)Lio/ballerina/runtime/internal/values/XmlValue;", false);
        }
        this.storeToVar(xmlLoadIns.lhsOp.variableDcl);
    }

    void generateNewRegExpIns(BIRNonTerminator.NewRegExp newRegExp) {
        this.loadVar(newRegExp.reDisjunction.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createRegExpValue", "(Lio/ballerina/runtime/internal/values/RegExpDisjunction;)Lio/ballerina/runtime/internal/values/RegExpValue;", false);
        this.storeToVar(newRegExp.lhsOp.variableDcl);
    }

    void generateNewRegExpDisjunctionIns(BIRNonTerminator.NewReDisjunction newReDisjunction) {
        this.loadVar(newReDisjunction.sequences.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReDisjunction", "(Lio/ballerina/runtime/internal/values/ArrayValue;)Lio/ballerina/runtime/internal/values/RegExpDisjunction;", false);
        this.storeToVar(newReDisjunction.lhsOp.variableDcl);
    }

    void generateNewRegExpSequenceIns(BIRNonTerminator.NewReSequence newReSequence) {
        this.loadVar(newReSequence.terms.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReSequence", "(Lio/ballerina/runtime/internal/values/ArrayValue;)Lio/ballerina/runtime/internal/values/RegExpSequence;", false);
        this.storeToVar(newReSequence.lhsOp.variableDcl);
    }

    void generateNewRegExpAssertionIns(BIRNonTerminator.NewReAssertion newReAssertion) {
        this.loadVar(newReAssertion.assertion.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReAssertion", "(Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/internal/values/RegExpAssertion;", false);
        this.storeToVar(newReAssertion.lhsOp.variableDcl);
    }

    void generateNewRegExpAtomQuantifierIns(BIRNonTerminator.NewReAtomQuantifier newReAtomQuantifier) {
        this.loadVar(newReAtomQuantifier.atom.variableDcl);
        this.loadVar(newReAtomQuantifier.quantifier.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReAtomQuantifier", "(Ljava/lang/Object;Lio/ballerina/runtime/internal/values/RegExpQuantifier;)Lio/ballerina/runtime/internal/values/RegExpAtomQuantifier;", false);
        this.storeToVar(newReAtomQuantifier.lhsOp.variableDcl);
    }

    void generateNewRegExpLiteralCharOrEscapeIns(BIRNonTerminator.NewReLiteralCharOrEscape newReLiteralCharOrEscape) {
        this.loadVar(newReLiteralCharOrEscape.charOrEscape.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReLiteralCharOrEscape", "(Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/internal/values/RegExpLiteralCharOrEscape;", false);
        this.storeToVar(newReLiteralCharOrEscape.lhsOp.variableDcl);
    }

    void generateNewRegExpCharacterClassIns(BIRNonTerminator.NewReCharacterClass newReCharacterClass) {
        this.loadVar(newReCharacterClass.classStart.variableDcl);
        this.loadVar(newReCharacterClass.negation.variableDcl);
        this.loadVar(newReCharacterClass.charSet.variableDcl);
        this.loadVar(newReCharacterClass.classEnd.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReCharacterClass", "(Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/internal/values/RegExpCharSet;Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/internal/values/RegExpCharacterClass;", false);
        this.storeToVar(newReCharacterClass.lhsOp.variableDcl);
    }

    void generateNewRegExpCharSetIns(BIRNonTerminator.NewReCharSet newReCharSet) {
        this.loadVar(newReCharSet.charSetAtoms.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReCharSet", "(Lio/ballerina/runtime/internal/values/ArrayValue;)Lio/ballerina/runtime/internal/values/RegExpCharSet;", false);
        this.storeToVar(newReCharSet.lhsOp.variableDcl);
    }

    void generateNewRegExpCharSetRangeIns(BIRNonTerminator.NewReCharSetRange newReCharSetRange) {
        this.loadVar(newReCharSetRange.lhsCharSetAtom.variableDcl);
        this.loadVar(newReCharSetRange.dash.variableDcl);
        this.loadVar(newReCharSetRange.rhsCharSetAtom.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReCharSetRange", "(Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/internal/values/RegExpCharSetRange;", false);
        this.storeToVar(newReCharSetRange.lhsOp.variableDcl);
    }

    void generateNewRegExpCapturingGroupIns(BIRNonTerminator.NewReCapturingGroup newReCapturingGroup) {
        this.loadVar(newReCapturingGroup.openParen.variableDcl);
        this.loadVar(newReCapturingGroup.flagExpr.variableDcl);
        this.loadVar(newReCapturingGroup.reDisjunction.variableDcl);
        this.loadVar(newReCapturingGroup.closeParen.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReCapturingGroup", "(Lio/ballerina/runtime/api/values/BString;Ljava/lang/Object;Lio/ballerina/runtime/internal/values/RegExpDisjunction;Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/internal/values/RegExpCapturingGroup;", false);
        this.storeToVar(newReCapturingGroup.lhsOp.variableDcl);
    }

    void generateNewRegExpFlagExprIns(BIRNonTerminator.NewReFlagExpression newReFlagExpression) {
        this.loadVar(newReFlagExpression.questionMark.variableDcl);
        this.loadVar(newReFlagExpression.flagsOnOff.variableDcl);
        this.loadVar(newReFlagExpression.colon.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReFlagExpression", "(Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/internal/values/RegExpFlagOnOff;Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/internal/values/RegExpFlagExpression;", false);
        this.storeToVar(newReFlagExpression.lhsOp.variableDcl);
    }

    void generateNewRegExpFlagOnOffIns(BIRNonTerminator.NewReFlagOnOff newReFlagOnOff) {
        this.loadVar(newReFlagOnOff.flags.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReFlagOnOff", "(Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/internal/values/RegExpFlagOnOff;", false);
        this.storeToVar(newReFlagOnOff.lhsOp.variableDcl);
    }

    void generateNewRegExpQuantifierIns(BIRNonTerminator.NewReQuantifier newReQuantifier) {
        this.loadVar(newReQuantifier.quantifier.variableDcl);
        this.loadVar(newReQuantifier.nonGreedyChar.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/regexp/RegExpFactory", "createReQuantifier", "(Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/internal/values/RegExpQuantifier;", false);
        this.storeToVar(newReQuantifier.lhsOp.variableDcl);
    }

    void generateTypeofIns(BIRNonTerminator.UnaryOP unaryOp) {
        this.loadVar(unaryOp.rhsOp.variableDcl);
        this.jvmCastGen.addBoxInsn(this.mv, unaryOp.rhsOp.variableDcl.type);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "getTypedesc", "(Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/TypedescValue;", false);
        this.storeToVar(unaryOp.lhsOp.variableDcl);
    }

    void generateNotIns(BIRNonTerminator.UnaryOP unaryOp) {
        this.loadVar(unaryOp.rhsOp.variableDcl);
        Label label1 = new Label();
        Label label2 = new Label();
        this.mv.visitJumpInsn(154, label1);
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(167, label2);
        this.mv.visitLabel(label1);
        this.mv.visitInsn(3);
        this.mv.visitLabel(label2);
        this.storeToVar(unaryOp.lhsOp.variableDcl);
    }

    void generateNegateIns(BIRNonTerminator.UnaryOP unaryOp) {
        this.loadVar(unaryOp.rhsOp.variableDcl);
        BType btype = JvmCodeGenUtil.getImpliedType(unaryOp.rhsOp.variableDcl.type);
        if (TypeTags.isIntegerTypeTag(btype.tag)) {
            this.mv.visitInsn(117);
        } else if (btype.tag == 2) {
            this.mv.visitInsn(116);
        } else if (btype.tag == 3) {
            this.mv.visitInsn(119);
        } else if (btype.tag == 4) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/DecimalValue", "negate", "()Lio/ballerina/runtime/internal/values/DecimalValue;", false);
        } else {
            throw new BLangCompilerException("Negation is not supported for type: " + String.valueOf(btype));
        }
        this.storeToVar(unaryOp.lhsOp.variableDcl);
    }

    void generateNewTypedescIns(BIRNonTerminator.NewTypeDesc newTypeDesc) {
        List<BIROperand> closureVars = newTypeDesc.closureVars;
        if (this.isNonReferredRecord(newTypeDesc.type)) {
            BType type = JvmCodeGenUtil.getImpliedType(newTypeDesc.type);
            PackageID packageID = type.tsymbol.pkgID;
            String typeOwner = JvmCodeGenUtil.getPackageName(packageID) + "$_init";
            String fieldName = this.jvmTypeGen.getTypedescFieldName(JvmCodeGenUtil.toNameString(type));
            this.mv.visitFieldInsn(178, typeOwner, fieldName, "Lio/ballerina/runtime/internal/values/TypedescValue;");
        } else {
            this.generateNewTypedescCreate(newTypeDesc.type, closureVars, newTypeDesc.annotations);
        }
        this.storeToVar(newTypeDesc.lhsOp.variableDcl);
    }

    private boolean isNonReferredRecord(BType type) {
        if (type.tag != 14) {
            return false;
        }
        BType referredType = ((BTypeReferenceType)type).referredType;
        return referredType.tag == 12 && type.getQualifiedTypeName().equals(referredType.getQualifiedTypeName());
    }

    private void generateNewTypedescCreate(BType btype, List<BIROperand> closureVars, BIROperand annotations) {
        BType type = JvmCodeGenUtil.getImpliedType(btype);
        String className = "io/ballerina/runtime/internal/values/TypedescValueImpl";
        if (type.tag == 12) {
            className = JvmValueGen.getTypeDescClassName(JvmCodeGenUtil.getPackageName(type.tsymbol.pkgID), JvmCodeGenUtil.toNameString(type));
        }
        this.mv.visitTypeInsn(187, className);
        this.mv.visitInsn(89);
        this.jvmTypeGen.loadType(this.mv, btype);
        this.mv.visitIntInsn(16, closureVars.size());
        this.mv.visitTypeInsn(189, "io/ballerina/runtime/internal/values/MapValue");
        for (int i = 0; i < closureVars.size(); ++i) {
            BIROperand closureVar = closureVars.get(i);
            this.mv.visitInsn(89);
            this.mv.visitIntInsn(16, i);
            this.loadVar(closureVar.variableDcl);
            this.mv.visitInsn(83);
        }
        if (annotations != null) {
            this.loadVar(annotations.variableDcl);
            this.mv.visitMethodInsn(183, className, "<init>", "(Lio/ballerina/runtime/api/types/Type;[Lio/ballerina/runtime/internal/values/MapValue;Lio/ballerina/runtime/internal/values/MapValue;)V", false);
        } else {
            this.mv.visitMethodInsn(183, className, "<init>", "(Lio/ballerina/runtime/api/types/Type;[Lio/ballerina/runtime/internal/values/MapValue;)V", false);
        }
    }

    void loadVar(BIRNode.BIRVariableDcl varDcl) {
        this.generateVarLoad(this.mv, varDcl, this.getJVMIndexOfVarRef(varDcl));
    }

    void storeToVar(BIRNode.BIRVariableDcl varDcl) {
        this.generateVarStore(this.mv, varDcl, this.getJVMIndexOfVarRef(varDcl));
    }

    void generateConstantLoadIns(BIRNonTerminator.ConstantLoad loadIns) {
        JvmCodeGenUtil.loadConstantValue(loadIns.type, loadIns.value, this.mv, this.jvmConstantsGen);
        this.storeToVar(loadIns.lhsOp.variableDcl);
    }

    private void loadListInitialValues(BIRNonTerminator.NewArray arrayNewIns) {
        List<BIRNode.BIRListConstructorEntry> initialValues = arrayNewIns.values;
        this.mv.visitLdcInsn((Object)initialValues.size());
        this.mv.visitInsn(136);
        this.mv.visitTypeInsn(189, "io/ballerina/runtime/internal/values/ListInitialValueEntry");
        int i = 0;
        for (BIRNode.BIRListConstructorEntry initialValueOp : initialValues) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn((Object)i);
            this.mv.visitInsn(136);
            ++i;
            if (initialValueOp instanceof BIRNode.BIRListConstructorExprEntry) {
                this.createExprEntry(initialValueOp);
            } else {
                this.createSpreadEntry(initialValueOp);
            }
            this.mv.visitInsn(83);
        }
    }

    private void loadListInitialValues(JLargeArrayInstruction largeArrayIns) {
        this.loadVar(largeArrayIns.values.variableDcl);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
        this.mv.visitTypeInsn(192, "[Lio/ballerina/runtime/api/values/BListInitialValueEntry;");
    }

    private void createExprEntry(BIRNode.BIRListConstructorEntry initialValueOp) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ListInitialValueEntry$ExpressionEntry");
        this.mv.visitInsn(89);
        BIRNode.BIRVariableDcl varDecl = initialValueOp.exprOp.variableDcl;
        this.loadVar(varDecl);
        this.jvmCastGen.addBoxInsn(this.mv, varDecl.type);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ListInitialValueEntry$ExpressionEntry", "<init>", "(Ljava/lang/Object;)V", false);
    }

    private void createSpreadEntry(BIRNode.BIRListConstructorEntry initialValueOp) {
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ListInitialValueEntry$SpreadEntry");
        this.mv.visitInsn(89);
        BIRNode.BIRVariableDcl varDecl = initialValueOp.exprOp.variableDcl;
        this.loadVar(varDecl);
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ListInitialValueEntry$SpreadEntry", "<init>", "(Lio/ballerina/runtime/api/values/BArray;)V", false);
    }

    void generateInstructions(int localVarOffset, BIRInstruction inst) {
        if (inst instanceof BIRNonTerminator.BinaryOp) {
            this.generateBinaryOpIns((BIRNonTerminator.BinaryOp)inst);
        } else {
            switch (inst.getKind()) {
                case MOVE: {
                    this.generateMoveIns((BIRNonTerminator.Move)inst);
                    break;
                }
                case CONST_LOAD: {
                    this.generateConstantLoadIns((BIRNonTerminator.ConstantLoad)inst);
                    break;
                }
                case NEW_STRUCTURE: {
                    this.generateMapNewIns((BIRNonTerminator.NewStructure)inst, localVarOffset);
                    break;
                }
                case NEW_INSTANCE: {
                    this.generateObjectNewIns((BIRNonTerminator.NewInstance)inst, localVarOffset);
                    break;
                }
                case MAP_STORE: {
                    this.generateMapStoreIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case NEW_TABLE: {
                    this.generateTableNewIns((BIRNonTerminator.NewTable)inst);
                    break;
                }
                case TABLE_STORE: {
                    this.generateTableStoreIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case TABLE_LOAD: {
                    this.generateTableLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case NEW_ARRAY: {
                    this.generateArrayNewIns((BIRNonTerminator.NewArray)inst, localVarOffset);
                    break;
                }
                case ARRAY_STORE: {
                    this.generateArrayStoreIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case MAP_LOAD: {
                    this.generateMapLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case ARRAY_LOAD: {
                    this.generateArrayValueLoad((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case NEW_ERROR: {
                    this.generateNewErrorIns((BIRNonTerminator.NewError)inst);
                    break;
                }
                case TYPE_CAST: {
                    this.generateCastIns((BIRNonTerminator.TypeCast)inst);
                    break;
                }
                case IS_LIKE: {
                    this.generateIsLikeIns((BIRNonTerminator.IsLike)inst);
                    break;
                }
                case TYPE_TEST: {
                    this.typeTestGen.generateTypeTestIns((BIRNonTerminator.TypeTest)inst);
                    break;
                }
                case OBJECT_STORE: {
                    this.generateObjectStoreIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case OBJECT_LOAD: {
                    this.generateObjectLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case NEW_XML_ELEMENT: {
                    this.generateNewXMLElementIns((BIRNonTerminator.NewXMLElement)inst);
                    break;
                }
                case NEW_XML_TEXT: {
                    this.generateNewXMLTextIns((BIRNonTerminator.NewXMLText)inst);
                    break;
                }
                case NEW_XML_COMMENT: {
                    this.generateNewXMLCommentIns((BIRNonTerminator.NewXMLComment)inst);
                    break;
                }
                case NEW_XML_PI: {
                    this.generateNewXMLProcIns((BIRNonTerminator.NewXMLProcIns)inst);
                    break;
                }
                case NEW_XML_QNAME: {
                    this.generateNewXMLQNameIns((BIRNonTerminator.NewXMLQName)inst);
                    break;
                }
                case NEW_STRING_XML_QNAME: {
                    this.generateNewStringXMLQNameIns((BIRNonTerminator.NewStringXMLQName)inst);
                    break;
                }
                case NEW_XML_SEQUENCE: {
                    this.generateNewXMLSequenceIns((BIRNonTerminator.NewXMLSequence)inst);
                    break;
                }
                case XML_SEQ_STORE: {
                    this.generateXMLStoreIns((BIRNonTerminator.XMLAccess)inst);
                    break;
                }
                case XML_SEQ_LOAD: 
                case XML_LOAD: {
                    this.generateXMLLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case XML_LOAD_ALL: {
                    this.generateXMLLoadAllIns((BIRNonTerminator.XMLAccess)inst);
                    break;
                }
                case XML_ATTRIBUTE_STORE: {
                    this.generateXMLAttrStoreIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case XML_ATTRIBUTE_LOAD: {
                    this.generateXMLAttrLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case NEW_REG_EXP: {
                    this.generateNewRegExpIns((BIRNonTerminator.NewRegExp)inst);
                    break;
                }
                case NEW_RE_DISJUNCTION: {
                    this.generateNewRegExpDisjunctionIns((BIRNonTerminator.NewReDisjunction)inst);
                    break;
                }
                case NEW_RE_SEQUENCE: {
                    this.generateNewRegExpSequenceIns((BIRNonTerminator.NewReSequence)inst);
                    break;
                }
                case NEW_RE_ASSERTION: {
                    this.generateNewRegExpAssertionIns((BIRNonTerminator.NewReAssertion)inst);
                    break;
                }
                case NEW_RE_ATOM_QUANTIFIER: {
                    this.generateNewRegExpAtomQuantifierIns((BIRNonTerminator.NewReAtomQuantifier)inst);
                    break;
                }
                case NEW_RE_LITERAL_CHAR_ESCAPE: {
                    this.generateNewRegExpLiteralCharOrEscapeIns((BIRNonTerminator.NewReLiteralCharOrEscape)inst);
                    break;
                }
                case NEW_RE_CHAR_CLASS: {
                    this.generateNewRegExpCharacterClassIns((BIRNonTerminator.NewReCharacterClass)inst);
                    break;
                }
                case NEW_RE_CHAR_SET: {
                    this.generateNewRegExpCharSetIns((BIRNonTerminator.NewReCharSet)inst);
                    break;
                }
                case NEW_RE_CHAR_SET_RANGE: {
                    this.generateNewRegExpCharSetRangeIns((BIRNonTerminator.NewReCharSetRange)inst);
                    break;
                }
                case NEW_RE_CAPTURING_GROUP: {
                    this.generateNewRegExpCapturingGroupIns((BIRNonTerminator.NewReCapturingGroup)inst);
                    break;
                }
                case NEW_RE_FLAG_EXPR: {
                    this.generateNewRegExpFlagExprIns((BIRNonTerminator.NewReFlagExpression)inst);
                    break;
                }
                case NEW_RE_FLAG_ON_OFF: {
                    this.generateNewRegExpFlagOnOffIns((BIRNonTerminator.NewReFlagOnOff)inst);
                    break;
                }
                case NEW_RE_QUANTIFIER: {
                    this.generateNewRegExpQuantifierIns((BIRNonTerminator.NewReQuantifier)inst);
                    break;
                }
                case FP_LOAD: {
                    this.generateFPLoadIns((BIRNonTerminator.FPLoad)inst);
                    break;
                }
                case STRING_LOAD: {
                    this.generateStringLoadIns((BIRNonTerminator.FieldAccess)inst);
                    break;
                }
                case TYPEOF: {
                    this.generateTypeofIns((BIRNonTerminator.UnaryOP)inst);
                    break;
                }
                case NOT: {
                    this.generateNotIns((BIRNonTerminator.UnaryOP)inst);
                    break;
                }
                case NEW_TYPEDESC: {
                    this.generateNewTypedescIns((BIRNonTerminator.NewTypeDesc)inst);
                    break;
                }
                case NEGATE: {
                    this.generateNegateIns((BIRNonTerminator.UnaryOP)inst);
                    break;
                }
                case PLATFORM: {
                    this.generatePlatformIns((JInstruction)inst, localVarOffset);
                    break;
                }
                case RECORD_DEFAULT_FP_LOAD: {
                    this.generateRecordDefaultFPLoadIns((BIRNonTerminator.RecordDefaultFPLoad)inst);
                    break;
                }
                default: {
                    throw new BLangCompilerException("JVM generation is not supported for operation " + String.valueOf(inst));
                }
            }
        }
    }
}

