/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.internal;

import io.ballerina.identifier.Utils;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LambdaClass;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LambdaFunction;
import org.wso2.ballerinalang.compiler.bir.model.BIRInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;

public class AsyncDataCollector {
    private final Map<String, LambdaClass> lambdas = new HashMap<String, LambdaClass>();
    private final PackageID packageID;
    private String currentSourceFileWithoutExt = null;
    private String currentSourceFileName = null;
    private int classIndex = 0;
    private int lambdaIndex = 0;

    public AsyncDataCollector(BIRNode.BIRPackage module) {
        this.packageID = module.packageID;
    }

    public LambdaFunction addAndGetLambda(String funcName, BIRInstruction inst, boolean isAsync) {
        String encodedFuncName = Utils.encodeFunctionIdentifier((String)funcName);
        String enclosingClass = JvmCodeGenUtil.getModuleLevelClassName(this.packageID, "lambdas/$_generated" + this.classIndex, this.currentSourceFileWithoutExt, "/");
        LambdaClass lambdaClass = this.lambdas.get(enclosingClass);
        if (lambdaClass == null || lambdaClass.lambdaFunctionList.size() > 500) {
            enclosingClass = JvmCodeGenUtil.getModuleLevelClassName(this.packageID, "lambdas/$_generated" + ++this.classIndex, this.currentSourceFileWithoutExt, "/");
            lambdaClass = new LambdaClass(this.currentSourceFileName);
            this.lambdas.put(enclosingClass, lambdaClass);
            this.lambdaIndex = 0;
        }
        String lambdaName = isAsync ? encodedFuncName + "$lambda$" + this.lambdaIndex++ + "$" : encodedFuncName + "$lambda" + this.lambdaIndex++ + "$";
        LambdaFunction lambdaFunction = new LambdaFunction(lambdaName, enclosingClass, inst);
        lambdaClass.lambdaFunctionList.add(lambdaFunction);
        return lambdaFunction;
    }

    public Map<String, LambdaClass> getLambdaClasses() {
        return this.lambdas;
    }

    public void setCurrentSourceFileName(String currentSourceFileName) {
        this.currentSourceFileName = currentSourceFileName;
    }

    public void setCurrentSourceFileWithoutExt(String currentSourceFileWithoutExt) {
        this.currentSourceFileWithoutExt = currentSourceFileWithoutExt;
    }
}

