/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.bir.codegen.exceptions.JInteropException;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JFieldMethod;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ParamTypeConstraint;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodKind;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JType;

final class JInterop {
    static final String INTEROP_ANNOT_ORG = "ballerina";
    static final String INTEROP_ANNOT_MODULE = "jballerina.java";
    static final String CONSTRUCTOR_ANNOT_TAG = "Constructor";
    static final String METHOD_ANNOT_TAG = "Method";
    static final String FIELD_GET_ANNOT_TAG = "FieldGet";
    static final String FIELD_PUT_ANNOT_TAG = "FieldSet";
    static final String J_OBJECT_TNAME = Object.class.getTypeName();
    static final String J_STRING_TNAME = String.class.getTypeName();
    static final String J_BOOLEAN_OBJ_TNAME = Boolean.class.getTypeName();
    static final String J_INTEGER_OBJ_TNAME = Integer.class.getTypeName();
    static final String J_LONG_OBJ_TNAME = Long.class.getTypeName();
    static final String J_DOUBLE_OBJ_TNAME = Double.class.getTypeName();
    static final String J_PRIMITIVE_INT_TNAME = Integer.TYPE.getTypeName();
    static final String J_PRIMITIVE_LONG_TNAME = Long.TYPE.getTypeName();
    static final String J_PRIMITIVE_BYTE_TNAME = Byte.TYPE.getTypeName();
    static final String J_PRIMITIVE_SHORT_TNAME = Short.TYPE.getTypeName();
    static final String J_PRIMITIVE_CHAR_TNAME = Character.TYPE.getTypeName();
    static final String J_PRIMITIVE_FLOAT_TNAME = Float.TYPE.getTypeName();
    static final String J_PRIMITIVE_DOUBLE_TNAME = Double.TYPE.getTypeName();
    static final String J_PRIMITIVE_BOOLEAN_TNAME = Boolean.TYPE.getTypeName();
    static final String J_VOID_TNAME = Void.TYPE.getTypeName();

    static JType getJType(Class<?> jTypeClass) {
        if (jTypeClass.isPrimitive()) {
            String primitiveName = jTypeClass.getName();
            return JType.getJTypeForPrimitive(primitiveName);
        }
        if (jTypeClass == Void.class) {
            throw new IllegalArgumentException("The Java Void type is not yet supported.");
        }
        if (jTypeClass.isArray()) {
            return JType.getJArrayTypeFromTypeName(jTypeClass.getComponentType().getName(), (byte)0);
        }
        JType.JRefType jRefType = new JType.JRefType(jTypeClass.getName().replace('.', '/'));
        jRefType.isArray = false;
        jRefType.isInterface = jTypeClass.isInterface();
        return jRefType;
    }

    static ParamTypeConstraint[] buildParamTypeConstraints(List<JType> javaTypeConstraints, ClassLoader classLoader) {
        if (javaTypeConstraints == null) {
            return null;
        }
        ArrayList<ParamTypeConstraint> constraintList = new ArrayList<ParamTypeConstraint>();
        for (JType javaTypeConstraint : javaTypeConstraints) {
            constraintList.add(JInterop.buildParamTypeConstraint(javaTypeConstraint, classLoader));
        }
        return constraintList.toArray(new ParamTypeConstraint[0]);
    }

    private static ParamTypeConstraint buildParamTypeConstraint(JType javaTypeConstraint, ClassLoader classLoader) {
        return switch (javaTypeConstraint.jTag) {
            case 10 -> JInterop.buildConstraintFromJavaRefType((JType.JRefType)javaTypeConstraint, classLoader);
            case 9 -> JInterop.buildConstraintFromJavaArrayType((JType.JArrayType)javaTypeConstraint, classLoader);
            case 12 -> ParamTypeConstraint.NO_CONSTRAINT;
            default -> JInterop.buildConstraintFromJavaPrimitiveType(javaTypeConstraint);
        };
    }

    private static ParamTypeConstraint buildConstraintFromJavaRefType(JType.JRefType javaRefType, ClassLoader classLoader) {
        String constraintBValue = javaRefType.typeValue;
        return new ParamTypeConstraint(JInterop.loadClass(constraintBValue, classLoader));
    }

    private static ParamTypeConstraint buildConstraintFromJavaArrayType(JType.JArrayType jArrayType, ClassLoader classLoader) {
        String typeSig = JInterop.getJavaArrayTypeSig(jArrayType);
        return new ParamTypeConstraint(JInterop.loadClass(typeSig, classLoader));
    }

    private static String getJavaArrayTypeSig(JType.JArrayType jArrayType) {
        JType elementType = jArrayType.elementType;
        Object elementTypeSig = "[";
        int jTag = elementType.jTag;
        elementTypeSig = jTag == 10 ? (String)elementTypeSig + "L" + ((JType.JRefType)elementType).typeValue + ";" : (jTag == 9 ? (String)elementTypeSig + JInterop.getJavaArrayTypeSig((JType.JArrayType)elementType) : (String)elementTypeSig + JInterop.getSignatureFromJavaPrimitiveType(elementType));
        return elementTypeSig;
    }

    private static ParamTypeConstraint buildConstraintFromJavaPrimitiveType(JType primitiveTypeName) {
        Class<Comparable<Byte>> constraintClass = switch (primitiveTypeName.jTag) {
            case 1 -> Byte.TYPE;
            case 3 -> Short.TYPE;
            case 2 -> Character.TYPE;
            case 4 -> Integer.TYPE;
            case 5 -> Long.TYPE;
            case 6 -> Float.TYPE;
            case 7 -> Double.TYPE;
            case 8 -> Boolean.TYPE;
            default -> throw new JInteropException(DiagnosticErrorCode.UNSUPPORTED_PRIMITIVE_TYPE, "Unsupported Java primitive type '" + String.valueOf(primitiveTypeName) + "'");
        };
        return new ParamTypeConstraint(constraintClass);
    }

    private static String getSignatureFromJavaPrimitiveType(JType primitiveTypeName) {
        return switch (primitiveTypeName.jTag) {
            case 1 -> "B";
            case 3 -> "S";
            case 2 -> "C";
            case 4 -> "I";
            case 5 -> "J";
            case 6 -> "F";
            case 7 -> "D";
            case 8 -> "Z";
            default -> throw new JInteropException(DiagnosticErrorCode.UNSUPPORTED_PRIMITIVE_TYPE, "Unsupported Java primitive type '" + String.valueOf(primitiveTypeName) + "'");
        };
    }

    static Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className.replace("/", "."), false, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new JInteropException(DiagnosticErrorCode.CLASS_NOT_FOUND, e.getMessage(), e);
        }
    }

    static JMethodKind getMethodKindFromAnnotTag(String annotTagRef) {
        if (CONSTRUCTOR_ANNOT_TAG.equals(annotTagRef)) {
            return JMethodKind.CONSTRUCTOR;
        }
        return JMethodKind.METHOD;
    }

    static JFieldMethod getFieldMethodFromAnnotTag(String annotTagRef) {
        if (FIELD_GET_ANNOT_TAG.equals(annotTagRef)) {
            return JFieldMethod.ACCESS;
        }
        return JFieldMethod.MUTATE;
    }

    static boolean isInteropAnnotationTag(String annotTag) {
        return switch (annotTag) {
            case CONSTRUCTOR_ANNOT_TAG, METHOD_ANNOT_TAG, FIELD_GET_ANNOT_TAG, FIELD_PUT_ANNOT_TAG -> true;
            default -> false;
        };
    }

    static boolean isMethodAnnotationTag(String annotTag) {
        return CONSTRUCTOR_ANNOT_TAG.equals(annotTag) || METHOD_ANNOT_TAG.equals(annotTag);
    }

    private JInterop() {
    }
}

