/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ParamTypeConstraint;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodKind;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Unifier;

class JMethodRequest {
    Class<?> declaringClass;
    String methodName;
    JMethodKind kind;
    ParamTypeConstraint[] paramTypeConstraints = new ParamTypeConstraint[0];
    int bFuncParamCount;
    int pathParamCount;
    BType[] bParamTypes = null;
    List<BVarSymbol> paramSymbols = new ArrayList<BVarSymbol>();
    List<BVarSymbol> pathParamSymbols = new ArrayList<BVarSymbol>();
    BType bReturnType = null;
    boolean returnsBErrorType = false;
    boolean restParamExist = false;
    BType receiverType = null;
    private static final Unifier unifier = new Unifier();

    private JMethodRequest() {
    }

    static JMethodRequest build(Env typeEnv, InteropValidationRequest.MethodValidationRequest methodValidationRequest, ClassLoader classLoader) {
        BType returnType;
        JMethodRequest jMethodReq = new JMethodRequest();
        jMethodReq.kind = methodValidationRequest.methodKind;
        jMethodReq.methodName = methodValidationRequest.name;
        jMethodReq.declaringClass = JInterop.loadClass(methodValidationRequest.klass, classLoader);
        jMethodReq.receiverType = methodValidationRequest.receiverType;
        jMethodReq.paramTypeConstraints = JInterop.buildParamTypeConstraints(methodValidationRequest.paramTypeConstraints, classLoader);
        BInvokableType bFuncType = methodValidationRequest.bFuncType;
        BInvokableTypeSymbol typeSymbol = (BInvokableTypeSymbol)bFuncType.tsymbol;
        jMethodReq.paramSymbols.addAll(typeSymbol.params);
        ArrayList<BVarSymbol> pathParams = new ArrayList<BVarSymbol>();
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        for (BVarSymbol param : typeSymbol.params) {
            paramTypes.add(param.type);
            if (param.kind != SymbolKind.PATH_PARAMETER && param.kind != SymbolKind.PATH_REST_PARAMETER) continue;
            pathParams.add(param);
        }
        BVarSymbol restParam = typeSymbol.restParam;
        if (restParam != null) {
            jMethodReq.paramSymbols.add(restParam);
            paramTypes.add(restParam.type);
        }
        jMethodReq.bFuncParamCount = paramTypes.size();
        jMethodReq.pathParamCount = pathParams.size();
        jMethodReq.bParamTypes = paramTypes.toArray(new BType[0]);
        jMethodReq.pathParamSymbols = pathParams;
        jMethodReq.bReturnType = returnType = unifier.build(typeEnv, bFuncType.retType);
        jMethodReq.returnsBErrorType = SemTypes.containsBasicType((SemType)returnType.semType(), (BasicTypeBitSet)PredefinedType.ERROR);
        jMethodReq.restParamExist = methodValidationRequest.restParamExist;
        return jMethodReq;
    }
}

