/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.model;

import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JType
extends BType {
    private static final String JBYTE_KIND = "byte";
    private static final String JCHAR_KIND = "char";
    private static final String JSHORT_KIND = "short";
    private static final String JINT_KIND = "int";
    private static final String JLONG_KIND = "long";
    private static final String JFLOAT_KIND = "float";
    private static final String JDOUBLE_KIND = "double";
    private static final String JBOOLEAN_KIND = "boolean";
    private static final String JVOID_KIND = "void";
    public static final JType J_VOID = new JType(11);
    private static final JType J_BYTE = new JType(1);
    private static final JType J_CHAR = new JType(2);
    private static final JType J_SHORT = new JType(3);
    private static final JType J_INT = new JType(4);
    private static final JType J_LONG = new JType(5);
    private static final JType J_FLOAT = new JType(6);
    private static final JType J_DOUBLE = new JType(7);
    private static final JType J_BOOLEAN = new JType(8);
    public int jTag;

    JType(int jTag) {
        super(Integer.MAX_VALUE, null);
        this.jTag = jTag;
    }

    public static JType getJTypeFromTypeName(String typeName) {
        return switch (typeName) {
            case JBYTE_KIND -> J_BYTE;
            case JCHAR_KIND -> J_CHAR;
            case JSHORT_KIND -> J_SHORT;
            case JINT_KIND -> J_INT;
            case JLONG_KIND -> J_LONG;
            case JFLOAT_KIND -> J_FLOAT;
            case JDOUBLE_KIND -> J_DOUBLE;
            case JBOOLEAN_KIND -> J_BOOLEAN;
            case JVOID_KIND -> J_VOID;
            default -> new JRefType(typeName.replace('.', '/'));
        };
    }

    public static JType getJTypeForPrimitive(String typeName) {
        return switch (typeName) {
            case JBYTE_KIND -> J_BYTE;
            case JCHAR_KIND -> J_CHAR;
            case JSHORT_KIND -> J_SHORT;
            case JINT_KIND -> J_INT;
            case JLONG_KIND -> J_LONG;
            case JFLOAT_KIND -> J_FLOAT;
            case JDOUBLE_KIND -> J_DOUBLE;
            case JBOOLEAN_KIND -> J_BOOLEAN;
            case JVOID_KIND -> J_VOID;
            default -> throw new IllegalArgumentException("The Java " + typeName + " type is not yet supported.");
        };
    }

    public static JArrayType getJArrayTypeFromTypeName(String typeName, byte dimensions) {
        JArrayType arrayType = new JArrayType(JType.getJTypeFromTypeName(typeName));
        for (int i = 1; i < dimensions; ++i) {
            arrayType = new JArrayType(arrayType);
        }
        return arrayType;
    }

    public static JType getJTypeForBType(BType type) {
        return switch (type.tag) {
            case 1 -> J_LONG;
            case 2 -> J_INT;
            case 6 -> J_BOOLEAN;
            case 3 -> J_FLOAT;
            default -> new JRefType("java/lang/Object");
        };
    }

    public static class JRefType
    extends JType {
        public String typeValue;
        public boolean isInterface = false;
        public boolean isArray = false;

        public JRefType(String typeValue) {
            super(10);
            this.typeValue = typeValue;
        }
    }

    public static class JArrayType
    extends JType {
        public JType elementType;

        public JArrayType(JType elementType) {
            super(9);
            this.elementType = elementType;
        }
    }
}

