/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split;

import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmAnnotationsGen {
    private final String annotationsClass;
    private final JvmPackageGen jvmPackageGen;
    private final JvmTypeGen jvmTypeGen;
    private final BIRNode.BIRPackage module;

    public JvmAnnotationsGen(BIRNode.BIRPackage module, JvmPackageGen jvmPackageGen, JvmTypeGen jvmTypeGen) {
        this.annotationsClass = JvmCodeGenUtil.getModuleLevelClassName(module.packageID, "annotations/$_annotations");
        this.jvmPackageGen = jvmPackageGen;
        this.jvmTypeGen = jvmTypeGen;
        this.module = module;
    }

    public void generateAnnotationsClass(JarEntries jarEntries) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(65, 33, this.annotationsClass, null, "java/lang/Object", null);
        this.generateProcessAnnotationsMethod(cw, this.module.typeDefs, this.module.packageID);
        cw.visitEnd();
        byte[] bytes = this.jvmPackageGen.getBytes(cw, this.module);
        jarEntries.put(this.annotationsClass + ".class", bytes);
    }

    private void generateProcessAnnotationsMethod(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs, PackageID packageID) {
        int annotationsCount = this.generateAnnotationsLoad(cw, typeDefs, packageID, this.jvmTypeGen);
        MethodVisitor mv = cw.visitMethod(9, "$process_annotations", "()V", null, null);
        mv.visitCode();
        for (int i = 0; i < annotationsCount; ++i) {
            mv.visitMethodInsn(184, this.annotationsClass, "$process_annotations" + i, "()V", false);
        }
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "$process_annotations", this.annotationsClass);
        mv.visitEnd();
    }

    private int generateAnnotationsLoad(ClassWriter cw, List<BIRNode.BIRTypeDefinition> typeDefs, PackageID packageID, JvmTypeGen jvmTypeGen) {
        int methodCount = 0;
        String typePkgName = JvmCodeGenUtil.getPackageName(packageID);
        String annotationMethodName = "$process_annotations" + methodCount++;
        MethodVisitor mv = cw.visitMethod(8, annotationMethodName, "()V", null, null);
        mv.visitCode();
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BType bType;
            boolean constructorsPopulated;
            if (optionalTypeDef.isBuiltin || (constructorsPopulated = Symbols.isFlagOn((bType = optionalTypeDef.type).getFlags(), 0x100000000L))) continue;
            this.loadAnnotations(mv, typePkgName, optionalTypeDef, jvmTypeGen);
        }
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, annotationMethodName, this.annotationsClass);
        mv.visitEnd();
        return methodCount;
    }

    private void loadAnnotations(MethodVisitor mv, String pkgName, BIRNode.BIRTypeDefinition typeDef, JvmTypeGen jvmTypeGen) {
        String pkgClassName = pkgName.equals(".") || pkgName.isEmpty() ? "$_init" : this.jvmPackageGen.lookupGlobalVarClassName(pkgName, "$annotation_data");
        mv.visitFieldInsn(178, pkgClassName, "$annotation_data", "Lio/ballerina/runtime/internal/values/MapValue;");
        BType type = typeDef.type;
        BType refType = typeDef.referenceType == null || type.tag == 12 ? type : typeDef.referenceType;
        jvmTypeGen.loadType(mv, refType);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/AnnotationUtils", "processAnnotations", "(Lio/ballerina/runtime/internal/values/MapValue;Lio/ballerina/runtime/api/types/Type;)V", false);
    }
}

