/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.creators.JvmErrorCreatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.creators.JvmFunctionCallsCreatorsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.creators.JvmObjectCreatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.creators.JvmRecordCreatorGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.NamedNode;

public class JvmValueCreatorGen {
    private final JvmRecordCreatorGen jvmRecordCreatorGen;
    private final JvmObjectCreatorGen jvmObjectCreatorGen;
    private final JvmErrorCreatorGen jvmErrorCreatorGen;
    private final JvmFunctionCallsCreatorsGen jvmFunctionCallsCreatorsGen;

    public JvmValueCreatorGen(PackageID packageID, JvmTypeGen jvmTypeGen) {
        this.jvmRecordCreatorGen = new JvmRecordCreatorGen(packageID, jvmTypeGen);
        this.jvmObjectCreatorGen = new JvmObjectCreatorGen(packageID);
        this.jvmErrorCreatorGen = new JvmErrorCreatorGen(packageID, jvmTypeGen);
        this.jvmFunctionCallsCreatorsGen = new JvmFunctionCallsCreatorsGen(packageID);
    }

    public void generateValueCreatorClasses(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, String moduleInitClass, JarEntries jarEntries, SymbolTable symbolTable, JvmCastGen jvmCastGen, List<BIRNode.BIRFunction> sortedFunctions) {
        TreeSet<NamedNode> recordTypeDefSet = new TreeSet<NamedNode>(JvmCodeGenUtil.NAME_HASH_COMPARATOR);
        ArrayList<BIRNode.BIRTypeDefinition> objectTypeDefList = new ArrayList<BIRNode.BIRTypeDefinition>();
        ArrayList<BIRNode.BIRTypeDefinition> errorTypeDefList = new ArrayList<BIRNode.BIRTypeDefinition>();
        for (BIRNode.BIRTypeDefinition optionalTypeDef : module.typeDefs) {
            BType bType = JvmCodeGenUtil.getImpliedType(optionalTypeDef.type);
            if (bType.tag == 12) {
                recordTypeDefSet.add(optionalTypeDef);
                continue;
            }
            if (bType.tag == 34 && Symbols.isFlagOn(bType.tsymbol.flags, 0x10000000L)) {
                objectTypeDefList.add(optionalTypeDef);
                continue;
            }
            if (bType.tag != 29) continue;
            errorTypeDefList.add(optionalTypeDef);
        }
        ArrayList<NamedNode> recordTypeDefList = new ArrayList<NamedNode>(recordTypeDefSet);
        this.jvmRecordCreatorGen.generateRecordsClass(jvmPackageGen, module, jarEntries, recordTypeDefList);
        this.jvmObjectCreatorGen.generateObjectsClass(jvmPackageGen, module, moduleInitClass, jarEntries, objectTypeDefList, symbolTable);
        this.jvmErrorCreatorGen.generateErrorsClass(jvmPackageGen, module, jarEntries, errorTypeDefList, symbolTable);
        this.jvmFunctionCallsCreatorsGen.generateFunctionCallsClass(jvmPackageGen, module, jarEntries, jvmCastGen, sortedFunctions);
    }
}

