/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmConstantGenCommons;

public class JvmBStringConstantsGen {
    private final Map<String, Integer> bStringVarIndexMap;
    private final String stringConstantsClass;
    private final String surrogatesMethodsClass;
    private final Map<String, int[]> highSurrogatesMap = new HashMap<String, int[]>();
    private final Map<String, Map<String, String>> largeStringVarMap = new HashMap<String, Map<String, String>>();
    private int bStringConstantIndex = 0;

    public JvmBStringConstantsGen(PackageID module) {
        this.bStringVarIndexMap = new LinkedHashMap<String, Integer>();
        this.stringConstantsClass = JvmCodeGenUtil.getModuleLevelClassName(module, "constants/$_string_constants");
        this.surrogatesMethodsClass = JvmCodeGenUtil.getModuleLevelClassName(module, "constants/$_surrogate_methods");
    }

    public int addBStringConstantVarIndex(String val) {
        Integer index = this.bStringVarIndexMap.get(val);
        if (index == null) {
            index = this.bStringConstantIndex;
            this.bStringVarIndexMap.put(val, index);
            ++this.bStringConstantIndex;
            this.splitLargeStrings(val, index);
        }
        return index;
    }

    public void generateConstantInit(JarEntries jarEntries) {
        if (this.bStringVarIndexMap.isEmpty()) {
            return;
        }
        this.generateBStringInitMethodClasses(this.largeStringVarMap, jarEntries);
        if (!this.highSurrogatesMap.isEmpty()) {
            this.generateSurrogatesClass(jarEntries);
        }
    }

    private void generateSurrogatesClass(JarEntries jarEntries) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmConstantGenCommons.generateConstantsClassInit(cw, this.surrogatesMethodsClass);
        this.highSurrogatesMap.forEach((key, value) -> this.generateGetHighSurrogateArrayMethod(cw, (String)key, (int[])value));
        cw.visitEnd();
        jarEntries.put(this.surrogatesMethodsClass + ".class", cw.toByteArray());
    }

    private void generateGetHighSurrogateArrayMethod(ClassWriter cw, String varName, int[] values) {
        List<String> splitMethodNames = this.generateSplitGetSurrogateArrayMethod(cw, varName, values);
        String highSurrogateMethodName = this.getHighSurrogateMethodName(varName);
        MethodVisitor mv = cw.visitMethod(8, highSurrogateMethodName, "()[I", null, null);
        mv.visitLdcInsn((Object)values.length);
        mv.visitIntInsn(188, 10);
        mv.visitVarInsn(58, 0);
        for (String methodName : splitMethodNames) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, this.surrogatesMethodsClass, methodName, "([I)V", false);
        }
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, highSurrogateMethodName, this.surrogatesMethodsClass);
        mv.visitEnd();
    }

    private List<String> generateSplitGetSurrogateArrayMethod(ClassWriter cw, String varName, int[] values) {
        ArrayList<String> methods = new ArrayList<String>();
        MethodVisitor mv = null;
        int indexCount = 0;
        int methodCount = 0;
        Object methodName = this.getHighSurrogateMethodName(varName);
        for (int i = 0; i < values.length; ++i) {
            if (indexCount % 5000 == 0) {
                methodName = (String)methodName + methodCount++;
                mv = cw.visitMethod(8, (String)methodName, "([I)V", null, null);
                methods.add((String)methodName);
            }
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)i);
            mv.visitLdcInsn((Object)values[i]);
            mv.visitInsn(79);
            if (++indexCount % 5000 != 0) continue;
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)methodName, this.surrogatesMethodsClass);
            mv.visitEnd();
        }
        if (indexCount % 5000 != 0) {
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)methodName, this.surrogatesMethodsClass);
            mv.visitEnd();
        }
        return methods;
    }

    private void visitStringField(ClassWriter cw, Map<String, String> varList) {
        for (String varName : varList.keySet()) {
            FieldVisitor fv = cw.visitField(9, varName, "Ljava/lang/String;", null, null);
            fv.visitEnd();
        }
    }

    private String getStringVarName(String bStringVar, int index) {
        return bStringVar + "$stringChunk" + index;
    }

    private void splitLargeStrings(String str, int index) {
        String varName = "$bString" + index;
        Map<String, String> splitStrings = this.splitStringByByteLength(str, varName);
        if (!splitStrings.isEmpty()) {
            this.largeStringVarMap.put(varName, splitStrings);
        }
    }

    private Map<String, String> splitStringByByteLength(String str, String varName) {
        int byteLength = 0;
        LinkedHashMap<String, String> splitStrings = new LinkedHashMap<String, String>();
        int beginIndex = 0;
        int chunkCount = 0;
        for (int i = 0; i < str.length(); ++i) {
            char charValue = str.charAt(i);
            byteLength = charValue >= '\u0001' && charValue <= '\u007f' ? ++byteLength : (charValue <= '\u07ff' ? (byteLength += 2) : (byteLength += 3));
            if (byteLength < 65000) continue;
            splitStrings.put(this.getStringVarName(varName, chunkCount++), str.substring(beginIndex, i + 1));
            beginIndex = i + 1;
            byteLength = 0;
            ++this.bStringConstantIndex;
        }
        if (!splitStrings.isEmpty()) {
            splitStrings.put(this.getStringVarName(varName, chunkCount), str.substring(beginIndex));
            ++this.bStringConstantIndex;
        }
        return splitStrings;
    }

    private void visitBStringField(ClassWriter cw, String varName) {
        FieldVisitor fv = cw.visitField(9, varName, "Lio/ballerina/runtime/api/values/BString;", null, null);
        fv.visitEnd();
    }

    private void generateBStringInitMethodClasses(Map<String, Map<String, String>> stringVarMap, JarEntries jarEntries) {
        BallerinaClassWriter cw = null;
        MethodVisitor mv = null;
        String constantClassName = null;
        int bStringCount = 0;
        for (Map.Entry<String, Integer> entry : this.bStringVarIndexMap.entrySet()) {
            String bString = entry.getKey();
            int varIndex = entry.getValue();
            String bStringVarName = "$bString" + varIndex;
            int classIndex = varIndex / 5000;
            constantClassName = this.stringConstantsClass + "_" + classIndex;
            if (bStringCount % 5000 == 0) {
                cw = new BallerinaClassWriter(2);
                JvmConstantGenCommons.generateConstantsClassInit(cw, constantClassName);
                mv = cw.visitMethod(9, "$string_init", "()V", null, null);
            }
            this.visitBStringField(cw, bStringVarName);
            int[] highSurrogates = this.listHighSurrogates(bString);
            if (highSurrogates.length > 0) {
                this.highSurrogatesMap.put(bStringVarName, highSurrogates);
            }
            if (stringVarMap.containsKey(bStringVarName)) {
                this.visitStringField(cw, stringVarMap.get(bStringVarName));
                Map<String, String> stringChunkMap = stringVarMap.get(bStringVarName);
                this.createConcatenatedBString(mv, highSurrogates, bStringVarName, stringChunkMap, constantClassName);
                bStringCount += stringChunkMap.size() + 1;
            } else {
                this.createDirectBString(mv, bString, bStringVarName, highSurrogates, constantClassName);
                ++bStringCount;
            }
            if (bStringCount % 5000 != 0) continue;
            JvmConstantGenCommons.genMethodReturn(mv);
            this.generateStaticClassInitializer(cw, constantClassName);
            cw.visitEnd();
            jarEntries.put(constantClassName + ".class", cw.toByteArray());
        }
        if (bStringCount % 5000 != 0) {
            JvmConstantGenCommons.genMethodReturn(mv);
            this.generateStaticClassInitializer(cw, constantClassName);
            cw.visitEnd();
            jarEntries.put(constantClassName + ".class", cw.toByteArray());
        }
    }

    private String getHighSurrogateMethodName(String bStringVar) {
        return "getSurrogateArray" + bStringVar + "$";
    }

    private void createConcatenatedBString(MethodVisitor mv, int[] highSurrogates, String bStringVarName, Map<String, String> stringChunks, String constantClassName) {
        for (Map.Entry<String, String> stringEntry : stringChunks.entrySet()) {
            mv.visitLdcInsn((Object)stringEntry.getValue());
            mv.visitFieldInsn(179, constantClassName, stringEntry.getKey(), "Ljava/lang/String;");
        }
        if (highSurrogates.length > 0) {
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/NonBmpStringValue");
            this.generateAppendStringConstants(mv, stringChunks, constantClassName);
            mv.visitMethodInsn(184, this.surrogatesMethodsClass, this.getHighSurrogateMethodName(bStringVarName), "()[I", false);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/NonBmpStringValue", "<init>", "(Ljava/lang/String;[I)V", false);
        } else {
            mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/BmpStringValue");
            this.generateAppendStringConstants(mv, stringChunks, constantClassName);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/BmpStringValue", "<init>", "(Ljava/lang/String;)V", false);
        }
        mv.visitFieldInsn(179, constantClassName, bStringVarName, "Lio/ballerina/runtime/api/values/BString;");
    }

    private void generateAppendStringConstants(MethodVisitor mv, Map<String, String> stringChunks, String constantClassName) {
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        for (Map.Entry<String, String> stringEntry : stringChunks.entrySet()) {
            mv.visitFieldInsn(178, constantClassName, stringEntry.getKey(), "Ljava/lang/String;");
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
    }

    private void createDirectBString(MethodVisitor mv, String bString, String bStringVarName, int[] highSurrogates, String constantClassName) {
        if (highSurrogates.length > 0) {
            this.createNonBmpString(mv, bString, bStringVarName, constantClassName);
        } else {
            this.createBmpString(mv, bString, bStringVarName, constantClassName);
        }
    }

    private void generateStaticClassInitializer(ClassWriter cw, String className) {
        MethodVisitor mv = cw.visitMethod(9, "<clinit>", "()V", null, null);
        mv.visitMethodInsn(184, className, "$string_init", "()V", false);
        JvmConstantGenCommons.genMethodReturn(mv);
    }

    private void createBmpString(MethodVisitor mv, String val, String varName, String constantClassName) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/BmpStringValue");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)val);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/BmpStringValue", "<init>", "(Ljava/lang/String;)V", false);
        mv.visitFieldInsn(179, constantClassName, varName, "Lio/ballerina/runtime/api/values/BString;");
    }

    private void createNonBmpString(MethodVisitor mv, String val, String varName, String constantClassName) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/NonBmpStringValue");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)val);
        mv.visitMethodInsn(184, this.surrogatesMethodsClass, this.getHighSurrogateMethodName(varName), "()[I", false);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/NonBmpStringValue", "<init>", "(Ljava/lang/String;[I)V", false);
        mv.visitFieldInsn(179, constantClassName, varName, "Lio/ballerina/runtime/api/values/BString;");
    }

    public String getStringConstantsClass() {
        return this.stringConstantsClass;
    }

    private int[] listHighSurrogates(String str) {
        ArrayList<Integer> highSurrogates = new ArrayList<Integer>();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isHighSurrogate(c)) continue;
            highSurrogates.add(i - highSurrogates.size());
        }
        int[] highSurrogatesArr = new int[highSurrogates.size()];
        for (int i = 0; i < highSurrogates.size(); ++i) {
            Integer highSurrogate = (Integer)highSurrogates.get(i);
            highSurrogatesArr[i] = highSurrogate;
        }
        return highSurrogatesArr;
    }
}

