/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.TypeNamePair;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmConstantGenCommons;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmTupleTypeGen;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmTupleTypeConstantsGen {
    private final String tupleVarConstantsClass;
    private final Map<BTupleType, String> tupleTypeVarMap;
    private final ClassWriter cw;
    private MethodVisitor mv;
    private JvmTupleTypeGen jvmTupleTypeGen;
    private final List<String> funcNames = new ArrayList<String>();
    private final Queue<TypeNamePair> queue = new LinkedList<TypeNamePair>();
    private int tupleTypeConstCount = 0;
    private int methodCount = 1;
    private int constantIndex = 0;

    public JvmTupleTypeConstantsGen(PackageID packageID, BTypeHashComparator bTypeHashComparator) {
        this.tupleVarConstantsClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "constants/$_tuple_type_constants");
        this.cw = new BallerinaClassWriter(2);
        JvmConstantGenCommons.generateConstantsClassInit(this.cw, this.tupleVarConstantsClass);
        this.mv = this.cw.visitMethod(9, "$tuple_type_init", "()V", null, null);
        this.tupleTypeVarMap = new TreeMap<BType, String>(bTypeHashComparator);
    }

    public void setJvmTupleTypeGen(JvmTupleTypeGen jvmTupleTypeGen) {
        this.jvmTupleTypeGen = jvmTupleTypeGen;
    }

    public String add(BTupleType type, SymbolTable symbolTable) {
        String varName = this.tupleTypeVarMap.get(type);
        if (varName == null) {
            varName = this.generateBTupleInits(type, symbolTable);
            this.tupleTypeVarMap.put(type, varName);
        }
        return varName;
    }

    private String generateBTupleInits(BTupleType type, SymbolTable symbolTable) {
        String varName = "$tupleType" + this.constantIndex++;
        if (this.tupleTypeConstCount % 100 == 0 && this.tupleTypeConstCount != 0) {
            this.mv.visitMethodInsn(184, this.tupleVarConstantsClass, "$tuple_type_init" + this.methodCount, "()V", false);
            JvmConstantGenCommons.genMethodReturn(this.mv);
            this.mv = this.cw.visitMethod(8, "$tuple_type_init" + this.methodCount++, "()V", null, null);
        }
        this.visitBTupleField(varName);
        this.createBTupleType(type, varName);
        this.queue.add(new TypeNamePair(type, varName));
        if (this.queue.size() == 1) {
            this.genPopulateMethod(type, varName, symbolTable);
            this.queue.remove();
            while (!this.queue.isEmpty()) {
                TypeNamePair typeNamePair = this.queue.remove();
                this.genPopulateMethod((BTupleType)typeNamePair.type, typeNamePair.varName, symbolTable);
            }
        }
        ++this.tupleTypeConstCount;
        return varName;
    }

    private void genPopulateMethod(BTupleType type, String varName, SymbolTable symbolTable) {
        String methodName = "$populate" + varName;
        this.funcNames.add(methodName);
        MethodVisitor methodVisitor = this.cw.visitMethod(8, methodName, "()V", null, null);
        methodVisitor.visitCode();
        this.generateGetBTupleType(methodVisitor, varName);
        this.jvmTupleTypeGen.populateTuple(methodVisitor, type, symbolTable);
        JvmConstantGenCommons.genMethodReturn(methodVisitor);
    }

    private void visitTupleTypeConstPopulateInitMethods() {
        int populateFuncCount = 0;
        int populateInitMethodCount = 1;
        MethodVisitor mv = this.cw.visitMethod(9, "$populate_tuple_types", "()V", null, null);
        for (String funcName : this.funcNames) {
            if (populateFuncCount % 100 == 0 && populateFuncCount != 0) {
                mv.visitMethodInsn(184, this.tupleVarConstantsClass, "$populate_tuple_types" + populateInitMethodCount, "()V", false);
                JvmConstantGenCommons.genMethodReturn(mv);
                mv = this.cw.visitMethod(8, "$populate_tuple_types" + populateInitMethodCount++, "()V", null, null);
            }
            mv.visitMethodInsn(184, this.tupleVarConstantsClass, funcName, "()V", false);
            ++populateFuncCount;
        }
        JvmConstantGenCommons.genMethodReturn(mv);
    }

    private void createBTupleType(BTupleType tupleType, String varName) {
        this.jvmTupleTypeGen.createTupleType(this.mv, tupleType);
        this.mv.visitFieldInsn(179, this.tupleVarConstantsClass, varName, "Lio/ballerina/runtime/internal/types/BTupleType;");
    }

    private void visitBTupleField(String varName) {
        FieldVisitor fv = this.cw.visitField(9, varName, "Lio/ballerina/runtime/internal/types/BTupleType;", null, null);
        fv.visitEnd();
    }

    public void generateGetBTupleType(MethodVisitor mv, String varName) {
        mv.visitFieldInsn(178, this.tupleVarConstantsClass, varName, "Lio/ballerina/runtime/internal/types/BTupleType;");
    }

    public void generateClass(JarEntries jarEntries) {
        JvmConstantGenCommons.genMethodReturn(this.mv);
        this.visitTupleTypeConstPopulateInitMethods();
        this.cw.visitEnd();
        jarEntries.put(this.tupleVarConstantsClass + ".class", this.cw.toByteArray());
    }

    public String getTupleTypeConstantsClass() {
        return this.tupleVarConstantsClass;
    }
}

