/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.TypeNamePair;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmConstantGenCommons;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmUnionTypeGen;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

public class JvmUnionTypeConstantsGen {
    private final String unionVarConstantsClass;
    private final Map<BUnionType, String> unionTypeVarMap;
    private final ClassWriter cw;
    private MethodVisitor mv;
    private JvmUnionTypeGen jvmUnionTypeGen;
    private final List<String> funcNames = new ArrayList<String>();
    private final Queue<TypeNamePair> queue = new LinkedList<TypeNamePair>();
    private int unionTypeVarCount = 0;
    private int methodCount = 1;
    private int constantIndex = 0;

    public JvmUnionTypeConstantsGen(PackageID packageID, BTypeHashComparator bTypeHashComparator) {
        this.unionVarConstantsClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "constants/$_union_type_constants");
        this.cw = new BallerinaClassWriter(2);
        JvmConstantGenCommons.generateConstantsClassInit(this.cw, this.unionVarConstantsClass);
        this.mv = this.cw.visitMethod(9, "$union_type_init", "()V", null, null);
        this.unionTypeVarMap = new TreeMap<BType, String>(bTypeHashComparator);
    }

    public void setJvmUnionTypeGen(JvmUnionTypeGen jvmUnionTypeGen) {
        this.jvmUnionTypeGen = jvmUnionTypeGen;
    }

    public String add(BUnionType type, SymbolTable symbolTable) {
        String varName = this.unionTypeVarMap.get(type);
        if (varName == null) {
            varName = this.generateBUnionInits(type, symbolTable);
            this.unionTypeVarMap.put(type, varName);
        }
        return varName;
    }

    private String generateBUnionInits(BUnionType type, SymbolTable symbolTable) {
        String varName = "$unionType" + this.constantIndex++;
        if (this.unionTypeVarCount % 100 == 0 && this.unionTypeVarCount != 0) {
            this.mv.visitMethodInsn(184, this.unionVarConstantsClass, "$union_type_init" + this.methodCount, "()V", false);
            JvmConstantGenCommons.genMethodReturn(this.mv);
            this.mv = this.cw.visitMethod(8, "$union_type_init" + this.methodCount++, "()V", null, null);
        }
        this.visitBUnionField(varName);
        this.createBunionType(this.mv, type, varName);
        this.queue.add(new TypeNamePair(type, varName));
        if (this.queue.size() == 1) {
            this.genPopulateMethod(type, varName, symbolTable);
            this.queue.remove();
            while (!this.queue.isEmpty()) {
                TypeNamePair typeNamePair = this.queue.remove();
                this.genPopulateMethod((BUnionType)typeNamePair.type, typeNamePair.varName, symbolTable);
            }
        }
        ++this.unionTypeVarCount;
        return varName;
    }

    private void visitUnionTypePopulateInitMethods() {
        int populateFuncCount = 0;
        int populateInitMethodCount = 1;
        MethodVisitor mv = this.cw.visitMethod(9, "$populate_union_types", "()V", null, null);
        for (String funcName : this.funcNames) {
            if (populateFuncCount % 100 == 0 && populateFuncCount != 0) {
                mv.visitMethodInsn(184, this.unionVarConstantsClass, "$populate_union_types" + populateInitMethodCount, "()V", false);
                JvmConstantGenCommons.genMethodReturn(mv);
                mv = this.cw.visitMethod(8, "$populate_union_types" + populateInitMethodCount++, "()V", null, null);
            }
            mv.visitMethodInsn(184, this.unionVarConstantsClass, funcName, "()V", false);
            ++populateFuncCount;
        }
        JvmConstantGenCommons.genMethodReturn(mv);
    }

    private void genPopulateMethod(BUnionType type, String varName, SymbolTable symbolTable) {
        String methodName = "$populate" + varName;
        this.funcNames.add(methodName);
        MethodVisitor methodVisitor = this.cw.visitMethod(8, methodName, "()V", null, null);
        methodVisitor.visitCode();
        this.generateGetBUnionType(methodVisitor, varName);
        this.jvmUnionTypeGen.populateUnion(this.cw, methodVisitor, type, this.unionVarConstantsClass, varName, symbolTable);
        JvmConstantGenCommons.genMethodReturn(methodVisitor);
    }

    private void createBunionType(MethodVisitor mv, BUnionType unionType, String varName) {
        this.jvmUnionTypeGen.createUnionType(mv, unionType);
        mv.visitFieldInsn(179, this.unionVarConstantsClass, varName, "Lio/ballerina/runtime/internal/types/BUnionType;");
    }

    private void visitBUnionField(String varName) {
        FieldVisitor fv = this.cw.visitField(9, varName, "Lio/ballerina/runtime/internal/types/BUnionType;", null, null);
        fv.visitEnd();
    }

    public void generateGetBUnionType(MethodVisitor mv, String varName) {
        mv.visitFieldInsn(178, this.unionVarConstantsClass, varName, "Lio/ballerina/runtime/internal/types/BUnionType;");
    }

    public void generateClass(JarEntries jarEntries) {
        JvmConstantGenCommons.genMethodReturn(this.mv);
        this.visitUnionTypePopulateInitMethods();
        this.cw.visitEnd();
        jarEntries.put(this.unionVarConstantsClass + ".class", this.cw.toByteArray());
    }

    public String getUnionTypeConstantClass() {
        return this.unionVarConstantsClass;
    }
}

