/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.creators;

import io.ballerina.identifier.Utils;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.model.BIRFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmFunctionCallsCreatorsGen {
    private final String functionCallsClass;

    public JvmFunctionCallsCreatorsGen(PackageID packageID) {
        this.functionCallsClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "creators/$_function_calls");
    }

    public void generateFunctionCallsClass(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries, JvmCastGen jvmCastGen, List<BIRNode.BIRFunction> sortedFunctions) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(65, 33, this.functionCallsClass, null, "java/lang/Object", null);
        this.createAndSplitFunctionCallMethod(cw, module.packageID, sortedFunctions, jvmPackageGen, jvmCastGen);
        cw.visitEnd();
        byte[] bytes = jvmPackageGen.getBytes(cw, module);
        jarEntries.put(this.functionCallsClass + ".class", bytes);
    }

    public void createAndSplitFunctionCallMethod(ClassWriter cw, PackageID packageID, List<BIRNode.BIRFunction> functions, JvmPackageGen jvmPackageGen, JvmCastGen jvmCastGen) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        int funcNameRegIndex = 1;
        Label defaultCaseLabel = new Label();
        int i = 0;
        List<Object> targetLabels = new ArrayList();
        Object callMethod = "call";
        for (BIRNode.BIRFunction func : functions) {
            String encodedMethodName = Utils.encodeFunctionIdentifier((String)func.name.value);
            String packageName = JvmCodeGenUtil.getPackageName(packageID);
            BIRFunctionWrapper functionWrapper = jvmPackageGen.lookupBIRFunctionWrapper(packageName + encodedMethodName);
            if (bTypesCount % 100 == 0) {
                mv = cw.visitMethod(9, (String)callMethod, "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = functions.size() - bTypesCount;
                if (remainingCases > 100) {
                    remainingCases = 100;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, funcNameRegIndex, functions, bTypesCount, remainingCases, defaultCaseLabel, false);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, funcNameRegIndex, functions, bTypesCount, remainingCases, labels, defaultCaseLabel, false);
                i = 0;
                callMethod = "call" + ++methodCount;
            }
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            List<BType> paramTypes = func.type.paramTypes;
            BType retType = func.type.retType;
            mv.visitVarInsn(25, 0);
            int j = 0;
            for (BType paramType : paramTypes) {
                mv.visitVarInsn(25, 2);
                mv.visitLdcInsn((Object)j);
                mv.visitInsn(136);
                mv.visitInsn(50);
                jvmCastGen.addUnboxInsn(mv, paramType);
                ++j;
            }
            mv.visitMethodInsn(184, functionWrapper.fullQualifiedClassName(), func.name.value, functionWrapper.jvmMethodDescription(), false);
            int retTypeTag = JvmCodeGenUtil.getImpliedType((BType)retType).tag;
            if (retType == null || retTypeTag == 10 || retTypeTag == 50) {
                mv.visitInsn(1);
            } else {
                jvmCastGen.addBoxInsn(mv, retType);
            }
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 100 != 0) continue;
            if (bTypesCount == functions.size()) {
                JvmCodeGenUtil.createDefaultCase(mv, defaultCaseLabel, funcNameRegIndex, "No such function: ");
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(184, this.functionCallsClass, "call" + methodCount, "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", false);
                mv.visitInsn(176);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 100 != 0) {
            JvmCodeGenUtil.createDefaultCase(mv, defaultCaseLabel, funcNameRegIndex, "No such function: ");
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }
}

