/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.creators;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmRecordCreatorGen {
    private final String recordsClass;
    private final JvmTypeGen jvmTypeGen;

    public JvmRecordCreatorGen(PackageID packageID, JvmTypeGen jvmTypeGen) {
        this.recordsClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "creators/$_records");
        this.jvmTypeGen = jvmTypeGen;
    }

    public void generateRecordsClass(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries, List<BIRNode.BIRTypeDefinition> recordTypeDefList) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visit(65, 33, this.recordsClass, null, "java/lang/Object", null);
        this.generateCreateRecordMethods(cw, recordTypeDefList, this.recordsClass);
        cw.visitEnd();
        byte[] bytes = jvmPackageGen.getBytes(cw, module);
        jarEntries.put(this.recordsClass + ".class", bytes);
    }

    private void generateCreateRecordMethods(ClassWriter cw, List<BIRNode.BIRTypeDefinition> recordTypeDefList, String typeOwnerClass) {
        MethodVisitor mv = cw.visitMethod(9, "createRecordValue", "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/MapValue;", "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/MapValue<Ljava/lang/String;Ljava/lang/Object;>;", null);
        mv.visitCode();
        if (recordTypeDefList.isEmpty()) {
            JvmCodeGenUtil.createDefaultCase(mv, new Label(), 0, "No such record: ");
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, typeOwnerClass, "createRecordValue0", "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/MapValue;", false);
            mv.visitInsn(176);
            this.generateCreateRecordMethodSplits(cw, recordTypeDefList, typeOwnerClass);
        }
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "createRecordValue", this.recordsClass);
        mv.visitEnd();
    }

    private void generateCreateRecordMethodSplits(ClassWriter cw, List<BIRNode.BIRTypeDefinition> recordTypeDefList, String typeOwnerClass) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        List<Object> targetLabels = new ArrayList();
        int fieldNameRegIndex = 0;
        Label defaultCaseLabel = new Label();
        recordTypeDefList.sort(JvmCodeGenUtil.NAME_HASH_COMPARATOR);
        int i = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : recordTypeDefList) {
            if (bTypesCount % 100 == 0) {
                mv = cw.visitMethod(10, "createRecordValue" + methodCount++, "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/MapValue;", "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/MapValue<Ljava/lang/String;Ljava/lang/Object;>;", null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = recordTypeDefList.size() - bTypesCount;
                if (remainingCases > 100) {
                    remainingCases = 100;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, fieldNameRegIndex, recordTypeDefList, bTypesCount, remainingCases, defaultCaseLabel);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, fieldNameRegIndex, recordTypeDefList, bTypesCount, remainingCases, labels, defaultCaseLabel);
                i = 0;
            }
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            mv.visitVarInsn(25, 0);
            BTypeSymbol referredTypeSymbol = JvmCodeGenUtil.getImpliedType((BType)optionalTypeDef.type).tsymbol;
            String className = JvmValueGen.getTypeValueClassName(referredTypeSymbol.pkgID, referredTypeSymbol.name.getValue());
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            BType typeDefType = optionalTypeDef.type;
            if (typeDefType.tag == 14) {
                this.jvmTypeGen.loadType(mv, optionalTypeDef.referenceType);
            } else {
                this.jvmTypeGen.loadType(mv, optionalTypeDef.type);
            }
            mv.visitMethodInsn(183, className, "<init>", "(Lio/ballerina/runtime/api/types/Type;)V", false);
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 100 != 0) continue;
            if (bTypesCount == recordTypeDefList.size()) {
                JvmCodeGenUtil.createDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex, "No such record: ");
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, fieldNameRegIndex);
                mv.visitMethodInsn(184, typeOwnerClass, "createRecordValue" + methodCount, "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/MapValue;", false);
                mv.visitInsn(176);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 100 != 0) {
            JvmCodeGenUtil.createDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex, "No such record: ");
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }
}

