/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.types;

import io.ballerina.identifier.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.util.Name;

public class JvmObjectTypeGen {
    public final String objectTypesClass;
    private final String typesClass;
    public final ClassWriter objectTypesCw;
    private final JvmCreateTypeGen jvmCreateTypeGen;
    private final JvmTypeGen jvmTypeGen;
    private final JvmConstantsGen jvmConstantsGen;

    public JvmObjectTypeGen(JvmCreateTypeGen jvmCreateTypeGen, String typesClass, JvmTypeGen jvmTypeGen, JvmConstantsGen jvmConstantsGen, PackageID packageID) {
        this.objectTypesClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "types/$_object_types");
        this.typesClass = typesClass;
        this.jvmCreateTypeGen = jvmCreateTypeGen;
        this.jvmTypeGen = jvmTypeGen;
        this.jvmConstantsGen = jvmConstantsGen;
        this.objectTypesCw = new BallerinaClassWriter(2);
        this.objectTypesCw.visit(65, 33, this.objectTypesClass, null, "java/lang/Object", null);
    }

    public void visitEnd(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries) {
        this.objectTypesCw.visitEnd();
        jarEntries.put(this.objectTypesClass + ".class", jvmPackageGen.getBytes(this.objectTypesCw, module));
    }

    public void createObjectType(MethodVisitor mv, BObjectType objectType) {
        String objectClassName = Symbols.isService(objectType.tsymbol) ? "io/ballerina/runtime/internal/types/BServiceType" : (Symbols.isClient(objectType.tsymbol) ? "io/ballerina/runtime/internal/types/BClientType" : "io/ballerina/runtime/internal/types/BObjectType");
        mv.visitTypeInsn(187, objectClassName);
        mv.visitInsn(89);
        BTypeSymbol typeSymbol = objectType.tsymbol;
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)typeSymbol.name.getValue()));
        String varName = this.jvmConstantsGen.getModuleConstantVar(objectType.tsymbol.pkgID);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(), varName, "Lio/ballerina/runtime/api/Module;");
        mv.visitLdcInsn((Object)typeSymbol.flags);
        mv.visitMethodInsn(183, objectClassName, "<init>", "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;J)V", false);
    }

    public void populateObject(ClassWriter cw, MethodVisitor mv, String methodName, SymbolTable symbolTable, String fieldName, BObjectType bType, BIRVarToJVMIndexMap indexMap) {
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
        mv.visitInsn(89);
        mv.visitInsn(89);
        this.addObjectFields(mv, methodName, bType.fields);
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)bType.tsymbol;
        this.addObjectInitFunction(mv, objectTypeSymbol.generatedInitializerFunc, bType, indexMap, "$init$", symbolTable, true);
        this.addObjectInitFunction(mv, objectTypeSymbol.initializerFunc, bType, indexMap, "init", symbolTable, false);
        this.addObjectAttachedFunctions(cw, mv, fieldName, objectTypeSymbol.attachedFuncs, bType, symbolTable);
        this.addResourceMethods(cw, mv, fieldName, objectTypeSymbol.attachedFuncs, bType, symbolTable);
        this.jvmCreateTypeGen.addImmutableType(mv, bType, symbolTable);
        BTypeIdSet objTypeIdSet = bType.typeIdSet;
        if (!objTypeIdSet.isEmpty()) {
            mv.visitInsn(89);
            this.jvmCreateTypeGen.loadTypeIdSet(mv, objTypeIdSet);
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setTypeIdSet", "(Lio/ballerina/runtime/internal/types/BTypeIdSet;)V", false);
        }
    }

    private void addObjectAttachedFunctions(ClassWriter cw, MethodVisitor mv, String fieldName, List<BAttachedFunction> attachedFunctions, BObjectType objType, SymbolTable symbolTable) {
        mv.visitLdcInsn((Object)((long)attachedFunctions.size() - JvmObjectTypeGen.resourceFunctionCount(attachedFunctions)));
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/internal/types/BMethodType");
        String methodName = "$populate" + fieldName + "$attachedFunctions";
        int methodCount = this.splitObjectAttachedFunctions(cw, methodName, attachedFunctions, objType, symbolTable);
        if (methodCount > 0) {
            mv.visitVarInsn(58, 0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, this.typesClass, methodName + "0", "([Lio/ballerina/runtime/internal/types/BMethodType;)V", false);
            mv.visitVarInsn(25, 0);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setMethods", "([Lio/ballerina/runtime/api/types/MethodType;)V", false);
    }

    private int splitObjectAttachedFunctions(ClassWriter cw, String methodName, List<BAttachedFunction> attachedFunctions, BObjectType objType, SymbolTable symbolTable) {
        int fTypeCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        ArrayList<BAttachedFunction> nonResourceFunctions = new ArrayList<BAttachedFunction>();
        for (BAttachedFunction attachedFunc : attachedFunctions) {
            if (attachedFunc == null || attachedFunc instanceof BResourceFunction) continue;
            nonResourceFunctions.add(attachedFunc);
        }
        indexMap.addIfNotExists("$array", symbolTable.anyType);
        for (BAttachedFunction attachedFunc : nonResourceFunctions) {
            if (fTypeCount % 100 == 0) {
                mv = cw.visitMethod(9, methodName + methodCount++, "([Lio/ballerina/runtime/internal/types/BMethodType;)V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
            }
            this.createObjectMemberFunction(mv, attachedFunc, objType);
            int attachedFunctionVarIndex = indexMap.addIfNotExists(JvmCodeGenUtil.toNameString(objType) + attachedFunc.funcName.value, symbolTable.anyType);
            mv.visitVarInsn(58, attachedFunctionVarIndex);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)fTypeCount);
            mv.visitInsn(136);
            mv.visitVarInsn(25, attachedFunctionVarIndex);
            mv.visitInsn(83);
            if (++fTypeCount % 100 != 0) continue;
            if (fTypeCount != nonResourceFunctions.size()) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(184, this.typesClass, methodName + methodCount, "([Lio/ballerina/runtime/internal/types/BMethodType;)V", false);
            }
            mv.visitInsn(177);
            mv.visitMaxs(fTypeCount + 10, fTypeCount + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && fTypeCount % 100 != 0) {
            mv.visitInsn(177);
            mv.visitMaxs(fTypeCount + 10, fTypeCount + 10);
            mv.visitEnd();
        }
        return methodCount;
    }

    private void addObjectInitFunction(MethodVisitor mv, BAttachedFunction initFunction, BObjectType objType, BIRVarToJVMIndexMap indexMap, String funcName, SymbolTable symbolTable, boolean isGeneratedInit) {
        if (initFunction == null || !initFunction.funcName.value.contains(funcName)) {
            return;
        }
        mv.visitInsn(89);
        this.createObjectMemberFunction(mv, initFunction, objType);
        int attachedFunctionVarIndex = indexMap.addIfNotExists(String.valueOf(objType.name) + initFunction.funcName.value, symbolTable.anyType);
        mv.visitVarInsn(58, attachedFunctionVarIndex);
        mv.visitVarInsn(25, attachedFunctionVarIndex);
        mv.visitInsn(89);
        mv.visitInsn(87);
        if (isGeneratedInit) {
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setGeneratedInitMethod", "(Lio/ballerina/runtime/internal/types/BMethodType;)V", false);
        } else {
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setInitMethod", "(Lio/ballerina/runtime/api/types/MethodType;)V", false);
        }
    }

    private void addResourceMethods(ClassWriter cw, MethodVisitor mv, String fieldName, List<BAttachedFunction> attachedFunctions, BObjectType objType, SymbolTable symbolTable) {
        if (!Symbols.isService(objType.tsymbol) && !Symbols.isClient(objType.tsymbol)) {
            return;
        }
        String objectClassName = Symbols.isService(objType.tsymbol) ? "io/ballerina/runtime/internal/types/BServiceType" : "io/ballerina/runtime/internal/types/BClientType";
        mv.visitInsn(89);
        mv.visitTypeInsn(192, objectClassName);
        mv.visitLdcInsn((Object)JvmObjectTypeGen.resourceFunctionCount(attachedFunctions));
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/types/ResourceMethodType");
        String methodName = "$populate" + fieldName + "$resourceFunctions";
        int methodCount = this.splitResourceMethods(cw, methodName, attachedFunctions, objType, symbolTable);
        if (methodCount > 0) {
            mv.visitVarInsn(58, 0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, this.typesClass, methodName + "0", "([Lio/ballerina/runtime/api/types/ResourceMethodType;)V", false);
            mv.visitVarInsn(25, 0);
        }
        mv.visitMethodInsn(182, objectClassName, "setResourceMethods", "([Lio/ballerina/runtime/api/types/ResourceMethodType;)V", false);
    }

    private int splitResourceMethods(ClassWriter cw, String methodName, List<BAttachedFunction> attachedFunctions, BObjectType objType, SymbolTable symbolTable) {
        int resourcesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        BIRVarToJVMIndexMap indexMap = new BIRVarToJVMIndexMap();
        ArrayList<BAttachedFunction> resourceFunctions = new ArrayList<BAttachedFunction>();
        for (BAttachedFunction attachedFunc : attachedFunctions) {
            if (!(attachedFunc instanceof BResourceFunction)) continue;
            resourceFunctions.add(attachedFunc);
        }
        indexMap.addIfNotExists("$array", symbolTable.anyType);
        for (BAttachedFunction attachedFunc : resourceFunctions) {
            if (resourcesCount % 100 == 0) {
                mv = cw.visitMethod(9, methodName + methodCount++, "([Lio/ballerina/runtime/api/types/ResourceMethodType;)V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
            }
            BResourceFunction resourceFunction = (BResourceFunction)attachedFunc;
            this.createResourceFunction(mv, resourceFunction, objType);
            String varRefName = JvmCodeGenUtil.toNameString(objType) + resourceFunction.funcName.value + "$r$func";
            int rFuncVarIndex = indexMap.addIfNotExists(varRefName, symbolTable.anyType);
            mv.visitVarInsn(58, rFuncVarIndex);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)resourcesCount);
            mv.visitInsn(136);
            mv.visitVarInsn(25, rFuncVarIndex);
            mv.visitInsn(83);
            if (++resourcesCount % 100 != 0) continue;
            if (resourcesCount != resourceFunctions.size()) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(184, this.typesClass, methodName + methodCount, "([Lio/ballerina/runtime/api/types/ResourceMethodType;)V", false);
            }
            mv.visitInsn(177);
            mv.visitMaxs(resourcesCount + 10, resourcesCount + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && resourcesCount % 100 != 0) {
            mv.visitInsn(177);
            mv.visitMaxs(resourcesCount + 10, resourcesCount + 10);
            mv.visitEnd();
        }
        return methodCount;
    }

    private static long resourceFunctionCount(List<BAttachedFunction> attachedFunctions) {
        int i = 0;
        for (BAttachedFunction attachedFunction : attachedFunctions) {
            if (!(attachedFunction instanceof BResourceFunction)) continue;
            ++i;
        }
        return i;
    }

    private void createObjectMemberFunction(MethodVisitor mv, BAttachedFunction attachedFunc, BObjectType objType) {
        if (Symbols.isRemote(attachedFunc.symbol)) {
            this.createRemoteFunction(mv, attachedFunc, objType);
            return;
        }
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BMethodType");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)attachedFunc.funcName.value));
        String moduleName = this.jvmConstantsGen.getModuleConstantVar(objType.tsymbol.pkgID);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(), moduleName, "Lio/ballerina/runtime/api/Module;");
        this.jvmTypeGen.loadType(mv, objType);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
        this.jvmTypeGen.loadType(mv, attachedFunc.type);
        mv.visitLdcInsn((Object)attachedFunc.symbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BMethodType", "<init>", "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;Lio/ballerina/runtime/internal/types/BObjectType;Lio/ballerina/runtime/internal/types/BFunctionType;J)V", false);
    }

    private void createRemoteFunction(MethodVisitor mv, BAttachedFunction attachedFunc, BObjectType objType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BRemoteMethodType");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)attachedFunc.funcName.value));
        String moduleName = this.jvmConstantsGen.getModuleConstantVar(objType.tsymbol.pkgID);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(), moduleName, "Lio/ballerina/runtime/api/Module;");
        this.jvmTypeGen.loadType(mv, objType);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
        this.jvmTypeGen.loadType(mv, attachedFunc.type);
        mv.visitLdcInsn((Object)attachedFunc.symbol.flags);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BRemoteMethodType", "<init>", "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;Lio/ballerina/runtime/internal/types/BObjectType;Lio/ballerina/runtime/internal/types/BFunctionType;J)V", false);
    }

    private void createResourceFunction(MethodVisitor mv, BResourceFunction resourceFunction, BObjectType objType) {
        int i;
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BResourceMethodType");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)resourceFunction.funcName.value);
        String moduleName = this.jvmConstantsGen.getModuleConstantVar(objType.tsymbol.pkgID);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(), moduleName, "Lio/ballerina/runtime/api/Module;");
        this.jvmTypeGen.loadType(mv, objType);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BObjectType");
        this.jvmTypeGen.loadType(mv, resourceFunction.type);
        List<BResourcePathSegmentSymbol> pathSegmentSymbols = resourceFunction.pathSegmentSymbols;
        int pathSegmentSize = pathSegmentSymbols.size();
        mv.visitLdcInsn((Object)pathSegmentSize);
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/types/Type");
        for (i = 0; i < pathSegmentSize; ++i) {
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            this.jvmTypeGen.loadType(mv, pathSegmentSymbols.get((int)i).type);
            mv.visitInsn(83);
        }
        mv.visitLdcInsn((Object)resourceFunction.symbol.flags);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)resourceFunction.accessor.value));
        mv.visitLdcInsn((Object)pathSegmentSize);
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "java/lang/String");
        for (i = 0; i < pathSegmentSize; ++i) {
            Name path = pathSegmentSymbols.get((int)i).name;
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            mv.visitLdcInsn((Object)path.value);
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BResourceMethodType", "<init>", "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;Lio/ballerina/runtime/internal/types/BObjectType;Lio/ballerina/runtime/internal/types/BFunctionType;[Lio/ballerina/runtime/api/types/Type;JLjava/lang/String;[Ljava/lang/String;)V", false);
    }

    private void addObjectFields(MethodVisitor mv, String methodName, Map<String, BField> fields) {
        mv.visitTypeInsn(187, "java/util/LinkedHashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        if (!fields.isEmpty()) {
            mv.visitInsn(89);
            mv.visitMethodInsn(184, this.objectTypesClass, methodName + "$addField$", "(Ljava/util/LinkedHashMap;)V", false);
            this.jvmCreateTypeGen.splitAddFields(this.objectTypesCw, this.objectTypesClass, methodName, fields);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BObjectType", "setFields", "(Ljava/util/Map;)V", false);
    }
}

