/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.types;

import io.ballerina.identifier.Utils;
import java.util.List;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmTupleTypeGen {
    public final String tupleTypesClass;
    public final ClassWriter tupleTypesCw;
    private final JvmCreateTypeGen jvmCreateTypeGen;
    private final JvmTypeGen jvmTypeGen;
    private final JvmConstantsGen jvmConstantsGen;

    public JvmTupleTypeGen(JvmCreateTypeGen jvmCreateTypeGen, JvmTypeGen jvmTypeGen, JvmConstantsGen jvmConstantsGen, PackageID packageID) {
        this.tupleTypesClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "types/$_tuple_types");
        this.jvmCreateTypeGen = jvmCreateTypeGen;
        this.jvmTypeGen = jvmTypeGen;
        this.jvmConstantsGen = jvmConstantsGen;
        this.tupleTypesCw = new BallerinaClassWriter(2);
        this.tupleTypesCw.visit(65, 33, this.tupleTypesClass, null, "java/lang/Object", null);
    }

    public void visitEnd(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries) {
        this.tupleTypesCw.visitEnd();
        jarEntries.put(this.tupleTypesClass + ".class", jvmPackageGen.getBytes(this.tupleTypesCw, module));
    }

    public void createTupleType(MethodVisitor mv, BTupleType tupleType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BTupleType");
        mv.visitInsn(89);
        BTypeSymbol typeSymbol = tupleType.tsymbol;
        if (typeSymbol == null) {
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)tupleType.name.getValue()));
            mv.visitInsn(1);
        } else {
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)typeSymbol.name.getValue()));
            String varName = this.jvmConstantsGen.getModuleConstantVar(typeSymbol.pkgID);
            mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(), varName, "Lio/ballerina/runtime/api/Module;");
        }
        mv.visitLdcInsn((Object)this.jvmTypeGen.typeFlag(tupleType));
        this.jvmTypeGen.loadCyclicFlag(mv, tupleType);
        this.jvmTypeGen.loadReadonlyFlag(mv, tupleType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTupleType", "<init>", "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;IZZ)V", false);
    }

    public void populateTuple(MethodVisitor mv, BTupleType bType, SymbolTable symbolTable) {
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BTupleType");
        mv.visitInsn(89);
        mv.visitInsn(89);
        mv.visitInsn(89);
        this.addCyclicFlag(mv, bType);
        this.addTupleMembers(mv, bType);
        this.jvmCreateTypeGen.addImmutableType(mv, bType, symbolTable);
    }

    private void addTupleMembers(MethodVisitor mv, BTupleType tupleType) {
        this.createTupleMembersList(mv, tupleType.getMembers());
        BType restType = tupleType.restType;
        if (restType == null) {
            mv.visitInsn(1);
        } else {
            this.jvmTypeGen.loadType(mv, restType);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BTupleType", "setMemberTypes", "(Ljava/util/List;Lio/ballerina/runtime/api/types/Type;)V", false);
    }

    private void addCyclicFlag(MethodVisitor mv, BType userDefinedType) {
        this.jvmTypeGen.loadCyclicFlag(mv, userDefinedType);
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BTupleType", "setCyclic", "(Z)V", false);
    }

    private void createTupleMembersList(MethodVisitor mv, List<BTupleMember> members) {
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        for (BTupleMember tupleType : members) {
            mv.visitInsn(89);
            this.jvmTypeGen.loadType(mv, tupleType.type);
            mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
        }
    }
}

