/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.emit;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ballerinalang.compiler.CompilerOptionName;
import org.wso2.ballerinalang.compiler.bir.emit.EmitterUtils;
import org.wso2.ballerinalang.compiler.bir.emit.InstructionEmitter;
import org.wso2.ballerinalang.compiler.bir.emit.TypeEmitter;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;

public class BIREmitter {
    private static final CompilerContext.Key<BIREmitter> BIR_EMITTER = new CompilerContext.Key();
    private static final PrintStream console = System.out;
    private final boolean dumpBIR;

    public static BIREmitter getInstance(CompilerContext context) {
        BIREmitter birEmitter = context.get(BIR_EMITTER);
        if (birEmitter == null) {
            birEmitter = new BIREmitter(context);
        }
        return birEmitter;
    }

    private BIREmitter(CompilerContext context) {
        context.put(BIR_EMITTER, this);
        CompilerOptions compilerOptions = CompilerOptions.getInstance(context);
        this.dumpBIR = CompilerUtils.getBooleanValueIfSet(compilerOptions, CompilerOptionName.DUMP_BIR);
    }

    public BLangPackage emit(BLangPackage bLangPackage) {
        this.emit(bLangPackage.symbol.bir);
        return bLangPackage;
    }

    public void emit(BIRNode.BIRPackage birPackage) {
        if (this.dumpBIR) {
            console.println(BIREmitter.emitModule(birPackage));
        }
    }

    public static String emitModule(BIRNode.BIRPackage mod) {
        Object modStr = "================ Emitting Module ================";
        modStr = (String)modStr + EmitterUtils.emitLBreaks(1);
        modStr = (String)modStr + "module";
        modStr = (String)modStr + EmitterUtils.emitSpaces(1);
        modStr = (String)modStr + EmitterUtils.emitName(mod.packageID.orgName) + "/" + EmitterUtils.emitName(mod.packageID.name);
        modStr = (String)modStr + EmitterUtils.emitSpaces(1);
        modStr = (String)modStr + "v";
        modStr = (String)modStr + EmitterUtils.emitSpaces(1);
        modStr = (String)modStr + EmitterUtils.emitName(mod.packageID.version) + ";";
        modStr = (String)modStr + EmitterUtils.emitLBreaks(2);
        modStr = (String)modStr + BIREmitter.emitImports(mod.importModules);
        modStr = (String)modStr + EmitterUtils.emitLBreaks(2);
        modStr = (String)modStr + BIREmitter.emitTypeDefs(mod.typeDefs);
        modStr = (String)modStr + EmitterUtils.emitLBreaks(2);
        modStr = (String)modStr + BIREmitter.emitGlobalVars(mod.globalVars);
        modStr = (String)modStr + EmitterUtils.emitLBreaks(2);
        modStr = (String)modStr + BIREmitter.emitFunctions(mod.functions);
        modStr = (String)modStr + EmitterUtils.emitLBreaks(1);
        modStr = (String)modStr + "================ Emitting Module ================";
        return modStr;
    }

    private static String emitImports(Set<BIRNode.BIRImportModule> impMods) {
        StringBuilder impStr = new StringBuilder();
        for (BIRNode.BIRImportModule mod : impMods) {
            impStr.append(BIREmitter.emitImport(mod));
            impStr.append(EmitterUtils.emitLBreaks(1));
        }
        return impStr.toString();
    }

    private static String emitImport(BIRNode.BIRImportModule impMod) {
        Object impStr = "import ";
        impStr = (String)impStr + EmitterUtils.emitName(impMod.packageID.orgName) + "/";
        impStr = (String)impStr + EmitterUtils.emitName(impMod.packageID.name);
        if (!EmitterUtils.isEmpty(impMod.packageID.version)) {
            impStr = (String)impStr + EmitterUtils.emitSpaces(1);
            impStr = (String)impStr + "v";
            impStr = (String)impStr + EmitterUtils.emitSpaces(1);
            impStr = (String)impStr + EmitterUtils.emitName(impMod.packageID.version);
        }
        impStr = (String)impStr + ";";
        return impStr;
    }

    private static String emitTypeDefs(List<BIRNode.BIRTypeDefinition> typeDefs) {
        StringBuilder tDefStr = new StringBuilder();
        for (BIRNode.BIRTypeDefinition tDef : typeDefs) {
            tDefStr.append(BIREmitter.emitTypeDef(tDef));
            tDefStr.append(EmitterUtils.emitLBreaks(2));
        }
        return tDefStr.toString();
    }

    private static String emitTypeDef(BIRNode.BIRTypeDefinition tDef) {
        TypeEmitter.B_TYPES.put(tDef.internalName.value, tDef.type);
        StringBuilder tDefStr = new StringBuilder();
        tDefStr.append(EmitterUtils.emitFlags(tDef.flags));
        if (!tDefStr.toString().isEmpty()) {
            tDefStr.append(EmitterUtils.emitSpaces(1));
        }
        tDefStr.append(EmitterUtils.emitName(tDef.internalName));
        tDefStr.append(EmitterUtils.emitSpaces(1));
        tDefStr.append(TypeEmitter.emitType(tDef.type, 0));
        List<BIRNode.BIRFunction> attachedFuncs = tDef.attachedFuncs;
        if (attachedFuncs != null) {
            tDefStr.append(EmitterUtils.emitLBreaks(1));
            tDefStr.append("{");
            tDefStr.append(EmitterUtils.emitLBreaks(1));
            for (BIRNode.BIRFunction func : attachedFuncs) {
                tDefStr.append(BIREmitter.emitFunction(func, 1));
                tDefStr.append(EmitterUtils.emitLBreaks(1));
            }
            tDefStr.append("}");
        }
        tDefStr.append(";");
        return tDefStr.toString();
    }

    private static String emitGlobalVars(List<BIRNode.BIRGlobalVariableDcl> globleVars) {
        StringBuilder globalVarStr = new StringBuilder();
        for (BIRNode.BIRGlobalVariableDcl globalVar : globleVars) {
            globalVarStr.append(BIREmitter.emitGlobalVar(globalVar));
            globalVarStr.append(EmitterUtils.emitLBreaks(1));
        }
        return globalVarStr.toString();
    }

    private static String emitGlobalVar(BIRNode.BIRGlobalVariableDcl globalVar) {
        Object globalVarStr = "";
        if (!((String)(globalVarStr = (String)globalVarStr + EmitterUtils.emitFlags(globalVar.flags))).isEmpty()) {
            globalVarStr = (String)globalVarStr + EmitterUtils.emitSpaces(1);
        }
        globalVarStr = (String)globalVarStr + EmitterUtils.emitName(globalVar.name);
        globalVarStr = (String)globalVarStr + EmitterUtils.emitSpaces(1);
        globalVarStr = (String)globalVarStr + TypeEmitter.emitTypeRef(globalVar.type, 0);
        globalVarStr = (String)globalVarStr + ";";
        return globalVarStr;
    }

    private static String emitFunctions(List<BIRNode.BIRFunction> funcs) {
        StringBuilder funcString = new StringBuilder();
        for (BIRNode.BIRFunction func : funcs) {
            funcString.append(BIREmitter.emitFunction(func, 0));
            funcString.append(EmitterUtils.emitLBreaks(2));
        }
        return funcString.toString();
    }

    public static String emitFunction(BIRNode.BIRFunction func, int tabs) {
        Object funcString = "";
        funcString = (String)funcString + EmitterUtils.emitTabs(tabs);
        if (!((String)(funcString = (String)funcString + EmitterUtils.emitFlags(func.flags))).isEmpty()) {
            funcString = (String)funcString + EmitterUtils.emitSpaces(1);
        }
        funcString = (String)funcString + EmitterUtils.emitName(func.name);
        funcString = (String)funcString + EmitterUtils.emitSpaces(1);
        funcString = (String)funcString + TypeEmitter.emitType(func.type, 0);
        funcString = (String)funcString + EmitterUtils.emitSpaces(1);
        funcString = (String)funcString + "{";
        funcString = (String)funcString + EmitterUtils.emitLBreaks(1);
        funcString = (String)funcString + BIREmitter.emitLocalVars(func.localVars, tabs + 1);
        funcString = (String)funcString + EmitterUtils.emitLBreaks(1);
        funcString = (String)funcString + BIREmitter.emitBasicBlocks(func.basicBlocks, tabs + 1);
        funcString = (String)funcString + EmitterUtils.emitLBreaks(1);
        funcString = (String)funcString + BIREmitter.emitErrorEntries(func.errorTable, tabs + 1);
        funcString = (String)funcString + EmitterUtils.emitLBreaks(1);
        funcString = (String)funcString + EmitterUtils.emitTabs(tabs);
        funcString = (String)funcString + "}";
        return funcString;
    }

    private static String emitLocalVars(List<BIRNode.BIRVariableDcl> localVars, int tabs) {
        StringBuilder varStr = new StringBuilder();
        for (BIRNode.BIRVariableDcl lVar : localVars) {
            varStr.append(BIREmitter.emitLocalVar(lVar, tabs));
            varStr.append(EmitterUtils.emitLBreaks(1));
        }
        return varStr.toString();
    }

    private static String emitLocalVar(BIRNode.BIRVariableDcl lVar, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + EmitterUtils.emitName(lVar.name);
        str = (String)str + "(";
        str = (String)str + lVar.kind.toString();
        str = (String)str + ")";
        str = (String)str + EmitterUtils.emitSpaces(1);
        str = (String)str + TypeEmitter.emitTypeRef(lVar.type, 0);
        str = (String)str + ";";
        return str;
    }

    private static String emitBasicBlocks(List<BIRNode.BIRBasicBlock> basicBlocks, int tabs) {
        StringBuilder bbStr = new StringBuilder();
        for (BIRNode.BIRBasicBlock bb : basicBlocks) {
            bbStr.append(BIREmitter.emitBasicBlock(bb, tabs));
            bbStr.append(EmitterUtils.emitLBreaks(1));
        }
        return bbStr.toString();
    }

    private static String emitBasicBlock(BIRNode.BIRBasicBlock basicBlock, int tabs) {
        Object bbStr = "";
        bbStr = (String)bbStr + EmitterUtils.emitTabs(tabs);
        bbStr = (String)bbStr + EmitterUtils.emitName(basicBlock.id);
        bbStr = (String)bbStr + EmitterUtils.emitSpaces(1);
        bbStr = (String)bbStr + "{";
        bbStr = (String)bbStr + EmitterUtils.emitLBreaks(1);
        bbStr = (String)bbStr + InstructionEmitter.emitInstructions(basicBlock.instructions, tabs + 1);
        bbStr = (String)bbStr + InstructionEmitter.emitTerminator(basicBlock.terminator, tabs + 1);
        bbStr = (String)bbStr + EmitterUtils.emitLBreaks(1);
        bbStr = (String)bbStr + EmitterUtils.emitTabs(tabs);
        bbStr = (String)bbStr + "}";
        return bbStr;
    }

    private static String emitErrorEntries(List<BIRNode.BIRErrorEntry> errorEntries, int tabs) {
        StringBuilder str = new StringBuilder();
        if (errorEntries.isEmpty()) {
            return str.toString();
        }
        str.append(EmitterUtils.emitTabs(tabs));
        str.append("-------------------------------------------------------------");
        str.append(EmitterUtils.emitLBreaks(1));
        str.append(EmitterUtils.emitTabs(tabs));
        str.append("|");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("trapBB");
        str.append(EmitterUtils.emitSpaces(7));
        str.append("|");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("endBB");
        str.append(EmitterUtils.emitSpaces(8));
        str.append("|");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("targetBB");
        str.append(EmitterUtils.emitSpaces(5));
        str.append("|");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("errorOp");
        str.append(EmitterUtils.emitSpaces(6));
        str.append("|");
        str.append(EmitterUtils.emitLBreaks(1));
        str.append(EmitterUtils.emitTabs(tabs));
        str.append("-------------------------------------------------------------");
        str.append(EmitterUtils.emitLBreaks(1));
        for (BIRNode.BIRErrorEntry err : errorEntries) {
            str.append(BIREmitter.emitErrorEntry(err, tabs));
            str.append(EmitterUtils.emitLBreaks(1));
        }
        str.append(EmitterUtils.emitTabs(tabs));
        str.append("-------------------------------------------------------------");
        return str.toString();
    }

    private static String emitErrorEntry(BIRNode.BIRErrorEntry err, int tabs) {
        Object str = "";
        str = (String)str + EmitterUtils.emitTabs(tabs);
        str = (String)str + "|";
        str = (String)str + EmitterUtils.emitSpaces(1);
        String bbRef = EmitterUtils.emitBasicBlockRef(err.trapBB);
        int bbSpaces = BIREmitter.calculateSpaces(bbRef);
        str = (String)str + bbRef;
        str = (String)str + EmitterUtils.emitSpaces(bbSpaces);
        str = (String)str + "|";
        str = (String)str + EmitterUtils.emitSpaces(1);
        String endBBRef = EmitterUtils.emitBasicBlockRef(err.endBB);
        int endBBSpaces = BIREmitter.calculateSpaces(endBBRef);
        str = (String)str + endBBRef;
        str = (String)str + EmitterUtils.emitSpaces(endBBSpaces);
        str = (String)str + "|";
        str = (String)str + EmitterUtils.emitSpaces(1);
        String targetBBRef = EmitterUtils.emitBasicBlockRef(err.targetBB);
        int targetBBSpaces = BIREmitter.calculateSpaces(targetBBRef);
        str = (String)str + targetBBRef;
        str = (String)str + EmitterUtils.emitSpaces(targetBBSpaces);
        str = (String)str + "|";
        str = (String)str + EmitterUtils.emitSpaces(1);
        String varRef = EmitterUtils.emitVarRef(err.errorOp);
        int varRefSpaces = BIREmitter.calculateSpaces(varRef);
        str = (String)str + varRef;
        str = (String)str + EmitterUtils.emitSpaces(varRefSpaces);
        str = (String)str + "|";
        return str;
    }

    private static int calculateSpaces(String str) {
        return 13 - str.length();
    }
}

