/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.emit;

import io.ballerina.runtime.api.flags.SymbolFlags;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.emit.TypeEmitter;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;

final class EmitterUtils {
    private EmitterUtils() {
    }

    static String emitName(Name name) {
        return name.value;
    }

    static String emitVarRef(BIROperand ref) {
        if (ref == null) {
            return "null";
        }
        return EmitterUtils.emitName(ref.variableDcl.name);
    }

    static String emitVarRefs(BIROperand[] refs) {
        return Arrays.stream(refs).map(EmitterUtils::emitVarRef).collect(Collectors.joining(","));
    }

    static String emitBasicBlockRef(BIRNode.BIRBasicBlock basicBlock) {
        return EmitterUtils.emitName(basicBlock.id);
    }

    static String emitModuleID(PackageID modId) {
        Object str = "";
        str = (String)str + String.valueOf(modId.orgName) + "/";
        str = (String)str + String.valueOf(modId.name);
        if (!modId.version.value.isEmpty()) {
            str = (String)str + ":";
            str = (String)str + modId.version.value;
        }
        return str;
    }

    static String emitBinaryOpInstructionKind(InstructionKind kind) {
        return switch (kind) {
            case InstructionKind.ADD -> "+";
            case InstructionKind.SUB -> "-";
            case InstructionKind.MUL -> "*";
            case InstructionKind.DIV -> "/";
            case InstructionKind.MOD -> "%";
            case InstructionKind.EQUAL -> "==";
            case InstructionKind.NOT_EQUAL -> "!=";
            case InstructionKind.GREATER_THAN -> ">";
            case InstructionKind.GREATER_EQUAL -> ">=";
            case InstructionKind.LESS_THAN -> "<";
            case InstructionKind.LESS_EQUAL -> "<=";
            case InstructionKind.REF_EQUAL -> "===";
            case InstructionKind.REF_NOT_EQUAL -> "!==";
            case InstructionKind.CLOSED_RANGE -> "...";
            case InstructionKind.HALF_OPEN_RANGE -> "..<";
            case InstructionKind.ANNOT_ACCESS -> ".@";
            case InstructionKind.BITWISE_AND -> "&";
            case InstructionKind.BITWISE_OR -> "|";
            case InstructionKind.BITWISE_XOR -> "^";
            case InstructionKind.BITWISE_LEFT_SHIFT -> "<<";
            case InstructionKind.BITWISE_RIGHT_SHIFT -> ">>";
            case InstructionKind.BITWISE_UNSIGNED_RIGHT_SHIFT -> ">>>";
            default -> throw new IllegalStateException("Not a binary opkind");
        };
    }

    static String emitFlags(long flag) {
        if (SymbolFlags.isFlagOn((long)flag, (long)1024L)) {
            return "private";
        }
        if (SymbolFlags.isFlagOn((long)flag, (long)1L)) {
            return "public";
        }
        if (SymbolFlags.isFlagOn((long)flag, (long)0x2000000L)) {
            return "transactional";
        }
        return "";
    }

    static String emitTabs(int tabs) {
        StringBuilder tab = new StringBuilder();
        for (int i = 0; i < tabs; ++i) {
            tab.append(EmitterUtils.emitSpaces(4));
        }
        return tab.toString();
    }

    static String emitSpaces(int spaces) {
        StringBuilder spacesString = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            spacesString.append(" ");
        }
        return spacesString.toString();
    }

    static String emitLBreaks(int breaks) {
        StringBuilder lineBreaks = new StringBuilder();
        for (int i = 0; i < breaks; ++i) {
            lineBreaks.append("\n");
        }
        return lineBreaks.toString();
    }

    static String getTypeName(BType bType) {
        for (Map.Entry<String, BType> entry : TypeEmitter.B_TYPES.entrySet()) {
            if (!entry.getValue().equals(bType)) continue;
            return entry.getKey();
        }
        return "";
    }

    static boolean isEmpty(Name nameVal) {
        return nameVal.value.isEmpty();
    }

    static String emitValue(Object value, BType type) {
        if (value == null || 10 == type.tag) {
            return "0";
        }
        return value.toString();
    }

    static boolean isBinaryInstructionKind(InstructionKind insKind) {
        return switch (insKind) {
            case InstructionKind.ADD, InstructionKind.SUB, InstructionKind.MUL, InstructionKind.DIV, InstructionKind.MOD, InstructionKind.EQUAL, InstructionKind.NOT_EQUAL, InstructionKind.GREATER_THAN, InstructionKind.GREATER_EQUAL, InstructionKind.LESS_THAN, InstructionKind.LESS_EQUAL, InstructionKind.REF_EQUAL, InstructionKind.REF_NOT_EQUAL, InstructionKind.CLOSED_RANGE, InstructionKind.HALF_OPEN_RANGE, InstructionKind.ANNOT_ACCESS, InstructionKind.BITWISE_AND, InstructionKind.BITWISE_OR, InstructionKind.BITWISE_XOR, InstructionKind.BITWISE_LEFT_SHIFT, InstructionKind.BITWISE_RIGHT_SHIFT, InstructionKind.BITWISE_UNSIGNED_RIGHT_SHIFT, InstructionKind.AND, InstructionKind.OR -> true;
            default -> false;
        };
    }

    static boolean isUnaryInstructionKind(InstructionKind insKind) {
        return switch (insKind) {
            case InstructionKind.ADD, InstructionKind.SUB, InstructionKind.TYPEOF, InstructionKind.NOT, InstructionKind.NEGATE -> true;
            default -> false;
        };
    }
}

