/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.OCEDynamicEnvironmentData;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangDynamicArgExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExtendedXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownDocumentationLine;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLFilterStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLIndexedStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLMethodCallStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class ClassClosureDesugar
extends BLangNodeVisitor {
    private static final CompilerContext.Key<ClassClosureDesugar> CLASS_CLOSURE_DESUGAR_KEY = new CompilerContext.Key();
    private static final String BLOCK_MAP_SYM_NAME = "$map$block$oce$_";
    private static final String FUNCTION_MAP_SYM_NAME = "$map$func$oce$_";
    private static final String OBJECT_CTOR_MAP_SYM_NAME = "$map$objectCtor_";
    private static final String PARAMETER_MAP_NAME = "$paramMap$oce$_";
    private static final String OBJECT_CTOR_BLOCK_MAP_SYM_NAME = "$map$objectCtor_block";
    private static final String OBJECT_CTOR_FUNCTION_MAP_SYM_NAME = "$map$objectCtor_function";
    private static final BVarSymbol CLOSURE_MAP_NOT_FOUND = new BVarSymbol(0L, new Name("$not$found"), null, null, null, null, SymbolOrigin.VIRTUAL);
    private final int blockClosureMapCount = 1;
    private BLangClassDefinition classDef;
    private BLangNode result;
    private SymbolEnv env;
    private final SymbolTable symTable;
    private final Desugar desugar;
    private final Names names;
    private final BLangDiagnosticLog dlog;

    public static ClassClosureDesugar getInstance(CompilerContext context) {
        ClassClosureDesugar desugar = context.get(CLASS_CLOSURE_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new ClassClosureDesugar(context);
        }
        return desugar;
    }

    private ClassClosureDesugar(CompilerContext context) {
        context.put(CLASS_CLOSURE_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.desugar = Desugar.getInstance(context);
        this.names = Names.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        ClassClosureDesugar.CLOSURE_MAP_NOT_FOUND.pos = this.symTable.builtinPos;
    }

    private void reset() {
        this.classDef = null;
        this.env = null;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        this.result = pkgNode;
    }

    private void createClosureMapUpdateExpression(BLangClassDefinition classDef, BVarSymbol blockMap, BVarSymbol classMapSymbol) {
        OCEDynamicEnvironmentData oceEnvData = classDef.oceEnvData;
        BVarSymbol oceMap = oceEnvData.mapBlockMapSymbol;
        BLangFunction function = classDef.generatedInitFunction;
        BVarSymbol selfSymbol = function.receiver.symbol;
        BLangSimpleVarRef selfVarRef = ASTBuilderUtil.createVariableRef(function.pos, selfSymbol);
        BLangSimpleVarRef refToBlockClosureMap = ASTBuilderUtil.createVariableRef(function.pos, blockMap);
        BLangIdentifier identifierNode = ASTBuilderUtil.createIdentifier(function.pos, classMapSymbol.name.value);
        BLangFieldBasedAccess fieldAccess = ASTBuilderUtil.createFieldAccessExpr(selfVarRef, identifierNode);
        fieldAccess.symbol = oceMap;
        fieldAccess.setBType(classMapSymbol.type);
        fieldAccess.expectedType = classMapSymbol.type;
        fieldAccess.isStoreOnCreation = true;
        fieldAccess.isLValue = true;
        fieldAccess.fieldKind = FieldKind.SINGLE;
        fieldAccess.leafNode = true;
        BLangAssignment assignmentStmt = (BLangAssignment)TreeBuilder.createAssignmentNode();
        assignmentStmt.expr = refToBlockClosureMap;
        assignmentStmt.pos = function.pos;
        assignmentStmt.setVariable(fieldAccess);
        fieldAccess.parent = assignmentStmt;
        BLangFunction generatedInitFunction = classDef.generatedInitFunction;
        BLangBlockFunctionBody generatedInitFnBody = (BLangBlockFunctionBody)generatedInitFunction.body;
        generatedInitFnBody.stmts.add(0, assignmentStmt);
        assignmentStmt.parent = generatedInitFnBody;
        this.desugar.rewrite(assignmentStmt, oceEnvData.objMethodsEnv);
    }

    private void addMapSymbolAsAField(BLangClassDefinition classDef, BVarSymbol mapSymbol) {
        BLangSimpleVariable mapVar = ASTBuilderUtil.createVariable(this.symTable.builtinPos, mapSymbol.name.value, mapSymbol.type, null, mapSymbol);
        BObjectType object = (BObjectType)classDef.getBType();
        object.fields.put(mapSymbol.name.value, new BField(mapSymbol.name, classDef.pos, mapSymbol));
        classDef.fields.add(0, mapVar);
    }

    @Override
    public void visit(BLangResourceFunction resourceFunction) {
        this.visit((BLangFunction)resourceFunction);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.originalFuncSymbol.scope, this.env);
        funcNode.body = this.rewrite(funcNode.body, funcEnv);
        this.result = funcNode;
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv blockEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        this.rewriteStmts(body.stmts, blockEnv);
        if (body.mapSymbol != null) {
            body.stmts.add(0, this.getClosureMap(body.mapSymbol, blockEnv));
        }
        this.result = body;
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        this.result = body;
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        this.rewriteStmts(blockNode.stmts, blockEnv);
        if (blockNode.mapSymbol != null) {
            blockNode.stmts.add(0, this.getClosureMap(blockNode.mapSymbol, blockEnv));
        }
        this.result = blockNode;
    }

    private BLangSimpleVariableDef getClosureMap(BVarSymbol mapSymbol, SymbolEnv blockEnv) {
        BLangRecordLiteral emptyRecord = ASTBuilderUtil.createEmptyRecordLiteral(this.symTable.builtinPos, mapSymbol.type);
        BLangSimpleVariable mapVar = ASTBuilderUtil.createVariable(this.symTable.builtinPos, mapSymbol.name.value, mapSymbol.type, emptyRecord, mapSymbol);
        mapVar.typeNode = ASTBuilderUtil.createTypeNode(mapSymbol.type);
        BLangSimpleVariableDef mapVarDef = ASTBuilderUtil.createVariableDef(this.symTable.builtinPos, mapVar);
        return this.desugar.rewrite(mapVarDef, blockEnv);
    }

    @Override
    public void visit(BLangService serviceNode) {
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        if (!varDefNode.var.symbol.closure) {
            varDefNode.var = this.rewrite(varDefNode.var, this.env);
            this.result = varDefNode;
            return;
        }
        if (varDefNode.var.expr != null) {
            BLangAssignment stmt = this.createAssignmentToClosureMap(varDefNode);
            this.result = this.rewrite(stmt, this.env);
        } else {
            this.result = varDefNode;
        }
    }

    private BLangAssignment createAssignmentToClosureMap(BLangSimpleVariableDef varDefNode) {
        BVarSymbol mapSymbol = this.createMapSymbolIfAbsent(this.env.node, 1);
        BLangIndexBasedAccess accessExpr = ASTBuilderUtil.createIndexBasesAccessExpr(varDefNode.pos, varDefNode.getBType(), mapSymbol, ASTBuilderUtil.createLiteral(varDefNode.pos, this.symTable.stringType, varDefNode.var.name.value));
        accessExpr.setBType(((BMapType)mapSymbol.type).constraint);
        accessExpr.isLValue = true;
        return ASTBuilderUtil.createAssignmentStmt(varDefNode.pos, accessExpr, varDefNode.var.expr);
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangNode node, int closureMapCount) {
        NodeKind kind = node.getKind();
        return switch (kind) {
            case NodeKind.BLOCK_FUNCTION_BODY -> this.createMapSymbolIfAbsent((BLangBlockFunctionBody)node, closureMapCount);
            case NodeKind.BLOCK -> this.createMapSymbolIfAbsent((BLangBlockStmt)node, closureMapCount);
            case NodeKind.FUNCTION -> this.createMapSymbolIfAbsent((BLangFunction)node, closureMapCount);
            case NodeKind.RESOURCE_FUNC -> this.createMapSymbolIfAbsent((BLangResourceFunction)node, closureMapCount);
            case NodeKind.CLASS_DEFN -> this.createMapSymbolIfAbsent((BLangClassDefinition)node, closureMapCount);
            default -> null;
        };
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangBlockFunctionBody body, int closureMapCount) {
        if (body.mapSymbol == null) {
            body.mapSymbol = this.createMapSymbol(BLOCK_MAP_SYM_NAME + closureMapCount, this.env);
        }
        return body.mapSymbol;
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangBlockStmt blockStmt, int closureMapCount) {
        if (blockStmt.mapSymbol == null) {
            blockStmt.mapSymbol = this.createMapSymbol(BLOCK_MAP_SYM_NAME + closureMapCount, this.env);
        }
        return blockStmt.mapSymbol;
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangFunction function, int closureMapCount) {
        if (function.mapSymbol == null) {
            function.mapSymbol = this.createMapSymbol(FUNCTION_MAP_SYM_NAME + closureMapCount, this.env);
        }
        return function.mapSymbol;
    }

    private BVarSymbol createMapSymbolIfAbsent(BLangClassDefinition classDef, int closureMapCount) {
        if (classDef.oceEnvData.mapBlockMapSymbol == null) {
            classDef.oceEnvData.mapBlockMapSymbol = this.createMapSymbol(OBJECT_CTOR_MAP_SYM_NAME + closureMapCount, classDef.oceEnvData.capturedClosureEnv);
        }
        return classDef.oceEnvData.mapBlockMapSymbol;
    }

    @Override
    public void visit(BLangReturn returnNode) {
        if (returnNode.expr != null) {
            returnNode.expr = this.rewriteExpr(returnNode.expr);
        }
        this.result = returnNode;
    }

    @Override
    public void visit(BLangInvocation.BLangAttachedFunctionInvocation iExpr) {
        iExpr.expr = this.rewriteExpr(iExpr.expr);
        if (!iExpr.requiredArgs.isEmpty()) {
            iExpr.requiredArgs.set(0, iExpr.expr);
        }
        this.rewriteExprs(iExpr.requiredArgs);
        this.rewriteExprs(iExpr.restArgs);
        this.result = iExpr;
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        this.result = importPkgNode;
    }

    @Override
    public void visit(BLangTypeDefinition typeDef) {
        if (typeDef.typeNode.getKind() == NodeKind.OBJECT_TYPE || typeDef.typeNode.getKind() == NodeKind.RECORD_TYPE) {
            typeDef.typeNode = this.rewrite(typeDef.typeNode, this.env);
        }
        this.result = typeDef;
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        if (!classDefinition.isObjectContructorDecl) {
            this.result = classDefinition;
            return;
        }
        BLangClassDefinition preClass = this.classDef;
        SymbolEnv prevEnv = this.env;
        this.desugar(classDefinition);
        this.result = classDefinition;
        this.classDef = preClass;
        this.env = prevEnv;
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        this.result = objectTypeNode;
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        this.result = recordTypeNode;
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangTupleVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangRecordVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangErrorVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangTupleVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangRecordVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangErrorVariableDef varDefNode) {
        varDefNode.errorVariable = this.rewrite(varDefNode.errorVariable, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        assignNode.varRef = this.rewriteExpr(assignNode.varRef);
        assignNode.expr = this.rewriteExpr(assignNode.expr);
        this.result = assignNode;
    }

    @Override
    public void visit(BLangTupleDestructure tupleDestructure) {
        this.result = tupleDestructure;
    }

    @Override
    public void visit(BLangRecordDestructure recordDestructure) {
        this.result = recordDestructure;
    }

    @Override
    public void visit(BLangErrorDestructure errorDestructure) {
        this.result = errorDestructure;
    }

    @Override
    public void visit(BLangRetry retryNode) {
        retryNode.retryBody = this.rewrite(retryNode.retryBody, this.env);
        this.result = retryNode;
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        retryTransaction.transaction = this.rewrite(retryTransaction.transaction, this.env);
        this.result = retryTransaction;
    }

    @Override
    public void visit(BLangContinue nextNode) {
        this.result = nextNode;
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.result = breakNode;
    }

    @Override
    public void visit(BLangPanic panicNode) {
        panicNode.expr = this.rewriteExpr(panicNode.expr);
        this.result = panicNode;
    }

    @Override
    public void visit(BLangDo doNode) {
        doNode.body = this.rewrite(doNode.body, this.env);
        this.result = doNode;
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        xmlnsStmtNode.xmlnsDecl = this.rewrite(xmlnsStmtNode.xmlnsDecl, this.env);
        this.result = xmlnsStmtNode;
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        exprStmtNode.expr = this.rewriteExpr(exprStmtNode.expr);
        this.result = exprStmtNode;
    }

    @Override
    public void visit(BLangFail failNode) {
        if (failNode.exprStmt != null) {
            failNode.exprStmt = this.rewrite(failNode.exprStmt, this.env);
        }
        this.result = failNode;
    }

    @Override
    public void visit(BLangIf ifNode) {
        ifNode.expr = this.rewriteExpr(ifNode.expr);
        ifNode.body = this.rewrite(ifNode.body, this.env);
        ifNode.elseStmt = this.rewrite(ifNode.elseStmt, this.env);
        this.result = ifNode;
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.result = foreach;
    }

    @Override
    public void visit(BLangWhile whileNode) {
        whileNode.expr = this.rewriteExpr(whileNode.expr);
        whileNode.body = this.rewrite(whileNode.body, this.env);
        this.result = whileNode;
    }

    @Override
    public void visit(BLangLock lockNode) {
        lockNode.body = this.rewrite(lockNode.body, this.env);
        this.result = lockNode;
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockNode) {
        this.result = lockNode;
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockNode) {
        this.result = unLockNode;
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        transactionNode.transactionBody = this.rewrite(transactionNode.transactionBody, this.env);
        this.result = transactionNode;
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        rollbackNode.expr = this.rewriteExpr(rollbackNode.expr);
        this.result = rollbackNode;
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
        this.result = transactionalExpr;
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        this.result = commitExpr;
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.result = forkJoin;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        this.rewriteExprs(listConstructorExpr.exprs);
        this.result = listConstructorExpr;
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.rewriteExprs(tableConstructorExpr.recordLiteralList);
        this.result = tableConstructorExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
        this.rewriteExprs(jsonArrayLiteral.exprs);
        this.result = jsonArrayLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        this.rewriteExprs(tupleLiteral.exprs);
        this.result = tupleLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        this.rewriteExprs(arrayLiteral.exprs);
        this.result = arrayLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        recordLiteral.fields.forEach(field -> {
            BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
            keyValue.key.expr = this.rewriteExpr(keyValue.key.expr);
            keyValue.valueExpr = this.rewriteExpr(keyValue.valueExpr);
        });
        this.result = recordLiteral;
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        BVarSymbol symbol = (BVarSymbol)varRefExpr.symbol;
        if (symbol.closure && this.classDef.oceEnvData.isDirty) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.UNSUPPORTED_MULTILEVEL_CLOSURES, varRefExpr);
            varRefExpr.setBType(this.symTable.semanticError);
            this.result = null;
            return;
        }
        BVarSymbol mapSymbol = this.getVarMapSymbol(symbol);
        if (!symbol.closure || mapSymbol == null) {
            this.result = varRefExpr;
            return;
        }
        BLangSimpleVarRef.BLangLocalVarRef localVarRef = new BLangSimpleVarRef.BLangLocalVarRef(symbol);
        localVarRef.closureDesugared = true;
        localVarRef.desugared = true;
        localVarRef.setBType(varRefExpr.getBType());
        this.updateClosureVars(localVarRef, mapSymbol);
        this.classDef.oceEnvData.desugaredClosureVars.add(varRefExpr);
    }

    private BVarSymbol getVarMapSymbol(BVarSymbol symbol) {
        BVarSymbol mapSymbol = null;
        if (this.classDef.oceEnvData.closureFuncSymbols.contains(symbol)) {
            mapSymbol = this.classDef.oceEnvData.mapFunctionMapSymbol;
        } else if (this.classDef.oceEnvData.closureBlockSymbols.contains(symbol)) {
            mapSymbol = this.classDef.oceEnvData.mapBlockMapSymbol;
        }
        return mapSymbol;
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        fieldAccessExpr.expr = this.rewriteExpr(fieldAccessExpr.expr);
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.result = this.desugar.rewriteExpr(indexAccessExpr);
    }

    @Override
    public void visit(BLangInvocation iExpr) {
        iExpr.expr = this.rewriteExpr(iExpr.expr);
        this.rewriteExprs(iExpr.requiredArgs);
        this.rewriteExprs(iExpr.restArgs);
        this.result = iExpr;
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr) {
        this.rewriteExprs(errorConstructorExpr.positionalArgs);
        this.rewriteExpr(errorConstructorExpr.errorDetail);
        this.result = errorConstructorExpr;
    }

    @Override
    public void visit(BLangTypeInit typeInitExpr) {
        typeInitExpr.initInvocation = this.rewriteExpr(typeInitExpr.initInvocation);
        BLangNode parent = typeInitExpr.initInvocation.parent;
        if (parent != null && parent.getKind() == NodeKind.OBJECT_CTOR_EXPRESSION) {
            BLangObjectConstructorExpression oce = (BLangObjectConstructorExpression)parent;
            BLangClassDefinition dirtyOceClass = oce.classNode;
            if (dirtyOceClass.hasClosureVars && this.classDef.oceEnvData.closureDesugaringInProgress) {
                dirtyOceClass.hasClosureVars = false;
                OCEDynamicEnvironmentData dirtyOceEnvData = dirtyOceClass.oceEnvData;
                dirtyOceEnvData.isDirty = true;
                OCEDynamicEnvironmentData currentClassOceData = this.classDef.oceEnvData;
                currentClassOceData.closureBlockSymbols.removeAll(dirtyOceEnvData.closureBlockSymbols);
                currentClassOceData.closureFuncSymbols.removeAll(dirtyOceEnvData.closureFuncSymbols);
                dirtyOceEnvData.parents.remove(this.classDef);
                for (BLangSimpleVarRef simpleVarRef : dirtyOceEnvData.desugaredClosureVars) {
                    this.dlog.error(simpleVarRef.pos, DiagnosticErrorCode.UNSUPPORTED_MULTILEVEL_CLOSURES, simpleVarRef);
                }
                this.visit(dirtyOceClass);
            }
        }
        this.result = typeInitExpr;
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        ternaryExpr.expr = this.rewriteExpr(ternaryExpr.expr);
        ternaryExpr.thenExpr = this.rewriteExpr(ternaryExpr.thenExpr);
        ternaryExpr.elseExpr = this.rewriteExpr(ternaryExpr.elseExpr);
        this.result = ternaryExpr;
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        ArrayList<BLangExpression> exprList = new ArrayList<BLangExpression>();
        waitExpr.exprList.forEach(expression -> exprList.add(this.rewriteExpr(expression)));
        waitExpr.exprList = exprList;
        this.result = waitExpr;
    }

    @Override
    public void visit(BLangWaitForAllExpr waitExpr) {
        this.result = waitExpr;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        trapExpr.expr = this.rewriteExpr(trapExpr.expr);
        this.result = trapExpr;
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        binaryExpr.lhsExpr.parent = binaryExpr;
        binaryExpr.lhsExpr = this.rewriteExpr(binaryExpr.lhsExpr);
        binaryExpr.rhsExpr.parent = binaryExpr;
        binaryExpr.rhsExpr = this.rewriteExpr(binaryExpr.rhsExpr);
        this.result = binaryExpr;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.result = elvisExpr;
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        groupExpr.expression = this.rewriteExpr(groupExpr.expression);
        this.result = groupExpr;
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        unaryExpr.expr = this.rewriteExpr(unaryExpr.expr);
        this.result = unaryExpr;
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        if (conversionExpr.expr.impConversionExpr != null) {
            this.result = conversionExpr;
            return;
        }
        conversionExpr.expr = this.rewriteExpr(conversionExpr.expr);
        this.result = conversionExpr;
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        this.result = bLangLambdaFunction;
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        this.result = bLangArrowFunction;
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        this.result = xmlQName;
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        xmlAttribute.name = this.rewriteExpr(xmlAttribute.name);
        xmlAttribute.value = this.rewriteExpr(xmlAttribute.value);
        this.result = xmlAttribute;
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        xmlElementLiteral.startTagName = this.rewriteExpr(xmlElementLiteral.startTagName);
        xmlElementLiteral.endTagName = this.rewriteExpr(xmlElementLiteral.endTagName);
        this.rewriteExprs(xmlElementLiteral.modifiedChildren);
        this.rewriteExprs(xmlElementLiteral.attributes);
        this.result = xmlElementLiteral;
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        xmlTextLiteral.concatExpr = this.rewriteExpr(xmlTextLiteral.concatExpr);
        this.result = xmlTextLiteral;
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        xmlCommentLiteral.concatExpr = this.rewriteExpr(xmlCommentLiteral.concatExpr);
        this.result = xmlCommentLiteral;
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        xmlProcInsLiteral.target = this.rewriteExpr(xmlProcInsLiteral.target);
        xmlProcInsLiteral.dataFragments.forEach(this::rewriteExpr);
        this.result = xmlProcInsLiteral;
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.concatExpr = this.rewriteExpr(xmlQuotedString.concatExpr);
        this.result = xmlQuotedString;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        stringTemplateLiteral.exprs.forEach(this::rewriteExpr);
        this.result = stringTemplateLiteral;
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr) {
        asyncSendExpr.expr = this.rewriteExpr(asyncSendExpr.expr);
        this.result = asyncSendExpr;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        syncSendExpr.expr = this.rewriteExpr(syncSendExpr.expr);
        this.result = syncSendExpr;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.result = workerReceiveNode;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        this.result = workerFlushExpr;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef localVarRef) {
        if (!localVarRef.symbol.closure || localVarRef.closureDesugared) {
            this.result = localVarRef;
            return;
        }
        this.updateClosureVars(localVarRef, null);
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
        this.result = ignoreExpr;
    }

    @Override
    public void visit(BLangDynamicArgExpr dynamicParamExpr) {
        dynamicParamExpr.condition = this.rewriteExpr(dynamicParamExpr.condition);
        dynamicParamExpr.conditionalArgument = this.rewriteExpr(dynamicParamExpr.conditionalArgument);
        this.result = dynamicParamExpr;
    }

    private BVarSymbol createMapSymbol(String mapName, SymbolEnv symbolEnv) {
        return new BVarSymbol(0L, Names.fromString(mapName), symbolEnv.scope.owner.pkgID, this.symTable.mapAllType, symbolEnv.scope.owner, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
    }

    private void updateClosureVars(BLangSimpleVarRef varRefExpr, BVarSymbol mapSymbol) {
        BVarSymbol selfSymbol = this.classDef.generatedInitFunction.receiver.symbol;
        BLangSimpleVarRef.BLangLocalVarRef localSelfVarRef = new BLangSimpleVarRef.BLangLocalVarRef(selfSymbol);
        localSelfVarRef.setBType(this.classDef.getBType());
        localSelfVarRef.closureDesugared = true;
        BLangIndexBasedAccess.BLangStructFieldAccessExpr accessExprForClassField = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(varRefExpr.pos, localSelfVarRef, ASTBuilderUtil.createLiteral(varRefExpr.pos, this.symTable.stringType, mapSymbol.name), mapSymbol, false, true);
        accessExprForClassField.setBType(mapSymbol.type);
        BLangIndexBasedAccess.BLangMapAccessExpr closureMapAccessForField = new BLangIndexBasedAccess.BLangMapAccessExpr(varRefExpr.pos, accessExprForClassField, ASTBuilderUtil.createLiteral(varRefExpr.pos, this.symTable.stringType, varRefExpr.symbol.name));
        closureMapAccessForField.setBType(varRefExpr.getBType());
        BLangTypeConversionExpr castExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        castExpr.expr = closureMapAccessForField;
        castExpr.setBType(varRefExpr.getBType());
        castExpr.targetType = varRefExpr.getBType();
        this.result = this.desugar.rewriteExpr(castExpr);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
        this.result = fieldVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef packageVarRef) {
        this.result = packageVarRef;
    }

    @Override
    public void visit(BLangConstRef constRef) {
        this.result = constRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef functionVarRef) {
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr fieldAccessExpr) {
        fieldAccessExpr.indexExpr = this.rewriteExpr(fieldAccessExpr.indexExpr);
        fieldAccessExpr.expr = this.rewriteExpr(fieldAccessExpr.expr);
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef functionVarRef) {
        functionVarRef.expr = this.rewriteExpr(functionVarRef.expr);
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapKeyAccessExpr) {
        mapKeyAccessExpr.indexExpr = this.rewriteExpr(mapKeyAccessExpr.indexExpr);
        mapKeyAccessExpr.expr = this.rewriteExpr(mapKeyAccessExpr.expr);
        this.result = mapKeyAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTableAccessExpr tableKeyAccessExpr) {
        tableKeyAccessExpr.indexExpr = this.rewriteExpr(tableKeyAccessExpr.indexExpr);
        tableKeyAccessExpr.expr = this.rewriteExpr(tableKeyAccessExpr.expr);
        this.result = tableKeyAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayIndexAccessExpr) {
        arrayIndexAccessExpr.indexExpr = this.rewriteExpr(arrayIndexAccessExpr.indexExpr);
        arrayIndexAccessExpr.expr = this.rewriteExpr(arrayIndexAccessExpr.expr);
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr arrayIndexAccessExpr) {
        arrayIndexAccessExpr.indexExpr = this.rewriteExpr(arrayIndexAccessExpr.indexExpr);
        arrayIndexAccessExpr.expr = this.rewriteExpr(arrayIndexAccessExpr.expr);
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlIndexAccessExpr) {
        xmlIndexAccessExpr.indexExpr = this.rewriteExpr(xmlIndexAccessExpr.indexExpr);
        xmlIndexAccessExpr.expr = this.rewriteExpr(xmlIndexAccessExpr.expr);
        this.result = xmlIndexAccessExpr;
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        xmlElementAccess.expr = this.rewriteExpr(xmlElementAccess.expr);
        this.result = xmlElementAccess;
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        xmlNavigation.expr = this.rewriteExpr(xmlNavigation.expr);
        this.result = xmlNavigation;
    }

    @Override
    public void visit(BLangExtendedXMLNavigationAccess extendedXMLNavigationAccess) {
        extendedXMLNavigationAccess.stepExpr = this.rewriteExpr(extendedXMLNavigationAccess.stepExpr);
        this.rewriteExprs(extendedXMLNavigationAccess.extensions);
        this.result = extendedXMLNavigationAccess;
    }

    @Override
    public void visit(BLangXMLIndexedStepExtend xmlIndexedStepExtend) {
        xmlIndexedStepExtend.indexExpr = this.rewriteExpr(xmlIndexedStepExtend.indexExpr);
        this.result = xmlIndexedStepExtend;
    }

    @Override
    public void visit(BLangXMLMethodCallStepExtend xmlMethodCallStepExtend) {
        xmlMethodCallStepExtend.invocation = this.rewriteExpr(xmlMethodCallStepExtend.invocation);
        this.result = xmlMethodCallStepExtend;
    }

    @Override
    public void visit(BLangXMLFilterStepExtend xmlFilterStepExtend) {
        this.result = xmlFilterStepExtend;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangJSONAccessExpr jsonAccessExpr) {
        jsonAccessExpr.indexExpr = this.rewriteExpr(jsonAccessExpr.indexExpr);
        jsonAccessExpr.expr = this.rewriteExpr(jsonAccessExpr.expr);
        this.result = jsonAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
        stringAccessExpr.indexExpr = this.rewriteExpr(stringAccessExpr.indexExpr);
        stringAccessExpr.expr = this.rewriteExpr(stringAccessExpr.expr);
        this.result = stringAccessExpr;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
        for (RecordLiteralNode.RecordField field : mapLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                keyValueField.key.expr = this.rewriteExpr(keyValueField.key.expr);
                keyValueField.valueExpr = this.rewriteExpr(keyValueField.valueExpr);
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            spreadField.expr = this.rewriteExpr(spreadField.expr);
        }
        this.result = mapLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
        this.result = structLiteral;
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        waitLiteral.keyValuePairs.forEach(keyValue -> {
            if (keyValue.valueExpr != null) {
                keyValue.valueExpr = this.rewriteExpr(keyValue.valueExpr);
            } else {
                keyValue.keyExpr = this.rewriteExpr(keyValue.keyExpr);
            }
        });
        this.result = waitLiteral;
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        assignableExpr.lhsExpr = this.rewriteExpr(assignableExpr.lhsExpr);
        this.result = assignableExpr;
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation fpInvocation) {
        fpInvocation.expr = this.rewriteExpr(fpInvocation.expr);
        this.rewriteExprs(fpInvocation.requiredArgs);
        this.rewriteExprs(fpInvocation.restArgs);
        this.result = fpInvocation;
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        this.result = accessExpr;
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.result = this.rewriteExpr(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        bLangNamedArgsExpression.expr = this.rewriteExpr(bLangNamedArgsExpression.expr);
        this.result = bLangNamedArgsExpression.expr;
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.result = checkedExpr;
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.result = serviceConstructorExpr;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        typeTestExpr.expr = this.rewriteExpr(typeTestExpr.expr);
        this.result = typeTestExpr;
    }

    @Override
    public void visit(BLangIsLikeExpr isLikeExpr) {
        isLikeExpr.expr = this.rewriteExpr(isLikeExpr.expr);
        this.result = isLikeExpr;
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        annotAccessExpr.expr = this.rewriteExpr(annotAccessExpr.expr);
        this.result = annotAccessExpr;
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        if (bLangStatementExpression.stmt.getKind() == NodeKind.BLOCK) {
            BLangBlockStmt bLangBlockStmt = (BLangBlockStmt)bLangStatementExpression.stmt;
            for (int i = 0; i < bLangBlockStmt.stmts.size(); ++i) {
                BLangStatement stmt = bLangBlockStmt.stmts.remove(i);
                bLangBlockStmt.stmts.add(i, this.rewrite(stmt, this.env));
            }
        } else {
            bLangStatementExpression.stmt = this.rewrite(bLangStatementExpression.stmt, this.env);
        }
        bLangStatementExpression.expr = this.rewriteExpr(bLangStatementExpression.expr);
        this.result = bLangStatementExpression;
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation aIExpr) {
        aIExpr.expr = this.rewriteExpr(aIExpr.expr);
        this.rewriteExprs(aIExpr.requiredArgs);
        this.rewriteExprs(aIExpr.restArgs);
        this.result = aIExpr;
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
    }

    @Override
    public void visit(BLangConstant constant) {
        this.result = constant;
    }

    @Override
    public void visit(BLangNumericLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangTypeLoad typeLoad) {
        this.result = typeLoad;
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangXMLSequenceLiteral xmlSequenceLiteral) {
        xmlSequenceLiteral.xmlItems.forEach(this::rewriteExpr);
        this.result = xmlSequenceLiteral;
    }

    @Override
    public void visit(BLangMarkdownDocumentationLine bLangMarkdownDocumentationLine) {
    }

    @Override
    public void visit(BLangMarkdownParameterDocumentation bLangDocumentationParameter) {
    }

    @Override
    public void visit(BLangMarkdownReturnParameterDocumentation bLangMarkdownReturnParameterDocumentation) {
    }

    @Override
    public void visit(BLangMarkdownDocumentation bLangMarkdownDocumentation) {
    }

    private <E extends BLangNode> E rewrite(E node, SymbolEnv env) {
        if (node == null) {
            return null;
        }
        SymbolEnv previousEnv = this.env;
        this.env = env;
        node.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        this.env = previousEnv;
        return (E)resultNode;
    }

    private <E extends BLangExpression> E rewriteExpr(E node) {
        if (node == null) {
            return null;
        }
        Object expr = node;
        if (node.impConversionExpr != null) {
            expr = node.impConversionExpr;
            node.impConversionExpr = null;
        }
        expr.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        return (E)((BLangExpression)resultNode);
    }

    private <E extends BLangStatement> void rewriteStmts(List<E> nodeList, SymbolEnv env) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewrite((BLangStatement)nodeList.get(i), env));
        }
    }

    private <E extends BLangExpression> void rewriteExprs(List<E> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewriteExpr((BLangExpression)nodeList.get(i)));
        }
    }

    public void desugar(BLangClassDefinition classDef) {
        this.classDef = classDef;
        if (!classDef.hasClosureVars) {
            if (classDef.oceEnvData.isDirty) {
                this.updateFields(classDef);
            }
            return;
        }
        this.createMapSymbolsIfAbsent(classDef);
        this.addFunctionLevelClosureMapToClassDefinition(classDef);
        this.addBlockLevelClosureMapToClassDefinition(classDef);
        this.updateFields(classDef);
        this.reset();
    }

    private void updateFields(BLangClassDefinition classDef) {
        classDef.oceEnvData.closureDesugaringInProgress = true;
        for (BLangSimpleVariable field : classDef.fields) {
            if (!field.symbol.isDefaultable) continue;
            if (field.expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangSimpleVarRef varRef = (BLangSimpleVarRef)field.expr;
                if (!classDef.oceEnvData.isDirty || !varRef.symbol.closure) continue;
                this.dlog.error(varRef.pos, DiagnosticErrorCode.UNSUPPORTED_MULTILEVEL_CLOSURES, varRef);
                continue;
            }
            field.expr = this.rewrite(field.expr, this.env);
        }
        classDef.oceEnvData.closureDesugaringInProgress = false;
    }

    private BLangNode getNextPossibleNode(SymbolEnv envArg) {
        NodeKind kind;
        SymbolEnv localEnv = envArg;
        BLangNode node = localEnv.node;
        while ((kind = node.getKind()) != NodeKind.PACKAGE && kind != NodeKind.CLASS_DEFN && kind != NodeKind.BLOCK_FUNCTION_BODY && kind != NodeKind.BLOCK && kind != NodeKind.FUNCTION && kind != NodeKind.RESOURCE_FUNC) {
            localEnv = localEnv.enclEnv;
            node = localEnv.node;
        }
        return node;
    }

    private void addBlockLevelClosureMapToClassDefinition(BLangClassDefinition classDef) {
        SymbolEnv env;
        OCEDynamicEnvironmentData oceData = classDef.oceEnvData;
        if (oceData.blockMapUpdatedInInitMethod || oceData.mapBlockMapSymbol == null) {
            return;
        }
        this.env = env = oceData.capturedClosureEnv;
        BLangNode node = this.getNextPossibleNode(env.enclEnv);
        if (node == null) {
            return;
        }
        if (oceData.closureBlockSymbols.isEmpty()) {
            return;
        }
        if (node.getKind() == NodeKind.FUNCTION) {
            BLangFunction function = (BLangFunction)node;
            node = function.body;
        }
        BVarSymbol blockMap = this.createMapSymbolIfAbsent(node, oceData.closureBlockSymbols.size());
        BVarSymbol mapSymbol = oceData.mapBlockMapSymbol;
        this.addMapSymbolAsAField(classDef, mapSymbol);
        this.createClosureMapUpdateExpression(classDef, blockMap, mapSymbol);
        oceData.blockMapUpdatedInInitMethod = true;
    }

    private void addFunctionLevelClosureMapToClassDefinition(BLangClassDefinition classDef) {
        SymbolEnv env;
        OCEDynamicEnvironmentData oceData = classDef.oceEnvData;
        if (oceData.functionMapUpdatedInInitMethod || oceData.mapFunctionMapSymbol == null) {
            return;
        }
        this.env = env = oceData.capturedClosureEnv;
        if (env.enclEnv.node == null) {
            return;
        }
        if (oceData.closureFuncSymbols.isEmpty()) {
            return;
        }
        BLangFunction function = (BLangFunction)oceData.capturedClosureEnv.enclInvokable;
        BVarSymbol functionMap = this.createMapSymbolIfAbsent(function, oceData.closureFuncSymbols.size());
        BVarSymbol mapSymbol = oceData.mapFunctionMapSymbol;
        this.addMapSymbolAsAField(classDef, mapSymbol);
        this.createClosureMapUpdateExpression(classDef, functionMap, mapSymbol);
        oceData.functionMapUpdatedInInitMethod = true;
    }

    private void createMapSymbolsIfAbsent(BLangClassDefinition classDef) {
        OCEDynamicEnvironmentData oceData = classDef.oceEnvData;
        if (!oceData.closureBlockSymbols.isEmpty() && classDef.oceEnvData.mapBlockMapSymbol == null) {
            classDef.oceEnvData.mapBlockMapSymbol = this.createMapSymbol(OBJECT_CTOR_BLOCK_MAP_SYM_NAME, classDef.oceEnvData.capturedClosureEnv);
        }
        if (!oceData.closureFuncSymbols.isEmpty() && classDef.oceEnvData.mapFunctionMapSymbol == null) {
            classDef.oceEnvData.mapFunctionMapSymbol = this.createMapSymbol(OBJECT_CTOR_FUNCTION_MAP_SYM_NAME, classDef.oceEnvData.capturedClosureEnv);
        }
    }
}

