/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.identifier.Utils;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.AnnotationDesugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.SchedulerPolicy;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTableKeyTypeConstraint;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCollectContextInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangDynamicArgExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExtendedXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInferredTypedescDefaultNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownDocumentationLine;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLFilterStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLIndexedStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLMethodCallStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.ClosureVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class ClosureGenerator
extends BLangNodeVisitor {
    private static final CompilerContext.Key<ClosureGenerator> CLOSURE_GENERATOR_KEY = new CompilerContext.Key();
    private Queue<BLangSimpleVariableDef> queue;
    private Queue<BLangSimpleVariableDef> annotationClosureReferences;
    private final SymbolTable symTable;
    private SymbolEnv env;
    private BLangNode result;
    private final SymbolResolver symResolver;
    private final AnnotationDesugar annotationDesugar;
    private final Types types;

    public static ClosureGenerator getInstance(CompilerContext context) {
        ClosureGenerator closureGenerator = context.get(CLOSURE_GENERATOR_KEY);
        if (closureGenerator == null) {
            closureGenerator = new ClosureGenerator(context);
        }
        return closureGenerator;
    }

    private ClosureGenerator(CompilerContext context) {
        context.put(CLOSURE_GENERATOR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.queue = new LinkedList<BLangSimpleVariableDef>();
        this.annotationClosureReferences = new LinkedList<BLangSimpleVariableDef>();
        this.types = Types.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.annotationDesugar = AnnotationDesugar.getInstance(context);
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        BLangFunction bLangFunction;
        int i;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        for (i = 0; i < pkgNode.functions.size(); ++i) {
            bLangFunction = pkgNode.functions.get(i);
            if (bLangFunction.flagSet.contains((Object)Flag.LAMBDA)) continue;
            SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(bLangFunction, bLangFunction.symbol.scope, pkgEnv);
            this.rewriteParamsAndReturnTypeOfFunction(bLangFunction, funcEnv);
        }
        pkgNode.services.forEach(service -> this.rewrite(service, pkgEnv));
        pkgNode.typeDefinitions.forEach(typeDefinition -> this.rewrite(typeDefinition, pkgEnv));
        pkgNode.xmlnsList.forEach(xmlns -> this.rewrite(xmlns, pkgEnv));
        pkgNode.constants.forEach(constant -> this.rewrite(constant, pkgEnv));
        pkgNode.annotations.forEach(annotation -> this.rewrite(annotation, pkgEnv));
        pkgNode.initFunction = this.rewrite(pkgNode.initFunction, pkgEnv);
        pkgNode.classDefinitions = this.rewrite(pkgNode.classDefinitions, pkgEnv);
        this.rewrite(pkgNode.globalVars, pkgEnv);
        this.addClosuresToGlobalVariableList(pkgEnv);
        for (i = 0; i < pkgNode.functions.size(); ++i) {
            bLangFunction = pkgNode.functions.get(i);
            if (bLangFunction.flagSet.contains((Object)Flag.LAMBDA)) continue;
            this.rewrite(bLangFunction, pkgEnv);
        }
        this.result = pkgNode;
    }

    private void addClosuresToGlobalVariableList(SymbolEnv pkgEnv) {
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            BLangSimpleVariable simpleVariable = this.queue.poll().var;
            simpleVariable.flagSet.add(Flag.PUBLIC);
            simpleVariable.symbol.flags |= 1L;
            pkgEnv.enclPkg.globalVars.add(0, simpleVariable);
        }
        for (BLangSimpleVariableDef closureReference : this.annotationClosureReferences) {
            pkgEnv.enclPkg.globalVars.add(this.rewrite(closureReference.var, pkgEnv));
        }
    }

    @Override
    public void visit(BLangFunction funcNode) {
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, funcNode.symbol.scope, this.env);
        if (funcNode.flagSet.contains((Object)Flag.LAMBDA)) {
            this.rewriteParamsAndReturnTypeOfFunction(funcNode, funcEnv);
        }
        funcNode.body = this.rewrite(funcNode.body, funcEnv);
        this.result = funcNode;
    }

    public void rewriteParamsAndReturnTypeOfFunction(BLangFunction funcNode, SymbolEnv funcEnv) {
        for (BLangSimpleVariable bLangSimpleVariable : funcNode.requiredParams) {
            this.rewrite(bLangSimpleVariable, funcEnv);
        }
        if (funcNode.restParam != null) {
            funcNode.restParam = this.rewrite(funcNode.restParam, funcEnv);
        }
        if (funcNode.returnTypeNode != null && funcNode.returnTypeNode.getKind() != null) {
            funcNode.returnTypeNode = this.rewrite(funcNode.returnTypeNode, funcEnv);
        }
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv blockEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        body.stmts = this.rewriteStmt(body.stmts, blockEnv);
        this.result = body;
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        this.rewriteExprs(rawTemplateLiteral.strings);
        this.rewriteExprs(rawTemplateLiteral.insertions);
        this.result = rawTemplateLiteral;
    }

    @Override
    public void visit(BLangExprFunctionBody exprBody) {
        exprBody.expr = this.rewriteExpr(exprBody.expr);
        this.result = exprBody;
    }

    @Override
    public void visit(BLangResourceFunction resourceFunction) {
        this.visit((BLangFunction)resourceFunction);
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        this.result = body;
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        blockNode.stmts = this.rewriteStmt(blockNode.stmts, blockEnv);
        this.result = blockNode;
    }

    @Override
    public void visit(BLangService serviceNode) {
        this.result = serviceNode;
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangReturn returnNode) {
        if (returnNode.expr != null) {
            returnNode.expr = this.rewriteExpr(returnNode.expr);
        }
        this.result = returnNode;
    }

    @Override
    public void visit(BLangTypeDefinition typeDef) {
        typeDef.typeNode = this.rewrite(typeDef.typeNode, this.env);
        this.result = typeDef;
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        ArrayList<BLangType> rewrittenConstituents = new ArrayList<BLangType>();
        for (BLangType constituentTypeNode : intersectionTypeNode.constituentTypeNodes) {
            rewrittenConstituents.add(this.rewrite(constituentTypeNode, this.env));
        }
        intersectionTypeNode.constituentTypeNodes = rewrittenConstituents;
        this.result = intersectionTypeNode;
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        SymbolEnv classEnv = SymbolEnv.createClassEnv(classDefinition, classDefinition.symbol.scope, this.env);
        for (BLangSimpleVariable bLangSimpleVariable : classDefinition.fields) {
            bLangSimpleVariable.typeNode = this.rewrite(bLangSimpleVariable.typeNode, classEnv);
            bLangSimpleVariable.expr = this.rewrite(bLangSimpleVariable.expr, classEnv);
        }
        this.result = classDefinition;
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        for (BLangSimpleVariable field : objectTypeNode.fields) {
            this.rewrite(field, this.env);
        }
        this.result = objectTypeNode;
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectConstructorExpression) {
        objectConstructorExpression.typeInit = this.rewriteExpr(objectConstructorExpression.typeInit);
        this.result = objectConstructorExpression;
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        BTypeSymbol typeSymbol = recordTypeNode.getBType().tsymbol;
        BSymbol owner = typeSymbol.owner;
        this.desugarFieldAnnotations(owner, typeSymbol, recordTypeNode.fields, recordTypeNode.pos);
        for (BLangSimpleVariable field : recordTypeNode.fields) {
            this.rewrite(field, recordTypeNode.typeDefEnv);
        }
        recordTypeNode.restFieldType = this.rewrite(recordTypeNode.restFieldType, this.env);
        this.generateClosuresForNonOverriddenFields(recordTypeNode);
        this.result = recordTypeNode;
    }

    private void generateClosuresForNonOverriddenFields(BLangRecordTypeNode recordTypeNode) {
        if (recordTypeNode.typeRefs.isEmpty()) {
            return;
        }
        List<String> fieldNames = this.getFieldNames(recordTypeNode.fields);
        BTypeSymbol typeSymbol = recordTypeNode.getBType().tsymbol;
        String typeName = recordTypeNode.symbol.name.value;
        for (BLangType type : recordTypeNode.typeRefs) {
            BType bType = type.getBType();
            BRecordType recordType = (BRecordType)Types.getReferredType(bType);
            Map<String, BInvokableSymbol> defaultValuesOfTypeRef = ((BRecordTypeSymbol)recordType.tsymbol).defaultValues;
            for (Map.Entry<String, BInvokableSymbol> defaultValue : defaultValuesOfTypeRef.entrySet()) {
                String name = defaultValue.getKey();
                if (fieldNames.contains(name)) continue;
                BInvokableSymbol symbol = defaultValue.getValue();
                BLangInvocation invocation = this.getInvocation(symbol);
                String closureName = "$rec$" + typeName + "$rec$" + name;
                this.generateClosureForDefaultValues(closureName, name, invocation, symbol.retType, typeSymbol);
            }
        }
    }

    private List<String> getFieldNames(List<BLangSimpleVariable> fields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (BLangSimpleVariable field : fields) {
            fieldNames.add(field.name.getValue());
        }
        return fieldNames;
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        BTypeSymbol typeSymbol = tupleTypeNode.getBType().tsymbol;
        BSymbol owner = typeSymbol.owner;
        this.desugarFieldAnnotations(owner, typeSymbol, tupleTypeNode.members, tupleTypeNode.pos);
        ArrayList<BLangSimpleVariable> rewrittenMembers = new ArrayList<BLangSimpleVariable>();
        tupleTypeNode.members.forEach(member -> rewrittenMembers.add(this.rewrite(member, this.env)));
        tupleTypeNode.members = rewrittenMembers;
        tupleTypeNode.restParamType = this.rewrite(tupleTypeNode.restParamType, this.env);
        this.result = tupleTypeNode;
    }

    private void desugarFieldAnnotations(BSymbol owner, BTypeSymbol typeSymbol, List<BLangSimpleVariable> fields, Location pos) {
        if (owner.getKind() == SymbolKind.PACKAGE && typeSymbol.name != Names.EMPTY) {
            return;
        }
        owner = this.getOwner(this.env);
        BLangLambdaFunction lambdaFunction = this.annotationDesugar.defineFieldAnnotations(fields, pos, this.env.enclPkg, this.env, typeSymbol.pkgID, owner);
        if (lambdaFunction != null) {
            boolean isPackageLevelAnnotationClosure = owner.getKind() == SymbolKind.PACKAGE;
            BInvokableSymbol invokableSymbol = this.createSimpleVariable(lambdaFunction.function, lambdaFunction, isPackageLevelAnnotationClosure);
            typeSymbol.annotations = this.createSimpleVariable(invokableSymbol, isPackageLevelAnnotationClosure);
        }
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        finiteTypeNode.valueSpace.forEach(param -> this.rewrite(param, this.env));
        this.result = finiteTypeNode;
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        arrayType.elemtype = this.rewrite(arrayType.elemtype, this.env);
        this.result = arrayType;
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
        this.result = userDefinedType;
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        ArrayList<BLangType> rewrittenMembers = new ArrayList<BLangType>();
        unionTypeNode.memberTypeNodes.forEach(typeNode -> rewrittenMembers.add(this.rewrite(typeNode, this.env)));
        unionTypeNode.memberTypeNodes = rewrittenMembers;
        this.result = unionTypeNode;
    }

    @Override
    public void visit(BLangValueType valueType) {
        this.result = valueType;
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefTypeNode) {
        this.result = builtInRefTypeNode;
    }

    @Override
    public void visit(BLangStreamType streamType) {
        streamType.constraint = this.rewrite(streamType.constraint, this.env);
        streamType.error = this.rewrite(streamType.error, this.env);
        this.result = streamType;
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        constrainedType.constraint = this.rewrite(constrainedType.constraint, this.env);
        this.result = constrainedType;
    }

    @Override
    public void visit(BLangErrorType errorType) {
        errorType.detailType = this.rewrite(errorType.detailType, this.env);
        this.result = errorType;
    }

    @Override
    public void visit(BLangTableTypeNode tableTypeNode) {
        tableTypeNode.constraint = this.rewrite(tableTypeNode.constraint, this.env);
        tableTypeNode.tableKeyTypeConstraint = this.rewrite(tableTypeNode.tableKeyTypeConstraint, this.env);
        this.result = tableTypeNode;
    }

    @Override
    public void visit(BLangInvocation.BLangResourceAccessInvocation resourceAccessInvocation) {
        this.result = resourceAccessInvocation;
    }

    @Override
    public void visit(BLangTableKeyTypeConstraint keyTypeConstraint) {
        keyTypeConstraint.keyType = this.rewrite(keyTypeConstraint.keyType, this.env);
        this.result = keyTypeConstraint;
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        SymbolEnv funcEnv = SymbolEnv.createTypeEnv(functionTypeNode, functionTypeNode.getBType().tsymbol.scope, this.env);
        for (BLangSimpleVariable param : functionTypeNode.params) {
            this.rewrite(param, funcEnv);
        }
        if (functionTypeNode.restParam != null) {
            functionTypeNode.restParam.typeNode = this.rewrite(functionTypeNode.restParam.typeNode, this.env);
        }
        if (functionTypeNode.returnTypeNode != null) {
            functionTypeNode.returnTypeNode = this.rewrite(functionTypeNode.returnTypeNode, this.env);
        }
        this.result = functionTypeNode;
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        if (varNode.typeNode != null && varNode.typeNode.getKind() != null) {
            varNode.typeNode = this.rewrite(varNode.typeNode, this.env);
        }
        if (Symbols.isFlagOn(varNode.symbol.flags, 0x4000000000L) && varNode.symbol.isDefaultable) {
            String closureName = this.generateName(varNode.symbol.name.value, this.env.node);
            varNode.pos = null;
            varNode.expr.pos = null;
            this.generateClosureForDefaultValues(closureName, varNode.name.value, varNode);
            this.result = varNode;
            return;
        }
        if (Symbols.isFlagOn(varNode.symbol.flags, 0x1000000000L)) {
            String closureName = this.generateName(varNode.symbol.name.value, this.env.node);
            this.generateClosureForDefaultValues(closureName, varNode.name.value, varNode);
        } else {
            this.rewriteExpr(varNode.expr);
        }
        this.result = varNode;
    }

    private BSymbol getOwner(SymbolEnv symbolEnv) {
        while (symbolEnv.node.getKind() != NodeKind.PACKAGE) {
            NodeKind kind = symbolEnv.node.getKind();
            if (kind != NodeKind.BLOCK_FUNCTION_BODY && kind != NodeKind.BLOCK) {
                symbolEnv = symbolEnv.enclEnv;
                continue;
            }
            return symbolEnv.enclInvokable.symbol;
        }
        return symbolEnv.enclPkg.symbol;
    }

    private void generateClosureForDefaultValues(String closureName, String paramName, BLangSimpleVariable varNode) {
        this.generateClosureForDefaultValues(closureName, paramName, varNode.expr, varNode.getBType(), this.env.node.getBType().tsymbol);
    }

    private void generateClosureForDefaultValues(String closureName, String paramName, BLangExpression expr, BType returnType, BTypeSymbol symbol) {
        BSymbol owner = this.getOwner(this.env);
        BLangFunction function = this.createFunction(closureName, expr.pos, owner.pkgID, owner, returnType);
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(function.pos, (BLangBlockFunctionBody)function.body);
        returnStmt.expr = this.types.addConversionExprIfRequired(expr, function.returnTypeNode.getBType());
        BLangLambdaFunction lambdaFunction = this.createLambdaFunction(function);
        BInvokableSymbol varSymbol = this.createSimpleVariable(function, lambdaFunction, false);
        if (symbol.getKind() == SymbolKind.INVOKABLE_TYPE) {
            BInvokableTypeSymbol invokableTypeSymbol = (BInvokableTypeSymbol)symbol;
            this.updateFunctionParams(function, invokableTypeSymbol.params, paramName);
            invokableTypeSymbol.defaultValues.put(Utils.unescapeBallerina((String)paramName), varSymbol);
        } else {
            ((BRecordTypeSymbol)symbol).defaultValues.put(Utils.unescapeBallerina((String)paramName), varSymbol);
            lambdaFunction.function.flagSet.add(Flag.RECORD);
        }
        this.env.enclPkg.symbol.scope.define(function.symbol.name, function.symbol);
        this.env.enclPkg.functions.add(function);
        this.env.enclPkg.topLevelNodes.add(function);
        this.rewrite(lambdaFunction, this.env);
    }

    private void updateFunctionParams(BLangFunction funcNode, List<BVarSymbol> params, String paramName) {
        BInvokableSymbol funcSymbol = funcNode.symbol;
        Location pos = funcSymbol.pos;
        for (BVarSymbol symbol : params) {
            Name symbolName = symbol.name;
            if (paramName.equals(symbolName.value)) break;
            BType type = symbol.type;
            BVarSymbol varSymbol = new BVarSymbol(0x800000000L, symbolName, symbol.pkgID, type, funcSymbol, pos, SymbolOrigin.VIRTUAL);
            funcSymbol.scope.define(symbolName, varSymbol);
            funcSymbol.params.add(varSymbol);
            BInvokableType funcType = (BInvokableType)funcSymbol.type;
            funcType.addParamType(varSymbol.type);
            funcNode.requiredParams.add(ASTBuilderUtil.createVariable(pos, symbolName.value, type, null, varSymbol));
        }
    }

    BLangLambdaFunction createLambdaFunction(BLangFunction function) {
        BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)TreeBuilder.createLambdaFunctionNode();
        lambdaFunction.function = function;
        lambdaFunction.setBType(function.getBType());
        lambdaFunction.pos = function.pos;
        return lambdaFunction;
    }

    public BInvokableSymbol createSimpleVariable(BLangFunction function, BLangLambdaFunction lambdaFunction, boolean isAnnotationClosure) {
        BInvokableSymbol invokableSymbol = function.symbol;
        BType type = function.getBType();
        Location pos = function.pos;
        Name name = invokableSymbol.name;
        BInvokableSymbol varSymbol = new BInvokableSymbol(52L, 0L, name, invokableSymbol.pkgID, type, invokableSymbol.owner, pos, SymbolOrigin.VIRTUAL);
        varSymbol.params = invokableSymbol.params;
        varSymbol.restParam = invokableSymbol.restParam;
        varSymbol.retType = invokableSymbol.retType;
        BLangSimpleVariableDef variableDef = this.createSimpleVariableDef(pos, name.value, type, lambdaFunction, varSymbol);
        this.addToQueue(variableDef, isAnnotationClosure);
        return varSymbol;
    }

    private BVarSymbol createSimpleVariable(BInvokableSymbol invokableSymbol, boolean isAnnotationClosure) {
        BType type = invokableSymbol.retType;
        Location pos = invokableSymbol.pos;
        Name name = invokableSymbol.name;
        BVarSymbol varSymbol = new BVarSymbol(0L, name, invokableSymbol.originalName, invokableSymbol.pkgID, type, invokableSymbol.owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariableDef variableDef = this.createSimpleVariableDef(pos, name.value, type, this.getInvocation(invokableSymbol), varSymbol);
        this.addToQueue(variableDef, isAnnotationClosure);
        return varSymbol;
    }

    private BLangSimpleVariableDef createSimpleVariableDef(Location pos, String name, BType type, BLangExpression expr, BVarSymbol varSymbol) {
        BLangSimpleVariable simpleVariable = ASTBuilderUtil.createVariable(pos, name, type, expr, varSymbol);
        BLangSimpleVariableDef variableDef = ASTBuilderUtil.createVariableDef(pos);
        variableDef.var = simpleVariable;
        variableDef.setBType(type);
        return variableDef;
    }

    private void addToQueue(BLangSimpleVariableDef variableDef, boolean isAnnotationClosure) {
        if (isAnnotationClosure) {
            this.annotationClosureReferences.add(variableDef);
            return;
        }
        this.queue.add(variableDef);
    }

    private BLangInvocation getInvocation(BInvokableSymbol symbol) {
        BLangInvocation funcInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        funcInvocation.setBType(symbol.retType);
        funcInvocation.symbol = symbol;
        funcInvocation.name = ASTBuilderUtil.createIdentifier(symbol.pos, symbol.name.value);
        funcInvocation.functionPointerInvocation = true;
        return funcInvocation;
    }

    private BLangFunction createFunction(String funcName, Location pos, PackageID pkgID, BSymbol owner, BType bType) {
        BLangFunction function = ASTBuilderUtil.createFunction(pos, funcName);
        function.flagSet.add(Flag.PUBLIC);
        BInvokableTypeSymbol invokableTypeSymbol = Symbols.createInvokableTypeSymbol(33587228L, 1L, pkgID, bType, owner, pos, SymbolOrigin.VIRTUAL);
        function.setBType(new BInvokableType(this.symTable.typeEnv(), List.of(), bType, invokableTypeSymbol));
        BLangBuiltInRefTypeNode typeNode = (BLangBuiltInRefTypeNode)TreeBuilder.createBuiltInReferenceTypeNode();
        typeNode.setBType(bType);
        typeNode.typeKind = bType.getKind();
        typeNode.pos = pos;
        function.returnTypeNode = typeNode;
        BInvokableSymbol functionSymbol = new BInvokableSymbol(820L, 1L, new Name(funcName), pkgID, function.getBType(), owner, pos, SymbolOrigin.VIRTUAL);
        functionSymbol.bodyExist = true;
        functionSymbol.kind = SymbolKind.FUNCTION;
        functionSymbol.retType = function.returnTypeNode.getBType();
        functionSymbol.scope = new Scope(functionSymbol);
        functionSymbol.schedulerPolicy = SchedulerPolicy.ANY;
        function.symbol = functionSymbol;
        return function;
    }

    private String generateName(String name, BLangNode parent) {
        if (parent == null) {
            return "$" + name;
        }
        return switch (parent.getKind()) {
            case NodeKind.CLASS_DEFN -> this.generateName(((BLangClassDefinition)parent).name.getValue() + "_" + name, parent.parent);
            case NodeKind.FUNCTION -> this.generateName(((BLangFunction)parent).symbol.name.value.replace(".", "_") + "_" + name, parent.parent);
            case NodeKind.RESOURCE_FUNC -> this.generateName(((BLangResourceFunction)parent).name.value + "_" + name, parent.parent);
            case NodeKind.VARIABLE -> this.generateName(((BLangSimpleVariable)parent).name.getValue() + "_" + name, parent.parent);
            case NodeKind.TYPE_DEFINITION -> this.generateName(((BLangTypeDefinition)parent).name.getValue() + "_" + name, parent.parent);
            case NodeKind.RECORD_TYPE -> this.generateName("$rec$" + ((BLangRecordTypeNode)parent).symbol.name.getValue() + "$rec$" + name, parent.parent);
            default -> this.generateName(name, parent.parent);
        };
    }

    @Override
    public void visit(BLangTupleVariable varNode) {
        this.rewrite(varNode.restVariable, this.env);
        this.result = varNode;
    }

    @Override
    public void visit(BLangRecordVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangErrorVariable varNode) {
        varNode.expr = this.rewriteExpr(varNode.expr);
        this.result = varNode;
    }

    @Override
    public void visit(BLangTupleVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangRecordVariableDef varDefNode) {
        varDefNode.var = this.rewrite(varDefNode.var, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangErrorVariableDef varDefNode) {
        varDefNode.errorVariable = this.rewrite(varDefNode.errorVariable, this.env);
        this.result = varDefNode;
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        assignNode.varRef = this.rewriteExpr(assignNode.varRef);
        assignNode.expr = this.rewriteExpr(assignNode.expr);
        this.result = assignNode;
    }

    @Override
    public void visit(BLangTupleDestructure tupleDestructure) {
        this.result = tupleDestructure;
    }

    @Override
    public void visit(BLangRecordDestructure recordDestructure) {
        this.result = recordDestructure;
    }

    @Override
    public void visit(BLangErrorDestructure errorDestructure) {
        this.result = errorDestructure;
    }

    @Override
    public void visit(BLangRetry retryNode) {
        retryNode.retryBody = this.rewrite(retryNode.retryBody, this.env);
        this.result = retryNode;
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        retryTransaction.transaction = this.rewrite(retryTransaction.transaction, this.env);
        this.result = retryTransaction;
    }

    @Override
    public void visit(BLangContinue nextNode) {
        this.result = nextNode;
    }

    @Override
    public void visit(BLangBreak breakNode) {
        this.result = breakNode;
    }

    @Override
    public void visit(BLangPanic panicNode) {
        panicNode.expr = this.rewriteExpr(panicNode.expr);
        this.result = panicNode;
    }

    @Override
    public void visit(BLangDo doNode) {
        doNode.body = this.rewrite(doNode.body, this.env);
        this.result = doNode;
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        xmlnsStmtNode.xmlnsDecl = this.rewrite(xmlnsStmtNode.xmlnsDecl, this.env);
        this.result = xmlnsStmtNode;
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        exprStmtNode.expr = this.rewriteExpr(exprStmtNode.expr);
        this.result = exprStmtNode;
    }

    @Override
    public void visit(BLangFail failNode) {
        if (failNode.exprStmt != null) {
            failNode.exprStmt = this.rewrite(failNode.exprStmt, this.env);
        }
        this.result = failNode;
    }

    @Override
    public void visit(BLangIf ifNode) {
        ifNode.expr = this.rewriteExpr(ifNode.expr);
        ifNode.body = this.rewrite(ifNode.body, this.env);
        ifNode.elseStmt = this.rewrite(ifNode.elseStmt, this.env);
        this.result = ifNode;
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.result = foreach;
    }

    @Override
    public void visit(BLangWhile whileNode) {
        whileNode.expr = this.rewriteExpr(whileNode.expr);
        whileNode.body = this.rewrite(whileNode.body, this.env);
        this.result = whileNode;
    }

    @Override
    public void visit(BLangLock lockNode) {
        lockNode.body = this.rewrite(lockNode.body, this.env);
        this.result = lockNode;
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockNode) {
        this.result = lockNode;
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockNode) {
        this.result = unLockNode;
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        transactionNode.transactionBody = this.rewrite(transactionNode.transactionBody, this.env);
        this.result = transactionNode;
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        rollbackNode.expr = this.rewriteExpr(rollbackNode.expr);
        this.result = rollbackNode;
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
        this.result = transactionalExpr;
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
        this.result = commitExpr;
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        this.result = forkJoin;
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        listConstructorExpr.exprs = this.rewriteExprs(listConstructorExpr.exprs);
        this.result = listConstructorExpr;
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        this.rewriteExprs(tableConstructorExpr.recordLiteralList);
        this.result = tableConstructorExpr;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
        jsonArrayLiteral.exprs = this.rewriteExprs(jsonArrayLiteral.exprs);
        this.result = jsonArrayLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        tupleLiteral.exprs = this.rewriteExprs(tupleLiteral.exprs);
        this.result = tupleLiteral;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        arrayLiteral.exprs = this.rewriteExprs(arrayLiteral.exprs);
        this.result = arrayLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                keyValueField.key.expr = this.rewriteExpr(keyValueField.key.expr);
                keyValueField.valueExpr = this.rewriteExpr(keyValueField.valueExpr);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                BLangSimpleVarRef varRefField = (BLangSimpleVarRef)((Object)field);
                this.rewriteExpr(varRefField);
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadOpField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            spreadOpField.expr = this.rewriteExpr(spreadOpField.expr);
        }
        this.result = recordLiteral;
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        BSymbol varRefSym = varRefExpr.symbol;
        if (varRefSym != null) {
            boolean isMemberOfFunction;
            boolean bl = isMemberOfFunction = Symbols.isFlagOn(varRefSym.flags, 0x800000000L) || Symbols.isFlagOn(varRefSym.flags, 0x1000000000L);
            if (isMemberOfFunction) {
                this.updateFunctionParamsOfClosures(this.env, varRefExpr);
            }
        }
        BLangInvokableNode encInvokable = this.env.enclInvokable;
        BSymbol symbol = varRefExpr.symbol;
        if (varRefSym == null || encInvokable == null || (symbol.tag & 0x34L) != 52L) {
            this.result = varRefExpr;
            return;
        }
        this.updateClosureVariable((BVarSymbol)symbol, encInvokable, varRefExpr.pos);
        this.result = varRefExpr;
    }

    private void updateFunctionParamsOfClosures(SymbolEnv symbolEnv, BLangSimpleVarRef varRefExpr) {
        BLangFunction closure = null;
        while (symbolEnv != null && symbolEnv.node.getKind() != NodeKind.PACKAGE) {
            if (symbolEnv.node.getKind() != NodeKind.FUNCTION) {
                symbolEnv = symbolEnv.enclEnv;
                continue;
            }
            BLangFunction bLangFunction = (BLangFunction)symbolEnv.node;
            BLangInvokableNode enclInvokable = symbolEnv.enclInvokable;
            if (enclInvokable.flagSet.contains((Object)Flag.LAMBDA) && !enclInvokable.flagSet.contains((Object)Flag.QUERY_LAMBDA) && !enclInvokable.flagSet.contains((Object)Flag.ANONYMOUS)) {
                closure = bLangFunction;
            }
            symbolEnv = symbolEnv.enclEnv;
        }
        if (closure != null) {
            this.updateFunctionParams(closure, varRefExpr);
        }
    }

    private void updateFunctionParams(BLangFunction funcNode, BLangSimpleVarRef varRefExpr) {
        BInvokableSymbol funcSymbol = funcNode.symbol;
        for (BVarSymbol varSymbol : funcSymbol.params) {
            if (!varSymbol.name.value.equals(varRefExpr.symbol.name.value)) continue;
            varRefExpr.symbol = varSymbol;
            return;
        }
    }

    private SymbolEnv findEnclosingInvokableEnv(SymbolEnv env, BLangInvokableNode encInvokable) {
        if (env.enclEnv.node != null && env.enclEnv.node.getKind() == NodeKind.ARROW_EXPR) {
            return env.enclEnv;
        }
        if (env.enclEnv.node != null && env.enclEnv.node.getKind() == NodeKind.ON_FAIL) {
            return env.enclEnv;
        }
        if (env.enclInvokable != null && env.enclInvokable == encInvokable) {
            return this.findEnclosingInvokableEnv(env.enclEnv, encInvokable);
        }
        return env;
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        fieldAccessExpr.expr = this.rewriteExpr(fieldAccessExpr.expr);
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        indexAccessExpr.indexExpr = this.rewriteExpr(indexAccessExpr.indexExpr);
        indexAccessExpr.expr = this.rewriteExpr(indexAccessExpr.expr);
        this.result = indexAccessExpr;
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignment) {
        this.result = compoundAssignment;
    }

    @Override
    public void visit(BLangInvocation invocation) {
        this.rewriteInvocationExpr(invocation);
        BLangInvokableNode encInvokable = this.env.enclInvokable;
        if (encInvokable == null || !invocation.functionPointerInvocation || !this.env.enclPkg.packageID.equals(invocation.symbol.pkgID)) {
            return;
        }
        this.updateClosureVariable((BVarSymbol)invocation.symbol, encInvokable, invocation.pos);
    }

    public void rewriteInvocationExpr(BLangInvocation invocation) {
        invocation.requiredArgs = this.rewriteExprs(invocation.requiredArgs);
        this.result = invocation;
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        this.result = queryAction;
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkedExpr) {
        this.result = checkedExpr;
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr) {
        this.rewriteExprs(errorConstructorExpr.positionalArgs);
        errorConstructorExpr.errorDetail = this.rewriteExpr(errorConstructorExpr.errorDetail);
        this.result = errorConstructorExpr;
    }

    @Override
    public void visit(BLangTypeInit typeInitExpr) {
        typeInitExpr.initInvocation = this.rewriteExpr(typeInitExpr.initInvocation);
        this.result = typeInitExpr;
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        ternaryExpr.expr = this.rewriteExpr(ternaryExpr.expr);
        ternaryExpr.thenExpr = this.rewriteExpr(ternaryExpr.thenExpr);
        ternaryExpr.elseExpr = this.rewriteExpr(ternaryExpr.elseExpr);
        this.result = ternaryExpr;
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        ArrayList<BLangExpression> exprList = new ArrayList<BLangExpression>();
        waitExpr.exprList.forEach(expression -> exprList.add(this.rewriteExpr(expression)));
        waitExpr.exprList = exprList;
        this.result = waitExpr;
    }

    @Override
    public void visit(BLangWaitForAllExpr waitExpr) {
        this.result = waitExpr;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        trapExpr.expr = this.rewriteExpr(trapExpr.expr);
        this.result = trapExpr;
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        binaryExpr.lhsExpr = this.rewriteExpr(binaryExpr.lhsExpr);
        binaryExpr.rhsExpr = this.rewriteExpr(binaryExpr.rhsExpr);
        this.result = binaryExpr;
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.result = elvisExpr;
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        groupExpr.expression = this.rewriteExpr(groupExpr.expression);
        this.result = groupExpr;
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        unaryExpr.expr = this.rewriteExpr(unaryExpr.expr);
        this.result = unaryExpr;
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        conversionExpr.expr = this.rewriteExpr(conversionExpr.expr);
        conversionExpr.typeNode = this.rewrite(conversionExpr.typeNode, this.env);
        this.result = conversionExpr;
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        bLangLambdaFunction.capturedClosureEnv = this.env;
        bLangLambdaFunction.function = this.rewrite(bLangLambdaFunction.function, this.env);
        this.result = bLangLambdaFunction;
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        this.result = bLangArrowFunction;
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        this.result = xmlQName;
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        xmlAttribute.name = this.rewriteExpr(xmlAttribute.name);
        xmlAttribute.value = this.rewriteExpr(xmlAttribute.value);
        this.result = xmlAttribute;
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        xmlElementLiteral.startTagName = this.rewriteExpr(xmlElementLiteral.startTagName);
        xmlElementLiteral.endTagName = this.rewriteExpr(xmlElementLiteral.endTagName);
        xmlElementLiteral.modifiedChildren = this.rewriteExprs(xmlElementLiteral.modifiedChildren);
        xmlElementLiteral.attributes = this.rewriteExprs(xmlElementLiteral.attributes);
        this.result = xmlElementLiteral;
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        xmlTextLiteral.textFragments.forEach(this::rewriteExpr);
        xmlTextLiteral.concatExpr = this.rewriteExpr(xmlTextLiteral.concatExpr);
        this.result = xmlTextLiteral;
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        xmlCommentLiteral.textFragments.forEach(this::rewriteExpr);
        this.result = xmlCommentLiteral;
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        xmlProcInsLiteral.target = this.rewriteExpr(xmlProcInsLiteral.target);
        xmlProcInsLiteral.dataFragments.forEach(this::rewriteExpr);
        this.result = xmlProcInsLiteral;
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.textFragments.forEach(this::rewriteExpr);
        this.result = xmlQuotedString;
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        stringTemplateLiteral.exprs.forEach(this::rewriteExpr);
        this.result = stringTemplateLiteral;
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr) {
        asyncSendExpr.expr = this.rewriteExpr(asyncSendExpr.expr);
        this.result = asyncSendExpr;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
        syncSendExpr.expr = this.rewriteExpr(syncSendExpr.expr);
        this.result = syncSendExpr;
    }

    @Override
    public void visit(BLangAlternateWorkerReceive alternateWorkerReceive) {
        this.result = alternateWorkerReceive;
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive) {
        this.result = multipleWorkerReceive;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
        this.result = workerReceiveNode;
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
        this.result = workerFlushExpr;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef localVarRef) {
        BLangInvokableNode encInvokable = this.env.enclInvokable;
        BSymbol symbol = localVarRef.symbol;
        this.updateClosureVariable((BVarSymbol)symbol, encInvokable, localVarRef.pos);
        this.result = localVarRef;
    }

    private void updateClosureVariable(BVarSymbol varSymbol, BLangInvokableNode encInvokable, Location pos) {
        SymbolEnv encInvokableEnv;
        BSymbol resolvedSymbol;
        boolean isClosure;
        Set<Flag> flagSet = encInvokable.flagSet;
        boolean bl = isClosure = !flagSet.contains((Object)Flag.QUERY_LAMBDA) && flagSet.contains((Object)Flag.LAMBDA) && !flagSet.contains((Object)Flag.ATTACHED) && varSymbol.owner.tag != 4097L && !CompilerUtils.isInParameterList(varSymbol, encInvokable.requiredParams);
        if (!varSymbol.closure && isClosure && (resolvedSymbol = this.symResolver.lookupClosureVarSymbol(encInvokableEnv = this.findEnclosingInvokableEnv(this.env, encInvokable), varSymbol)) != this.symTable.notFoundSymbol) {
            varSymbol.closure = true;
            ((BLangFunction)encInvokable).closureVarSymbols.add(new ClosureVarSymbol(varSymbol, pos));
        }
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
        this.result = ignoreExpr;
    }

    @Override
    public void visit(BLangDynamicArgExpr dynamicParamExpr) {
        dynamicParamExpr.condition = this.rewriteExpr(dynamicParamExpr.condition);
        dynamicParamExpr.conditionalArgument = this.rewriteExpr(dynamicParamExpr.conditionalArgument);
        this.result = dynamicParamExpr;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef packageVarRef) {
        this.result = packageVarRef;
    }

    @Override
    public void visit(BLangConstRef constRef) {
        this.result = constRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef functionVarRef) {
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr fieldAccessExpr) {
        fieldAccessExpr.indexExpr = this.rewriteExpr(fieldAccessExpr.indexExpr);
        fieldAccessExpr.expr = this.rewriteExpr(fieldAccessExpr.expr);
        this.result = fieldAccessExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef functionVarRef) {
        functionVarRef.expr = this.rewriteExpr(functionVarRef.expr);
        this.result = functionVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapKeyAccessExpr) {
        mapKeyAccessExpr.indexExpr = this.rewriteExpr(mapKeyAccessExpr.indexExpr);
        mapKeyAccessExpr.expr = this.rewriteExpr(mapKeyAccessExpr.expr);
        this.result = mapKeyAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTableAccessExpr tableKeyAccessExpr) {
        tableKeyAccessExpr.indexExpr = this.rewriteExpr(tableKeyAccessExpr.indexExpr);
        tableKeyAccessExpr.expr = this.rewriteExpr(tableKeyAccessExpr.expr);
        this.result = tableKeyAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayIndexAccessExpr) {
        arrayIndexAccessExpr.indexExpr = this.rewriteExpr(arrayIndexAccessExpr.indexExpr);
        arrayIndexAccessExpr.expr = this.rewriteExpr(arrayIndexAccessExpr.expr);
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr arrayIndexAccessExpr) {
        arrayIndexAccessExpr.indexExpr = this.rewriteExpr(arrayIndexAccessExpr.indexExpr);
        arrayIndexAccessExpr.expr = this.rewriteExpr(arrayIndexAccessExpr.expr);
        this.result = arrayIndexAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlIndexAccessExpr) {
        xmlIndexAccessExpr.indexExpr = this.rewriteExpr(xmlIndexAccessExpr.indexExpr);
        xmlIndexAccessExpr.expr = this.rewriteExpr(xmlIndexAccessExpr.expr);
        this.result = xmlIndexAccessExpr;
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
        xmlElementAccess.expr = this.rewriteExpr(xmlElementAccess.expr);
        this.result = xmlElementAccess;
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
        xmlNavigation.expr = this.rewriteExpr(xmlNavigation.expr);
        this.result = xmlNavigation;
    }

    @Override
    public void visit(BLangExtendedXMLNavigationAccess extendedXmlNavigationAccess) {
        extendedXmlNavigationAccess.stepExpr = this.rewriteExpr(extendedXmlNavigationAccess.stepExpr);
        List<BLangXMLStepExtend> extensions = extendedXmlNavigationAccess.extensions;
        for (int i = 0; i < extensions.size(); ++i) {
            extensions.set(i, this.rewrite(extensions.get(i), this.env));
        }
        this.result = extendedXmlNavigationAccess;
    }

    @Override
    public void visit(BLangXMLIndexedStepExtend xmlIndexedStepExtend) {
        xmlIndexedStepExtend.indexExpr = this.rewriteExpr(xmlIndexedStepExtend.indexExpr);
        this.result = xmlIndexedStepExtend;
    }

    @Override
    public void visit(BLangXMLFilterStepExtend xmlFilterStepExtend) {
        this.result = xmlFilterStepExtend;
    }

    @Override
    public void visit(BLangXMLMethodCallStepExtend xmlMethodCallStepExtend) {
        xmlMethodCallStepExtend.invocation = this.rewriteExpr(xmlMethodCallStepExtend.invocation);
        this.result = xmlMethodCallStepExtend;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangJSONAccessExpr jsonAccessExpr) {
        jsonAccessExpr.indexExpr = this.rewriteExpr(jsonAccessExpr.indexExpr);
        jsonAccessExpr.expr = this.rewriteExpr(jsonAccessExpr.expr);
        this.result = jsonAccessExpr;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
        stringAccessExpr.indexExpr = this.rewriteExpr(stringAccessExpr.indexExpr);
        stringAccessExpr.expr = this.rewriteExpr(stringAccessExpr.expr);
        this.result = stringAccessExpr;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
        for (RecordLiteralNode.RecordField field : mapLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                keyValueField.key.expr = this.rewriteExpr(keyValueField.key.expr);
                keyValueField.valueExpr = this.rewriteExpr(keyValueField.valueExpr);
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            spreadField.expr = this.rewriteExpr(spreadField.expr);
        }
        this.result = mapLiteral;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
        for (RecordLiteralNode.RecordField field : structLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                keyValueField.key.expr = this.rewriteExpr(keyValueField.key.expr);
                keyValueField.valueExpr = this.rewriteExpr(keyValueField.valueExpr);
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            spreadField.expr = this.rewriteExpr(spreadField.expr);
        }
        this.result = structLiteral;
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        waitLiteral.keyValuePairs.forEach(keyValue -> {
            if (keyValue.valueExpr != null) {
                keyValue.valueExpr = this.rewriteExpr(keyValue.valueExpr);
            } else {
                keyValue.keyExpr = this.rewriteExpr(keyValue.keyExpr);
            }
        });
        this.result = waitLiteral;
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        assignableExpr.lhsExpr = this.rewriteExpr(assignableExpr.lhsExpr);
        this.result = assignableExpr;
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation fpInvocation) {
        fpInvocation.expr = this.rewriteExpr(fpInvocation.expr);
        this.rewriteInvocationExpr(fpInvocation);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        this.result = accessExpr;
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.result = this.rewriteExpr(bLangVarArgsExpression.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        bLangNamedArgsExpression.expr = this.rewriteExpr(bLangNamedArgsExpression.expr);
        this.result = bLangNamedArgsExpression;
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.result = checkedExpr;
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.result = serviceConstructorExpr;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        typeTestExpr.typeNode = this.rewrite(typeTestExpr.typeNode, this.env);
        typeTestExpr.expr = this.rewriteExpr(typeTestExpr.expr);
        this.result = typeTestExpr;
    }

    @Override
    public void visit(BLangIsLikeExpr isLikeExpr) {
        isLikeExpr.expr = this.rewriteExpr(isLikeExpr.expr);
        this.result = isLikeExpr;
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess prefixedFieldBasedAccess) {
        this.result = prefixedFieldBasedAccess;
    }

    @Override
    public void visit(BLangLetExpression letExpression) {
        for (BLangLetVariable letVariable : letExpression.letVarDeclarations) {
            this.rewrite((BLangNode)((Object)letVariable.definitionNode), this.env);
        }
        letExpression.expr = this.rewriteExpr(letExpression.expr);
        this.result = letExpression;
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        annotAccessExpr.expr = this.rewriteExpr(annotAccessExpr.expr);
        this.result = annotAccessExpr;
    }

    @Override
    public void visit(BLangStatementExpression bLangStatementExpression) {
        if (bLangStatementExpression.stmt.getKind() == NodeKind.BLOCK) {
            BLangBlockStmt bLangBlockStmt = (BLangBlockStmt)bLangStatementExpression.stmt;
            for (int i = 0; i < bLangBlockStmt.stmts.size(); ++i) {
                BLangStatement stmt = bLangBlockStmt.stmts.remove(i);
                bLangBlockStmt.stmts.add(i, this.rewrite(stmt, this.env));
            }
        } else {
            bLangStatementExpression.stmt = this.rewrite(bLangStatementExpression.stmt, this.env);
        }
        bLangStatementExpression.expr = this.rewriteExpr(bLangStatementExpression.expr);
        this.result = bLangStatementExpression;
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation invocation) {
        this.rewriteInvocationExpr(invocation);
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
    }

    @Override
    public void visit(BLangConstant constant) {
        this.result = constant;
    }

    @Override
    public void visit(BLangNumericLiteral literalExpr) {
        this.result = literalExpr;
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        this.result = varRefExpr;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangTypeLoad typeLoad) {
        this.result = typeLoad;
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
        xmlnsNode.namespaceURI = this.rewriteExpr(xmlnsNode.namespaceURI);
        this.result = xmlnsNode;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangListConstructorSpreadOpExpr listConstructorSpreadOpExpr) {
        listConstructorSpreadOpExpr.expr = this.rewriteExpr(listConstructorSpreadOpExpr.expr);
        this.result = listConstructorSpreadOpExpr;
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        for (BLangNode clause : queryExpr.getQueryClauses()) {
            this.rewrite(clause, this.env);
        }
        this.result = queryExpr;
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        BLangExpression collection = fromClause.collection;
        this.rewrite(collection, this.env);
        this.result = fromClause;
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        this.rewrite(joinClause.collection, this.env);
        if (joinClause.onClause != null) {
            this.rewrite(joinClause.onClause, this.env);
        }
        this.result = joinClause;
    }

    @Override
    public void visit(BLangLetClause letClause) {
        for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
            this.rewrite((BLangNode)((Object)letVariable.definitionNode), this.env);
        }
        this.result = letClause;
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.rewrite(whereClause.expression, this.env);
        this.result = whereClause;
    }

    @Override
    public void visit(BLangOnClause onClause) {
        this.rewrite(onClause.lhsExpr, this.env);
        this.rewrite(onClause.rhsExpr, this.env);
        this.result = onClause;
    }

    @Override
    public void visit(BLangOrderKey orderKeyClause) {
        this.rewrite(orderKeyClause.expression, this.env);
        this.result = orderKeyClause;
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        orderByClause.orderByKeyList.forEach(value -> this.rewrite((BLangNode)((Object)value), this.env));
        this.result = orderByClause;
    }

    @Override
    public void visit(BLangGroupByClause groupByClause) {
        groupByClause.groupingKeyList.forEach(value -> this.rewrite(value, this.env));
        this.result = groupByClause;
    }

    @Override
    public void visit(BLangGroupingKey groupingKey) {
        this.rewrite((BLangNode)groupingKey.getGroupingKey(), this.env);
        this.result = groupingKey;
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.rewrite(selectClause.expression, this.env);
        this.result = selectClause;
    }

    @Override
    public void visit(BLangCollectClause bLangCollectClause) {
        this.rewrite(bLangCollectClause.expression, this.env);
        this.result = bLangCollectClause;
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        this.rewrite(onConflictClause.expression, this.env);
        this.result = onConflictClause;
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        this.rewrite(limitClause.expression, this.env);
        this.result = limitClause;
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        this.rewrite(onFailClause.body, this.env);
        this.result = onFailClause;
    }

    @Override
    public void visit(BLangCollectContextInvocation collectContextInvocation) {
        this.rewrite(collectContextInvocation.invocation, this.env);
        this.result = collectContextInvocation;
    }

    @Override
    public void visit(BLangMatchStatement matchStatement) {
        this.result = matchStatement;
    }

    @Override
    public void visit(BLangXMLSequenceLiteral xmlSequenceLiteral) {
        xmlSequenceLiteral.xmlItems.forEach(this::rewriteExpr);
        this.result = xmlSequenceLiteral;
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral) {
        List<BLangExpression> interpolationsList = this.symResolver.getListOfInterpolations(regExpTemplateLiteral.reDisjunction.sequenceList);
        interpolationsList.forEach(this::rewriteExpr);
        this.result = regExpTemplateLiteral;
    }

    @Override
    public void visit(BLangMarkdownDocumentationLine bLangMarkdownDocumentationLine) {
    }

    @Override
    public void visit(BLangMarkdownParameterDocumentation bLangDocumentationParameter) {
    }

    @Override
    public void visit(BLangMarkdownReturnParameterDocumentation bLangMarkdownReturnParameterDocumentation) {
    }

    @Override
    public void visit(BLangInferredTypedescDefaultNode inferTypedescExpr) {
        this.result = inferTypedescExpr;
    }

    @Override
    public void visit(BLangMarkdownDocumentation bLangMarkdownDocumentation) {
    }

    private <E extends BLangNode> E rewrite(E node, SymbolEnv env) {
        if (node == null) {
            return null;
        }
        SymbolEnv previousEnv = this.env;
        this.env = env;
        node.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        this.env = previousEnv;
        return (E)resultNode;
    }

    private <E extends BLangNode> List<E> rewrite(List<E> nodeList, SymbolEnv env) {
        Queue<BLangSimpleVariableDef> previousQueue = this.annotationClosureReferences;
        this.annotationClosureReferences = new LinkedList<BLangSimpleVariableDef>();
        int size = nodeList.size();
        for (int i = 0; i < size; ++i) {
            BLangNode node = this.rewrite((BLangNode)nodeList.remove(0), env);
            Iterator iterator = this.annotationClosureReferences.iterator();
            while (iterator.hasNext()) {
                nodeList.add(this.rewrite(this.annotationClosureReferences.poll().var, env));
            }
            nodeList.add((BLangSimpleVariable)node);
        }
        this.annotationClosureReferences = previousQueue;
        return nodeList;
    }

    private <E extends BLangExpression> E rewriteExpr(E node) {
        if (node == null) {
            return null;
        }
        node.accept(this);
        BLangNode resultNode = this.result;
        this.result = null;
        return (E)((BLangExpression)resultNode);
    }

    private <E extends BLangStatement> List<E> rewriteStmt(List<E> nodeList, SymbolEnv env) {
        Queue<BLangSimpleVariableDef> previousQueue = this.queue;
        this.queue = new LinkedList<BLangSimpleVariableDef>();
        int size = nodeList.size();
        for (int i = 0; i < size; ++i) {
            BLangStatement node = this.rewrite((BLangStatement)nodeList.remove(0), env);
            Iterator iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                BLangSimpleVariableDef bLangSimpleVariableDef = this.queue.poll();
                nodeList.add(this.rewrite(bLangSimpleVariableDef, env));
                BVarSymbol varSymbol = bLangSimpleVariableDef.var.symbol;
                env.scope.define(varSymbol.name, varSymbol);
            }
            nodeList.add(node);
        }
        this.queue = previousQueue;
        return nodeList;
    }

    private <E extends BLangExpression> List<E> rewriteExprs(List<E> nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            nodeList.set(i, this.rewriteExpr((BLangExpression)nodeList.get(i)));
        }
        return nodeList;
    }
}

