/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.TopLevelNode;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.Name;

public class MockDesugar {
    private static final CompilerContext.Key<MockDesugar> MOCK_DESUGAR_KEY = new CompilerContext.Key();
    private static final String MOCK_FN_DELIMITER = "#";
    private static final String MOCK_LEGACY_DELIMITER = "~";
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private BLangPackage bLangPackage;
    private BLangFunction originalFunction;
    private BInvokableSymbol importFunction;
    private String mockFnObjectName;
    private final String testPackageSymbol = "ballerina/test";
    public static final String MOCK_FUNCTION = "$MOCK_";

    private MockDesugar(CompilerContext context) {
        context.put(MOCK_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
    }

    public static MockDesugar getInstance(CompilerContext context) {
        MockDesugar desugar = context.get(MOCK_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new MockDesugar(context);
        }
        return desugar;
    }

    private static IdentifierNode createIdentifier(String value) {
        IdentifierNode node = TreeBuilder.createIdentifierNode();
        if (value != null) {
            node.setValue(value);
        }
        return node;
    }

    public void generateMockFunctions(BLangPackage pkgNode) {
        this.bLangPackage = pkgNode;
        Map<String, String> mockFunctionMap = pkgNode.getTestablePkg().getMockFunctionNamesMap();
        Map<String, Boolean> isLegacyMockingMap = pkgNode.getTestablePkg().getIsLegacyMockingMap();
        Set<String> mockFunctionSet = mockFunctionMap.keySet();
        for (String function : mockFunctionSet) {
            if (isLegacyMockingMap.get(function).booleanValue()) continue;
            pkgNode.getTestablePkg().functions.add(this.generateMockFunction(function));
        }
    }

    private BLangFunction generateMockFunction(String functionName) {
        this.mockFnObjectName = this.bLangPackage.getTestablePkg().getMockFunctionNamesMap().get(functionName);
        this.importFunction = null;
        this.originalFunction = null;
        if (((String)functionName).contains(this.bLangPackage.packageID.toString())) {
            functionName = ((String)functionName).substring(((String)functionName).indexOf(MOCK_FN_DELIMITER) + 1);
            this.originalFunction = this.getOriginalFunction((String)functionName);
        } else {
            String packageName = ((String)functionName).substring(((String)functionName).indexOf(47) + 1, ((String)functionName).indexOf(58));
            functionName = ((String)functionName).substring(((String)functionName).indexOf(MOCK_FN_DELIMITER) + 1);
            this.importFunction = this.getImportFunction((String)functionName, packageName);
        }
        functionName = MOCK_FUNCTION + (String)functionName;
        BLangFunction generatedMock = ASTBuilderUtil.createFunction(this.bLangPackage.pos, (String)functionName);
        if (this.originalFunction == null && this.importFunction == null) {
            throw new IllegalStateException("Mock Function and Function to Mock cannot be null");
        }
        generatedMock.requiredParams = this.generateRequiredParams();
        generatedMock.restParam = this.generateRestParam();
        generatedMock.returnTypeNode = this.generateReturnTypeNode();
        generatedMock.setBType(this.generateSymbolInvokableType());
        BInvokableSymbol symbol = this.generateSymbol((String)functionName);
        symbol.scope = new Scope(symbol);
        generatedMock.symbol = symbol;
        generatedMock.body = this.generateBody(symbol);
        return generatedMock;
    }

    private BLangFunction getOriginalFunction(String functionName) {
        List<BLangFunction> functionList = this.bLangPackage.getFunctions();
        for (BLangFunction function : functionList) {
            if (!function.getName().toString().equals(functionName)) continue;
            return function;
        }
        return null;
    }

    private BInvokableSymbol getImportFunction(String functionName, String packageName) {
        BInvokableSymbol bInvokableSymbol = this.getInvokableSymbol(functionName, packageName, this.bLangPackage.getImports());
        if (bInvokableSymbol == null) {
            bInvokableSymbol = this.getInvokableSymbol(functionName, packageName, this.bLangPackage.getTestablePkg().getImports());
        }
        return bInvokableSymbol;
    }

    private BInvokableSymbol getInvokableSymbol(String functionName, String packageName, List<BLangImportPackage> importList) {
        for (BLangImportPackage importPkg : importList) {
            if (!importPkg.pkgNameComps.stream().map(BLangIdentifier::toString).collect(Collectors.joining(".")).equals(packageName)) continue;
            return (BInvokableSymbol)importPkg.symbol.scope.entries.get((Object)new Name((String)functionName)).symbol;
        }
        return null;
    }

    private List<BLangSimpleVariable> generateRequiredParams() {
        List requiredParams = this.originalFunction != null ? this.originalFunction.requiredParams : this.generateImportRequiredParams();
        return requiredParams;
    }

    private List<BLangSimpleVariable> generateImportRequiredParams() {
        ArrayList<BLangSimpleVariable> bLangSimpleVariables = new ArrayList<BLangSimpleVariable>();
        for (BVarSymbol bVarSymbol : this.importFunction.params) {
            BLangSimpleVariable bLangSimpleVariable = ASTBuilderUtil.createVariable(this.bLangPackage.pos, bVarSymbol.name.getValue(), bVarSymbol.type, null, bVarSymbol);
            bLangSimpleVariables.add(bLangSimpleVariable);
        }
        return bLangSimpleVariables;
    }

    private BLangSimpleVariable generateRestParam() {
        BLangSimpleVariable bLangSimpleVariable = null;
        if (this.importFunction != null) {
            if (this.importFunction.restParam != null) {
                bLangSimpleVariable = ASTBuilderUtil.createVariable(this.bLangPackage.pos, this.importFunction.restParam.name.getValue(), this.importFunction.restParam.type, null, this.importFunction.restParam);
                bLangSimpleVariable.typeNode = ASTBuilderUtil.createTypeNode(this.importFunction.restParam.type);
            }
        } else {
            bLangSimpleVariable = this.originalFunction.restParam;
        }
        return bLangSimpleVariable;
    }

    private BLangType generateReturnTypeNode() {
        BLangType returnTypeNode = this.originalFunction == null ? this.generateImportReturnTypeNode() : this.originalFunction.returnTypeNode;
        return returnTypeNode;
    }

    private BLangType generateImportReturnTypeNode() {
        BLangValueType typeNode = (BLangValueType)TreeBuilder.createValueTypeNode();
        typeNode.pos = this.bLangPackage.pos;
        typeNode.typeKind = this.importFunction.retType.getKind();
        typeNode.setBType(this.importFunction.retType);
        return typeNode;
    }

    private BInvokableSymbol generateSymbol(String functionName) {
        BInvokableSymbol symbol = new BInvokableSymbol(820L, 0L, new Name(functionName), this.bLangPackage.packageID, (BType)this.generateSymbolInvokableType(), (BSymbol)this.bLangPackage.symbol, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        return symbol;
    }

    private BInvokableType generateSymbolInvokableType() {
        BInvokableType bInvokableType = this.originalFunction == null && this.importFunction != null ? (BInvokableType)this.importFunction.type : (BInvokableType)this.originalFunction.symbol.type;
        return bInvokableType;
    }

    private BLangFunctionBody generateBody(BInvokableSymbol symbol) {
        BLangBlockFunctionBody body = ASTBuilderUtil.createBlockFunctionBody(this.bLangPackage.pos, this.generateStatements());
        body.scope = new Scope(symbol);
        return body;
    }

    private List<BLangStatement> generateStatements() {
        String functionToMockVal = this.originalFunction == null ? this.importFunction.name.toString() : this.originalFunction.name.toString();
        BLangAssignment bLangAssignment1 = ASTBuilderUtil.createAssignmentStmt(this.bLangPackage.pos, this.generateFieldBasedAccess("functionToMock", this.symTable.stringType), this.generateRHSExpr(functionToMockVal));
        String functionToMockPackageVal = this.originalFunction == null ? this.importFunction.pkgID.toString() + "/" + this.getFunctionSource(this.importFunction.source) : this.originalFunction.symbol.pkgID.toString() + "/" + this.getFunctionSource(this.originalFunction.symbol.source);
        BLangAssignment bLangAssignment2 = ASTBuilderUtil.createAssignmentStmt(this.bLangPackage.pos, this.generateFieldBasedAccess("functionToMockPackage", this.symTable.stringType), this.generateRHSExpr(functionToMockPackageVal));
        BLangAssignment bLangAssignment3 = ASTBuilderUtil.createAssignmentStmt(this.bLangPackage.pos, this.generateFieldBasedAccess("mockFunctionClasses", this.symTable.arrayType), this.generateClassListConstructorExpr());
        BLangReturn blangReturn = ASTBuilderUtil.createReturnStmt(this.bLangPackage.pos, this.generateTypeConversionExpression());
        ArrayList<BLangStatement> statements = new ArrayList<BLangStatement>();
        statements.add(bLangAssignment1);
        statements.add(bLangAssignment2);
        statements.add(bLangAssignment3);
        statements.add(blangReturn);
        return statements;
    }

    private String getFunctionSource(String source) {
        return source.replaceAll(".bal", "");
    }

    private BLangFieldBasedAccess generateFieldBasedAccess(String fieldName, BType fieldType) {
        BLangSimpleVarRef expr = this.getMockFunctionReference();
        BLangIdentifier field = ASTBuilderUtil.createIdentifier(this.bLangPackage.pos, fieldName);
        BLangFieldBasedAccess bLangFieldBasedAccess = ASTBuilderUtil.createFieldAccessExpr(expr, field);
        bLangFieldBasedAccess.fieldKind = FieldKind.SINGLE;
        bLangFieldBasedAccess.originalType = fieldType;
        bLangFieldBasedAccess.isLValue = true;
        bLangFieldBasedAccess.expectedType = fieldType;
        bLangFieldBasedAccess.setBType(fieldType);
        return bLangFieldBasedAccess;
    }

    private BLangLiteral generateRHSExpr(String val) {
        BType type = this.symTable.stringType;
        BLangLiteral bLangLiteral = ASTBuilderUtil.createLiteral(this.bLangPackage.pos, type, val);
        bLangLiteral.expectedType = type;
        return bLangLiteral;
    }

    private BLangListConstructorExpr generateClassListConstructorExpr() {
        List<BLangCompilationUnit> compUnitList = this.bLangPackage.getTestablePkg().getCompilationUnits();
        BArrayType bArrayType = new BArrayType(this.symTable.typeEnv(), this.symTable.stringType, null, -1, BArrayState.OPEN);
        ArrayList<BLangCompilationUnit> modifiedcompUnitList = new ArrayList<BLangCompilationUnit>();
        block0: for (BLangCompilationUnit compUnit : compUnitList) {
            List<TopLevelNode> topLevelNodes = compUnit.getTopLevelNodes();
            for (TopLevelNode topLevelNode : topLevelNodes) {
                if (!(topLevelNode instanceof BLangFunction)) continue;
                modifiedcompUnitList.add(compUnit);
                continue block0;
            }
        }
        compUnitList = modifiedcompUnitList;
        BLangListConstructorExpr bLangListConstructorExpr = ASTBuilderUtil.createListConstructorExpr(this.bLangPackage.pos, bArrayType);
        for (BLangCompilationUnit compUnit : compUnitList) {
            String sourceName = compUnit.getName();
            sourceName = sourceName.replace("/", ".");
            sourceName = sourceName.replace(".bal", "");
            BLangLiteral bLangLiteral = ASTBuilderUtil.createLiteral(this.bLangPackage.pos, this.symTable.stringType, sourceName);
            bLangListConstructorExpr.exprs.add(bLangLiteral);
        }
        return bLangListConstructorExpr;
    }

    private BLangTypeConversionExpr generateTypeConversionExpression() {
        BLangInvocation bLangInvocation = this.generateBLangInvocation();
        BType target = this.generateType();
        BLangTypeConversionExpr typeConversionExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
        typeConversionExpr.pos = bLangInvocation.pos;
        typeConversionExpr.expr = bLangInvocation;
        typeConversionExpr.setBType(target);
        typeConversionExpr.targetType = target;
        return typeConversionExpr;
    }

    private BLangInvocation generateBLangInvocation() {
        BInvokableSymbol invokableSymbol = this.getMockHandlerInvokableSymbol();
        List<BLangExpression> argsExprs = this.generateInvocationArgsExprs();
        List<BLangExpression> requiredArgs = this.generateInvocationRequiredArgs();
        List<BLangExpression> restArgs = this.generateInvocationRestArgs();
        BLangInvocation bLangInvocation = ASTBuilderUtil.createInvocationExprForMethod(this.bLangPackage.pos, invokableSymbol, requiredArgs, this.symResolver);
        bLangInvocation.pkgAlias = (BLangIdentifier)MockDesugar.createIdentifier("test");
        bLangInvocation.argExprs = argsExprs;
        bLangInvocation.expectedType = bLangInvocation.getBType();
        bLangInvocation.restArgs = restArgs;
        return bLangInvocation;
    }

    private BInvokableSymbol getMockHandlerInvokableSymbol() {
        List<BLangImportPackage> packageList = this.bLangPackage.getTestablePkg().getImports();
        for (BLangImportPackage importPackage : packageList) {
            if (!importPackage.alias.getValue().equals("test")) continue;
            BInvokableSymbol mockHandlerSymbol = (BInvokableSymbol)importPackage.symbol.scope.lookup((Name)new Name((String)"mockHandler")).symbol;
            return mockHandlerSymbol;
        }
        return null;
    }

    private List<BLangExpression> generateInvocationArgsExprs() {
        ArrayList<BLangExpression> argExprs = new ArrayList<BLangExpression>();
        BLangSimpleVarRef bLangSimpleVarRef = this.getMockFunctionReference();
        argExprs.add(bLangSimpleVarRef);
        if (this.originalFunction != null) {
            for (BLangSimpleVariable var : this.originalFunction.requiredParams) {
                bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, var.symbol);
                argExprs.add(bLangSimpleVarRef);
            }
            if (this.originalFunction.restParam != null) {
                bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, this.originalFunction.restParam.symbol);
                argExprs.add(bLangSimpleVarRef);
            }
        } else {
            if (!this.importFunction.params.isEmpty()) {
                for (BVarSymbol bVarSymbol : this.importFunction.params) {
                    bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, bVarSymbol);
                    argExprs.add(bLangSimpleVarRef);
                }
            }
            if (this.importFunction.restParam != null) {
                bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, this.importFunction.restParam);
                argExprs.add(bLangSimpleVarRef);
            }
        }
        return argExprs;
    }

    private BLangSimpleVarRef getMockFunctionReference() {
        BVarSymbol mockObjectSymbol = (BVarSymbol)this.bLangPackage.getTestablePkg().symbol.scope.lookup((Name)new Name((String)this.mockFnObjectName)).symbol;
        BLangSimpleVarRef bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, mockObjectSymbol);
        return bLangSimpleVarRef;
    }

    private List<BLangExpression> generateInvocationRequiredArgs() {
        ArrayList<BLangExpression> requiredArgs;
        block3: {
            BLangSimpleVarRef bLangSimpleVarRef;
            block2: {
                requiredArgs = new ArrayList<BLangExpression>();
                bLangSimpleVarRef = this.getMockFunctionReference();
                requiredArgs.add(bLangSimpleVarRef);
                if (this.originalFunction == null) break block2;
                for (BLangSimpleVariable var : this.originalFunction.requiredParams) {
                    bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, var.symbol);
                    requiredArgs.add(bLangSimpleVarRef);
                }
                break block3;
            }
            if (this.importFunction.params.isEmpty()) break block3;
            for (BVarSymbol bVarSymbol : this.importFunction.params) {
                bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, bVarSymbol);
                requiredArgs.add(bLangSimpleVarRef);
            }
        }
        return requiredArgs;
    }

    private List<BLangExpression> generateInvocationRestArgs() {
        ArrayList<BLangExpression> restArgs = new ArrayList<BLangExpression>();
        BLangSimpleVarRef bLangSimpleVarRef = null;
        if (this.originalFunction != null) {
            if (this.originalFunction.requiredParams != null) {
                for (BLangSimpleVariable var : this.originalFunction.requiredParams) {
                    bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, var.symbol);
                    restArgs.add(bLangSimpleVarRef);
                }
            }
            if (this.originalFunction.restParam != null) {
                bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, this.originalFunction.restParam.symbol);
                restArgs.add(bLangSimpleVarRef);
            }
        } else {
            if (!this.importFunction.params.isEmpty()) {
                for (BVarSymbol bVarSymbol : this.importFunction.params) {
                    bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, bVarSymbol);
                    restArgs.add(bLangSimpleVarRef);
                }
            }
            if (this.importFunction.restParam != null) {
                bLangSimpleVarRef = ASTBuilderUtil.createVariableRef(this.bLangPackage.pos, this.importFunction.restParam);
                restArgs.add(bLangSimpleVarRef);
            }
        }
        return restArgs;
    }

    private BType generateType() {
        BType type = this.originalFunction == null ? this.importFunction.retType : ((BInvokableType)this.originalFunction.getBType()).retType;
        return type;
    }

    private Boolean startsWithMockLegacyDelimiterForImportedMockFunctions(String mockFnName, ArrayList<String> importsList) {
        for (String importName : importsList) {
            if (!mockFnName.contains(importName) || !mockFnName.split(importName)[1].startsWith(MOCK_LEGACY_DELIMITER)) continue;
            return true;
        }
        return false;
    }
}

