/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.diagnostic;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.util.Objects;

public class BLangDiagnosticLocation
implements Location {
    private final String filePath;
    private final int startLine;
    private final int endLine;
    private final int startColumn;
    private final int endColumn;
    private final int startOffset;
    private final int length;

    @Deprecated
    public BLangDiagnosticLocation(String filePath, int startLine, int endLine, int startColumn, int endColumn) {
        this(filePath, startLine, endLine, startColumn, endColumn, 0, 0);
    }

    public BLangDiagnosticLocation(String filePath, int startLine, int endLine, int startColumn, int endColumn, int startOffset, int length) {
        this.filePath = filePath;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        this.startOffset = startOffset;
        this.length = length;
    }

    public LineRange lineRange() {
        return LineRange.from((String)this.filePath, (LinePosition)LinePosition.from((int)this.startLine, (int)this.startColumn), (LinePosition)LinePosition.from((int)this.endLine, (int)this.endColumn));
    }

    public TextRange textRange() {
        return TextRange.from((int)this.startOffset, (int)this.length);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BLangDiagnosticLocation) {
            BLangDiagnosticLocation location = (BLangDiagnosticLocation)obj;
            return this.lineRange().equals((Object)location.lineRange()) && this.textRange().equals((Object)location.textRange());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.lineRange(), this.textRange());
    }

    public String toString() {
        int endOffset = this.startOffset + this.length;
        return "(" + this.startLine + "," + this.endLine + ")(" + this.startOffset + "," + endOffset + ")";
    }
}

