/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.converters;

import io.ballerina.projects.internal.model.Proxy;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompilerInput;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.repo.HomeBalaRepo;
import org.wso2.ballerinalang.programfile.ProgramFileConstants;
import org.wso2.ballerinalang.util.RepoUtils;
import org.wso2.ballerinalang.util.TomlParserUtils;

public class URIConverter
implements Converter<URI> {
    private final HomeBalaRepo homeBalaRepo;
    protected URI base;
    protected final Map<PackageID, Manifest> dependencyManifests;
    private boolean isBuild = true;
    private final PrintStream errStream = System.err;

    public URIConverter(URI base, Map<PackageID, Manifest> dependencyManifests) {
        this.base = URI.create(base.toString() + "/modules/");
        this.dependencyManifests = dependencyManifests;
        this.homeBalaRepo = new HomeBalaRepo(this.dependencyManifests);
    }

    public URIConverter(URI base, Map<PackageID, Manifest> dependencyManifests, boolean isBuild) {
        this.base = URI.create(base.toString() + "/modules/");
        this.dependencyManifests = dependencyManifests;
        this.isBuild = isBuild;
        this.homeBalaRepo = new HomeBalaRepo(this.dependencyManifests);
    }

    public void createDirectory(Path dirPath) {
        if (!Files.exists(dirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("error occurred when creating the directory path " + String.valueOf(dirPath));
            }
        }
    }

    @Override
    public URI start() {
        return this.base;
    }

    @Override
    public URI combine(URI s, String p) {
        return s.resolve(p + "/");
    }

    @Override
    public Stream<URI> getLatestVersion(URI u, PackageID packageID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<URI> expandBalWithTest(URI uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<URI> expandBal(URI u) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<CompilerInput> finalize(URI remoteURI, PackageID moduleID) {
        String orgName = moduleID.getOrgName().getValue();
        String moduleName = moduleID.getName().getValue();
        Path modulePathInBalaCache = RepoUtils.createAndGetHomeReposPath().resolve("bala_cache").resolve(orgName).resolve(moduleName);
        this.createDirectory(modulePathInBalaCache);
        Proxy proxy = TomlParserUtils.readSettings().getProxy();
        String supportedVersionRange = "";
        boolean nightlyBuild = RepoUtils.getBallerinaVersion().contains("SNAPSHOT");
        String[] stringArray = ProgramFileConstants.SUPPORTED_PLATFORMS;
        int n = stringArray.length;
        int n2 = 0;
        if (n2 < n) {
            String supportedPlatform = stringArray[n2];
            Patten patten = this.homeBalaRepo.calculate(moduleID);
            return patten.convertToSources(this.homeBalaRepo.getConverterInstance(), moduleID);
        }
        return Stream.of(new CompilerInput[0]);
    }

    public String toString() {
        return this.base.toString();
    }
}

