/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.repo;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.toml.model.Dependency;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.ZipConverter;
import org.wso2.ballerinalang.compiler.packaging.repo.Repo;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.util.RepoUtils;

public class PathBalaRepo
implements Repo<Path> {
    private static final Pattern SEM_VER_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
    private final Manifest manifest;
    private final Map<PackageID, Manifest> dependencyManifests;
    private final ZipConverter zipConverter;

    public PathBalaRepo(Manifest manifest, Map<PackageID, Manifest> dependencyManifests) {
        this.manifest = manifest;
        this.dependencyManifests = dependencyManifests;
        this.zipConverter = new ZipConverter(Path.of("", new String[0]));
    }

    @Override
    public Patten calculate(PackageID moduleID) {
        Matcher semverMatcher;
        if (null == this.manifest) {
            return Patten.NULL;
        }
        Optional<Dependency> tomlDependency = this.manifest.getDependencies().stream().filter(dep -> dep.getOrgName().equals(moduleID.orgName.value) && dep.getModuleName().equals(moduleID.name.value) && null != dep.getMetadata().getPath()).findFirst();
        if (!tomlDependency.isPresent()) {
            return Patten.NULL;
        }
        Dependency dep2 = tomlDependency.get();
        Path balaPath = dep2.getMetadata().getPath();
        if (Files.notExists(balaPath, new LinkOption[0])) {
            throw new BLangCompilerException("bala file for dependency [" + dep2.getModuleID() + "] does not exists: " + String.valueOf(dep2.getMetadata().getPath().toAbsolutePath().normalize()));
        }
        if (!Files.isRegularFile(balaPath, new LinkOption[0])) {
            throw new BLangCompilerException("bala file for dependency [" + dep2.getModuleID() + "] is not a file: " + String.valueOf(dep2.getMetadata().getPath().toAbsolutePath().normalize()));
        }
        if (moduleID.version.value.isEmpty() && null != dep2.getMetadata().getVersion() && (semverMatcher = SEM_VER_PATTERN.matcher(dep2.getMetadata().getVersion())).matches()) {
            moduleID.version = new Name(dep2.getMetadata().getVersion());
        }
        Manifest manifestFromBala = RepoUtils.getManifestFromBala(balaPath.toAbsolutePath());
        if (moduleID.version.value.isEmpty()) {
            moduleID.version = new Name(manifestFromBala.getProject().getVersion());
        }
        this.dependencyManifests.put(moduleID, manifestFromBala);
        return new Patten(Patten.path(balaPath.toAbsolutePath().toString(), "src", dep2.getModuleName()), Patten.WILDCARD_SOURCE);
    }

    @Override
    public Converter<Path> getConverterInstance() {
        return this.zipConverter;
    }

    public String toString() {
        return "{t:'PathBalaRepo', c:'" + String.valueOf(this.zipConverter) + "'}";
    }
}

