/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.clauses.OrderKeyNode;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.ballerinalang.util.diagnostic.DiagnosticHintCode;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNeverType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BPackageType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangRetrySpec;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangCaptureBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorCauseBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorFieldBindingPatterns;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangErrorMessageBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangFieldBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangListBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangMappingBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangNamedArgBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangRestBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangSimpleBindingPattern;
import org.wso2.ballerinalang.compiler.tree.bindingpatterns.BLangWildCardBindingPattern;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangCollectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangGroupingKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangJoinClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLimitClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangMatchClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnConflictClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOnFailClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderByClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangOrderKey;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCollectContextInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCommitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExtendedXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInferredTypedescDefaultNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchGuard;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangObjectConstructorExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRawTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTransactionalExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangVariableReference;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLFilterStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLIndexedStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLMethodCallStepExtend;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangConstPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorCauseMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorFieldMatchPatterns;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangErrorMessageMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangFieldMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangListMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMappingMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangNamedArgMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangRestMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangSimpleMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangVarBindingPatternMatchPattern;
import org.wso2.ballerinalang.compiler.tree.matchpatterns.BLangWildCardMatchPattern;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangDo;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatchStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetryTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRollback;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangIntersectionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangTableTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class IsolationAnalyzer
extends BLangNodeVisitor {
    private static final CompilerContext.Key<IsolationAnalyzer> ISOLATION_ANALYZER_KEY = new CompilerContext.Key();
    private static final String VALUE_LANG_LIB = "lang.value";
    private static final String CLONE_LANG_LIB_METHOD = "clone";
    private static final String CLONE_READONLY_LANG_LIB_METHOD = "cloneReadOnly";
    private SymbolEnv env;
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final Names names;
    private final Types types;
    private final BLangDiagnosticLog dlog;
    private boolean inferredIsolated = true;
    private boolean inLockStatement = false;
    private boolean inIsolatedStartAction = false;
    private final Deque<LockInfo> copyInLockInfoStack = new ArrayDeque<LockInfo>();
    private final Deque<Set<BSymbol>> isolatedLetVarStack = new ArrayDeque<Set<BSymbol>>();
    private final Map<BSymbol, IsolationInferenceInfo> isolationInferenceInfoMap = new HashMap<BSymbol, IsolationInferenceInfo>();
    private final Map<BLangArrowFunction, BInvokableSymbol> arrowFunctionTempSymbolMap = new HashMap<BLangArrowFunction, BInvokableSymbol>();

    private IsolationAnalyzer(CompilerContext context) {
        context.put(ISOLATION_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
    }

    public static IsolationAnalyzer getInstance(CompilerContext context) {
        IsolationAnalyzer isolationAnalyzer = context.get(ISOLATION_ANALYZER_KEY);
        if (isolationAnalyzer == null) {
            isolationAnalyzer = new IsolationAnalyzer(context);
        }
        return isolationAnalyzer;
    }

    private void analyzeNode(BLangNode node, SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        if (node != null) {
            node.accept(this);
        }
        this.env = prevEnv;
    }

    public BLangPackage analyze(BLangPackage pkgNode) {
        this.arrowFunctionTempSymbolMap.clear();
        this.isolationInferenceInfoMap.clear();
        this.dlog.setCurrentPackageId(pkgNode.packageID);
        pkgNode.accept(this);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.ISOLATION_ANALYZE)) {
            return;
        }
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(pkgNode.symbol);
        List<BLangVariable> moduleLevelVariables = pkgNode.globalVars;
        Set<BSymbol> moduleLevelVarSymbols = this.getModuleLevelVarSymbols(moduleLevelVariables);
        this.populateNonPublicMutableOrNonIsolatedVars(moduleLevelVarSymbols);
        List<BLangClassDefinition> classDefinitions = pkgNode.classDefinitions;
        this.populateNonPublicIsolatedInferableClasses(classDefinitions);
        for (BLangTypeDefinition typeDefinition : pkgNode.typeDefinitions) {
            this.analyzeNode(typeDefinition.typeNode, pkgEnv);
        }
        for (BLangClassDefinition classDefinition : pkgNode.classDefinitions) {
            if (classDefinition.flagSet.contains((Object)Flag.ANONYMOUS) && this.isIsolated(classDefinition.getBType().getFlags())) {
                classDefinition.flagSet.add(Flag.ISOLATED);
                classDefinition.symbol.flags |= 0x20000000L;
            }
            this.analyzeNode(classDefinition, pkgEnv);
        }
        for (BLangFunction function : pkgNode.functions) {
            if (this.isWorkerLambda(function)) continue;
            this.analyzeNode(function, pkgEnv);
        }
        for (BLangVariable globalVar : moduleLevelVariables) {
            this.analyzeNode(globalVar, pkgEnv);
        }
        this.inferIsolation(moduleLevelVarSymbols, this.getPubliclyExposedObjectTypes(pkgNode), classDefinitions, moduleLevelVariables);
        this.logServiceIsolationHints(classDefinitions);
        this.arrowFunctionTempSymbolMap.clear();
        this.isolationInferenceInfoMap.clear();
        for (BLangTestablePackage testablePkg : pkgNode.testablePkgs) {
            this.visit((BLangPackage)testablePkg);
        }
        pkgNode.completedPhases.add(CompilerPhase.ISOLATION_ANALYZE);
    }

    @Override
    public void visit(BLangCompilationUnit compUnit) {
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangResourceFunction funcNode) {
        this.visit((BLangFunction)funcNode);
    }

    @Override
    public void visit(BLangFunction funcNode) {
        boolean prevInferredIsolated = this.inferredIsolated;
        this.inferredIsolated = true;
        IsolationInferenceInfo functionIsolationInferenceInfo = null;
        BInvokableSymbol symbol = funcNode.symbol;
        if (this.isIsolationInferableFunction(funcNode) && !this.isolationInferenceInfoMap.containsKey(symbol)) {
            functionIsolationInferenceInfo = new IsolationInferenceInfo();
            this.isolationInferenceInfoMap.put(symbol, functionIsolationInferenceInfo);
        }
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(funcNode, symbol.scope, this.env);
        for (BLangSimpleVariable requiredParam : funcNode.requiredParams) {
            if (!requiredParam.symbol.isDefaultable) continue;
            this.analyzeNode(requiredParam.expr, funcEnv);
        }
        this.analyzeNode(funcNode.body, funcEnv);
        if (this.inferredIsolated && !this.isIsolated(symbol.flags) && functionIsolationInferenceInfo != null && functionIsolationInferenceInfo.dependsOnlyOnInferableConstructs && !funcNode.objInitFunction) {
            functionIsolationInferenceInfo.inferredIsolated = true;
        }
        this.inferredIsolated = this.inferredIsolated && prevInferredIsolated;
    }

    @Override
    public void visit(BLangBlockFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        for (BLangStatement statement : body.stmts) {
            this.analyzeNode(statement, bodyEnv);
        }
    }

    @Override
    public void visit(BLangExprFunctionBody body) {
        SymbolEnv bodyEnv = SymbolEnv.createFuncBodyEnv(body, this.env);
        this.analyzeNode(body.expr, bodyEnv);
    }

    @Override
    public void visit(BLangExternalFunctionBody body) {
        this.markDependsOnIsolationNonInferableConstructs();
        this.inferredIsolated = false;
    }

    @Override
    public void visit(BLangService serviceNode) {
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        this.analyzeNode(typeDefinition.typeNode, this.env);
    }

    @Override
    public void visit(BLangConstant constant) {
        BLangType typeNode = constant.typeNode;
        if (typeNode != null) {
            this.analyzeNode(typeNode, this.env);
        }
        this.analyzeNode(constant.expr, this.env);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        BLangType typeNode = varNode.typeNode;
        if (typeNode != null && (typeNode.getBType() == null || typeNode.getBType().tsymbol == null || typeNode.getBType().tsymbol.owner.getKind() != SymbolKind.PACKAGE)) {
            this.analyzeNode(typeNode, this.env);
        }
        BVarSymbol symbol = varNode.symbol;
        long flags = symbol.flags;
        BLangExpression expr = varNode.expr;
        BType fieldType = varNode.getBType();
        boolean isolatedClassField = this.isIsolatedClassField();
        if (isolatedClassField && this.isExpectedToBeAPrivateField(symbol, fieldType) && !Symbols.isFlagOn(flags, 1024L)) {
            this.dlog.error(varNode.pos, DiagnosticErrorCode.INVALID_NON_PRIVATE_MUTABLE_FIELD_IN_ISOLATED_OBJECT, new Object[0]);
        }
        if (expr == null) {
            return;
        }
        if (isolatedClassField || varNode.flagSet.contains((Object)Flag.ISOLATED)) {
            this.validateIsolatedExpression(fieldType, expr);
        }
        this.analyzeNode(expr, this.env);
        BSymbol owner = symbol.owner;
        if (owner != null && (owner.tag & 0x8000000L) == 0x8000000L && this.isIsolatedExpression(expr)) {
            this.isolatedLetVarStack.peek().add(symbol);
        }
        if (expr.getKind() == NodeKind.LAMBDA) {
            this.addIsolationInfoForWorkerVarNode(((BLangLambdaFunction)expr).function, symbol);
        }
    }

    private void addIsolationInfoForWorkerVarNode(BLangFunction workerFunc, BVarSymbol workerVarSymbol) {
        if (workerFunc.flagSet.contains((Object)Flag.WORKER) && workerFunc.flagSet.contains((Object)Flag.LAMBDA) && this.isolationInferenceInfoMap.containsKey(workerFunc.symbol)) {
            IsolationInferenceInfo functionIsolationInferenceInfo = this.isolationInferenceInfoMap.get(workerFunc.symbol);
            this.isolationInferenceInfoMap.put(workerVarSymbol, functionIsolationInferenceInfo);
        }
    }

    @Override
    public void visit(BLangIdentifier identifierNode) {
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
    }

    @Override
    public void visit(BLangAnnotationAttachment annAttachmentNode) {
        BLangExpression expr = annAttachmentNode.expr;
        if (expr != null) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangBlockStmt blockNode) {
        SymbolEnv blockEnv = SymbolEnv.createBlockEnv(blockNode, this.env);
        for (BLangStatement statement : blockNode.stmts) {
            this.analyzeNode(statement, blockEnv);
        }
    }

    @Override
    public void visit(BLangSimpleVariableDef varDefNode) {
        BLangSimpleVariable var = varDefNode.var;
        if (var.expr == null) {
            if (var.typeNode != null) {
                this.analyzeNode(var.typeNode, this.env);
            }
            return;
        }
        this.analyzeNode(var, this.env);
    }

    @Override
    public void visit(BLangAssignment assignNode) {
        BLangExpression varRef = assignNode.varRef;
        this.analyzeNode(varRef, this.env);
        BLangExpression expr = assignNode.expr;
        this.analyzeNode(expr, this.env);
        BLangInvokableNode enclInvokable = this.env.enclInvokable;
        if (varRef.getKind() == NodeKind.FIELD_BASED_ACCESS_EXPR) {
            BLangFieldBasedAccess fieldAccess = (BLangFieldBasedAccess)varRef;
            if (enclInvokable != null && enclInvokable.getKind() == NodeKind.FUNCTION && ((BLangFunction)enclInvokable).objInitFunction && this.isIsolatedObjectFieldOrMethodAccessViaSelf(fieldAccess, false)) {
                this.validateIsolatedExpression(((BField)((BObjectType)enclInvokable.symbol.owner.type).fields.get((Object)fieldAccess.field.value)).type, expr);
            }
        }
        this.validateTransferOut(varRef, expr);
    }

    @Override
    public void visit(BLangCompoundAssignment compoundAssignNode) {
        this.analyzeNode(compoundAssignNode.varRef, this.env);
        this.analyzeNode(compoundAssignNode.expr, this.env);
    }

    @Override
    public void visit(BLangRetry retryNode) {
        this.analyzeNode(retryNode.retrySpec, this.env);
        this.analyzeNode(retryNode.retryBody, this.env);
    }

    @Override
    public void visit(BLangRetryTransaction retryTransaction) {
        this.analyzeNode(retryTransaction.retrySpec, this.env);
        this.analyzeNode(retryTransaction.transaction, this.env);
    }

    @Override
    public void visit(BLangRetrySpec retrySpec) {
        for (BLangExpression argExpr : retrySpec.argExprs) {
            this.analyzeNode(argExpr, this.env);
        }
    }

    @Override
    public void visit(BLangContinue continueNode) {
    }

    @Override
    public void visit(BLangBreak breakNode) {
    }

    @Override
    public void visit(BLangReturn returnNode) {
        BLangExpression expr = returnNode.expr;
        this.analyzeNode(expr, this.env);
        if (!this.inLockStatement) {
            return;
        }
        this.validateTransferOut(expr, this.copyInLockInfoStack.peek().nonIsolatedTransferOutExpressions);
    }

    @Override
    public void visit(BLangPanic panicNode) {
        this.analyzeNode(panicNode.expr, this.env);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.analyzeNode(xmlnsStmtNode.xmlnsDecl, this.env);
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        this.analyzeNode(exprStmtNode.expr, this.env);
    }

    @Override
    public void visit(BLangIf ifNode) {
        this.analyzeNode(ifNode.expr, this.env);
        this.analyzeNode(ifNode.body, this.env);
        this.analyzeNode(ifNode.elseStmt, this.env);
    }

    @Override
    public void visit(BLangQueryAction queryAction) {
        for (BLangNode clause : queryAction.getQueryClauses()) {
            this.analyzeNode(clause, this.env);
        }
        this.analyzeNode(queryAction.doClause, this.env);
    }

    @Override
    public void visit(BLangMatchStatement matchStatement) {
        this.analyzeNode(matchStatement.expr, this.env);
        for (BLangMatchClause matchClause : matchStatement.matchClauses) {
            this.analyzeNode(matchClause, this.env);
        }
        if (matchStatement.onFailClause != null) {
            this.analyzeNode(matchStatement.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangMatchGuard matchGuard) {
        this.analyzeNode(matchGuard.expr, this.env);
    }

    @Override
    public void visit(BLangConstPattern constMatchPattern) {
        this.analyzeNode(constMatchPattern.expr, this.env);
    }

    @Override
    public void visit(BLangWildCardMatchPattern wildCardMatchPattern) {
    }

    @Override
    public void visit(BLangListMatchPattern listMatchPattern) {
        for (BLangMatchPattern matchPattern : listMatchPattern.matchPatterns) {
            this.analyzeNode(matchPattern, this.env);
        }
        if (listMatchPattern.restMatchPattern != null) {
            this.analyzeNode(listMatchPattern.restMatchPattern, this.env);
        }
    }

    @Override
    public void visit(BLangRestMatchPattern restMatchPattern) {
    }

    @Override
    public void visit(BLangMappingMatchPattern mappingMatchPattern) {
        for (BLangFieldMatchPattern fieldMatchPattern : mappingMatchPattern.fieldMatchPatterns) {
            this.analyzeNode(fieldMatchPattern, this.env);
        }
    }

    @Override
    public void visit(BLangFieldMatchPattern fieldMatchPattern) {
        this.analyzeNode(fieldMatchPattern.fieldName, this.env);
        this.analyzeNode(fieldMatchPattern.matchPattern, this.env);
    }

    @Override
    public void visit(BLangWildCardBindingPattern wildCardBindingPattern) {
    }

    @Override
    public void visit(BLangVarBindingPatternMatchPattern varBindingPattern) {
        this.analyzeNode(varBindingPattern.getBindingPattern(), this.env);
    }

    @Override
    public void visit(BLangCaptureBindingPattern captureBindingPattern) {
    }

    @Override
    public void visit(BLangErrorBindingPattern errorBindingPattern) {
        this.analyzeNode(errorBindingPattern.errorMessageBindingPattern, this.env);
        this.analyzeNode(errorBindingPattern.errorCauseBindingPattern, this.env);
        this.analyzeNode(errorBindingPattern.errorFieldBindingPatterns, this.env);
    }

    @Override
    public void visit(BLangErrorMessageBindingPattern errorMessageBindingPattern) {
        this.analyzeNode(errorMessageBindingPattern.simpleBindingPattern, this.env);
    }

    @Override
    public void visit(BLangSimpleBindingPattern simpleBindingPattern) {
        this.analyzeNode(simpleBindingPattern.wildCardBindingPattern, this.env);
        this.analyzeNode(simpleBindingPattern.captureBindingPattern, this.env);
    }

    @Override
    public void visit(BLangErrorCauseBindingPattern errorCauseBindingPattern) {
        this.analyzeNode(errorCauseBindingPattern.simpleBindingPattern, this.env);
        this.analyzeNode(errorCauseBindingPattern.errorBindingPattern, this.env);
    }

    @Override
    public void visit(BLangErrorFieldBindingPatterns errorFieldBindingPatterns) {
        for (BLangNamedArgBindingPattern namedArgBindingPattern : errorFieldBindingPatterns.namedArgBindingPatterns) {
            this.analyzeNode(namedArgBindingPattern, this.env);
        }
        this.analyzeNode(errorFieldBindingPatterns.restBindingPattern, this.env);
    }

    @Override
    public void visit(BLangNamedArgBindingPattern namedArgBindingPattern) {
        this.analyzeNode(namedArgBindingPattern.argName, this.env);
        this.analyzeNode(namedArgBindingPattern.bindingPattern, this.env);
    }

    @Override
    public void visit(BLangErrorMatchPattern errorMatchPattern) {
        this.analyzeNode(errorMatchPattern.errorMessageMatchPattern, this.env);
        this.analyzeNode(errorMatchPattern.errorCauseMatchPattern, this.env);
        this.analyzeNode(errorMatchPattern.errorFieldMatchPatterns, this.env);
    }

    @Override
    public void visit(BLangErrorMessageMatchPattern errorMessageMatchPattern) {
        this.analyzeNode(errorMessageMatchPattern.simpleMatchPattern, this.env);
    }

    @Override
    public void visit(BLangSimpleMatchPattern simpleMatchPattern) {
        this.analyzeNode(simpleMatchPattern.wildCardMatchPattern, this.env);
        this.analyzeNode(simpleMatchPattern.constPattern, this.env);
        this.analyzeNode(simpleMatchPattern.varVariableName, this.env);
    }

    @Override
    public void visit(BLangErrorCauseMatchPattern errorCauseMatchPattern) {
        this.analyzeNode(errorCauseMatchPattern.simpleMatchPattern, this.env);
        this.analyzeNode(errorCauseMatchPattern.errorMatchPattern, this.env);
    }

    @Override
    public void visit(BLangErrorFieldMatchPatterns errorFieldMatchPatterns) {
        for (BLangNamedArgMatchPattern namedArgMatchPattern : errorFieldMatchPatterns.namedArgMatchPatterns) {
            this.analyzeNode(namedArgMatchPattern, this.env);
        }
        this.analyzeNode(errorFieldMatchPatterns.restMatchPattern, this.env);
    }

    @Override
    public void visit(BLangNamedArgMatchPattern namedArgMatchPattern) {
        this.analyzeNode(namedArgMatchPattern.argName, this.env);
        this.analyzeNode(namedArgMatchPattern.matchPattern, this.env);
    }

    @Override
    public void visit(BLangListBindingPattern listBindingPattern) {
        for (BLangBindingPattern bindingPattern : listBindingPattern.bindingPatterns) {
            this.analyzeNode(bindingPattern, this.env);
        }
    }

    @Override
    public void visit(BLangRestBindingPattern restBindingPattern) {
    }

    @Override
    public void visit(BLangMappingBindingPattern mappingBindingPattern) {
        for (BLangFieldBindingPattern fieldBindingPattern : mappingBindingPattern.fieldBindingPatterns) {
            this.analyzeNode(fieldBindingPattern, this.env);
        }
    }

    @Override
    public void visit(BLangFieldBindingPattern fieldBindingPattern) {
        this.analyzeNode(fieldBindingPattern.fieldName, this.env);
        this.analyzeNode(fieldBindingPattern.bindingPattern, this.env);
    }

    @Override
    public void visit(BLangMatchClause matchClause) {
        for (BLangMatchPattern matchPattern : matchClause.matchPatterns) {
            this.analyzeNode(matchPattern, this.env);
        }
        BLangMatchGuard matchGuard = matchClause.matchGuard;
        if (matchGuard != null) {
            this.analyzeNode(matchGuard, this.env);
        }
        this.analyzeNode(matchClause.blockStmt, this.env);
    }

    @Override
    public void visit(BLangForeach foreach) {
        this.analyzeNode(foreach.collection, this.env);
        this.analyzeNode(foreach.body, this.env);
        BLangOnFailClause onFailClause = foreach.onFailClause;
        if (onFailClause != null) {
            this.analyzeNode(onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangFromClause fromClause) {
        SymbolEnv fromEnv = fromClause.env;
        this.analyzeNode((BLangNode)((Object)fromClause.getVariableDefinitionNode()), fromEnv);
        this.analyzeNode(fromClause.collection, fromEnv);
    }

    @Override
    public void visit(BLangJoinClause joinClause) {
        SymbolEnv joinEnv = joinClause.env;
        this.analyzeNode((BLangNode)((Object)joinClause.getVariableDefinitionNode()), joinEnv);
        this.analyzeNode(joinClause.collection, joinEnv);
        this.analyzeNode(joinClause.onClause, joinEnv);
    }

    @Override
    public void visit(BLangLetClause letClause) {
        SymbolEnv letClauseEnv = letClause.env;
        for (BLangLetVariable letVarDeclaration : letClause.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVarDeclaration.definitionNode), letClauseEnv);
        }
    }

    @Override
    public void visit(BLangOnClause onClause) {
        this.analyzeNode(onClause.lhsExpr, this.env);
        this.analyzeNode(onClause.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangOrderKey orderKeyClause) {
        this.analyzeNode(orderKeyClause.expression, this.env);
    }

    @Override
    public void visit(BLangOrderByClause orderByClause) {
        SymbolEnv orderByEnv = orderByClause.env;
        for (OrderKeyNode orderKeyNode : orderByClause.orderByKeyList) {
            this.analyzeNode((BLangExpression)orderKeyNode.getOrderKey(), orderByEnv);
        }
    }

    @Override
    public void visit(BLangGroupByClause groupByClause) {
        SymbolEnv orderByEnv = groupByClause.env;
        for (BLangGroupingKey groupingKeyNode : groupByClause.groupingKeyList) {
            this.analyzeNode(groupingKeyNode, orderByEnv);
        }
    }

    @Override
    public void visit(BLangGroupingKey groupingKey) {
    }

    @Override
    public void visit(BLangSelectClause selectClause) {
        this.analyzeNode(selectClause.expression, selectClause.env);
    }

    @Override
    public void visit(BLangCollectClause bLangCollectClause) {
        this.analyzeNode(bLangCollectClause.expression, this.env);
    }

    @Override
    public void visit(BLangWhereClause whereClause) {
        this.analyzeNode(whereClause.expression, whereClause.env);
    }

    @Override
    public void visit(BLangDoClause doClause) {
        this.analyzeNode(doClause.body, doClause.env);
    }

    @Override
    public void visit(BLangOnFailClause onFailClause) {
        this.analyzeNode(onFailClause.body, this.env);
    }

    @Override
    public void visit(BLangOnConflictClause onConflictClause) {
        this.analyzeNode(onConflictClause.expression, this.env);
    }

    @Override
    public void visit(BLangLimitClause limitClause) {
        this.analyzeNode(limitClause.expression, this.env);
    }

    @Override
    public void visit(BLangWhile whileNode) {
        this.analyzeNode(whileNode.expr, this.env);
        this.analyzeNode(whileNode.body, this.env);
        BLangOnFailClause onFailClause = whileNode.onFailClause;
        if (onFailClause != null) {
            this.analyzeNode(onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangLock lockNode) {
        boolean prevInLockStatement = this.inLockStatement;
        this.inLockStatement = true;
        this.copyInLockInfoStack.push(new LockInfo(lockNode));
        this.analyzeNode(lockNode.body, SymbolEnv.createLockEnv(lockNode, this.env));
        LockInfo copyInLockInfo = this.copyInLockInfoStack.pop();
        this.inLockStatement = prevInLockStatement;
        BLangOnFailClause onFailClause = lockNode.onFailClause;
        if (onFailClause != null) {
            this.analyzeNode(onFailClause, this.env);
        }
        Map<BSymbol, List<BLangSimpleVarRef>> accessedRestrictedVars = copyInLockInfo.accessedRestrictedVars;
        Set<BSymbol> accessedRestrictedVarKeys = accessedRestrictedVars.keySet();
        Set<BSymbol> accessedNonImmutableAndNonIsolatedVars = copyInLockInfo.accessedPotentiallyIsolatedVars;
        if (!accessedRestrictedVarKeys.isEmpty()) {
            if (accessedRestrictedVarKeys.size() > 1) {
                for (BSymbol accessedRestrictedVarKey : accessedRestrictedVarKeys) {
                    for (BLangSimpleVarRef varRef : accessedRestrictedVars.get(accessedRestrictedVarKey)) {
                        this.dlog.error(varRef.pos, DiagnosticErrorCode.INVALID_USAGE_OF_MULTIPLE_RESTRICTED_VARS_IN_LOCK, new Object[0]);
                    }
                }
            }
            for (BLangSimpleVarRef varRef : copyInLockInfo.nonCaptureBindingPatternVarRefsOnLhs) {
                this.dlog.error(varRef.pos, DiagnosticErrorCode.INVALID_ASSIGNMENT_IN_LOCK_WITH_RESTRICTED_VAR_USAGE, new Object[0]);
            }
            for (BLangExpression expr : copyInLockInfo.nonIsolatedTransferInExpressions) {
                this.dlog.error(expr.pos, DiagnosticErrorCode.INVALID_TRANSFER_INTO_LOCK_WITH_RESTRICTED_VAR_USAGE, new Object[0]);
            }
            for (BLangExpression expr : copyInLockInfo.nonIsolatedTransferOutExpressions) {
                this.dlog.error(expr.pos, DiagnosticErrorCode.INVALID_TRANSFER_OUT_OF_LOCK_WITH_RESTRICTED_VAR_USAGE, new Object[0]);
            }
            for (BLangInvocation invocation : copyInLockInfo.nonIsolatedInvocations) {
                this.dlog.error(invocation.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INVOCATION_IN_LOCK_WITH_RESTRICTED_VAR_USAGE, new Object[0]);
            }
        }
        if (this.copyInLockInfoStack.isEmpty()) {
            return;
        }
        BLangLock lastCheckedLockNode = lockNode;
        for (LockInfo prevCopyInLockInfo : this.copyInLockInfoStack) {
            BLangLock outerLockNode = prevCopyInLockInfo.lockNode;
            if (!this.isEnclosedLockWithinSameFunction(lastCheckedLockNode, outerLockNode)) {
                return;
            }
            lastCheckedLockNode = outerLockNode;
            Map<BSymbol, List<BLangSimpleVarRef>> prevLockAccessedRestrictedVars = prevCopyInLockInfo.accessedRestrictedVars;
            for (Map.Entry<BSymbol, List<BLangSimpleVarRef>> entry : accessedRestrictedVars.entrySet()) {
                BSymbol key = entry.getKey();
                if (prevLockAccessedRestrictedVars.containsKey(key)) {
                    prevLockAccessedRestrictedVars.get(key).addAll((Collection<BLangSimpleVarRef>)entry.getValue());
                    continue;
                }
                prevLockAccessedRestrictedVars.put(key, entry.getValue());
            }
            prevCopyInLockInfo.accessedPotentiallyIsolatedVars.addAll(accessedNonImmutableAndNonIsolatedVars);
            if (!accessedRestrictedVars.isEmpty()) continue;
            prevCopyInLockInfo.nonCaptureBindingPatternVarRefsOnLhs.addAll(copyInLockInfo.nonCaptureBindingPatternVarRefsOnLhs);
            prevCopyInLockInfo.nonIsolatedTransferInExpressions.addAll(copyInLockInfo.nonIsolatedTransferInExpressions);
            prevCopyInLockInfo.nonIsolatedTransferOutExpressions.addAll(copyInLockInfo.nonIsolatedTransferOutExpressions);
            prevCopyInLockInfo.nonIsolatedInvocations.addAll(copyInLockInfo.nonIsolatedInvocations);
            prevCopyInLockInfo.accessedPotentiallyIsolatedVars.addAll(copyInLockInfo.accessedPotentiallyIsolatedVars);
        }
    }

    @Override
    public void visit(BLangTransaction transactionNode) {
        this.analyzeNode(transactionNode.transactionBody, this.env);
    }

    @Override
    public void visit(BLangTupleDestructure stmt) {
        BLangTupleVarRef varRef = stmt.varRef;
        BLangExpression expr = stmt.expr;
        this.analyzeNode(varRef, this.env);
        this.analyzeNode(expr, this.env);
        this.validateTransferOut((BLangExpression)varRef, expr);
    }

    @Override
    public void visit(BLangRecordDestructure stmt) {
        BLangRecordVarRef varRef = stmt.varRef;
        BLangExpression expr = stmt.expr;
        this.analyzeNode(varRef, this.env);
        this.analyzeNode(expr, this.env);
        this.validateTransferOut((BLangExpression)varRef, expr);
    }

    @Override
    public void visit(BLangErrorDestructure stmt) {
        BLangErrorVarRef varRef = stmt.varRef;
        BLangExpression expr = stmt.expr;
        this.analyzeNode(varRef, this.env);
        this.analyzeNode(expr, this.env);
        this.validateTransferOut((BLangExpression)varRef, expr);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr) {
    }

    @Override
    public void visit(BLangAlternateWorkerReceive altWorkerReceive) {
        for (BLangWorkerReceive workerReceive : altWorkerReceive.getWorkerReceives()) {
            this.analyzeNode(workerReceive, this.env);
        }
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive) {
        for (BLangMultipleWorkerReceive.BLangReceiveField rvField : multipleWorkerReceive.getReceiveFields()) {
            this.analyzeNode(rvField.getKey(), this.env);
            this.analyzeNode(rvField.getWorkerReceive(), this.env);
        }
    }

    @Override
    public void visit(BLangWorkerReceive workerReceiveNode) {
    }

    @Override
    public void visit(BLangRollback rollbackNode) {
        this.analyzeNode(rollbackNode.expr, this.env);
    }

    @Override
    public void visit(BLangLiteral literalExpr) {
    }

    @Override
    public void visit(BLangConstRef constRef) {
    }

    @Override
    public void visit(BLangNumericLiteral literalExpr) {
    }

    @Override
    public void visit(BLangRecordLiteral recordLiteral) {
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                if (keyValuePair.key.computedKey) {
                    this.analyzeNode(keyValuePair.key.expr, this.env);
                }
                this.analyzeNode(keyValuePair.valueExpr, this.env);
                continue;
            }
            if (field.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                this.analyzeNode((BLangRecordLiteral.BLangRecordVarNameField)field, this.env);
                continue;
            }
            this.analyzeNode(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr, this.env);
        }
    }

    @Override
    public void visit(BLangTupleVarRef varRefExpr) {
        for (BLangExpression expression : varRefExpr.expressions) {
            this.analyzeNode(expression, this.env);
        }
        BLangExpression restParam = varRefExpr.restParam;
        if (restParam != null) {
            this.analyzeNode(restParam, this.env);
        }
    }

    @Override
    public void visit(BLangRecordVarRef varRefExpr) {
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue recordRefField : varRefExpr.recordRefFields) {
            this.analyzeNode(recordRefField.variableReference, this.env);
        }
        BLangExpression restParam = varRefExpr.restParam;
        if (restParam != null) {
            this.analyzeNode(restParam, this.env);
        }
    }

    @Override
    public void visit(BLangErrorVarRef varRefExpr) {
        BLangType typeNode;
        this.analyzeNode(varRefExpr.message, this.env);
        BLangVariableReference cause = varRefExpr.cause;
        if (cause != null) {
            this.analyzeNode(cause, this.env);
        }
        for (BLangNamedArgsExpression namedArgsExpression : varRefExpr.detail) {
            this.analyzeNode(namedArgsExpression, this.env);
        }
        BLangVariableReference restVar = varRefExpr.restVar;
        if (restVar != null) {
            this.analyzeNode(restVar, this.env);
        }
        if ((typeNode = varRefExpr.typeNode) != null) {
            this.analyzeNode(typeNode, this.env);
        }
    }

    @Override
    public void visit(BLangSimpleVarRef varRefExpr) {
        BLangFunction initFunction;
        BType accessType = varRefExpr.getBType();
        BSymbol symbol = varRefExpr.symbol;
        BLangInvokableNode enclInvokable = this.env.enclInvokable;
        BLangType enclType = this.env.enclType;
        if (symbol == null) {
            return;
        }
        BLangNode parent = varRefExpr.parent;
        boolean isolatedModuleVariableReference = this.isIsolatedModuleVariableSymbol(symbol);
        boolean accessOfPotentiallyIsolatedVariable = false;
        boolean accessOfPotentiallyReadOnlyOrIsolatedObjectTypedFinalVariable = false;
        HashSet<BSymbol> inferableClasses = new HashSet<BSymbol>();
        if ((symbol.owner.tag & 0x1001L) == 4097L) {
            accessOfPotentiallyIsolatedVariable = this.isolationInferenceInfoMap.containsKey(symbol) && this.isolationInferenceInfoMap.get(symbol).getKind() != IsolationInferenceKind.FUNCTION;
            boolean bl = accessOfPotentiallyReadOnlyOrIsolatedObjectTypedFinalVariable = Symbols.isFlagOn(symbol.flags, 4L) && !this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(accessType) && this.isSubtypeOfReadOnlyOrIsolatedObjectOrInferableObject(symbol.owner, accessType, inferableClasses);
        }
        if (this.inLockStatement) {
            LockInfo exprInfo = this.copyInLockInfoStack.peek();
            if (isolatedModuleVariableReference || this.isMethodCallOnSelfInIsolatedObject(varRefExpr, parent)) {
                this.addToAccessedRestrictedVars(exprInfo.accessedRestrictedVars, varRefExpr);
            }
            if (parent == null && varRefExpr.isLValue) {
                if (!this.isSelfOfObject(varRefExpr) && this.isInvalidCopyIn(varRefExpr, this.env)) {
                    exprInfo.nonCaptureBindingPatternVarRefsOnLhs.add(varRefExpr);
                }
            } else if (!(varRefExpr.isLValue && parent.getKind() == NodeKind.ASSIGNMENT || this.isIsolated(varRefExpr.symbol.flags) || this.isSelfOfIsolatedObject(varRefExpr) || !this.isInvalidCopyIn(varRefExpr, this.env))) {
                exprInfo.nonIsolatedTransferInExpressions.add(varRefExpr);
            }
            if (accessOfPotentiallyIsolatedVariable) {
                ((VariableIsolationInferenceInfo)this.isolationInferenceInfoMap.get((Object)symbol)).accessedLockInfo.add(exprInfo);
                exprInfo.accessedPotentiallyIsolatedVars.add(symbol);
            }
        } else if (accessOfPotentiallyIsolatedVariable || accessOfPotentiallyReadOnlyOrIsolatedObjectTypedFinalVariable) {
            VariableIsolationInferenceInfo inferenceInfo = (VariableIsolationInferenceInfo)this.isolationInferenceInfoMap.get(symbol);
            inferenceInfo.accessedOutsideLockStatement = true;
            inferenceInfo.accessOutsideLockStatementValidIfInferredIsolated = false;
            if (accessOfPotentiallyReadOnlyOrIsolatedObjectTypedFinalVariable) {
                inferenceInfo.dependsOnVariablesAndClasses.addAll(inferableClasses);
            }
        }
        boolean inIsolatedFunction = this.isInIsolatedFunction(this.env);
        boolean recordFieldDefaultValue = this.isRecordFieldDefaultValue(enclType);
        boolean objectFieldDefaultValueRequiringIsolation = !recordFieldDefaultValue && this.isObjectFieldDefaultValueRequiringIsolation(this.env);
        SymbolEnv enclEnv = this.env.enclEnv;
        if (inIsolatedFunction && enclInvokable == null) {
            BLangArrowFunction bLangArrowFunction = (BLangArrowFunction)enclEnv.node;
            for (BLangSimpleVariable param : bLangArrowFunction.params) {
                if (param.symbol != symbol) continue;
                return;
            }
        }
        if (this.inIsolatedStartAction && !this.isSubtypeOfReadOnlyOrIsolatedObjectOrInferableObject(symbol.owner, symbol.getType())) {
            this.inferredIsolated = false;
            return;
        }
        if (!recordFieldDefaultValue && !objectFieldDefaultValueRequiringIsolation && enclInvokable != null && this.isReferenceToVarDefinedInSameInvokable(symbol.owner, enclInvokable.symbol)) {
            return;
        }
        long flags = symbol.flags;
        if (Symbols.isFlagOn(flags, 16384L)) {
            return;
        }
        if ((Symbols.isFlagOn(flags, 4L) || Symbols.isFlagOn(flags, 64L)) && this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(accessType)) {
            return;
        }
        if (this.isDefinitionReference(symbol)) {
            return;
        }
        if (enclEnv != null && enclEnv.node != null && enclEnv.node.getKind() == NodeKind.ARROW_EXPR) {
            BLangArrowFunction bLangArrowFunction = (BLangArrowFunction)enclEnv.node;
            for (BLangSimpleVariable param : bLangArrowFunction.params) {
                if (param.symbol != this.getOriginalSymbol(symbol)) continue;
                return;
            }
        }
        if (isolatedModuleVariableReference) {
            if (this.inLockStatement) {
                return;
            }
            if (recordFieldDefaultValue) {
                this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_ISOLATED_VARIABLE_ACCESS_OUTSIDE_LOCK_IN_RECORD_DEFAULT, new Object[0]);
            } else {
                this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_ISOLATED_VARIABLE_ACCESS_OUTSIDE_LOCK, new Object[0]);
            }
            return;
        }
        if (accessOfPotentiallyIsolatedVariable) {
            this.markDependentlyIsolatedOnVar(symbol);
        } else {
            this.markDependsOnIsolationNonInferableConstructs();
        }
        this.inferredIsolated = false;
        if (inIsolatedFunction) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_MUTABLE_ACCESS_IN_ISOLATED_FUNCTION, new Object[0]);
            return;
        }
        if (recordFieldDefaultValue) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_MUTABLE_ACCESS_AS_RECORD_DEFAULT, new Object[0]);
            return;
        }
        if (objectFieldDefaultValueRequiringIsolation) {
            this.dlog.error(varRefExpr.pos, DiagnosticErrorCode.INVALID_MUTABLE_ACCESS_AS_OBJECT_DEFAULT, new Object[0]);
            return;
        }
        if (this.isObjectFieldDefaultValue(this.env) && (initFunction = ((BLangClassDefinition)this.env.node).initFunction) != null) {
            this.markInitMethodDependentlyIsolatedOnVar(initFunction, symbol);
        }
    }

    @Override
    public void visit(BLangFieldBasedAccess fieldAccessExpr) {
        this.analyzeFieldBasedAccess(fieldAccessExpr);
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangPrefixedFieldBasedAccess prefixedFieldBasedAccess) {
        this.analyzeFieldBasedAccess(prefixedFieldBasedAccess);
    }

    private void analyzeFieldBasedAccess(BLangFieldBasedAccess fieldAccessExpr) {
        BLangExpression expr = fieldAccessExpr.expr;
        this.analyzeNode(expr, this.env);
        if (!this.isInvalidIsolatedObjectFieldOrMethodAccessViaSelfIfOutsideLock(fieldAccessExpr)) {
            BType bType = expr.getBType();
            BTypeSymbol tsymbol = bType.tsymbol;
            BLangIdentifier field = fieldAccessExpr.field;
            if (!this.isPotentiallyProtectedFieldAccessedRequiringLock(fieldAccessExpr, tsymbol, field)) {
                return;
            }
            if (this.inLockStatement) {
                LockInfo lockInfo = this.copyInLockInfoStack.peek();
                ((VariableIsolationInferenceInfo)this.isolationInferenceInfoMap.get((Object)tsymbol)).accessedLockInfo.add(lockInfo);
                lockInfo.accessedPotentiallyIsolatedVars.add(tsymbol);
                return;
            }
            VariableIsolationInferenceInfo inferenceInfo = (VariableIsolationInferenceInfo)this.isolationInferenceInfoMap.get(tsymbol);
            inferenceInfo.accessedOutsideLockStatement = true;
            BType fieldType = fieldAccessExpr.getBType();
            if (Symbols.isFlagOn(((BField)((BObjectType)bType).fields.get((Object)field.value)).symbol.flags, 4L) && this.isSubtypeOfReadOnlyOrIsolatedObjectOrInferableObject(this.env.enclPkg.symbol, fieldType)) {
                inferenceInfo.typesOfFinalFieldsAccessedOutsideLock.add(fieldType);
            } else {
                inferenceInfo.accessOutsideLockStatementValidIfInferredIsolated = false;
            }
            return;
        }
        if (this.inLockStatement) {
            this.addToAccessedRestrictedVars(this.copyInLockInfoStack.peek().accessedRestrictedVars, (BLangSimpleVarRef)expr);
            return;
        }
        this.dlog.error(fieldAccessExpr.pos, DiagnosticErrorCode.INVALID_MUTABLE_FIELD_ACCESS_IN_ISOLATED_OBJECT_OUTSIDE_LOCK, new Object[0]);
    }

    private boolean isPotentiallyProtectedFieldAccessedRequiringLock(BLangFieldBasedAccess fieldAccessExpr, BTypeSymbol tsymbol, BLangIdentifier field) {
        BLangExpression expr = fieldAccessExpr.expr;
        return expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && this.isSelfOfObject((BLangSimpleVarRef)expr) && this.isolationInferenceInfoMap.containsKey(tsymbol) && !this.isObjectFieldInitializationInInitMethod(fieldAccessExpr) && ((ClassIsolationInferenceInfo)this.isolationInferenceInfoMap.get((Object)tsymbol)).protectedFields.contains(field);
    }

    @Override
    public void visit(BLangIndexBasedAccess indexAccessExpr) {
        this.analyzeNode(indexAccessExpr.expr, this.env);
        this.analyzeNode(indexAccessExpr.indexExpr, this.env);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        this.analyzeInvocation(invocationExpr);
    }

    @Override
    public void visit(BLangCollectContextInvocation collectContextInvocation) {
        this.analyzeNode(collectContextInvocation.invocation, this.env);
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr) {
        for (BLangExpression positionalArg : errorConstructorExpr.positionalArgs) {
            this.analyzeNode(positionalArg, this.env);
        }
        for (BLangNamedArgsExpression namedArgsExpression : errorConstructorExpr.namedArgs) {
            this.analyzeNode(namedArgsExpression, this.env);
        }
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocationExpr) {
        boolean isWorker;
        if (!actionInvocationExpr.async) {
            this.analyzeInvocation(actionInvocationExpr);
            return;
        }
        boolean bl = isWorker = actionInvocationExpr.functionPointerInvocation && Symbols.isFlagOn(actionInvocationExpr.symbol.flags, 0x800000L);
        if (this.isInIsolatedFunction(this.env)) {
            if (this.checkStrandAnnotationExists(actionInvocationExpr.annAttachments, true, isWorker)) {
                return;
            }
            if (!isWorker && !this.isValidIsolatedAsyncInvocation(actionInvocationExpr)) {
                return;
            }
            this.analyzeInvocation(actionInvocationExpr);
            return;
        }
        if (this.checkStrandAnnotationExists(actionInvocationExpr.annAttachments, false, isWorker)) {
            this.markDependsOnIsolationNonInferableConstructs();
            this.inferredIsolated = false;
            return;
        }
        this.analyzeInvocation(actionInvocationExpr);
    }

    private boolean checkStrandAnnotationExists(List<BLangAnnotationAttachment> attachments, boolean inIsolatedFunc, boolean isWorker) {
        BAnnotationSymbol strandAnnotSymbol = this.symResolver.getStrandAnnotationSymbol();
        for (BLangAnnotationAttachment attachment : attachments) {
            if (attachment.annotationSymbol != strandAnnotSymbol) continue;
            if (inIsolatedFunc) {
                String actionInvocation = isWorker ? "worker declaration" : "start action";
                this.dlog.error(attachment.pos, DiagnosticErrorCode.INVALID_STRAND_ANNOTATION_IN_ISOLATED_FUNCTION, actionInvocation);
            } else {
                this.dlog.warning(attachment.pos, DiagnosticWarningCode.USAGE_OF_STRAND_ANNOTATION_WILL_BE_DEPRECATED, new Object[0]);
            }
            return true;
        }
        return false;
    }

    private boolean isValidIsolatedAsyncInvocation(BLangInvocation.BLangActionInvocation actionInvocation) {
        boolean isIsolatedStartAction = true;
        if (!this.isIsolated(actionInvocation.symbol.type.getFlags())) {
            this.dlog.error(actionInvocation.name.pos, DiagnosticErrorCode.INVALID_ASYNC_INVOCATION_OF_NON_ISOLATED_FUNCTION_IN_ISOLATED_FUNCTION, new Object[0]);
            isIsolatedStartAction = false;
        }
        if (actionInvocation.expr != null && !this.isIsolatedExpression(actionInvocation.expr)) {
            this.dlog.error(actionInvocation.expr.pos, DiagnosticErrorCode.INVALID_ACCESS_OF_NON_ISOLATED_EXPR_IN_ARGS_OF_ASYNC_INV_OF_ISOLATED_FUNC, new Object[0]);
            isIsolatedStartAction = false;
        }
        if (!this.containsIsolatedExpressionsForAllArgs(actionInvocation.requiredArgs)) {
            isIsolatedStartAction = false;
        }
        if (!this.containsIsolatedExpressionsForAllArgs(actionInvocation.restArgs)) {
            isIsolatedStartAction = false;
        }
        return isIsolatedStartAction;
    }

    private boolean containsIsolatedExpressionsForAllArgs(List<BLangExpression> args) {
        boolean containIsolatedExprs = true;
        for (BLangExpression arg : args) {
            if (this.isIsolatedExpression(arg)) continue;
            this.dlog.error(arg.pos, DiagnosticErrorCode.INVALID_ACCESS_OF_NON_ISOLATED_EXPR_IN_ARGS_OF_ASYNC_INV_OF_ISOLATED_FUNC, new Object[0]);
            containIsolatedExprs = false;
        }
        return containIsolatedExprs;
    }

    @Override
    public void visit(BLangInvocation.BLangResourceAccessInvocation resourceAccessInvocation) {
        this.analyzeNode(resourceAccessInvocation.resourceAccessPathSegments, this.env);
        this.analyzeInvocation(resourceAccessInvocation);
    }

    @Override
    public void visit(BLangTypeInit typeInitExpr) {
        BInvokableSymbol initInvocationSymbol = (BInvokableSymbol)((BLangInvocation)typeInitExpr.initInvocation).symbol;
        if (initInvocationSymbol != null && !this.isIsolated(initInvocationSymbol.flags)) {
            BLangFunction initFunction;
            this.analyzeFunctionForInference(initInvocationSymbol);
            this.inferredIsolated = false;
            if (this.isInIsolatedFunction(this.env.enclInvokable)) {
                this.dlog.error(typeInitExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INIT_EXPRESSION_IN_ISOLATED_FUNCTION, new Object[0]);
            } else if (this.isRecordFieldDefaultValue(this.env.enclType)) {
                this.dlog.error(typeInitExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INIT_EXPRESSION_AS_RECORD_DEFAULT, new Object[0]);
            } else if (this.isObjectFieldDefaultValueRequiringIsolation(this.env)) {
                this.dlog.error(typeInitExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INIT_EXPRESSION_AS_OBJECT_DEFAULT, new Object[0]);
            } else if (this.isObjectFieldDefaultValue(this.env) && (initFunction = ((BLangClassDefinition)this.env.node).initFunction) != null) {
                this.markInitMethodDependentlyIsolatedOnFunction(initFunction, initInvocationSymbol);
            }
        }
        for (BLangExpression expression : typeInitExpr.argsExpr) {
            this.analyzeNode(expression, this.env);
        }
    }

    @Override
    public void visit(BLangTernaryExpr ternaryExpr) {
        this.analyzeNode(ternaryExpr.expr, this.env);
        this.analyzeNode(ternaryExpr.thenExpr, this.env);
        this.analyzeNode(ternaryExpr.elseExpr, this.env);
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        for (BLangExpression expression : waitExpr.exprList) {
            this.analyzeNode(expression, this.env);
        }
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        this.analyzeNode(trapExpr.expr, this.env);
    }

    @Override
    public void visit(BLangBinaryExpr binaryExpr) {
        this.analyzeNode(binaryExpr.lhsExpr, this.env);
        this.analyzeNode(binaryExpr.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangElvisExpr elvisExpr) {
        this.analyzeNode(elvisExpr.lhsExpr, this.env);
        this.analyzeNode(elvisExpr.rhsExpr, this.env);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        this.analyzeNode(groupExpr.expression, this.env);
    }

    @Override
    public void visit(BLangLetExpression letExpr) {
        this.isolatedLetVarStack.push(new HashSet());
        for (BLangLetVariable letVarDeclaration : letExpr.letVarDeclarations) {
            this.analyzeNode((BLangNode)((Object)letVarDeclaration.definitionNode), this.env);
        }
        this.analyzeNode(letExpr.expr, this.env);
        this.isolatedLetVarStack.pop();
    }

    @Override
    public void visit(BLangListConstructorExpr listConstructorExpr) {
        for (BLangExpression expr : listConstructorExpr.exprs) {
            if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                expr = ((BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr).expr;
            }
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        for (BLangRecordLiteral recordLiteral : tableConstructorExpr.recordLiteralList) {
            this.analyzeNode(recordLiteral, this.env);
        }
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        this.analyzeNode(unaryExpr.expr, this.env);
    }

    @Override
    public void visit(BLangTypedescExpr typedescExpr) {
        this.analyzeNode(typedescExpr.typeNode, this.env);
    }

    @Override
    public void visit(BLangTypeConversionExpr conversionExpr) {
        this.analyzeNode(conversionExpr.typeNode, this.env);
        this.analyzeNode(conversionExpr.expr, this.env);
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
    }

    @Override
    public void visit(BLangXMLAttribute xmlAttribute) {
        this.analyzeNode(xmlAttribute.name, this.env);
        this.analyzeNode(xmlAttribute.value, this.env);
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        for (BLangExpression child : xmlElementLiteral.children) {
            this.analyzeNode(child, this.env);
        }
        for (BLangXMLAttribute attribute : xmlElementLiteral.attributes) {
            this.analyzeNode(attribute, this.env);
        }
        for (BLangXMLNS inlineNamespace : xmlElementLiteral.inlineNamespaces) {
            this.analyzeNode(inlineNamespace, this.env);
        }
    }

    @Override
    public void visit(BLangXMLSequenceLiteral xmlSequenceLiteral) {
        for (BLangExpression expr : xmlSequenceLiteral.xmlItems) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        for (BLangExpression expr : xmlTextLiteral.textFragments) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        for (BLangExpression textFragment : xmlCommentLiteral.textFragments) {
            this.analyzeNode(textFragment, this.env);
        }
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        for (BLangExpression dataFragment : xmlProcInsLiteral.dataFragments) {
            this.analyzeNode(dataFragment, this.env);
        }
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        for (BLangExpression textFragment : xmlQuotedString.textFragments) {
            this.analyzeNode(textFragment, this.env);
        }
    }

    @Override
    public void visit(BLangStringTemplateLiteral stringTemplateLiteral) {
        for (BLangExpression expr : stringTemplateLiteral.exprs) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangRawTemplateLiteral rawTemplateLiteral) {
        for (BLangExpression insertion : rawTemplateLiteral.insertions) {
            this.analyzeNode(insertion, this.env);
        }
    }

    @Override
    public void visit(BLangLambdaFunction bLangLambdaFunction) {
        BLangFunction function = bLangLambdaFunction.function;
        if (this.isWorkerLambda(function)) {
            this.visit(function);
        }
    }

    @Override
    public void visit(BLangArrowFunction bLangArrowFunction) {
        SymbolEnv arrowFunctionEnv = SymbolEnv.createArrowFunctionSymbolEnv(bLangArrowFunction, this.env);
        this.createTempSymbolIfNonExistent(bLangArrowFunction);
        this.analyzeNode(bLangArrowFunction.body, arrowFunctionEnv);
    }

    @Override
    public void visit(BLangRestArgsExpression bLangVarArgsExpression) {
        this.analyzeNode(bLangVarArgsExpression.expr, this.env);
    }

    @Override
    public void visit(BLangNamedArgsExpression bLangNamedArgsExpression) {
        this.analyzeNode(bLangNamedArgsExpression.expr, this.env);
    }

    @Override
    public void visit(BLangCheckedExpr checkedExpr) {
        this.analyzeNode(checkedExpr.expr, this.env);
    }

    @Override
    public void visit(BLangDo doNode) {
        this.analyzeNode(doNode.body, this.env);
        if (doNode.onFailClause != null) {
            this.analyzeNode(doNode.onFailClause, this.env);
        }
    }

    @Override
    public void visit(BLangFail failExpr) {
        this.analyzeNode(failExpr.expr, this.env);
    }

    @Override
    public void visit(BLangCheckPanickedExpr checkPanickedExpr) {
        this.analyzeNode(checkPanickedExpr.expr, this.env);
    }

    @Override
    public void visit(BLangServiceConstructorExpr serviceConstructorExpr) {
        this.analyzeNode(serviceConstructorExpr.serviceNode, this.env);
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        this.analyzeNode(typeTestExpr.expr, this.env);
        this.analyzeNode(typeTestExpr.typeNode, this.env);
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
    }

    @Override
    public void visit(BLangAnnotAccessExpr annotAccessExpr) {
        this.analyzeNode(annotAccessExpr.expr, this.env);
    }

    @Override
    public void visit(BLangQueryExpr queryExpr) {
        for (BLangNode clause : queryExpr.getQueryClauses()) {
            this.analyzeNode(clause, this.env);
        }
    }

    @Override
    public void visit(BLangTransactionalExpr transactionalExpr) {
    }

    @Override
    public void visit(BLangCommitExpr commitExpr) {
    }

    @Override
    public void visit(BLangValueType valueType) {
    }

    @Override
    public void visit(BLangArrayType arrayType) {
        this.analyzeNode(arrayType.getElementType(), this.env);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode builtInRefType) {
    }

    @Override
    public void visit(BLangConstrainedType constrainedType) {
        this.analyzeNode(constrainedType.constraint, this.env);
    }

    @Override
    public void visit(BLangStreamType streamType) {
        this.analyzeNode(streamType.constraint, this.env);
        this.analyzeNode(streamType.error, this.env);
    }

    @Override
    public void visit(BLangTableTypeNode tableType) {
        this.analyzeNode(tableType.constraint, this.env);
        if (tableType.tableKeyTypeConstraint != null) {
            this.analyzeNode(tableType.tableKeyTypeConstraint.keyType, this.env);
        }
    }

    @Override
    public void visit(BLangUserDefinedType userDefinedType) {
    }

    @Override
    public void visit(BLangFunctionTypeNode functionTypeNode) {
        for (BLangVariable bLangVariable : functionTypeNode.params) {
            this.analyzeNode(bLangVariable.typeNode, this.env);
        }
        if (functionTypeNode.restParam != null) {
            this.analyzeNode(functionTypeNode.restParam.typeNode, this.env);
        }
        this.analyzeNode(functionTypeNode.returnTypeNode, this.env);
    }

    @Override
    public void visit(BLangUnionTypeNode unionTypeNode) {
        for (BLangType memberTypeNode : unionTypeNode.memberTypeNodes) {
            this.analyzeNode(memberTypeNode, this.env);
        }
    }

    @Override
    public void visit(BLangIntersectionTypeNode intersectionTypeNode) {
        for (BLangType constituentTypeNode : intersectionTypeNode.constituentTypeNodes) {
            this.analyzeNode(constituentTypeNode, this.env);
        }
    }

    @Override
    public void visit(BLangObjectTypeNode objectTypeNode) {
        SymbolEnv objectEnv = SymbolEnv.createTypeEnv(objectTypeNode, objectTypeNode.symbol.scope, this.env);
        for (BLangSimpleVariable field : objectTypeNode.fields) {
            this.analyzeNode(field, objectEnv);
        }
        for (BLangSimpleVariable referencedField : objectTypeNode.includedFields) {
            this.analyzeNode(referencedField, objectEnv);
        }
        BLangFunction initFunction = objectTypeNode.initFunction;
        if (initFunction != null) {
            this.analyzeNode(initFunction, objectEnv);
        }
        for (BLangFunction function : objectTypeNode.functions) {
            this.analyzeNode(function, objectEnv);
        }
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        SymbolEnv classEnv = SymbolEnv.createClassEnv(classDefinition, classDefinition.symbol.scope, this.env);
        for (BLangSimpleVariable bLangSimpleVariable : classDefinition.fields) {
            this.analyzeNode(bLangSimpleVariable, classEnv);
        }
        for (BLangSimpleVariable field : classDefinition.referencedFields) {
            this.analyzeNode(field, classEnv);
        }
        BLangFunction initFunction = classDefinition.initFunction;
        if (initFunction != null) {
            this.analyzeNode(initFunction, classEnv);
        }
        for (BLangFunction function : classDefinition.functions) {
            this.analyzeNode(function, classEnv);
        }
    }

    @Override
    public void visit(BLangObjectConstructorExpression objectConstructorExpression) {
        this.visit(objectConstructorExpression.typeInit);
    }

    @Override
    public void visit(BLangInferredTypedescDefaultNode inferTypedescExpr) {
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        SymbolEnv typeEnv = SymbolEnv.createTypeEnv(recordTypeNode, recordTypeNode.symbol.scope, this.env);
        boolean prevInLockStatement = this.inLockStatement;
        this.inLockStatement = false;
        for (BLangSimpleVariable field : recordTypeNode.fields) {
            this.analyzeNode(field, typeEnv);
        }
        this.inLockStatement = prevInLockStatement;
        for (BLangSimpleVariable referencedField : recordTypeNode.includedFields) {
            this.analyzeNode(referencedField, typeEnv);
        }
        BLangType restFieldType = recordTypeNode.restFieldType;
        if (restFieldType != null) {
            this.analyzeNode(restFieldType, typeEnv);
        }
    }

    @Override
    public void visit(BLangFiniteTypeNode finiteTypeNode) {
        for (BLangExpression expression : finiteTypeNode.valueSpace) {
            this.analyzeNode(expression, this.env);
        }
    }

    @Override
    public void visit(BLangTupleTypeNode tupleTypeNode) {
        for (BLangType memberType : tupleTypeNode.getMemberTypeNodes()) {
            this.analyzeNode(memberType, this.env);
        }
        this.analyzeNode(tupleTypeNode.restParamType, this.env);
    }

    @Override
    public void visit(BLangErrorType errorTypeNode) {
        this.analyzeNode(errorTypeNode.detailType, this.env);
    }

    @Override
    public void visit(BLangTupleVariable bLangTupleVariable) {
        this.analyzeNode(bLangTupleVariable.typeNode, this.env);
        BLangExpression expr = bLangTupleVariable.expr;
        if (expr != null) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangTupleVariableDef bLangTupleVariableDef) {
        this.analyzeNode(bLangTupleVariableDef.var, this.env);
    }

    @Override
    public void visit(BLangRecordVariable bLangRecordVariable) {
        this.analyzeNode(bLangRecordVariable.typeNode, this.env);
        BLangExpression expr = bLangRecordVariable.expr;
        if (expr != null) {
            this.analyzeNode(expr, this.env);
        }
    }

    @Override
    public void visit(BLangRecordVariableDef bLangRecordVariableDef) {
        this.analyzeNode(bLangRecordVariableDef.var, this.env);
    }

    @Override
    public void visit(BLangErrorVariable bLangErrorVariable) {
        this.analyzeNode(bLangErrorVariable.typeNode, this.env);
        this.analyzeNode(bLangErrorVariable.expr, this.env);
        for (BLangErrorVariable.BLangErrorDetailEntry bLangErrorDetailEntry : bLangErrorVariable.detail) {
            this.analyzeNode(bLangErrorDetailEntry.valueBindingPattern, this.env);
        }
    }

    @Override
    public void visit(BLangErrorVariableDef bLangErrorVariableDef) {
        this.analyzeNode(bLangErrorVariableDef.errorVariable, this.env);
    }

    @Override
    public void visit(BLangWorkerFlushExpr workerFlushExpr) {
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSendExpr) {
    }

    @Override
    public void visit(BLangWaitForAllExpr waitForAllExpr) {
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyValuePair : waitForAllExpr.keyValuePairs) {
            this.analyzeNode(keyValuePair, this.env);
        }
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitKeyValue waitKeyValue) {
        BLangExpression valueExpr;
        BLangExpression keyExpr = waitKeyValue.keyExpr;
        if (keyExpr != null) {
            this.analyzeNode(keyExpr, this.env);
        }
        if ((valueExpr = waitKeyValue.valueExpr) != null) {
            this.analyzeNode(valueExpr, this.env);
        }
    }

    @Override
    public void visit(BLangXMLElementAccess xmlElementAccess) {
    }

    @Override
    public void visit(BLangXMLNavigationAccess xmlNavigation) {
    }

    @Override
    public void visit(BLangExtendedXMLNavigationAccess extendedXmlNavigationAccess) {
        extendedXmlNavigationAccess.extensions.forEach(extension -> this.analyzeNode((BLangNode)extension, this.env));
    }

    @Override
    public void visit(BLangXMLIndexedStepExtend xmlIndexedStepExtend) {
        this.analyzeNode(xmlIndexedStepExtend.indexExpr, this.env);
    }

    @Override
    public void visit(BLangXMLFilterStepExtend xmlFilterStepExtend) {
    }

    @Override
    public void visit(BLangXMLMethodCallStepExtend xmlMethodCallStepExtend) {
        this.analyzeNode(xmlMethodCallStepExtend.invocation, this.env);
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral) {
        List<BLangExpression> interpolationsList = this.symResolver.getListOfInterpolations(regExpTemplateLiteral.reDisjunction.sequenceList);
        interpolationsList.forEach(interpolation -> this.analyzeNode((BLangNode)interpolation, this.env));
    }

    private void analyzeInvocation(BLangInvocation invocationExpr) {
        BLangFunction initFunction;
        long flags;
        boolean inStartAction;
        BInvokableSymbol symbol;
        List<BLangExpression> requiredArgs = invocationExpr.requiredArgs;
        List<BLangExpression> restArgs = invocationExpr.restArgs;
        BLangExpression expr = invocationExpr.expr;
        if (expr != null && (requiredArgs.isEmpty() || requiredArgs.get(0) != expr)) {
            this.analyzeNode(expr, this.env);
        }
        if ((symbol = (BInvokableSymbol)invocationExpr.symbol) == null) {
            this.analyzeArgs(requiredArgs, restArgs);
            return;
        }
        boolean inIsolatedFunction = this.isInIsolatedFunction(this.env);
        boolean recordFieldDefaultValue = this.isRecordFieldDefaultValue(this.env.enclType);
        boolean objectFieldDefaultValueRequiringIsolation = this.isObjectFieldDefaultValueRequiringIsolation(this.env);
        boolean expectsIsolation = inIsolatedFunction || recordFieldDefaultValue || objectFieldDefaultValueRequiringIsolation;
        boolean isolatedFunctionCall = this.isIsolated(symbol.type.getFlags());
        boolean bl = inStartAction = invocationExpr.async && !invocationExpr.functionPointerInvocation;
        if (inStartAction) {
            this.analyzeFunctionInStartActionForInference(this.env, requiredArgs, restArgs, expr, symbol);
        }
        if (isolatedFunctionCall) {
            boolean prevInIsolationStartAction = this.inIsolatedStartAction;
            this.inIsolatedStartAction = inStartAction;
            this.analyzeArgIsolatedness(invocationExpr, requiredArgs, restArgs, symbol, expectsIsolation);
            this.inIsolatedStartAction = prevInIsolationStartAction;
            return;
        }
        this.analyzeArgs(requiredArgs, restArgs);
        if (this.inLockStatement) {
            this.copyInLockInfoStack.peek().nonIsolatedInvocations.add(invocationExpr);
        }
        if (Symbols.isFlagOn(flags = symbol.flags, 0x40000000L)) {
            return;
        }
        if (!inStartAction) {
            this.analyzeFunctionForInference(symbol);
        }
        this.inferredIsolated = false;
        if (inIsolatedFunction && !Symbols.isFlagOn(flags, 0x800000L)) {
            this.dlog.error(invocationExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INVOCATION_IN_ISOLATED_FUNCTION, new Object[0]);
            return;
        }
        if (recordFieldDefaultValue) {
            this.dlog.error(invocationExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INVOCATION_AS_RECORD_DEFAULT, new Object[0]);
        }
        if (objectFieldDefaultValueRequiringIsolation) {
            this.dlog.error(invocationExpr.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_INVOCATION_AS_OBJECT_DEFAULT, new Object[0]);
        } else if (this.isObjectFieldDefaultValue(this.env) && (initFunction = ((BLangClassDefinition)this.env.node).initFunction) != null) {
            this.markInitMethodDependentlyIsolatedOnFunction(initFunction, symbol);
        }
    }

    private void markFunctionDependentlyIsolatedOnStartAction(BInvokableSymbol enclInvokableSymbol, Set<BLangExpression> argsList, BInvokableSymbol symbol) {
        boolean isIsolatedFunction = this.isIsolated(symbol.type.getFlags());
        if (!isIsolatedFunction && Symbols.isFlagOn(symbol.flags, 1L)) {
            this.markDependsOnIsolationNonInferableConstructs();
            return;
        }
        if (!this.isolationInferenceInfoMap.containsKey(enclInvokableSymbol)) {
            return;
        }
        if (!isIsolatedFunction) {
            this.isolationInferenceInfoMap.get((Object)enclInvokableSymbol).dependsOnFunctions.add(symbol);
        }
        this.isolationInferenceInfoMap.get((Object)enclInvokableSymbol).dependsOnFuncCallArgExprs.addAll(argsList);
    }

    private boolean isInIsolatedFunction(SymbolEnv env) {
        BLangInvokableNode enclInvokable = env.enclInvokable;
        if (enclInvokable != null && enclInvokable.flagSet.contains((Object)Flag.WORKER)) {
            return this.isInIsolatedFunction(this.getWorkerEnclosedFunctionInvokable());
        }
        return this.isInIsolatedFunction(enclInvokable);
    }

    private BLangInvokableNode getWorkerEnclosedFunctionInvokable() {
        SymbolEnv env = this.env;
        while (env != null) {
            BLangNode node = env.node;
            if (node != null && this.isFunction(node) && !this.isWorkerLambda((BLangFunction)node)) {
                return env.enclInvokable;
            }
            env = env.enclEnv;
        }
        return this.env.enclInvokable;
    }

    private void analyzeArgs(List<BLangExpression> requiredArgs, List<BLangExpression> restArgs) {
        ArrayList<BLangExpression> args = new ArrayList<BLangExpression>(requiredArgs);
        args.addAll(restArgs);
        for (BLangExpression argExpr : args) {
            this.analyzeNode(argExpr, this.env);
        }
    }

    private void analyzeAndSetArrowFuncFlagForIsolatedParamArg(BLangExpression arg) {
        BLangExpression argExpr;
        if (arg.getKind() == NodeKind.REST_ARGS_EXPR) {
            BLangExpression expr = ((BLangRestArgsExpression)arg).expr;
            if (expr.getKind() != NodeKind.LIST_CONSTRUCTOR_EXPR) {
                this.analyzeNode(arg, this.env);
                return;
            }
            for (BLangExpression expression : ((BLangListConstructorExpr)expr).exprs) {
                this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(expression);
            }
            return;
        }
        boolean namedArg = arg.getKind() == NodeKind.NAMED_ARGS_EXPR;
        BLangExpression bLangExpression = argExpr = namedArg ? ((BLangNamedArgsExpression)arg).expr : arg;
        if (argExpr.getKind() != NodeKind.ARROW_EXPR) {
            this.analyzeNode(argExpr, this.env);
            return;
        }
        boolean prevInferredIsolatedness = this.inferredIsolated;
        this.inferredIsolated = true;
        this.analyzeNode(argExpr, this.env);
        if (this.inferredIsolated) {
            BInvokableType invokableType = (BInvokableType)argExpr.getBType();
            BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)invokableType.tsymbol;
            BInvokableTypeSymbol dupInvokableTypeSymbol = new BInvokableTypeSymbol(tsymbol.tag, tsymbol.flags | 0x20000000L, tsymbol.pkgID, null, tsymbol.owner, tsymbol.pos, tsymbol.origin);
            dupInvokableTypeSymbol.params = tsymbol.params == null ? null : new ArrayList<BVarSymbol>(tsymbol.params);
            BInvokableType dupInvokableType = new BInvokableType(this.symTable.typeEnv(), invokableType.paramTypes, invokableType.restType, invokableType.retType, dupInvokableTypeSymbol);
            dupInvokableType.addFlags(0x20000000L);
            dupInvokableTypeSymbol.type = dupInvokableType;
            argExpr.setBType(dupInvokableType);
            if (namedArg) {
                arg.setBType(dupInvokableType);
            }
        }
        this.inferredIsolated = prevInferredIsolatedness && this.inferredIsolated;
    }

    private void analyzeArgIsolatedness(BLangInvocation invocationExpr, List<BLangExpression> requiredArgs, List<BLangExpression> restArgs, BInvokableSymbol symbol, boolean expectsIsolation) {
        List<BVarSymbol> params = symbol.params;
        int paramsCount = params.size();
        if (restArgs.isEmpty()) {
            int nextParamIndex = 0;
            for (BLangExpression arg : requiredArgs) {
                if (arg.getKind() != NodeKind.NAMED_ARGS_EXPR) {
                    BVarSymbol varSymbol = params.get(nextParamIndex++);
                    if (!Symbols.isFlagOn(varSymbol.flags, 0x40000000L)) {
                        this.analyzeNode(arg, this.env);
                        continue;
                    }
                    this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg);
                    this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, arg, expectsIsolation, arg.getBType(), arg.pos);
                    continue;
                }
                String name = ((BLangNamedArgsExpression)arg).name.value;
                for (BVarSymbol param : params) {
                    if (!param.name.value.equals(name)) continue;
                    if (!Symbols.isFlagOn(param.flags, 0x40000000L)) {
                        this.analyzeNode(arg, this.env);
                        continue;
                    }
                    this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg);
                    this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, arg, expectsIsolation, arg.getBType(), arg.pos);
                }
            }
            return;
        }
        int reqArgCount = requiredArgs.size();
        for (int i = 0; i < reqArgCount; ++i) {
            BLangExpression arg = requiredArgs.get(i);
            if (!Symbols.isFlagOn(params.get((int)i).flags, 0x40000000L)) {
                this.analyzeNode(arg, this.env);
                continue;
            }
            if (arg.getBType() == this.symTable.semanticError) continue;
            this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg);
            this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, arg, expectsIsolation, arg.getBType(), arg.pos);
        }
        if (restArgs.get(restArgs.size() - 1).getKind() == NodeKind.REST_ARGS_EXPR) {
            BLangRestArgsExpression varArg = (BLangRestArgsExpression)restArgs.get(restArgs.size() - 1);
            BType varArgType = Types.getImpliedType(varArg.getBType());
            Location varArgPos = varArg.pos;
            if (varArgType == this.symTable.semanticError) {
                return;
            }
            if (reqArgCount == paramsCount) {
                if (!Symbols.isFlagOn(symbol.restParam.flags, 0x40000000L)) {
                    this.analyzeNode(varArg, this.env);
                    return;
                }
                this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(varArg);
                this.analyzeVarArgIsolatedness(invocationExpr, varArg, varArgPos, expectsIsolation);
                return;
            }
            if (reqArgCount < paramsCount) {
                BLangExpression arg;
                BLangListConstructorExpr listConstructorExpr;
                BTupleType tupleType = varArgType.tag == 20 ? this.getRepresentativeTupleTypeForRemainingArgs(paramsCount, reqArgCount, (BArrayType)varArgType) : (BTupleType)varArgType;
                List<BType> memberTypes = tupleType.getTupleTypes();
                BLangExpression varArgExpr = varArg.expr;
                boolean listConstrVarArg = varArgExpr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR;
                BLangListConstructorExpr bLangListConstructorExpr = listConstructorExpr = listConstrVarArg ? (BLangListConstructorExpr)varArgExpr : null;
                if (!listConstrVarArg) {
                    this.analyzeNode(varArg, this.env);
                }
                int tupleIndex = 0;
                for (int i = reqArgCount; i < paramsCount; ++i) {
                    if (!Symbols.isFlagOn(params.get((int)i).flags, 0x40000000L)) {
                        if (listConstrVarArg) {
                            this.analyzeNode(listConstructorExpr.exprs.get(tupleIndex), this.env);
                        }
                        ++tupleIndex;
                        continue;
                    }
                    BType type = memberTypes.get(tupleIndex);
                    BLangExpression arg2 = null;
                    if (listConstrVarArg) {
                        arg2 = listConstructorExpr.exprs.get(tupleIndex);
                        this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg2);
                        type = arg2.getBType();
                    }
                    this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, arg2, expectsIsolation, type, varArgPos);
                    ++tupleIndex;
                }
                BVarSymbol restParam = symbol.restParam;
                if (restParam == null) {
                    return;
                }
                if (!Symbols.isFlagOn(restParam.flags, 0x40000000L)) {
                    if (listConstructorExpr == null) {
                        return;
                    }
                    List<BLangExpression> exprs = listConstructorExpr.exprs;
                    for (int i = tupleIndex; i < exprs.size(); ++i) {
                        this.analyzeNode(exprs.get(i), this.env);
                    }
                    return;
                }
                int memberTypeCount = memberTypes.size();
                if (tupleIndex < memberTypeCount) {
                    for (int i = tupleIndex; i < memberTypeCount; ++i) {
                        BType type = memberTypes.get(i);
                        arg = null;
                        if (listConstrVarArg) {
                            arg = listConstructorExpr.exprs.get(i);
                            this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg);
                            type = arg.getBType();
                        }
                        this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, arg, expectsIsolation, type, varArgPos);
                    }
                }
                if (listConstrVarArg) {
                    List<BLangExpression> exprs = listConstructorExpr.exprs;
                    for (int i = tupleIndex; i < exprs.size(); ++i) {
                        arg = exprs.get(i);
                        this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(arg);
                        this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, arg, expectsIsolation, arg.getBType(), varArgPos);
                    }
                    return;
                }
                BType tupleRestType = tupleType.restType;
                if (tupleRestType == null) {
                    return;
                }
                this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, null, expectsIsolation, tupleRestType, varArgPos);
                return;
            }
        }
        if (!Symbols.isFlagOn(symbol.restParam.flags, 0x40000000L)) {
            for (BLangExpression restArg : restArgs) {
                this.analyzeNode(restArg, this.env);
            }
            return;
        }
        this.analyzeRestArgsForRestParam(invocationExpr, restArgs, symbol, expectsIsolation);
    }

    private BTupleType getRepresentativeTupleTypeForRemainingArgs(int paramCount, int reqArgCount, BArrayType arrayType) {
        int remReqArgCount = paramCount - reqArgCount;
        ArrayList<BTupleMember> members = new ArrayList<BTupleMember>(remReqArgCount);
        BType eType = arrayType.eType;
        for (int i = 0; i < remReqArgCount; ++i) {
            members.add(new BTupleMember(eType, Symbols.createVarSymbolForTupleMember(eType)));
        }
        if (arrayType.getSize() > remReqArgCount) {
            return new BTupleType(this.symTable.typeEnv(), null, members, eType, 0L);
        }
        return new BTupleType(this.symTable.typeEnv(), members);
    }

    private void analyzeRestArgsForRestParam(BLangInvocation invocationExpr, List<BLangExpression> restArgs, BInvokableSymbol symbol, boolean expectsIsolation) {
        if (Symbols.isFlagOn(((BArrayType)symbol.restParam.type).eType.getFlags(), 0x20000000L)) {
            for (BLangExpression restArg : restArgs) {
                this.analyzeNode(restArg, this.env);
            }
            return;
        }
        for (BLangExpression restArg : restArgs) {
            this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(restArg);
        }
        int size = restArgs.size();
        BLangExpression lastArg = restArgs.get(size - 1);
        boolean lastArgIsVarArg = lastArg.getKind() == NodeKind.REST_ARGS_EXPR;
        for (int i = 0; i < (lastArgIsVarArg ? size - 1 : size); ++i) {
            BLangExpression arg = restArgs.get(i);
            this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, arg, expectsIsolation, arg.getBType(), arg.pos);
        }
        if (lastArgIsVarArg) {
            this.analyzeVarArgIsolatedness(invocationExpr, (BLangRestArgsExpression)lastArg, lastArg.pos, expectsIsolation);
        }
    }

    private void analyzeVarArgIsolatedness(BLangInvocation invocationExpr, BLangRestArgsExpression restArgsExpression, Location pos, boolean expectsIsolation) {
        BLangExpression expr = restArgsExpression.expr;
        if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_EXPR) {
            for (BLangExpression expression : ((BLangListConstructorExpr)expr).exprs) {
                this.analyzeAndSetArrowFuncFlagForIsolatedParamArg(expression);
                this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, expression, expectsIsolation, expression.getBType(), pos);
            }
            return;
        }
        BType varArgType = Types.getImpliedType(restArgsExpression.getBType());
        if (varArgType.tag == 20) {
            this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, null, expectsIsolation, ((BArrayType)varArgType).eType, pos);
            return;
        }
        BTupleType tupleType = (BTupleType)varArgType;
        for (BType type : tupleType.getTupleTypes()) {
            this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, null, expectsIsolation, type, pos);
        }
        BType restType = tupleType.restType;
        if (restType != null) {
            this.handleNonExplicitlyIsolatedArgForIsolatedParam(invocationExpr, null, expectsIsolation, restType, pos);
        }
    }

    private void handleNonExplicitlyIsolatedArgForIsolatedParam(BLangInvocation invocationExpr, BLangExpression expr, boolean expectsIsolation, BType type, Location pos) {
        if (Symbols.isFlagOn(type.getFlags(), 0x20000000L)) {
            return;
        }
        this.inferredIsolated = false;
        if (expectsIsolation) {
            this.dlog.error(pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_FUNCTION_AS_ARGUMENT, new Object[0]);
            return;
        }
        if (expr != null) {
            NodeKind kind = expr.getKind();
            if (kind == NodeKind.LAMBDA) {
                this.markFunctionDependentlyIsolatedOnFunction(this.env.enclInvokable, ((BLangLambdaFunction)expr).function.symbol);
            } else if (kind == NodeKind.ARROW_EXPR) {
                this.markFunctionDependentlyIsolatedOnFunction(this.env.enclInvokable, this.createTempSymbolIfNonExistent((BLangArrowFunction)expr));
            }
        } else {
            this.markDependsOnIsolationNonInferableConstructs();
        }
        if (this.inLockStatement) {
            this.copyInLockInfoStack.peek().nonIsolatedInvocations.add(invocationExpr);
        }
    }

    private boolean isInIsolatedFunction(BLangInvokableNode enclInvokable) {
        if (enclInvokable == null) {
            if (this.isNotInArrowFunctionBody(this.env)) {
                return false;
            }
            return this.isIsolated(((BLangArrowFunction)this.env.enclEnv.node).funcType.getFlags());
        }
        return this.isIsolated(enclInvokable.symbol.flags);
    }

    private boolean isRecordFieldDefaultValue(BLangType enclType) {
        if (enclType == null) {
            return false;
        }
        return enclType.getKind() == NodeKind.RECORD_TYPE;
    }

    private boolean isObjectFieldDefaultValueRequiringIsolation(SymbolEnv env) {
        if (!this.isObjectFieldDefaultValue(env)) {
            return false;
        }
        BLangClassDefinition classDefinition = (BLangClassDefinition)env.node;
        BLangFunction initFunction = classDefinition.initFunction;
        if (initFunction == null) {
            return true;
        }
        return this.isIsolated(initFunction.symbol.flags);
    }

    private boolean isObjectFieldDefaultValue(SymbolEnv env) {
        return env.node.getKind() == NodeKind.CLASS_DEFN;
    }

    private boolean isDefinitionReference(BSymbol symbol) {
        return Symbols.isTagOn(symbol, 32796L) || Symbols.isTagOn(symbol, 820L);
    }

    private boolean isIsolated(long flags) {
        return Symbols.isFlagOn(flags, 0x20000000L);
    }

    private boolean isIsolatedClassField() {
        BLangNode node = this.env.node;
        return node.getKind() == NodeKind.CLASS_DEFN && ((BLangClassDefinition)node).flagSet.contains((Object)Flag.ISOLATED);
    }

    private boolean isExpectedToBeAPrivateField(BVarSymbol symbol, BType type) {
        return !Symbols.isFlagOn(symbol.flags, 4L) || !this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(type);
    }

    private boolean isIsolatedObjectFieldOrMethodAccessViaSelf(BLangFieldBasedAccess fieldAccessExpr, boolean ignoreInit) {
        BLangExpression expr = fieldAccessExpr.expr;
        if (expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return false;
        }
        if (!this.isSelfOfObject((BLangSimpleVarRef)expr)) {
            return false;
        }
        return this.isInIsolatedObjectMethod(this.env, ignoreInit);
    }

    private boolean isInvalidIsolatedObjectFieldOrMethodAccessViaSelfIfOutsideLock(BLangFieldBasedAccess fieldAccessExpr) {
        if (!this.isIsolatedObjectFieldOrMethodAccessViaSelf(fieldAccessExpr, this.isObjectFieldInitialization(fieldAccessExpr))) {
            return false;
        }
        BLangFunction enclInvokable = this.getEnclNonAnonymousFunction((BLangFunction)this.env.enclInvokable);
        BField field = (BField)((BObjectType)enclInvokable.symbol.owner.type).fields.get(fieldAccessExpr.field.value);
        if (field == null) {
            return false;
        }
        return this.isExpectedToBeAPrivateField(field.symbol, field.type);
    }

    private boolean isObjectFieldInitialization(BLangFieldBasedAccess fieldAccessExpr) {
        BLangNode parent = fieldAccessExpr.parent;
        if (fieldAccessExpr.isLValue) {
            return parent.getKind() == NodeKind.ASSIGNMENT;
        }
        while (parent != null && parent.getKind() != NodeKind.ASSIGNMENT) {
            parent = parent.parent;
        }
        if (parent == null) {
            return false;
        }
        BLangAssignment assignment = (BLangAssignment)parent;
        BLangExpression lhsExpr = assignment.varRef;
        if (lhsExpr.getKind() != NodeKind.FIELD_BASED_ACCESS_EXPR) {
            return false;
        }
        BLangExpression expr = ((BLangFieldBasedAccess)lhsExpr).expr;
        if (expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return false;
        }
        return this.isSelfOfObject((BLangSimpleVarRef)expr);
    }

    private void validateIsolatedExpression(BType type, BLangExpression expression) {
        if (this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(type)) {
            return;
        }
        this.validateIsolatedExpression(expression);
    }

    private void validateIsolatedExpression(BLangExpression expression) {
        this.isIsolatedExpression(expression, true, true, new ArrayList<BLangExpression>());
    }

    private boolean isIsolatedExpression(BLangExpression expression) {
        return this.isIsolatedExpression(expression, false, false, new ArrayList<BLangExpression>());
    }

    private boolean isIsolatedExpression(BLangExpression expression, boolean logErrors, boolean visitRestOnError, List<BLangExpression> nonIsolatedLocations) {
        return this.isIsolatedExpression(expression, logErrors, visitRestOnError, nonIsolatedLocations, false, null, null, null, null);
    }

    private boolean isIsolatedExpression(BLangExpression expression, boolean logErrors, boolean visitRestOnError, List<BLangExpression> nonIsolatedExpressions, boolean inferring, Set<BType> publiclyExposedObjectTypes, List<BLangClassDefinition> classDefinitions, List<BLangVariable> moduleLevelVariables, Set<BSymbol> unresolvedSymbols) {
        BType type = expression.getBType();
        if (type != null && this.isSubTypeOfReadOnlyOrIsolatedObjectUnionWithInference(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, inferring, type, unresolvedSymbols)) {
            return true;
        }
        switch (expression.getKind()) {
            case SIMPLE_VARIABLE_REF: {
                if (!this.isReferenceOfLetVarInitializedWithAnIsolatedExpression((BLangSimpleVarRef)expression)) break;
                return true;
            }
            case LITERAL: 
            case NUMERIC_LITERAL: {
                return true;
            }
            case LIST_CONSTRUCTOR_EXPR: {
                for (BLangExpression expr : ((BLangListConstructorExpr)expression).exprs) {
                    if (this.isIsolatedExpression(expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                return true;
            }
            case TABLE_CONSTRUCTOR_EXPR: {
                for (BLangRecordLiteral mappingConstr : ((BLangTableConstructorExpr)expression).recordLiteralList) {
                    if (this.isIsolatedExpression(mappingConstr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                return true;
            }
            case RECORD_LITERAL_EXPR: {
                for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)expression).fields) {
                    if (field.isKeyValueField()) {
                        BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                        BLangRecordLiteral.BLangRecordKey key = keyValueField.key;
                        if (key.computedKey && !this.isIsolatedExpression(key.expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) && !logErrors && !visitRestOnError) {
                            return false;
                        }
                        if (this.isIsolatedExpression(keyValueField.valueExpr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                        return false;
                    }
                    if (field.getKind() == NodeKind.RECORD_LITERAL_SPREAD_OP) {
                        if (this.isIsolatedExpression(((BLangRecordLiteral.BLangRecordSpreadOperatorField)field).expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                        return false;
                    }
                    if (this.isIsolatedExpression((BLangRecordLiteral.BLangRecordVarNameField)field, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                return true;
            }
            case XML_COMMENT_LITERAL: {
                BLangXMLCommentLiteral commentLiteral = (BLangXMLCommentLiteral)expression;
                for (BLangExpression textFragment : commentLiteral.textFragments) {
                    if (this.isIsolatedExpression(textFragment, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                BLangExpression commentLiteralConcatExpr = commentLiteral.concatExpr;
                if (commentLiteralConcatExpr == null) {
                    return true;
                }
                return this.isIsolatedExpression(commentLiteralConcatExpr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            case XML_TEXT_LITERAL: {
                BLangXMLTextLiteral textLiteral = (BLangXMLTextLiteral)expression;
                for (BLangExpression textFragment : textLiteral.textFragments) {
                    if (this.isIsolatedExpression(textFragment, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                BLangExpression textLiteralConcatExpr = textLiteral.concatExpr;
                if (textLiteralConcatExpr == null) {
                    return true;
                }
                return this.isIsolatedExpression(textLiteralConcatExpr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            case XML_PI_LITERAL: {
                BLangXMLProcInsLiteral procInsLiteral = (BLangXMLProcInsLiteral)expression;
                for (BLangExpression dataFragment : procInsLiteral.dataFragments) {
                    if (this.isIsolatedExpression(dataFragment, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                BLangExpression procInsLiteralConcatExpr = procInsLiteral.dataConcatExpr;
                if (procInsLiteralConcatExpr == null) {
                    return true;
                }
                return this.isIsolatedExpression(procInsLiteralConcatExpr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            case XML_ELEMENT_LITERAL: {
                for (BLangExpression child : ((BLangXMLElementLiteral)expression).children) {
                    if (this.isIsolatedExpression(child, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                return true;
            }
            case XML_SEQUENCE_LITERAL: {
                for (BLangExpression xmlItem : ((BLangXMLSequenceLiteral)expression).xmlItems) {
                    if (this.isIsolatedExpression(xmlItem, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                return true;
            }
            case RAW_TEMPLATE_LITERAL: {
                for (BLangExpression insertion : ((BLangRawTemplateLiteral)expression).insertions) {
                    if (this.isIsolatedExpression(insertion, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                return true;
            }
            case STRING_TEMPLATE_LITERAL: {
                for (BLangExpression expr : ((BLangStringTemplateLiteral)expression).exprs) {
                    if (this.isIsolatedExpression(expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                return true;
            }
            case TYPE_CONVERSION_EXPR: {
                return this.isIsolatedExpression(((BLangTypeConversionExpr)expression).expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            case CHECK_EXPR: 
            case CHECK_PANIC_EXPR: {
                return this.isIsolatedExpression(((BLangCheckedExpr)expression).expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            case TRAP_EXPR: {
                return this.isIsolatedExpression(((BLangTrapExpr)expression).expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            case TERNARY_EXPR: {
                BLangTernaryExpr ternaryExpr = (BLangTernaryExpr)expression;
                if (!(this.isIsolatedExpression(ternaryExpr.expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError)) {
                    return false;
                }
                if (!(this.isIsolatedExpression(ternaryExpr.thenExpr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError)) {
                    return false;
                }
                return this.isIsolatedExpression(ternaryExpr.elseExpr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            case ELVIS_EXPR: {
                BLangElvisExpr elvisExpr = (BLangElvisExpr)expression;
                if (!(this.isIsolatedExpression(elvisExpr.lhsExpr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError)) {
                    return false;
                }
                return this.isIsolatedExpression(elvisExpr.rhsExpr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            case LET_EXPR: {
                return this.isIsolatedExpression(((BLangLetExpression)expression).expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            case GROUP_EXPR: {
                return this.isIsolatedExpression(((BLangGroupExpr)expression).expression, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            case TYPE_INIT_EXPR: {
                BLangTypeInit typeInitExpr = (BLangTypeInit)expression;
                expression = typeInitExpr.initInvocation;
                break;
            }
            case OBJECT_CTOR_EXPRESSION: {
                BLangObjectConstructorExpression objectConstructorExpression = (BLangObjectConstructorExpression)expression;
                BLangTypeInit typeInitExpr = objectConstructorExpression.typeInit;
                if (typeInitExpr == null) {
                    return true;
                }
                expression = typeInitExpr.initInvocation;
            }
        }
        if (expression.getKind() == NodeKind.INVOCATION) {
            BLangInvocation invocation = (BLangInvocation)expression;
            if (this.isCloneOrCloneReadOnlyInvocation(invocation)) {
                return true;
            }
            BSymbol invocationSymbol = invocation.symbol;
            if (invocationSymbol == null) {
                List<BLangExpression> argExprs = invocation.argExprs;
                if (argExprs.isEmpty()) {
                    return true;
                }
                return this.isIsolatedExpression(argExprs.get(0), logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols);
            }
            if (this.isIsolated(invocationSymbol.type.getFlags()) || inferring && this.isolationInferenceInfoMap.containsKey(invocationSymbol) && this.inferFunctionIsolation(invocationSymbol, this.isolationInferenceInfoMap.get(invocationSymbol), publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols)) {
                List<BLangExpression> requiredArgs = invocation.requiredArgs;
                BLangExpression calledOnExpr = invocation.expr;
                if (!(calledOnExpr == null || !requiredArgs.isEmpty() && calledOnExpr == requiredArgs.get(0) || this.isIsolatedExpression(calledOnExpr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError)) {
                    return false;
                }
                for (BLangExpression requiredArg : requiredArgs) {
                    if (requiredArg.getKind() == NodeKind.NAMED_ARGS_EXPR) {
                        if (this.isIsolatedExpression(((BLangNamedArgsExpression)requiredArg).expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                        return false;
                    }
                    if (this.isIsolatedExpression(requiredArg, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                for (BLangExpression restArg : invocation.restArgs) {
                    if (restArg.getKind() == NodeKind.REST_ARGS_EXPR) {
                        if (this.isIsolatedExpression(((BLangRestArgsExpression)restArg).expr, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                        return false;
                    }
                    if (this.isIsolatedExpression(restArg, logErrors, visitRestOnError, nonIsolatedExpressions, inferring, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols) || logErrors || visitRestOnError) continue;
                    return false;
                }
                return true;
            }
        }
        if (logErrors) {
            this.dlog.error(expression.pos, DiagnosticErrorCode.INVALID_NON_ISOLATED_EXPRESSION_AS_INITIAL_VALUE, new Object[0]);
        } else {
            nonIsolatedExpressions.add(expression);
        }
        return false;
    }

    private boolean isSubTypeOfReadOnlyOrIsolatedObjectUnionWithInference(Set<BType> publiclyExposedObjectTypes, List<BLangClassDefinition> classDefinitions, List<BLangVariable> moduleLevelVariables, boolean inferring, BType type, Set<BSymbol> unresolvedSymbols) {
        if (this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(type = Types.getImpliedType(type))) {
            return true;
        }
        if (!inferring) {
            return false;
        }
        BTypeSymbol tsymbol = type.tsymbol;
        int tag = type.tag;
        if (tag == 34) {
            if (this.isolationInferenceInfoMap.containsKey(tsymbol)) {
                return this.inferVariableOrClassIsolation(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, tsymbol, (VariableIsolationInferenceInfo)this.isolationInferenceInfoMap.get(tsymbol), true, unresolvedSymbols);
            }
            return false;
        }
        if (tag != 21) {
            return false;
        }
        for (BType memberType : ((BUnionType)type).getMemberTypes()) {
            if (this.isSubTypeOfReadOnlyOrIsolatedObjectUnionWithInference(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, true, memberType, unresolvedSymbols)) continue;
            return false;
        }
        return true;
    }

    private boolean isDependentlyIsolatedExpressionKind(BLangExpression expression) {
        return switch (expression.getKind()) {
            case NodeKind.LIST_CONSTRUCTOR_EXPR, NodeKind.TABLE_CONSTRUCTOR_EXPR, NodeKind.RECORD_LITERAL_EXPR, NodeKind.XML_COMMENT_LITERAL, NodeKind.XML_TEXT_LITERAL, NodeKind.XML_PI_LITERAL, NodeKind.XML_ELEMENT_LITERAL, NodeKind.XML_SEQUENCE_LITERAL, NodeKind.RAW_TEMPLATE_LITERAL, NodeKind.STRING_TEMPLATE_LITERAL, NodeKind.TYPE_CONVERSION_EXPR, NodeKind.CHECK_EXPR, NodeKind.CHECK_PANIC_EXPR, NodeKind.TRAP_EXPR, NodeKind.TERNARY_EXPR, NodeKind.ELVIS_EXPR -> true;
            case NodeKind.GROUP_EXPR -> this.isDependentlyIsolatedExpressionKind(((BLangGroupExpr)expression).expression);
            default -> false;
        };
    }

    private boolean isCloneOrCloneReadOnlyInvocation(BLangInvocation invocation) {
        if (!invocation.langLibInvocation) {
            return false;
        }
        String methodName = invocation.symbol.name.value;
        return invocation.symbol.pkgID.name.value.equals(VALUE_LANG_LIB) && (methodName.equals(CLONE_LANG_LIB_METHOD) || methodName.equals(CLONE_READONLY_LANG_LIB_METHOD));
    }

    private boolean isInvalidTransferIn(BLangSimpleVarRef expression) {
        return this.isInvalidTransferIn(expression, this.isSelfOfObject(expression));
    }

    private boolean isInvalidTransferIn(BLangExpression expression, boolean invokedOnSelf) {
        BLangNode parent = expression.parent;
        NodeKind parentExprKind = parent.getKind();
        if (!(parent instanceof BLangExpression)) {
            return !this.isIsolatedExpression(expression);
        }
        BLangExpression parentExpression = (BLangExpression)parent;
        if (parentExprKind != NodeKind.INVOCATION) {
            if (!this.isSelfReference(expression) && this.isIsolatedExpression(expression)) {
                return false;
            }
            return this.isInvalidTransferIn(parentExpression, invokedOnSelf);
        }
        BLangInvocation invocation = (BLangInvocation)parentExpression;
        BLangExpression calledOnExpr = invocation.expr;
        if (calledOnExpr == expression) {
            if (this.isIsolatedExpression(expression)) {
                return false;
            }
            if (this.isCloneOrCloneReadOnlyInvocation(invocation)) {
                return false;
            }
            if (!invokedOnSelf && Types.getImpliedType((BType)invocation.getBType()).tag == 10) {
                return true;
            }
            return this.isInvalidTransferIn(parentExpression, invokedOnSelf);
        }
        return !this.isIsolatedExpression(expression);
    }

    private void validateTransferOut(BLangExpression expression, List<BLangExpression> nonIsolatedCopyOutExpressions) {
        if (!this.isDependentlyIsolatedExpressionKind(expression)) {
            if (!this.isIsolatedExpression(expression)) {
                nonIsolatedCopyOutExpressions.add(expression);
            }
            return;
        }
        this.isIsolatedExpression(expression, false, true, nonIsolatedCopyOutExpressions);
    }

    private void validateTransferOutViaAssignment(BLangExpression expression, BLangExpression varRef, List<BLangExpression> nonIsolatedCopyOutLocations) {
        if (!this.hasRefDefinedOutsideLock(varRef)) {
            return;
        }
        this.validateTransferOut(expression, nonIsolatedCopyOutLocations);
    }

    private void validateTransferOut(BLangExpression varRef, BLangExpression expr) {
        if (!this.inLockStatement) {
            return;
        }
        this.validateTransferOutViaAssignment(expr, varRef, this.copyInLockInfoStack.peek().nonIsolatedTransferOutExpressions);
    }

    private boolean isSelfReference(BLangExpression expression) {
        return expression.getKind() == NodeKind.SIMPLE_VARIABLE_REF && this.isSelfOfObject((BLangSimpleVarRef)expression);
    }

    private boolean isSelfOfObject(BLangSimpleVarRef varRefExpr) {
        if (!Names.SELF.value.equals(varRefExpr.variableName.value)) {
            return false;
        }
        BSymbol symbol = varRefExpr.symbol;
        if (symbol == null) {
            return false;
        }
        BSymbol owner = symbol.owner;
        if (owner == null || (owner.tag & 0x100L) != 256L) {
            return false;
        }
        return symbol == ((BInvokableSymbol)owner).receiverSymbol;
    }

    private boolean isSelfOfIsolatedObject(BLangSimpleVarRef varRefExpr) {
        return this.isSelfOfObject(varRefExpr) && this.isIsolated(varRefExpr.symbol.type.getFlags());
    }

    private boolean hasRefDefinedOutsideLock(BLangExpression variableReference) {
        switch (variableReference.getKind()) {
            case SIMPLE_VARIABLE_REF: {
                BLangSimpleVarRef simpleVarRef = (BLangSimpleVarRef)variableReference;
                return this.isDefinedOutsideLock(this.names.fromIdNode(simpleVarRef.variableName), simpleVarRef.symbol.tag, this.env);
            }
            case RECORD_VARIABLE_REF: {
                BLangRecordVarRef recordVarRef = (BLangRecordVarRef)variableReference;
                for (BLangRecordVarRef.BLangRecordVarRefKeyValue recordRefField : recordVarRef.recordRefFields) {
                    if (!this.hasRefDefinedOutsideLock(recordRefField.variableReference)) continue;
                    return true;
                }
                BLangExpression recordRestParam = recordVarRef.restParam;
                return recordRestParam != null && this.hasRefDefinedOutsideLock(recordRestParam);
            }
            case TUPLE_VARIABLE_REF: {
                BLangTupleVarRef tupleVarRef = (BLangTupleVarRef)variableReference;
                for (BLangExpression expression : tupleVarRef.expressions) {
                    if (!this.hasRefDefinedOutsideLock(expression)) continue;
                    return true;
                }
                BLangExpression tupleRestParam = tupleVarRef.restParam;
                return tupleRestParam != null && this.hasRefDefinedOutsideLock(tupleRestParam);
            }
            case ERROR_VARIABLE_REF: {
                BLangErrorVarRef errorVarRef = (BLangErrorVarRef)variableReference;
                BLangVariableReference message = errorVarRef.message;
                if (message != null && this.hasRefDefinedOutsideLock(message)) {
                    return true;
                }
                BLangVariableReference cause = errorVarRef.cause;
                if (cause != null && this.hasRefDefinedOutsideLock(cause)) {
                    return true;
                }
                for (BLangNamedArgsExpression namedArgsExpression : errorVarRef.detail) {
                    if (!this.hasRefDefinedOutsideLock(namedArgsExpression.expr)) continue;
                    return true;
                }
                BLangVariableReference errorRestVar = errorVarRef.restVar;
                return errorRestVar != null && this.hasRefDefinedOutsideLock(errorRestVar);
            }
        }
        return false;
    }

    private boolean isDefinedOutsideLock(Name name, long symTag, SymbolEnv currentEnv) {
        if (Names.IGNORE == name || this.symResolver.lookupSymbolInGivenScope(currentEnv, name, symTag) != this.symTable.notFoundSymbol) {
            return false;
        }
        if (currentEnv.node.getKind() == NodeKind.LOCK) {
            return true;
        }
        return this.isDefinedOutsideLock(name, symTag, currentEnv.enclEnv);
    }

    private boolean isInIsolatedObjectMethod(SymbolEnv env, boolean ignoreInit) {
        BLangInvokableNode enclInvokable = env.enclInvokable;
        if (enclInvokable == null || !this.isFunction(enclInvokable)) {
            return false;
        }
        BLangFunction enclFunction = (BLangFunction)enclInvokable;
        if (Symbols.isFlagOn(enclFunction.symbol.flags, 2048L)) {
            BLangFunction enclNonAnonymousFunction = this.getEnclNonAnonymousFunction(enclFunction);
            if (enclNonAnonymousFunction == null) {
                return false;
            }
            enclFunction = enclNonAnonymousFunction;
        }
        if (!enclFunction.attachedFunction) {
            return false;
        }
        if (enclFunction.objInitFunction && ignoreInit) {
            return false;
        }
        BType ownerType = Types.getImpliedType(enclFunction.symbol.owner.type);
        return ownerType.tag == 34 && this.isIsolated(ownerType.getFlags());
    }

    private BLangFunction getEnclNonAnonymousFunction(BLangFunction enclFunction) {
        if (enclFunction == null || enclFunction.symbol.owner.kind == SymbolKind.PACKAGE) {
            return null;
        }
        if (!Symbols.isFlagOn(enclFunction.symbol.flags, 2048L)) {
            return enclFunction;
        }
        BLangNode enclNode = enclFunction.parent;
        while (enclNode != null && !this.isFunction(enclNode)) {
            enclNode = enclNode.parent;
        }
        return this.getEnclNonAnonymousFunction((BLangFunction)enclNode);
    }

    private boolean isFunction(BLangNode enclNode) {
        NodeKind kind = enclNode.getKind();
        return kind == NodeKind.FUNCTION || kind == NodeKind.RESOURCE_FUNC;
    }

    private boolean isInvalidCopyIn(BLangSimpleVarRef varRefExpr, SymbolEnv currentEnv) {
        return this.isInvalidCopyIn(varRefExpr, this.names.fromIdNode(varRefExpr.variableName), varRefExpr.symbol.tag, currentEnv);
    }

    private boolean isInvalidCopyIn(BLangSimpleVarRef varRefExpr, Name name, long symTag, SymbolEnv currentEnv) {
        block5: {
            block6: {
                BSymbol symbol = this.symResolver.lookupSymbolInGivenScope(currentEnv, name, symTag);
                if (symbol == this.symTable.notFoundSymbol) break block5;
                if (!(symbol instanceof BVarSymbol)) break block6;
                BVarSymbol bVarSymbol = (BVarSymbol)symbol;
                if (bVarSymbol.originalSymbol != null) break block5;
            }
            return false;
        }
        if (currentEnv.node.getKind() == NodeKind.LOCK) {
            if (varRefExpr.parent == null) {
                return true;
            }
            return this.isInvalidTransferIn(varRefExpr);
        }
        return this.isInvalidCopyIn(varRefExpr, name, symTag, currentEnv.enclEnv);
    }

    private boolean isMethodCallOnSelfInIsolatedObject(BLangSimpleVarRef varRefExpr, BLangNode parent) {
        return this.isSelfVarInIsolatedObject(varRefExpr) && parent != null && parent.getKind() != NodeKind.FIELD_BASED_ACCESS_EXPR;
    }

    private boolean isSelfVarInIsolatedObject(BLangSimpleVarRef varRefExpr) {
        return this.isInIsolatedObjectMethod(this.env, true) && this.isSelfOfObject(varRefExpr);
    }

    private boolean isIsolatedModuleVariableSymbol(BSymbol symbol) {
        return symbol.owner.getKind() == SymbolKind.PACKAGE && this.isIsolated(symbol.flags);
    }

    private BSymbol getOriginalSymbol(BSymbol symbol) {
        if (!(symbol instanceof BVarSymbol)) {
            return symbol;
        }
        BVarSymbol varSymbol = (BVarSymbol)symbol;
        BVarSymbol originalSymbol = varSymbol.originalSymbol;
        return originalSymbol == null ? varSymbol : this.getOriginalSymbol(originalSymbol);
    }

    private void addToAccessedRestrictedVars(Map<BSymbol, List<BLangSimpleVarRef>> accessedRestrictedVars, final BLangSimpleVarRef varRef) {
        BSymbol originalSymbol = this.getOriginalSymbol(varRef.symbol);
        if (accessedRestrictedVars.containsKey(originalSymbol)) {
            accessedRestrictedVars.get(originalSymbol).add(varRef);
            return;
        }
        accessedRestrictedVars.put(originalSymbol, (List<BLangSimpleVarRef>)new ArrayList<BLangSimpleVarRef>(){
            {
                this.add(varRef);
            }
        });
    }

    private boolean isEnclosedLockWithinSameFunction(BLangLock currentLock, BLangLock potentialOuterLock) {
        return this.isEnclosedLockWithinSameFunction(currentLock.parent, potentialOuterLock);
    }

    private boolean isEnclosedLockWithinSameFunction(BLangNode parent, BLangLock potentialOuterLock) {
        if (parent == potentialOuterLock) {
            return true;
        }
        if (parent == null || this.isFunction(parent)) {
            return false;
        }
        return this.isEnclosedLockWithinSameFunction(parent.parent, potentialOuterLock);
    }

    private boolean isReferenceOfLetVarInitializedWithAnIsolatedExpression(BLangSimpleVarRef varRef) {
        BSymbol symbol = varRef.symbol;
        if ((symbol.owner.tag & 0x8000000L) != 0x8000000L) {
            return false;
        }
        BSymbol originalSymbol = this.getOriginalSymbol(symbol);
        for (Set<BSymbol> bSymbols : this.isolatedLetVarStack) {
            if (!bSymbols.contains(originalSymbol)) continue;
            return true;
        }
        return false;
    }

    private boolean isReferenceToVarDefinedInSameInvokable(BSymbol currentOwner, BInvokableSymbol enclInvokableSymbol) {
        if (currentOwner == enclInvokableSymbol) {
            return true;
        }
        if ((currentOwner.tag & 0x100L) == 256L) {
            return false;
        }
        BSymbol nextOwner = currentOwner.owner;
        if (nextOwner == null) {
            return false;
        }
        return this.isReferenceToVarDefinedInSameInvokable(nextOwner, enclInvokableSymbol);
    }

    private boolean isIsolationInferableFunction(BLangFunction funcNode) {
        Set flagSet = funcNode.flagSet;
        if (flagSet.contains((Object)Flag.INTERFACE)) {
            return false;
        }
        if (!flagSet.contains((Object)Flag.ATTACHED)) {
            return !flagSet.contains((Object)Flag.PUBLIC);
        }
        BSymbol owner = funcNode.symbol.owner;
        if (!Symbols.isFlagOn(owner.flags, 1L)) {
            return true;
        }
        if (!(owner instanceof BClassSymbol)) {
            return false;
        }
        BClassSymbol ownerClassSymbol = (BClassSymbol)owner;
        return ownerClassSymbol.isServiceDecl || Symbols.isFlagOn(ownerClassSymbol.flags, 0x100000000L);
    }

    private void markDependsOnIsolationNonInferableConstructs() {
        BLangInvokableNode enclInvokable = this.env.enclInvokable;
        if (enclInvokable == null) {
            if (this.isNotInArrowFunctionBody(this.env)) {
                return;
            }
            enclInvokableSymbol = this.arrowFunctionTempSymbolMap.get((BLangArrowFunction)this.env.enclEnv.node);
        } else {
            BSymbol owner;
            enclInvokableSymbol = enclInvokable.symbol;
            NodeKind enclInvokableKind = enclInvokable.getKind();
            if ((enclInvokableKind == NodeKind.RESOURCE_FUNC || enclInvokableKind == NodeKind.FUNCTION && ((BLangFunction)enclInvokable).attachedFunction) && this.isolationInferenceInfoMap.containsKey(owner = enclInvokableSymbol.owner)) {
                this.isolationInferenceInfoMap.get((Object)owner).dependsOnlyOnInferableConstructs = false;
            }
            if (!this.isolationInferenceInfoMap.containsKey(enclInvokableSymbol)) {
                return;
            }
        }
        this.isolationInferenceInfoMap.get((Object)enclInvokableSymbol).dependsOnlyOnInferableConstructs = false;
    }

    private void analyzeFunctionInStartActionForInference(SymbolEnv env, List<BLangExpression> requiredArgs, List<BLangExpression> restArgs, BLangExpression expr, BInvokableSymbol symbol) {
        HashSet<BLangExpression> argsList = new HashSet<BLangExpression>(requiredArgs);
        argsList.addAll(restArgs);
        if (expr != null) {
            argsList.add(expr);
        }
        this.markFunctionDependentlyIsolatedOnStartAction(env.enclInvokable.symbol, argsList, symbol);
    }

    private void analyzeFunctionForInference(BInvokableSymbol symbol) {
        if (Symbols.isFlagOn(symbol.flags, 1L)) {
            this.markDependsOnIsolationNonInferableConstructs();
            return;
        }
        this.markDependentlyIsolatedOnFunction(symbol);
    }

    private void markInitMethodDependentlyIsolatedOnFunction(BLangInvokableNode initMethod, BInvokableSymbol symbol) {
        BInvokableSymbol initMethodSymbol = initMethod.symbol;
        if (!this.isolationInferenceInfoMap.containsKey(initMethodSymbol)) {
            this.isolationInferenceInfoMap.put(initMethodSymbol, new IsolationInferenceInfo());
        }
        this.markFunctionDependentlyIsolatedOnFunction(initMethod, symbol);
    }

    private void markDependentlyIsolatedOnFunction(BInvokableSymbol symbol) {
        BLangInvokableNode enclInvokable = this.env.enclInvokable;
        this.markFunctionDependentlyIsolatedOnFunction(enclInvokable, symbol);
    }

    private void markFunctionDependentlyIsolatedOnFunction(BLangInvokableNode enclInvokable, BInvokableSymbol symbol) {
        BInvokableSymbol enclInvokableSymbol;
        if (enclInvokable == null) {
            if (this.isNotInArrowFunctionBody(this.env)) {
                return;
            }
            enclInvokableSymbol = this.arrowFunctionTempSymbolMap.get((BLangArrowFunction)this.env.enclEnv.node);
        } else {
            enclInvokableSymbol = enclInvokable.symbol;
            if (!this.isolationInferenceInfoMap.containsKey(enclInvokableSymbol)) {
                return;
            }
        }
        this.isolationInferenceInfoMap.get((Object)enclInvokableSymbol).dependsOnFunctions.add(symbol);
    }

    private boolean isNotInArrowFunctionBody(SymbolEnv env) {
        return env.node.getKind() != NodeKind.EXPR_FUNCTION_BODY || env.enclEnv.node.getKind() != NodeKind.ARROW_EXPR;
    }

    private void markInitMethodDependentlyIsolatedOnVar(BLangInvokableNode initMethod, BSymbol symbol) {
        BInvokableSymbol initMethodSymbol = initMethod.symbol;
        if (!this.isolationInferenceInfoMap.containsKey(initMethodSymbol)) {
            this.isolationInferenceInfoMap.put(initMethodSymbol, new IsolationInferenceInfo());
        }
        this.markFunctionDependentlyIsolatedOnVar(initMethod, symbol);
    }

    private void markDependentlyIsolatedOnVar(BSymbol symbol) {
        BLangInvokableNode enclInvokable = this.env.enclInvokable;
        this.markFunctionDependentlyIsolatedOnVar(enclInvokable, symbol);
    }

    private void markFunctionDependentlyIsolatedOnVar(BLangInvokableNode enclInvokable, BSymbol symbol) {
        BInvokableSymbol enclInvokableSymbol;
        if (enclInvokable == null) {
            if (this.isNotInArrowFunctionBody(this.env)) {
                return;
            }
            enclInvokableSymbol = this.arrowFunctionTempSymbolMap.get((BLangArrowFunction)this.env.enclEnv.node);
        } else {
            enclInvokableSymbol = enclInvokable.symbol;
            if (!this.isolationInferenceInfoMap.containsKey(enclInvokableSymbol)) {
                return;
            }
        }
        this.isolationInferenceInfoMap.get((Object)enclInvokableSymbol).dependsOnVariablesAndClasses.add(symbol);
    }

    private Set<BSymbol> getModuleLevelVarSymbols(List<BLangVariable> moduleLevelVars) {
        HashSet<BSymbol> symbols = new HashSet<BSymbol>(moduleLevelVars.size());
        for (BLangVariable globalVar : moduleLevelVars) {
            symbols.add(globalVar.symbol);
        }
        return symbols;
    }

    private void populateNonPublicMutableOrNonIsolatedVars(Set<BSymbol> moduleLevelVarSymbols) {
        for (BSymbol moduleLevelVarSymbol : moduleLevelVarSymbols) {
            if (!this.isVarRequiringInference(moduleLevelVarSymbol)) continue;
            this.isolationInferenceInfoMap.put(moduleLevelVarSymbol, new VariableIsolationInferenceInfo());
        }
    }

    private void populateNonPublicIsolatedInferableClasses(List<BLangClassDefinition> classDefinitions) {
        for (BLangClassDefinition classDefinition : classDefinitions) {
            this.populateInferableClass(classDefinition);
        }
    }

    private boolean isWorkerLambda(BLangFunction function) {
        return function.flagSet.contains((Object)Flag.WORKER) && function.flagSet.contains((Object)Flag.LAMBDA);
    }

    private boolean isObjectFieldInitializationInInitMethod(BLangFieldBasedAccess fieldBasedAccess) {
        return this.inObjectInitMethod() && this.isObjectFieldInitialization(fieldBasedAccess);
    }

    private boolean inObjectInitMethod() {
        BLangInvokableNode enclInvokable = this.env.enclInvokable;
        if (enclInvokable == null || enclInvokable.getKind() != NodeKind.FUNCTION) {
            return false;
        }
        return ((BLangFunction)enclInvokable).objInitFunction;
    }

    private boolean isVarRequiringInference(BSymbol moduleLevelVarSymbol) {
        long symbolFlags = moduleLevelVarSymbol.flags;
        if (Symbols.isFlagOn(symbolFlags, 1L) || Symbols.isFlagOn(symbolFlags, 0x20000000L)) {
            return false;
        }
        if (!Symbols.isFlagOn(symbolFlags, 4L)) {
            return true;
        }
        BType type = moduleLevelVarSymbol.type;
        return !this.types.isInherentlyImmutableType(type) && !Symbols.isFlagOn(type.getFlags(), 32L);
    }

    private void populateInferableClass(BLangClassDefinition classDefinition) {
        if (Symbols.isFlagOn(classDefinition.symbol.flags, 1L) && !classDefinition.isServiceDecl && !classDefinition.flagSet.contains((Object)Flag.OBJECT_CTOR)) {
            return;
        }
        BType type = classDefinition.getBType();
        if (Symbols.isFlagOn(type.getFlags(), 0x20000000L)) {
            return;
        }
        HashSet<BLangIdentifier> protectedFields = new HashSet<BLangIdentifier>();
        HashSet<BSymbol> dependentObjectTypes = new HashSet<BSymbol>();
        HashMap<String, BLangSimpleVariable> fields = new HashMap<String, BLangSimpleVariable>();
        for (BLangSimpleVariable field : classDefinition.fields) {
            fields.put(field.name.value, field);
        }
        for (BLangSimpleVariable referencedField : classDefinition.referencedFields) {
            String name = referencedField.name.value;
            if (fields.containsKey(name)) continue;
            fields.put(name, referencedField);
        }
        for (BLangSimpleVariable field : fields.values()) {
            boolean isFinal = field.flagSet.contains((Object)Flag.FINAL);
            boolean isPrivate = field.flagSet.contains((Object)Flag.PRIVATE);
            if (!isFinal && !isPrivate) {
                return;
            }
            BType fieldType = field.getBType();
            if (isFinal && this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(fieldType)) continue;
            boolean subtypeOfReadOnlyOrIsolatedObjectOrInferableObject = this.isSubtypeOfReadOnlyOrIsolatedObjectOrInferableObject(classDefinition.symbol.owner, fieldType, dependentObjectTypes);
            if (!isPrivate && !subtypeOfReadOnlyOrIsolatedObjectOrInferableObject) {
                return;
            }
            protectedFields.add(field.name);
        }
        ClassIsolationInferenceInfo inferenceInfo = new ClassIsolationInferenceInfo(protectedFields);
        this.isolationInferenceInfoMap.put(classDefinition.symbol, inferenceInfo);
        inferenceInfo.dependsOnVariablesAndClasses.addAll(dependentObjectTypes);
    }

    private boolean isSubtypeOfReadOnlyOrIsolatedObjectOrInferableObject(BSymbol owner, BType type) {
        return this.isSubtypeOfReadOnlyOrIsolatedObjectOrInferableObject(owner, type, new HashSet<BSymbol>());
    }

    private boolean isSubtypeOfReadOnlyOrIsolatedObjectOrInferableObject(BSymbol owner, BType type, Set<BSymbol> inferableClasses) {
        if (this.types.isSubTypeOfReadOnlyOrIsolatedObjectUnion(type = Types.getImpliedType(type))) {
            return true;
        }
        int tag = type.tag;
        if (tag == 34) {
            boolean inferable;
            BTypeSymbol tsymbol = type.tsymbol;
            boolean bl = inferable = tsymbol.owner == owner && !Symbols.isFlagOn(tsymbol.flags, 1L);
            if (inferable) {
                inferableClasses.add(tsymbol);
            }
            return inferable;
        }
        if (tag != 21) {
            return false;
        }
        for (BType memberType : ((BUnionType)type).getMemberTypes()) {
            if (this.isSubtypeOfReadOnlyOrIsolatedObjectOrInferableObject(owner, memberType, inferableClasses)) continue;
            return false;
        }
        return true;
    }

    private Set<BType> getPubliclyExposedObjectTypes(final BLangPackage bLangPackage) {
        Set<Flag> flagSet;
        HashSet<BType> publiclyExposedTypes = new HashSet<BType>();
        BPubliclyExposedInferableTypeCollector collector = new BPubliclyExposedInferableTypeCollector(publiclyExposedTypes);
        ArrayList<BLangVariable> moduleVarsAndConstants = new ArrayList<BLangVariable>(){
            {
                this.addAll(bLangPackage.globalVars);
                this.addAll(bLangPackage.constants);
            }
        };
        for (BLangVariable construct : moduleVarsAndConstants) {
            BLangType typeNode;
            if (!construct.flagSet.contains((Object)Flag.PUBLIC) || (typeNode = construct.typeNode) == null) continue;
            collector.visitType(typeNode.getBType());
        }
        for (BLangTypeDefinition typeDefinition : bLangPackage.typeDefinitions) {
            flagSet = typeDefinition.flagSet;
            if (!flagSet.contains((Object)Flag.PUBLIC) || flagSet.contains((Object)Flag.ANONYMOUS)) continue;
            collector.visitType(typeDefinition.typeNode.getBType());
        }
        for (BLangClassDefinition classDefinition : bLangPackage.classDefinitions) {
            flagSet = classDefinition.flagSet;
            if (!flagSet.contains((Object)Flag.PUBLIC) || classDefinition.isServiceDecl || flagSet.contains((Object)Flag.OBJECT_CTOR)) continue;
            collector.visitType(classDefinition.getBType());
        }
        for (BLangFunction function : bLangPackage.functions) {
            if (!function.flagSet.contains((Object)Flag.PUBLIC) && (!function.attachedFunction || !function.receiver.flagSet.contains((Object)Flag.PUBLIC))) continue;
            collector.visitType(function.getBType());
        }
        return publiclyExposedTypes;
    }

    private void inferIsolation(Set<BSymbol> moduleLevelVarSymbols, Set<BType> publiclyExposedObjectTypes, List<BLangClassDefinition> classDefinitions, List<BLangVariable> moduleLevelVariables) {
        for (Map.Entry<BSymbol, IsolationInferenceInfo> entry : this.isolationInferenceInfoMap.entrySet()) {
            boolean isObjectType;
            IsolationInferenceInfo value = entry.getValue();
            BSymbol symbol = entry.getKey();
            if (value.getKind() == IsolationInferenceKind.FUNCTION) {
                if (!this.inferFunctionIsolation(symbol, value, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, new HashSet<BSymbol>())) continue;
                symbol.flags |= 0x20000000L;
                if (moduleLevelVarSymbols.contains(symbol)) continue;
                symbol.type.addFlags(0x20000000L);
                continue;
            }
            boolean bl = isObjectType = symbol.kind == SymbolKind.OBJECT;
            if (!isObjectType && this.isFinalVarOfReadOnlyOrIsolatedObjectTypeWithInference(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, symbol, new HashSet<BSymbol>()) || !this.inferVariableOrClassIsolation(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, symbol, (VariableIsolationInferenceInfo)value, isObjectType, new HashSet<BSymbol>())) continue;
            symbol.flags |= 0x20000000L;
            if (!isObjectType) continue;
            symbol.type.addFlags(0x20000000L);
        }
        this.isolationInferenceInfoMap.clear();
        this.arrowFunctionTempSymbolMap.clear();
    }

    private boolean inferVariableOrClassIsolation(Set<BType> publiclyExposedObjectTypes, List<BLangClassDefinition> classDefinitions, List<BLangVariable> moduleLevelVariables, BSymbol symbol, VariableIsolationInferenceInfo inferenceInfo, boolean isObjectType, Set<BSymbol> unresolvedSymbols) {
        if (!unresolvedSymbols.add(symbol)) {
            return true;
        }
        if (!inferenceInfo.dependsOnlyOnInferableConstructs) {
            return false;
        }
        if (inferenceInfo.accessedOutsideLockStatement) {
            if (!inferenceInfo.accessOutsideLockStatementValidIfInferredIsolated) {
                if (inferenceInfo.getKind() == IsolationInferenceKind.CLASS) {
                    return false;
                }
                if (Symbols.isFlagOn(symbol.flags, 4L)) {
                    return this.isSubTypeOfReadOnlyOrIsolatedObjectUnionWithInference(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, true, symbol.type, unresolvedSymbols);
                }
                return false;
            }
            for (BType bType : inferenceInfo.typesOfFinalFieldsAccessedOutsideLock) {
                if (this.isSubTypeOfReadOnlyOrIsolatedObjectUnionWithInference(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, true, bType, unresolvedSymbols)) continue;
                return false;
            }
        }
        if (isObjectType) {
            if (publiclyExposedObjectTypes.contains(symbol.type)) {
                return false;
            }
            BLangClassDefinition classDefinition = null;
            for (BLangClassDefinition classDef : classDefinitions) {
                if (classDef.symbol != symbol) continue;
                classDefinition = classDef;
                break;
            }
            if (classDefinition != null) {
                List<BLangSimpleVariable> list = classDefinition.fields;
                HashMap<BLangIdentifier, BLangSimpleVariable> fields = new HashMap<BLangIdentifier, BLangSimpleVariable>(list.size());
                for (BLangSimpleVariable classField : list) {
                    fields.put(classField.name, classField);
                }
                for (BLangIdentifier protectedField : ((ClassIsolationInferenceInfo)inferenceInfo).protectedFields) {
                    BLangSimpleVariable field = (BLangSimpleVariable)fields.get(protectedField);
                    if (field.flagSet.contains((Object)Flag.PRIVATE)) continue;
                    if (!field.flagSet.contains((Object)Flag.FINAL)) {
                        return false;
                    }
                    BType fieldType = field.typeNode.getBType();
                    if (this.isSubTypeOfReadOnlyOrIsolatedObjectUnionWithInference(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, true, fieldType, unresolvedSymbols)) continue;
                    return false;
                }
                for (BLangSimpleVariable field : classDefinition.fields) {
                    BLangExpression expr = field.expr;
                    if (expr == null || this.isIsolatedExpression(expr, false, false, new ArrayList<BLangExpression>(), true, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols)) continue;
                    return false;
                }
                BLangFunction initFunction = classDefinition.initFunction;
                if (initFunction != null) {
                    BLangFunctionBody body = initFunction.body;
                    for (BLangStatement stmt : ((BLangBlockFunctionBody)body).stmts) {
                        if (stmt.getKind() != NodeKind.ASSIGNMENT) continue;
                        BLangAssignment assignmentStmt = (BLangAssignment)stmt;
                        BLangExpression lhs = assignmentStmt.varRef;
                        if (lhs.getKind() != NodeKind.FIELD_BASED_ACCESS_EXPR) continue;
                        BLangFieldBasedAccess fieldAccessExpr = (BLangFieldBasedAccess)lhs;
                        BLangExpression calledOnExpr = fieldAccessExpr.expr;
                        if (calledOnExpr.getKind() != NodeKind.SIMPLE_VARIABLE_REF || !this.isSelfOfObject((BLangSimpleVarRef)calledOnExpr) || this.isIsolatedExpression(assignmentStmt.expr, false, false, new ArrayList<BLangExpression>(), true, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols)) continue;
                        return false;
                    }
                }
            }
        } else {
            if (this.isFinalVarOfReadOnlyOrIsolatedObjectTypeWithInference(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, symbol, unresolvedSymbols)) {
                return true;
            }
            if (Symbols.isFlagOn(symbol.flags, 524288L)) {
                return false;
            }
            BLangVariable variable = null;
            for (BLangVariable moduleLevelVariable : moduleLevelVariables) {
                if (symbol != moduleLevelVariable.symbol) continue;
                variable = moduleLevelVariable;
                break;
            }
            if (variable != null) {
                BLangExpression bLangExpression = variable.expr;
                if (bLangExpression != null) {
                    if (!this.isIsolatedExpression(bLangExpression, false, false, new ArrayList<BLangExpression>(), true, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        for (LockInfo lockInfo : inferenceInfo.accessedLockInfo) {
            if (!lockInfo.accessedRestrictedVars.isEmpty()) {
                return false;
            }
            for (BSymbol accessedPotentiallyIsolatedVar : lockInfo.accessedPotentiallyIsolatedVars) {
                if (accessedPotentiallyIsolatedVar == symbol || this.isFinalVarOfReadOnlyOrIsolatedObjectTypeWithInference(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, accessedPotentiallyIsolatedVar, unresolvedSymbols)) continue;
                return false;
            }
            for (BLangExpression expr : lockInfo.nonIsolatedTransferInExpressions) {
                if (expr.getKind() == NodeKind.SIMPLE_VARIABLE_REF && ((BLangSimpleVarRef)expr).symbol == symbol || this.isIsolatedExpression(expr, false, false, new ArrayList<BLangExpression>(), true, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols)) continue;
                return false;
            }
            for (BLangExpression expr : lockInfo.nonIsolatedTransferOutExpressions) {
                if (this.isIsolatedExpression(expr, false, false, new ArrayList<BLangExpression>(), true, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols)) continue;
                return false;
            }
            for (BLangInvocation nonIsolatedInvocation : lockInfo.nonIsolatedInvocations) {
                BSymbol funcSymbol = nonIsolatedInvocation.symbol;
                if (!this.isolationInferenceInfoMap.containsKey(funcSymbol)) {
                    return false;
                }
                if (this.inferFunctionIsolation(funcSymbol, this.isolationInferenceInfoMap.get(funcSymbol), publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isFinalVarOfReadOnlyOrIsolatedObjectTypeWithInference(Set<BType> publiclyExposedObjectTypes, List<BLangClassDefinition> classDefinitions, List<BLangVariable> moduleLevelVariables, BSymbol symbol, Set<BSymbol> unresolvedSymbols) {
        return Symbols.isFlagOn(symbol.flags, 4L) && this.isSubTypeOfReadOnlyOrIsolatedObjectUnionWithInference(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, true, symbol.type, unresolvedSymbols);
    }

    private boolean inferFunctionIsolation(BSymbol symbol, IsolationInferenceInfo functionIsolationInferenceInfo, Set<BType> publiclyExposedObjectTypes, List<BLangClassDefinition> classDefinitions, List<BLangVariable> moduleLevelVariables, Set<BSymbol> unresolvedSymbols) {
        BVarSymbol receiverSymbol;
        if (!unresolvedSymbols.add(symbol)) {
            return true;
        }
        if (!functionIsolationInferenceInfo.dependsOnlyOnInferableConstructs) {
            return false;
        }
        if (symbol.kind == SymbolKind.FUNCTION && (receiverSymbol = ((BInvokableSymbol)symbol).receiverSymbol) != null && Types.getImpliedType((BType)receiverSymbol.type).tag == 34 && publiclyExposedObjectTypes.contains(receiverSymbol.type)) {
            return false;
        }
        if (functionIsolationInferenceInfo.inferredIsolated) {
            return true;
        }
        for (BInvokableSymbol bInvokableSymbol : functionIsolationInferenceInfo.dependsOnFunctions) {
            if (!this.isolationInferenceInfoMap.containsKey(bInvokableSymbol)) {
                return false;
            }
            if (this.inferFunctionIsolation(bInvokableSymbol, this.isolationInferenceInfoMap.get(bInvokableSymbol), publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols)) continue;
            return false;
        }
        for (BSymbol dependsOnVariable : functionIsolationInferenceInfo.dependsOnVariablesAndClasses) {
            if (Symbols.isFlagOn(dependsOnVariable.flags, 0x20000000L)) continue;
            if (!this.isolationInferenceInfoMap.containsKey(dependsOnVariable)) {
                return false;
            }
            if (this.inferVariableOrClassIsolation(publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, dependsOnVariable, (VariableIsolationInferenceInfo)this.isolationInferenceInfoMap.get(dependsOnVariable), false, unresolvedSymbols)) continue;
            return false;
        }
        for (BLangExpression dependsOnArg : functionIsolationInferenceInfo.dependsOnFuncCallArgExprs) {
            if (this.isIsolatedExpression(dependsOnArg, false, false, new ArrayList<BLangExpression>(), true, publiclyExposedObjectTypes, classDefinitions, moduleLevelVariables, unresolvedSymbols)) continue;
            return false;
        }
        if (unresolvedSymbols.size() == 1) {
            functionIsolationInferenceInfo.inferredIsolated = true;
        }
        return true;
    }

    private void logServiceIsolationHints(List<BLangClassDefinition> classDefinitions) {
        for (BLangClassDefinition classDefinition : classDefinitions) {
            if (!classDefinition.flagSet.contains((Object)Flag.SERVICE)) continue;
            this.logServiceIsolationHints(classDefinition);
        }
    }

    private void logServiceIsolationHints(BLangClassDefinition classDefinition) {
        boolean isolatedService = this.isIsolated(classDefinition.getBType().getFlags());
        for (BLangFunction function : classDefinition.functions) {
            Set flagSet = function.flagSet;
            if (!flagSet.contains((Object)Flag.RESOURCE) && !flagSet.contains((Object)Flag.REMOTE)) continue;
            boolean isolatedMethod = this.isIsolated(function.getBType().getFlags());
            if (isolatedService && isolatedMethod) continue;
            this.dlog.hint(this.getStartLocation(function.pos), this.getHintCode(isolatedService, isolatedMethod), new Object[0]);
        }
    }

    private Location getStartLocation(Location location) {
        LineRange lineRange = location.lineRange();
        LinePosition linePosition = lineRange.startLine();
        int startLine = linePosition.line();
        int startColumn = linePosition.offset();
        return new BLangDiagnosticLocation(lineRange.fileName(), startLine, startLine, startColumn, startColumn);
    }

    private DiagnosticHintCode getHintCode(boolean isolatedService, boolean isolatedMethod) {
        if (!isolatedService && !isolatedMethod) {
            return DiagnosticHintCode.CONCURRENT_CALLS_WILL_NOT_BE_MADE_TO_NON_ISOLATED_METHOD_IN_NON_ISOLATED_SERVICE;
        }
        if (isolatedService) {
            return DiagnosticHintCode.CONCURRENT_CALLS_WILL_NOT_BE_MADE_TO_NON_ISOLATED_METHOD;
        }
        return DiagnosticHintCode.CONCURRENT_CALLS_WILL_NOT_BE_MADE_TO_NON_ISOLATED_SERVICE;
    }

    private BInvokableSymbol createTempSymbolIfNonExistent(BLangArrowFunction bLangArrowFunction) {
        if (this.arrowFunctionTempSymbolMap.containsKey(bLangArrowFunction)) {
            return this.arrowFunctionTempSymbolMap.get(bLangArrowFunction);
        }
        TemporaryArrowFunctionSymbol symbol = new TemporaryArrowFunctionSymbol(this, bLangArrowFunction);
        this.arrowFunctionTempSymbolMap.put(bLangArrowFunction, symbol);
        this.isolationInferenceInfoMap.put(symbol, new IsolationInferenceInfo());
        return symbol;
    }

    private static class IsolationInferenceInfo {
        boolean dependsOnlyOnInferableConstructs = true;
        Set<BInvokableSymbol> dependsOnFunctions = new HashSet<BInvokableSymbol>();
        Set<BSymbol> dependsOnVariablesAndClasses = new HashSet<BSymbol>();
        Set<BLangExpression> dependsOnFuncCallArgExprs = new HashSet<BLangExpression>();
        boolean inferredIsolated = false;

        private IsolationInferenceInfo() {
        }

        IsolationInferenceKind getKind() {
            return IsolationInferenceKind.FUNCTION;
        }
    }

    private static class LockInfo {
        BLangLock lockNode;
        Map<BSymbol, List<BLangSimpleVarRef>> accessedRestrictedVars = new HashMap<BSymbol, List<BLangSimpleVarRef>>();
        List<BLangSimpleVarRef> nonCaptureBindingPatternVarRefsOnLhs = new ArrayList<BLangSimpleVarRef>();
        List<BLangExpression> nonIsolatedTransferInExpressions = new ArrayList<BLangExpression>();
        List<BLangExpression> nonIsolatedTransferOutExpressions = new ArrayList<BLangExpression>();
        List<BLangInvocation> nonIsolatedInvocations = new ArrayList<BLangInvocation>();
        Set<BSymbol> accessedPotentiallyIsolatedVars = new HashSet<BSymbol>();

        private LockInfo(BLangLock lockNode) {
            this.lockNode = lockNode;
        }
    }

    private static enum IsolationInferenceKind {
        CLASS,
        VARIABLE,
        FUNCTION;

    }

    private static class VariableIsolationInferenceInfo
    extends IsolationInferenceInfo {
        Set<LockInfo> accessedLockInfo = new HashSet<LockInfo>();
        boolean accessedOutsideLockStatement = false;
        boolean accessOutsideLockStatementValidIfInferredIsolated = true;
        Set<BType> typesOfFinalFieldsAccessedOutsideLock = new HashSet<BType>();

        private VariableIsolationInferenceInfo() {
        }

        @Override
        IsolationInferenceKind getKind() {
            return IsolationInferenceKind.VARIABLE;
        }
    }

    private static class ClassIsolationInferenceInfo
    extends VariableIsolationInferenceInfo {
        Set<BLangIdentifier> protectedFields;

        ClassIsolationInferenceInfo(Set<BLangIdentifier> protectedFields) {
            this.protectedFields = protectedFields;
        }

        @Override
        IsolationInferenceKind getKind() {
            return IsolationInferenceKind.CLASS;
        }
    }

    private static class BPubliclyExposedInferableTypeCollector
    extends TypeVisitor {
        Set<BType> unresolvedTypes = new HashSet<BType>();
        Set<BType> exposedTypes;

        public BPubliclyExposedInferableTypeCollector(Set<BType> exposedTypes) {
            this.exposedTypes = exposedTypes;
        }

        public void visitType(BType type) {
            if (type == null) {
                return;
            }
            if (!this.unresolvedTypes.add(type)) {
                return;
            }
            type.accept(this);
        }

        @Override
        public void visit(BAnnotationType bAnnotationType) {
        }

        @Override
        public void visit(BArrayType bArrayType) {
            this.visitType(bArrayType.eType);
        }

        @Override
        public void visit(BAnyType bAnyType) {
        }

        @Override
        public void visit(BAnydataType bAnydataType) {
        }

        @Override
        public void visit(BErrorType bErrorType) {
            this.visitType(bErrorType.detailType);
        }

        @Override
        public void visit(BFiniteType bFiniteType) {
        }

        @Override
        public void visit(BInvokableType bInvokableType) {
            if (Symbols.isFlagOn(bInvokableType.getFlags(), 0x8000000000L)) {
                return;
            }
            for (BType paramType : bInvokableType.paramTypes) {
                this.visitType(paramType);
            }
            this.visitType(bInvokableType.restType);
            this.visitType(bInvokableType.retType);
        }

        @Override
        public void visit(BJSONType bjsonType) {
        }

        @Override
        public void visit(BMapType bMapType) {
            this.visitType(bMapType.constraint);
        }

        @Override
        public void visit(BStreamType bStreamType) {
            this.visitType(bStreamType.constraint);
            this.visitType(bStreamType.completionType);
        }

        @Override
        public void visit(BTypedescType bTypedescType) {
            this.visitType(bTypedescType.constraint);
        }

        @Override
        public void visit(BTypeReferenceType bTypeReferenceType) {
            this.visitType(bTypeReferenceType.referredType);
        }

        @Override
        public void visit(BParameterizedType bTypedescType) {
        }

        @Override
        public void visit(BNeverType bNeverType) {
        }

        @Override
        public void visitNilType(BType bType) {
        }

        @Override
        public void visit(BNoType bNoType) {
        }

        @Override
        public void visit(BPackageType bPackageType) {
        }

        @Override
        public void visit(BStructureType bStructureType) {
        }

        @Override
        public void visit(BTupleType bTupleType) {
            for (BType memType : bTupleType.getTupleTypes()) {
                this.visitType(memType);
            }
            this.visitType(bTupleType.restType);
        }

        @Override
        public void visit(BUnionType bUnionType) {
            for (BType memType : bUnionType.getMemberTypes()) {
                this.visitType(memType);
            }
        }

        @Override
        public void visit(BIntersectionType bIntersectionType) {
            for (BType constituentType : bIntersectionType.getConstituentTypes()) {
                this.visitType(constituentType);
            }
            this.visitType(bIntersectionType.effectiveType);
        }

        @Override
        public void visit(BXMLType bXmlType) {
            this.visitType(bXmlType.constraint);
        }

        @Override
        public void visit(BTableType bTableType) {
            this.visitType(bTableType.constraint);
            this.visitType(bTableType.keyTypeConstraint);
        }

        @Override
        public void visit(BRecordType bRecordType) {
            for (BField field : bRecordType.fields.values()) {
                this.visitType(field.type);
            }
            if (!bRecordType.sealed) {
                this.visitType(bRecordType.restFieldType);
            }
        }

        @Override
        public void visit(BObjectType bObjectType) {
            this.exposedTypes.add(bObjectType);
            for (BField field : bObjectType.fields.values()) {
                this.visitType(field.type);
            }
            for (BAttachedFunction attachedFunc : ((BObjectTypeSymbol)bObjectType.tsymbol).attachedFuncs) {
                this.visitType(attachedFunc.type);
            }
        }

        @Override
        public void visit(BFutureType bFutureType) {
            this.visitType(bFutureType.constraint);
        }

        @Override
        public void visit(BHandleType bHandleType) {
        }
    }

    private class TemporaryArrowFunctionSymbol
    extends BInvokableSymbol {
        TemporaryArrowFunctionSymbol(IsolationAnalyzer isolationAnalyzer, BLangArrowFunction fn) {
            super(820L, 0L, Names.EMPTY, isolationAnalyzer.env.enclPkg.symbol.pkgID, fn.funcType, (BSymbol)isolationAnalyzer.env.enclEnv.enclVarSym, null, SymbolOrigin.VIRTUAL);
            this.kind = SymbolKind.FUNCTION;
        }
    }
}

