/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.EnumerableCharString;
import io.ballerina.types.EnumerableDecimal;
import io.ballerina.types.EnumerableFloat;
import io.ballerina.types.EnumerableString;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.BooleanSubtype;
import io.ballerina.types.subtypedata.CharStringSubtype;
import io.ballerina.types.subtypedata.DecimalSubtype;
import io.ballerina.types.subtypedata.FloatSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.NonCharStringSubtype;
import io.ballerina.types.subtypedata.Range;
import io.ballerina.types.subtypedata.StringSubtype;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.SemNamedType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;

public final class SemTypeHelper {
    private SemTypeHelper() {
    }

    public static SemType resolveSingletonType(BLangLiteral literal) {
        return SemTypeHelper.resolveSingletonType(literal.value, literal.getDeterminedType().getKind());
    }

    public static SemType resolveSingletonType(Object value, TypeKind targetTypeKind) {
        switch (targetTypeKind) {
            case FLOAT: {
                double doubleVal;
                if (value instanceof Long) {
                    doubleVal = ((Long)value).doubleValue();
                } else if (value instanceof Double) {
                    doubleVal = (Double)value;
                } else {
                    try {
                        doubleVal = Double.parseDouble((String)value);
                    }
                    catch (NumberFormatException e) {
                        return FloatSubtype.floatConst((double)0.0);
                    }
                }
                return SemTypes.floatConst((double)doubleVal);
            }
            case INT: 
            case BYTE: {
                return SemTypes.intConst((long)((Number)value).longValue());
            }
            case STRING: {
                return SemTypes.stringConst((String)((String)value));
            }
            case BOOLEAN: {
                return SemTypes.booleanConst((boolean)((Boolean)value));
            }
            case DECIMAL: {
                return SemTypes.decimalConst((String)((String)value));
            }
            case NIL: {
                return PredefinedType.NIL;
            }
            case OTHER: {
                return PredefinedType.NEVER;
            }
        }
        throw new UnsupportedOperationException("Finite type not implemented for: " + String.valueOf((Object)targetTypeKind));
    }

    public static boolean isSubtypeSimple(BType bt, BasicTypeBitSet bbs) {
        return SemTypes.isSubtypeSimple((SemType)bt.semType(), (BasicTypeBitSet)bbs);
    }

    public static boolean isSubtypeSimpleNotNever(BType bt, BasicTypeBitSet bbs) {
        return SemTypes.isSubtypeSimpleNotNever((SemType)bt.semType(), (BasicTypeBitSet)bbs);
    }

    public static boolean containsBasicType(BType bt, BasicTypeBitSet bbs) {
        return SemTypes.containsBasicType((SemType)bt.semType(), (BasicTypeBitSet)bbs);
    }

    public static boolean containsType(Context ctx, BType bt, SemType bbs) {
        return SemTypes.containsType((Context)ctx, (SemType)bt.semType(), (SemType)bbs);
    }

    public static boolean isSubtype(Context context, BType bt, SemType st) {
        return SemTypes.isSubtype((Context)context, (SemType)bt.semType(), (SemType)st);
    }

    public static boolean isSimpleOrString(TypeKind kind) {
        switch (kind) {
            case FLOAT: 
            case INT: 
            case BYTE: 
            case STRING: 
            case BOOLEAN: 
            case DECIMAL: 
            case NIL: 
            case FINITE: {
                return true;
            }
        }
        return false;
    }

    public static Optional<BType> singleShapeBroadType(SemType t, SymbolTable symTable) {
        if (PredefinedType.NIL.equals((Object)t)) {
            return Optional.of(symTable.nilType);
        }
        if (t instanceof BasicTypeBitSet) {
            return Optional.empty();
        }
        if (SemTypes.isSubtypeSimple((SemType)t, (BasicTypeBitSet)PredefinedType.INT)) {
            SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)((ComplexSemType)t), (BasicTypeCode)BasicTypeCode.BT_INT);
            Optional value = IntSubtype.intSubtypeSingleValue((SubtypeData)sd);
            return value.isEmpty() ? Optional.empty() : Optional.of(symTable.intType);
        }
        if (SemTypes.isSubtypeSimple((SemType)t, (BasicTypeBitSet)PredefinedType.FLOAT)) {
            SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)((ComplexSemType)t), (BasicTypeCode)BasicTypeCode.BT_FLOAT);
            Optional value = FloatSubtype.floatSubtypeSingleValue((SubtypeData)sd);
            return value.isEmpty() ? Optional.empty() : Optional.of(symTable.floatType);
        }
        if (SemTypes.isSubtypeSimple((SemType)t, (BasicTypeBitSet)PredefinedType.STRING)) {
            SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)((ComplexSemType)t), (BasicTypeCode)BasicTypeCode.BT_STRING);
            Optional value = StringSubtype.stringSubtypeSingleValue((SubtypeData)sd);
            return value.isEmpty() ? Optional.empty() : Optional.of(symTable.stringType);
        }
        if (SemTypes.isSubtypeSimple((SemType)t, (BasicTypeBitSet)PredefinedType.BOOLEAN)) {
            SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)((ComplexSemType)t), (BasicTypeCode)BasicTypeCode.BT_BOOLEAN);
            Optional value = BooleanSubtype.booleanSubtypeSingleValue((SubtypeData)sd);
            return value.isEmpty() ? Optional.empty() : Optional.of(symTable.booleanType);
        }
        if (SemTypes.isSubtypeSimple((SemType)t, (BasicTypeBitSet)PredefinedType.DECIMAL)) {
            SubtypeData sd = Core.getComplexSubtypeData((ComplexSemType)((ComplexSemType)t), (BasicTypeCode)BasicTypeCode.BT_DECIMAL);
            Optional value = DecimalSubtype.decimalSubtypeSingleValue((SubtypeData)sd);
            return value.isEmpty() ? Optional.empty() : Optional.of(symTable.decimalType);
        }
        return Optional.empty();
    }

    public static Set<BType> broadTypes(SemType t, SymbolTable symTable) {
        LinkedHashSet<BType> types = new LinkedHashSet<BType>(7);
        BasicTypeBitSet basicTypeBitSet = Core.widenToBasicTypes((SemType)t);
        if ((basicTypeBitSet.bitset & PredefinedType.NIL.bitset) != 0) {
            types.add(symTable.nilType);
        }
        if ((basicTypeBitSet.bitset & PredefinedType.BOOLEAN.bitset) != 0) {
            types.add(symTable.booleanType);
        }
        if ((basicTypeBitSet.bitset & PredefinedType.INT.bitset) != 0) {
            types.add(symTable.intType);
        }
        if ((basicTypeBitSet.bitset & PredefinedType.FLOAT.bitset) != 0) {
            types.add(symTable.floatType);
        }
        if ((basicTypeBitSet.bitset & PredefinedType.DECIMAL.bitset) != 0) {
            types.add(symTable.decimalType);
        }
        if ((basicTypeBitSet.bitset & PredefinedType.STRING.bitset) != 0) {
            types.add(symTable.stringType);
        }
        return types;
    }

    public static Set<BType> broadTypes(BFiniteType finiteType, SymbolTable symTable) {
        LinkedHashSet<BType> types = new LinkedHashSet<BType>(7);
        for (SemNamedType semNamedType : finiteType.valueSpace) {
            SemType t = semNamedType.semType();
            BasicTypeBitSet basicTypeBitSet = Core.widenToBasicTypes((SemType)t);
            if ((basicTypeBitSet.bitset & PredefinedType.NIL.bitset) != 0) {
                types.add(symTable.nilType);
            }
            if ((basicTypeBitSet.bitset & PredefinedType.BOOLEAN.bitset) != 0) {
                types.add(symTable.booleanType);
            }
            if ((basicTypeBitSet.bitset & PredefinedType.INT.bitset) != 0) {
                types.add(symTable.intType);
            }
            if ((basicTypeBitSet.bitset & PredefinedType.FLOAT.bitset) != 0) {
                types.add(symTable.floatType);
            }
            if ((basicTypeBitSet.bitset & PredefinedType.DECIMAL.bitset) != 0) {
                types.add(symTable.decimalType);
            }
            if ((basicTypeBitSet.bitset & PredefinedType.STRING.bitset) == 0) continue;
            types.add(symTable.stringType);
        }
        return types;
    }

    public static int bitCount(int bitset) {
        int n = 0;
        int v = bitset;
        while (v != 0) {
            v &= v - 1;
            ++n;
        }
        return n;
    }

    public static Optional<String> getStringValue(BType type) {
        SemType semType = type.semType();
        if (Core.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.NIL)) {
            return Optional.of("");
        }
        if (Core.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.BOOLEAN)) {
            return SemTypeHelper.getSingletonBooleanValue(semType).map(String::valueOf);
        }
        if (Core.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.INT)) {
            return SemTypeHelper.getSingletonIntegerValue(semType).map(String::valueOf);
        }
        if (Core.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.FLOAT)) {
            return SemTypeHelper.getSingletonFloatValue(semType).map(String::valueOf);
        }
        if (Core.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.DECIMAL)) {
            return SemTypeHelper.getSingletonDecimalValue(semType).map(String::valueOf);
        }
        if (Core.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.STRING)) {
            return SemTypeHelper.getSingletonStringValue(semType);
        }
        return Optional.empty();
    }

    private static Optional<Boolean> getSingletonBooleanValue(SemType semType) {
        SubtypeData subtypeData = Core.subtypeData((SemType)semType, (BasicTypeCode)BasicTypeCode.BT_BOOLEAN);
        if (!(subtypeData instanceof BooleanSubtype)) {
            assert (subtypeData instanceof AllOrNothingSubtype);
            return Optional.empty();
        }
        BooleanSubtype booleanSubtype = (BooleanSubtype)subtypeData;
        return Optional.of(booleanSubtype.value);
    }

    private static Optional<Long> getSingletonIntegerValue(SemType semType) {
        SubtypeData subtypeData = Core.subtypeData((SemType)semType, (BasicTypeCode)BasicTypeCode.BT_INT);
        if (!(subtypeData instanceof IntSubtype)) {
            assert (subtypeData instanceof AllOrNothingSubtype);
            return Optional.empty();
        }
        IntSubtype intSubtype = (IntSubtype)subtypeData;
        Range[] ranges = intSubtype.ranges;
        if (ranges.length != 1) {
            return Optional.empty();
        }
        Range range = ranges[0];
        if (range.min != range.max) {
            return Optional.empty();
        }
        return Optional.of(range.min);
    }

    private static Optional<Double> getSingletonFloatValue(SemType semType) {
        SubtypeData subtypeData = Core.subtypeData((SemType)semType, (BasicTypeCode)BasicTypeCode.BT_FLOAT);
        if (!(subtypeData instanceof FloatSubtype)) {
            assert (subtypeData instanceof AllOrNothingSubtype);
            return Optional.empty();
        }
        FloatSubtype floatSubtypeData = (FloatSubtype)subtypeData;
        if (!floatSubtypeData.allowed) {
            return Optional.empty();
        }
        EnumerableFloat[] values = (EnumerableFloat[])floatSubtypeData.values();
        if (values.length != 1) {
            return Optional.empty();
        }
        return Optional.of(values[0].value);
    }

    private static Optional<BigDecimal> getSingletonDecimalValue(SemType semType) {
        SubtypeData subtypeData = Core.subtypeData((SemType)semType, (BasicTypeCode)BasicTypeCode.BT_DECIMAL);
        if (!(subtypeData instanceof DecimalSubtype)) {
            assert (subtypeData instanceof AllOrNothingSubtype);
            return Optional.empty();
        }
        DecimalSubtype decimalSubtype = (DecimalSubtype)subtypeData;
        if (!decimalSubtype.allowed) {
            return Optional.empty();
        }
        EnumerableDecimal[] values = (EnumerableDecimal[])decimalSubtype.values();
        if (values.length != 1) {
            return Optional.empty();
        }
        return Optional.of(values[0].value);
    }

    private static Optional<String> getSingletonStringValue(SemType semType) {
        SubtypeData subtypeData = Core.subtypeData((SemType)semType, (BasicTypeCode)BasicTypeCode.BT_STRING);
        if (!(subtypeData instanceof StringSubtype)) {
            assert (subtypeData instanceof AllOrNothingSubtype);
            return Optional.empty();
        }
        StringSubtype stringSubtypeData = (StringSubtype)subtypeData;
        CharStringSubtype charData = stringSubtypeData.getChar();
        NonCharStringSubtype nonCharData = stringSubtypeData.getNonChar();
        if (!charData.allowed || !nonCharData.allowed) {
            return Optional.empty();
        }
        if (charData.values().length == 1) {
            EnumerableCharString charValue = (EnumerableCharString)charData.values()[0];
            return Optional.of(charValue.value);
        }
        if (nonCharData.values().length == 1) {
            EnumerableString nonCharValue = (EnumerableString)nonCharData.values()[0];
            return Optional.of(nonCharValue.value);
        }
        return Optional.empty();
    }
}

