/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.PredefinedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.Name;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BReadonlyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ImmutableTypeCloner;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class TypeParamAnalyzer {
    private static final CompilerContext.Key<TypeParamAnalyzer> TYPE_PARAM_ANALYZER_KEY = new CompilerContext.Key();
    private final SymbolTable symTable;
    private final Types types;
    private final Names names;
    private final BLangDiagnosticLog dlog;
    private final BLangAnonymousModelHelper anonymousModelHelper;

    public static TypeParamAnalyzer getInstance(CompilerContext context) {
        TypeParamAnalyzer types = context.get(TYPE_PARAM_ANALYZER_KEY);
        if (types == null) {
            types = new TypeParamAnalyzer(context);
        }
        return types;
    }

    private TypeParamAnalyzer(CompilerContext context) {
        context.put(TYPE_PARAM_ANALYZER_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.names = Names.getInstance(context);
        this.dlog = BLangDiagnosticLog.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
    }

    static boolean isTypeParam(BType expType) {
        return Symbols.isFlagOn(expType.getFlags(), 0x200000L) || expType.tsymbol != null && Symbols.isFlagOn(expType.tsymbol.flags, 0x200000L);
    }

    public static boolean containsTypeParam(BType type) {
        return TypeParamAnalyzer.containsTypeParam(type, new HashSet<BType>());
    }

    void checkForTypeParamsInArg(BLangExpression arg, Location loc, BType actualType, SymbolEnv env, BType expType) {
        if (this.notRequireTypeParams(env)) {
            return;
        }
        FindTypeParamResult findTypeParamResult = new FindTypeParamResult();
        this.findTypeParam(arg, loc, expType, actualType, env, new HashSet<BType>(), findTypeParamResult);
    }

    boolean notRequireTypeParams(SymbolEnv env) {
        return env.typeParamsEntries == null;
    }

    BType getReturnTypeParams(SymbolEnv env, BType expType) {
        if (this.notRequireTypeParams(env) || env.typeParamsEntries.isEmpty()) {
            return expType;
        }
        return this.getMatchingBoundType(expType, env);
    }

    public BType getNominalType(BType type, Name name, long flag) {
        if (name == Names.EMPTY) {
            return type;
        }
        return this.createBuiltInType(type, name, flag);
    }

    BType createTypeParam(BSymbol symbol) {
        BType type = symbol.type;
        long flag = type.getFlags() | 0x200000L;
        return this.createTypeParamType(symbol, type, symbol.name, flag);
    }

    BType getMatchingBoundType(BType expType, SymbolEnv env) {
        return this.getMatchingBoundType(expType, env, new HashSet<BType>());
    }

    private static boolean containsTypeParam(BType type, HashSet<BType> resolvedTypes) {
        if (resolvedTypes.contains(type)) {
            return false;
        }
        resolvedTypes.add(type);
        if (TypeParamAnalyzer.isTypeParam(type)) {
            return true;
        }
        switch (type.tag) {
            case 20: {
                return TypeParamAnalyzer.containsTypeParam(((BArrayType)type).eType, resolvedTypes);
            }
            case 31: {
                BTupleType bTupleType = (BTupleType)type;
                for (BType memberType : bTupleType.getTupleTypes()) {
                    if (!TypeParamAnalyzer.containsTypeParam(memberType, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 16: {
                return TypeParamAnalyzer.containsTypeParam(((BMapType)type).constraint, resolvedTypes);
            }
            case 15: {
                return TypeParamAnalyzer.containsTypeParam(((BStreamType)type).constraint, resolvedTypes);
            }
            case 9: {
                return TypeParamAnalyzer.containsTypeParam(((BTableType)type).constraint, resolvedTypes) || ((BTableType)type).keyTypeConstraint != null && TypeParamAnalyzer.containsTypeParam(((BTableType)type).keyTypeConstraint, resolvedTypes);
            }
            case 12: {
                BRecordType recordType = (BRecordType)type;
                for (BField field : recordType.fields.values()) {
                    BType bFieldType = field.getType();
                    if (!TypeParamAnalyzer.containsTypeParam(bFieldType, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 17: {
                BInvokableType invokableType = (BInvokableType)type;
                if (Symbols.isFlagOn(invokableType.getFlags(), 0x8000000000L)) {
                    return false;
                }
                for (BType paramType : invokableType.paramTypes) {
                    if (!TypeParamAnalyzer.containsTypeParam(paramType, resolvedTypes)) continue;
                    return true;
                }
                return TypeParamAnalyzer.containsTypeParam(invokableType.retType, resolvedTypes);
            }
            case 34: {
                BObjectType objectType = (BObjectType)type;
                for (Object field : objectType.fields.values()) {
                    BType bFieldType = ((BField)field).getType();
                    if (!TypeParamAnalyzer.containsTypeParam(bFieldType, resolvedTypes)) continue;
                    return true;
                }
                BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)objectType.tsymbol;
                for (BAttachedFunction fuc : objectTypeSymbol.attachedFuncs) {
                    if (!TypeParamAnalyzer.containsTypeParam(fuc.type, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 21: {
                BUnionType unionType = (BUnionType)type;
                for (BType bType : unionType.getMemberTypes()) {
                    if (!TypeParamAnalyzer.containsTypeParam(bType, resolvedTypes)) continue;
                    return true;
                }
                return false;
            }
            case 29: {
                BErrorType errorType = (BErrorType)type;
                return TypeParamAnalyzer.containsTypeParam(errorType.detailType, resolvedTypes);
            }
            case 13: {
                return TypeParamAnalyzer.containsTypeParam(((BTypedescType)type).constraint, resolvedTypes);
            }
            case 14: {
                return TypeParamAnalyzer.containsTypeParam(Types.getImpliedType(type), resolvedTypes);
            }
        }
        return false;
    }

    private BType createBuiltInType(BType type, Name name, long flags) {
        BType referredType = Types.getImpliedType(type);
        int tag = referredType.tag;
        return switch (tag) {
            case 1, 2, 3, 4, 5, 6 -> new BType(tag, null, name, flags);
            case 18 -> new BAnyType(name, flags);
            case 11 -> this.createAnydataType((BUnionType)referredType, name, flags);
            case 38 -> new BReadonlyType(flags);
            default -> type;
        };
    }

    private BType createTypeParamType(BSymbol symbol, BType type, Name name, long flags) {
        BType refType = Types.getImpliedType(type);
        switch (refType.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new BType(type.tag, null, name, flags);
            }
            case 18: {
                return new BAnyType(name, flags);
            }
            case 11: {
                return this.createAnydataType((BUnionType)type, name, flags);
            }
            case 38: {
                return new BReadonlyType(flags);
            }
            case 21: {
                if (!this.types.isCloneableType((BUnionType)refType)) break;
                BUnionType cloneableType = BUnionType.create(this.symTable.typeEnv(), null, this.symTable.readonlyType, this.symTable.xmlType);
                this.addCyclicArrayMapTableOfMapMembers(cloneableType);
                cloneableType.setFlags(flags);
                cloneableType.tsymbol = new BTypeSymbol(12L, refType.tsymbol.flags, symbol.name, refType.tsymbol.pkgID, cloneableType, refType.tsymbol.owner, type.tsymbol.pos, SymbolOrigin.BUILTIN);
                ((BTypeDefinitionSymbol)symbol).referenceType.referredType = cloneableType;
                return cloneableType;
            }
        }
        return type;
    }

    private BAnydataType createAnydataType(BUnionType unionType, Name name, long flags) {
        BAnydataType anydataType = new BAnydataType(this.types.typeCtx(), unionType);
        Optional<BIntersectionType> immutableType = Types.getImmutableType(this.symTable, PackageID.ANNOTATIONS, unionType);
        immutableType.ifPresent(bIntersectionType -> Types.addImmutableType(this.symTable, PackageID.ANNOTATIONS, anydataType, bIntersectionType));
        anydataType.name = name;
        anydataType.addFlags(flags);
        return anydataType;
    }

    private void addCyclicArrayMapTableOfMapMembers(BUnionType unionType) {
        BArrayType arrayCloneableType = new BArrayType(this.symTable.typeEnv(), unionType);
        BMapType mapCloneableType = new BMapType(this.symTable.typeEnv(), 16, unionType, null);
        BTableType tableMapCloneableType = new BTableType(this.symTable.typeEnv(), mapCloneableType, null);
        unionType.add(arrayCloneableType);
        unionType.add(mapCloneableType);
        unionType.add(tableMapCloneableType);
        unionType.isCyclic = true;
    }

    private void findTypeParam(Location loc, BType expType, BType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        this.findTypeParam(loc, expType, actualType, env, resolvedTypes, result, false);
    }

    private void findTypeParam(Location loc, BType expType, BType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result, boolean checkContravariance) {
        this.findTypeParam(null, loc, expType, actualType, env, resolvedTypes, result, checkContravariance);
    }

    private void findTypeParam(BLangExpression expr, Location loc, BType expType, BType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        this.findTypeParam(expr, loc, expType, actualType, env, resolvedTypes, result, false);
    }

    private void findTypeParam(BLangExpression expr, Location loc, BType expType, BType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result, boolean checkContravariance) {
        if (resolvedTypes.contains(expType)) {
            return;
        }
        resolvedTypes.add(expType);
        if (TypeParamAnalyzer.isTypeParam(expType)) {
            this.updateTypeParamAndBoundType(loc, env, expType, actualType);
            if (checkContravariance) {
                this.types.checkType(loc, this.getMatchingBoundType(expType, env, new HashSet<BType>()), actualType, (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
            } else {
                this.types.checkType(loc, actualType, this.getMatchingBoundType(expType, env, new HashSet<BType>()), (DiagnosticCode)DiagnosticErrorCode.INCOMPATIBLE_TYPES);
            }
            return;
        }
        this.visitType(expr, loc, expType, actualType, env, resolvedTypes, result, checkContravariance);
    }

    private void visitType(BLangExpression expr, Location loc, BType expType, BType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result, boolean checkContravariance) {
        switch (expType.tag) {
            case 8: {
                if (!this.types.isAssignable(actualType, this.symTable.xmlType)) {
                    return;
                }
                switch (actualType.tag) {
                    case 8: {
                        BType constraint = ((BXMLType)actualType).constraint;
                        while (constraint.tag == 8) {
                            constraint = ((BXMLType)constraint).constraint;
                        }
                        this.findTypeParam(loc, ((BXMLType)expType).constraint, constraint, env, resolvedTypes, result);
                        return;
                    }
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: {
                        this.findTypeParam(loc, ((BXMLType)expType).constraint, actualType, env, resolvedTypes, result);
                        return;
                    }
                    case 21: {
                        this.findTypeParamInUnion(loc, ((BXMLType)expType).constraint, (BUnionType)actualType, env, resolvedTypes, result);
                        return;
                    }
                }
                break;
            }
            case 20: {
                if (actualType.tag == 20) {
                    this.findTypeParam(loc, ((BArrayType)expType).eType, ((BArrayType)actualType).eType, env, resolvedTypes, result);
                }
                if (actualType.tag == 31) {
                    this.findTypeParamInTupleForArray(loc, (BArrayType)expType, (BTupleType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag != 21) break;
                this.findTypeParamInUnion(loc, ((BArrayType)expType).eType, (BUnionType)actualType, env, resolvedTypes, result);
                break;
            }
            case 16: {
                if (actualType.tag == 16) {
                    this.findTypeParam(loc, ((BMapType)expType).constraint, ((BMapType)actualType).constraint, env, resolvedTypes, result);
                }
                if (actualType.tag == 12) {
                    this.findTypeParamInMapForRecord(loc, (BMapType)expType, (BRecordType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag != 21) break;
                this.findTypeParamInUnion(loc, ((BMapType)expType).constraint, (BUnionType)actualType, env, resolvedTypes, result);
                break;
            }
            case 15: {
                if (actualType.tag == 15) {
                    this.findTypeParamInStream(loc, (BStreamType)expType, (BStreamType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag != 21) break;
                this.findTypeParamInStreamForUnion(loc, (BStreamType)expType, (BUnionType)actualType, env, resolvedTypes, result);
                break;
            }
            case 9: {
                if (actualType.tag != 9) break;
                this.findTypeParamInTable(loc, (BTableType)expType, (BTableType)actualType, env, resolvedTypes, result);
                break;
            }
            case 31: {
                if (actualType.tag == 31) {
                    this.findTypeParamInTuple(loc, (BTupleType)expType, (BTupleType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag != 21) break;
                this.findTypeParamInUnion(loc, expType, (BUnionType)actualType, env, resolvedTypes, result);
                break;
            }
            case 12: {
                if (actualType.tag == 12) {
                    this.findTypeParamInRecord(loc, (BRecordType)expType, (BRecordType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag != 21) break;
                this.findTypeParamInUnion(loc, expType, (BUnionType)actualType, env, resolvedTypes, result);
                break;
            }
            case 17: {
                if (actualType.tag == 17) {
                    this.findTypeParamInInvokableType(loc, (BInvokableType)expType, (BInvokableType)actualType, env, resolvedTypes, result);
                }
                if (actualType.tag != 28 || expr == null || expr.getKind() != NodeKind.LAMBDA) break;
                this.updateTypeParamAndBoundTypeForInvokableType(loc, env, (BInvokableType)expType, (BInvokableType)((BLangLambdaFunction)expr).function.getBType());
                break;
            }
            case 34: {
                if (actualType.tag != 34) break;
                this.findTypeParamInObject(loc, (BObjectType)expType, (BObjectType)actualType, env, resolvedTypes, result);
                break;
            }
            case 21: {
                if (actualType.tag != 21) break;
                this.findTypeParamInUnion(loc, (BUnionType)expType, (BUnionType)actualType, env, resolvedTypes, result);
                break;
            }
            case 29: {
                if (expType == this.symTable.errorType) {
                    return;
                }
                if (actualType.tag == 14) break;
                this.findTypeParamInError(loc, (BErrorType)expType, actualType, env, resolvedTypes, result);
                return;
            }
            case 13: {
                if (actualType.tag != 13) break;
                this.findTypeParam(loc, ((BTypedescType)expType).constraint, ((BTypedescType)actualType).constraint, env, resolvedTypes, result);
                break;
            }
            case 22: {
                if (actualType.tag != 22) break;
                this.findTypeParam(loc, ((BIntersectionType)expType).effectiveType, ((BIntersectionType)actualType).effectiveType, env, resolvedTypes, result);
                break;
            }
            case 14: {
                this.visitType(expr, loc, Types.getImpliedType(expType), actualType, env, resolvedTypes, result, checkContravariance);
            }
        }
        if (actualType.tag == 22) {
            this.visitType(expr, loc, expType, ((BIntersectionType)actualType).effectiveType, env, resolvedTypes, result, checkContravariance);
        }
        if (actualType.tag == 14) {
            this.visitType(expr, loc, expType, Types.getImpliedType(actualType), env, resolvedTypes, result, checkContravariance);
        }
    }

    private void updateTypeParamAndBoundTypeForInvokableType(Location loc, SymbolEnv env, BInvokableType parentTypeParamType, BInvokableType parentBoundedType) {
        for (int i = 0; i < parentTypeParamType.paramTypes.size() && i < parentBoundedType.paramTypes.size(); ++i) {
            BType paramType = parentTypeParamType.paramTypes.get(i);
            if (!TypeParamAnalyzer.isTypeParam(paramType)) continue;
            this.updateTypeParamAndBoundType(loc, env, paramType, parentBoundedType.paramTypes.get(i));
        }
        if (TypeParamAnalyzer.isTypeParam(parentTypeParamType.retType)) {
            this.updateTypeParamAndBoundType(loc, env, parentTypeParamType.retType, parentBoundedType.retType);
        }
    }

    private void updateTypeParamAndBoundType(Location location, SymbolEnv env, BType typeParamType, BType boundType) {
        for (SymbolEnv.TypeParamEntry entry : env.typeParamsEntries) {
            if (entry.typeParam != typeParamType) continue;
            return;
        }
        if (boundType == this.symTable.noType) {
            this.dlog.error(location, DiagnosticErrorCode.CANNOT_INFER_TYPE, new Object[0]);
            return;
        }
        env.typeParamsEntries.add(new SymbolEnv.TypeParamEntry(typeParamType, boundType));
    }

    private void findTypeParamInTuple(Location loc, BTupleType expType, BTupleType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        List<BType> expTypeMemberTypes = expType.getTupleTypes();
        List<BType> actualTypeMemberTypes = actualType.getTupleTypes();
        for (int i = 0; i < expTypeMemberTypes.size() && i < actualTypeMemberTypes.size(); ++i) {
            this.findTypeParam(loc, expTypeMemberTypes.get(i), actualTypeMemberTypes.get(i), env, resolvedTypes, result);
        }
    }

    private void findTypeParamInStream(Location loc, BStreamType expType, BStreamType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        this.findTypeParam(loc, expType.constraint, actualType.constraint, env, resolvedTypes, result);
        this.findTypeParam(loc, expType.completionType, actualType.completionType, env, resolvedTypes, result);
    }

    private void findTypeParamInStreamForUnion(Location loc, BStreamType expType, BUnionType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        LinkedHashSet<BType> constraintTypes = new LinkedHashSet<BType>();
        LinkedHashSet<BType> completionTypes = new LinkedHashSet<BType>();
        for (BType type : actualType.getMemberTypes()) {
            type = Types.getImpliedType(type);
            if (type.tag != 15) continue;
            constraintTypes.add(((BStreamType)type).constraint);
            completionTypes.add(((BStreamType)type).completionType);
        }
        BUnionType cUnionType = BUnionType.create(this.symTable.typeEnv(), null, constraintTypes);
        this.findTypeParam(loc, expType.constraint, cUnionType, env, resolvedTypes, result);
        if (!completionTypes.isEmpty()) {
            BUnionType eUnionType = BUnionType.create(this.symTable.typeEnv(), null, completionTypes);
            this.findTypeParam(loc, expType.completionType, eUnionType, env, resolvedTypes, result);
        } else {
            this.findTypeParam(loc, expType.completionType, this.symTable.nilType, env, resolvedTypes, result);
        }
    }

    private void findTypeParamInTable(Location loc, BTableType expType, BTableType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        this.findTypeParam(loc, expType.constraint, actualType.constraint, env, resolvedTypes, result);
        if (expType.keyTypeConstraint != null) {
            if (actualType.keyTypeConstraint != null) {
                this.findTypeParam(loc, expType.keyTypeConstraint, actualType.keyTypeConstraint, env, resolvedTypes, result);
            } else if (!actualType.fieldNameList.isEmpty()) {
                ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
                actualType.fieldNameList.stream().map(f -> this.types.getTableConstraintField(actualType.constraint, (String)f)).filter(Objects::nonNull).map(f -> new BTupleMember(f.type, Symbols.createVarSymbolForTupleMember(f.type))).forEach(members::add);
                if (members.size() == 1) {
                    this.findTypeParam(loc, expType.keyTypeConstraint, ((BTupleMember)members.get((int)0)).type, env, resolvedTypes, result);
                } else {
                    BTupleType tupleType = new BTupleType(this.symTable.typeEnv(), members);
                    this.findTypeParam(loc, expType.keyTypeConstraint, tupleType, env, resolvedTypes, result);
                }
            }
        }
    }

    private void findTypeParamInTupleForArray(Location loc, BArrayType expType, BTupleType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        int size;
        LinkedHashSet<BType> tupleTypes = new LinkedHashSet<BType>();
        actualType.getTupleTypes().forEach(m -> tupleTypes.add((BType)m));
        if (actualType.restType != null) {
            tupleTypes.add(actualType.restType);
        }
        BType type = (size = tupleTypes.size()) == 0 ? this.symTable.neverType : (size == 1 ? (BType)tupleTypes.iterator().next() : BUnionType.create(this.symTable.typeEnv(), null, tupleTypes));
        this.findTypeParam(loc, expType.eType, type, env, resolvedTypes, result);
    }

    private void findTypeParamInUnion(Location loc, BType expType, BUnionType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        LinkedHashSet<BType> members = new LinkedHashSet<BType>();
        for (BType type : actualType.getMemberTypes()) {
            BType referredType = Types.getImpliedType(type);
            if (referredType.tag == 20) {
                members.add(((BArrayType)referredType).eType);
            }
            if (referredType.tag == 16) {
                members.add(((BMapType)referredType).constraint);
            }
            if (TypeTags.isXMLTypeTag(referredType.tag)) {
                if (referredType.tag == 8) {
                    members.add(((BXMLType)referredType).constraint);
                    continue;
                }
                members.add(type);
            }
            if (referredType.tag == 12) {
                for (BField field : ((BRecordType)referredType).fields.values()) {
                    members.add(field.type);
                }
            }
            if (referredType.tag != 31) continue;
            ((BTupleType)referredType).getTupleTypes().forEach(member -> members.add((BType)member));
        }
        BUnionType tupleElementType = BUnionType.create(this.symTable.typeEnv(), null, members);
        this.findTypeParam(loc, expType, tupleElementType, env, resolvedTypes, result);
    }

    private void findTypeParamInRecord(Location loc, BRecordType expType, BRecordType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        for (BField exField : expType.fields.values()) {
            if (!actualType.fields.containsKey(exField.name.value)) continue;
            this.findTypeParam(loc, exField.type, ((BField)actualType.fields.get((Object)exField.name.value)).type, env, resolvedTypes, result);
        }
    }

    private void findTypeParamInMapForRecord(Location loc, BMapType expType, BRecordType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        LinkedHashSet<BType> reducedTypeSet;
        LinkedHashSet<BType> fields = actualType.fields.values().stream().map(f -> f.type).collect(Collectors.toCollection(LinkedHashSet::new));
        if (actualType.restFieldType != this.symTable.noType) {
            reducedTypeSet = new LinkedHashSet<BType>();
            for (BType fType : fields) {
                if (this.types.isAssignable(fType, actualType.restFieldType)) continue;
                reducedTypeSet.add(fType);
            }
            reducedTypeSet.add(actualType.restFieldType);
        } else {
            reducedTypeSet = fields;
        }
        BType commonFieldType = reducedTypeSet.size() == 1 ? (BType)reducedTypeSet.iterator().next() : BUnionType.create(this.symTable.typeEnv(), null, reducedTypeSet);
        this.findTypeParam(loc, expType.constraint, commonFieldType, env, resolvedTypes, result);
    }

    private void findTypeParamInInvokableType(Location loc, BInvokableType expType, BInvokableType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        if (Symbols.isFlagOn(expType.getFlags(), 0x8000000000L)) {
            return;
        }
        for (int i = 0; i < expType.paramTypes.size() && i < actualType.paramTypes.size(); ++i) {
            this.findTypeParam(loc, expType.paramTypes.get(i), actualType.paramTypes.get(i), env, resolvedTypes, result, true);
        }
        this.findTypeParam(loc, expType.retType, actualType.retType, env, resolvedTypes, result);
    }

    private void findTypeParamInObject(Location loc, BObjectType expType, BObjectType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        for (BField exField : expType.fields.values()) {
            if (!actualType.fields.containsKey(exField.name.value)) continue;
            this.findTypeParam(loc, exField.type, ((BField)actualType.fields.get((Object)exField.name.value)).type, env, resolvedTypes, result);
        }
        List expAttFunctions = ((BObjectTypeSymbol)expType.tsymbol).attachedFuncs;
        List actualAttFunctions = ((BObjectTypeSymbol)actualType.tsymbol).attachedFuncs;
        for (BAttachedFunction expFunc : expAttFunctions) {
            BInvokableType actFuncType = actualAttFunctions.stream().filter(actFunc -> actFunc.funcName.equals(expFunc.funcName)).findFirst().map(actFunc -> actFunc.type).orElse(null);
            if (actFuncType == null) continue;
            this.findTypeParamInInvokableType(loc, expFunc.type, actFuncType, env, resolvedTypes, result);
        }
    }

    private void findTypeParamInUnion(Location loc, BUnionType expType, BUnionType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        if (((HashSet)expType.getMemberTypes()).size() != 2 || !expType.isNullable() || ((HashSet)actualType.getMemberTypes()).size() != 2 || !actualType.isNullable()) {
            return;
        }
        BType exp = expType.getMemberTypes().stream().filter(type -> type != this.symTable.nilType).findFirst().orElse(this.symTable.nilType);
        BType act = actualType.getMemberTypes().stream().filter(type -> type != this.symTable.nilType).findFirst().orElse(this.symTable.nilType);
        this.findTypeParam(loc, exp, act, env, resolvedTypes, result);
    }

    private void findTypeParamInError(Location loc, BErrorType expType, BType actualType, SymbolEnv env, HashSet<BType> resolvedTypes, FindTypeParamResult result) {
        actualType = Types.getImpliedType(actualType);
        if (actualType.tag == 29) {
            this.findTypeParam(loc, expType.detailType, ((BErrorType)actualType).detailType, env, resolvedTypes, result);
        }
        if (actualType.tag == 21 && this.types.isSubTypeOfBaseType(actualType, PredefinedType.ERROR)) {
            BUnionType errorUnion = (BUnionType)actualType;
            LinkedHashSet<BType> errorDetailTypes = new LinkedHashSet<BType>();
            for (BType errorType : errorUnion.getMemberTypes()) {
                BType member = Types.getImpliedType(errorType);
                errorDetailTypes.add(((BErrorType)member).detailType);
            }
            BUnionType errorDetailUnionType = BUnionType.create(this.symTable.typeEnv(), null, errorDetailTypes);
            this.findTypeParam(loc, expType.detailType, errorDetailUnionType, env, resolvedTypes, result);
        }
    }

    private BType getMatchingBoundType(BType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        if (TypeParamAnalyzer.isTypeParam(expType)) {
            for (SymbolEnv.TypeParamEntry typeParamEntry : env.typeParamsEntries) {
                if (typeParamEntry.typeParam != expType) continue;
                return typeParamEntry.boundType;
            }
            return this.symTable.noType;
        }
        if (resolvedTypes.contains(expType)) {
            return expType;
        }
        resolvedTypes.add(expType);
        switch (expType.tag) {
            case 20: {
                BType elementType = ((BArrayType)expType).eType;
                BType matchingBoundElementType = this.getMatchingBoundType(elementType, env, resolvedTypes);
                if (!this.isDifferentTypes(elementType, matchingBoundElementType)) {
                    return expType;
                }
                return new BArrayType(this.symTable.typeEnv(), matchingBoundElementType);
            }
            case 16: {
                BType constraint = ((BMapType)expType).constraint;
                BType matchingBoundMapConstraintType = this.getMatchingBoundType(constraint, env, resolvedTypes);
                if (!this.isDifferentTypes(constraint, matchingBoundMapConstraintType)) {
                    return expType;
                }
                return new BMapType(this.symTable.typeEnv(), 16, matchingBoundMapConstraintType, this.symTable.mapType.tsymbol);
            }
            case 15: {
                BStreamType expStreamType = (BStreamType)expType;
                BType expStreamConstraint = expStreamType.constraint;
                BType expStreamCompletionType = expStreamType.completionType;
                BType constraintType = this.getMatchingBoundType(expStreamConstraint, env, resolvedTypes);
                BType completionType = this.getMatchingBoundType(expStreamCompletionType, env, resolvedTypes);
                if (completionType.tag == 24) {
                    completionType = this.symTable.nilType;
                }
                if (!this.isDifferentTypes(expStreamConstraint, constraintType) && !this.isDifferentTypes(expStreamCompletionType, completionType)) {
                    return expStreamType;
                }
                return new BStreamType(this.symTable.typeEnv(), 15, constraintType, completionType, this.symTable.streamType.tsymbol);
            }
            case 9: {
                BTableType expTableType = (BTableType)expType;
                BType expTableConstraint = expTableType.constraint;
                BType tableConstraint = this.getMatchingBoundType(expTableConstraint, env, resolvedTypes);
                boolean differentTypes = this.isDifferentTypes(expTableConstraint, tableConstraint);
                BType expTableKeyTypeConstraint = expTableType.keyTypeConstraint;
                BType keyTypeConstraint = null;
                if (expTableKeyTypeConstraint != null) {
                    keyTypeConstraint = this.getMatchingBoundType(expTableKeyTypeConstraint, env, resolvedTypes);
                    boolean bl = differentTypes = differentTypes || this.isDifferentTypes(expTableKeyTypeConstraint, keyTypeConstraint);
                }
                if (!differentTypes) {
                    return expTableType;
                }
                BTableType tableType = new BTableType(this.symTable.typeEnv(), tableConstraint, this.symTable.tableType.tsymbol);
                if (expTableKeyTypeConstraint != null) {
                    tableType.keyTypeConstraint = keyTypeConstraint;
                }
                return tableType;
            }
            case 31: {
                return this.getMatchingTupleBoundType((BTupleType)expType, env, resolvedTypes);
            }
            case 12: {
                return this.getMatchingRecordBoundType((BRecordType)expType, env, resolvedTypes);
            }
            case 17: {
                return this.getMatchingFunctionBoundType((BInvokableType)expType, env, resolvedTypes);
            }
            case 34: {
                return this.getMatchingObjectBoundType((BObjectType)expType, env, resolvedTypes);
            }
            case 21: {
                return this.getMatchingOptionalBoundType((BUnionType)expType, env, resolvedTypes);
            }
            case 29: {
                return this.getMatchingErrorBoundType((BErrorType)expType, env, resolvedTypes);
            }
            case 13: {
                BType constraint = ((BTypedescType)expType).constraint;
                BType matchingBoundType = this.getMatchingBoundType(constraint, env, resolvedTypes);
                if (!this.isDifferentTypes(constraint, matchingBoundType)) {
                    return expType;
                }
                return new BTypedescType(this.symTable.typeEnv(), matchingBoundType, this.symTable.typeDesc.tsymbol);
            }
            case 22: {
                return this.getMatchingReadonlyIntersectionBoundType((BIntersectionType)expType, env, resolvedTypes);
            }
            case 14: {
                return this.getMatchingBoundType(Types.getImpliedType(expType), env, resolvedTypes);
            }
        }
        return expType;
    }

    private boolean isDifferentTypes(BType expType, BType boundType) {
        if (expType == boundType) {
            return false;
        }
        return Types.getImpliedType(expType) != Types.getImpliedType(boundType);
    }

    private BType getMatchingReadonlyIntersectionBoundType(BIntersectionType intersectionType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        boolean hasDifferentType = false;
        Set<BType> constituentTypes = intersectionType.getConstituentTypes();
        BType matchingBoundNonReadOnlyType = this.symTable.semanticError;
        for (BType type : constituentTypes) {
            if (type == this.symTable.readonlyType) continue;
            matchingBoundNonReadOnlyType = this.getMatchingBoundType(type, env, resolvedTypes);
            if (hasDifferentType || !this.isDifferentTypes(type, matchingBoundNonReadOnlyType)) continue;
            hasDifferentType = true;
        }
        if (!hasDifferentType) {
            return intersectionType;
        }
        if (this.types.isInherentlyImmutableType(matchingBoundNonReadOnlyType) || Symbols.isFlagOn(matchingBoundNonReadOnlyType.getFlags(), 32L)) {
            return matchingBoundNonReadOnlyType;
        }
        if (!this.types.isSelectivelyImmutableType(matchingBoundNonReadOnlyType, env.enclPkg.packageID)) {
            return this.symTable.semanticError;
        }
        return ImmutableTypeCloner.getImmutableIntersectionType(intersectionType.tsymbol.pos, this.types, matchingBoundNonReadOnlyType, env, this.symTable, this.anonymousModelHelper, this.names, new HashSet<Flag>());
    }

    private BTupleType getMatchingTupleBoundType(BTupleType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        boolean hasDifferentType = false;
        ArrayList<BTupleMember> members = new ArrayList<BTupleMember>();
        for (BType type : expType.getTupleTypes()) {
            BType matchingBoundType = this.getMatchingBoundType(type, env, resolvedTypes);
            if (!hasDifferentType && this.isDifferentTypes(type, matchingBoundType)) {
                hasDifferentType = true;
            }
            BVarSymbol varSymbol = new BVarSymbol(matchingBoundType.getFlags(), null, null, matchingBoundType, null, null, null);
            members.add(new BTupleMember(matchingBoundType, varSymbol));
        }
        BType restType = expType.restType;
        if (restType != null) {
            BType matchingBoundRestType = this.getMatchingBoundType(restType, env, resolvedTypes);
            if (!hasDifferentType && this.isDifferentTypes(restType, matchingBoundRestType)) {
                hasDifferentType = true;
            }
        }
        if (!hasDifferentType) {
            return expType;
        }
        return new BTupleType(this.symTable.typeEnv(), members);
    }

    private BRecordType getMatchingRecordBoundType(BRecordType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        boolean hasDifferentType = false;
        BRecordTypeSymbol expTSymbol = (BRecordTypeSymbol)expType.tsymbol;
        BRecordTypeSymbol recordSymbol = Symbols.createRecordSymbol(expTSymbol.flags, expTSymbol.name, expTSymbol.pkgID, null, expType.tsymbol.scope.owner, expTSymbol.pos, SymbolOrigin.VIRTUAL);
        recordSymbol.originalName = expTSymbol.getOriginalName();
        recordSymbol.isTypeParamResolved = true;
        recordSymbol.typeParamTSymbol = expTSymbol;
        recordSymbol.scope = new Scope(recordSymbol);
        LinkedHashMap<String, BField> fields = new LinkedHashMap<String, BField>();
        for (BField expField : expType.fields.values()) {
            BType type = expField.type;
            BType matchingBoundType = this.getMatchingBoundType(type, env, resolvedTypes);
            if (!hasDifferentType && this.isDifferentTypes(type, matchingBoundType)) {
                hasDifferentType = true;
            }
            BField field = new BField(expField.name, expField.pos, new BVarSymbol(0L, expField.name, env.enclPkg.packageID, matchingBoundType, env.scope.owner, expField.pos, SymbolOrigin.VIRTUAL));
            fields.put(field.name.value, field);
            recordSymbol.scope.define(expField.name, field.symbol);
        }
        BRecordType bRecordType = new BRecordType(this.symTable.typeEnv(), (BTypeSymbol)recordSymbol);
        bRecordType.fields = fields;
        recordSymbol.type = bRecordType;
        bRecordType.setFlags(expType.getFlags());
        if (expType.sealed) {
            bRecordType.sealed = true;
        }
        BType restFieldType = expType.restFieldType;
        bRecordType.restFieldType = this.getMatchingBoundType(restFieldType, env, resolvedTypes);
        if (!hasDifferentType && this.isDifferentTypes(restFieldType, bRecordType.restFieldType)) {
            hasDifferentType = true;
        }
        if (!hasDifferentType) {
            return expType;
        }
        return bRecordType;
    }

    private BInvokableType getMatchingFunctionBoundType(BInvokableType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        boolean hasDifferentType = false;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        for (BType type : expType.paramTypes) {
            BType matchingBoundType = this.getMatchingBoundType(type, env, resolvedTypes);
            if (!hasDifferentType && this.isDifferentTypes(type, matchingBoundType)) {
                hasDifferentType = true;
            }
            paramTypes.add(matchingBoundType);
        }
        BType restType = expType.restType;
        long flags = expType.getFlags();
        BInvokableTypeSymbol invokableTypeSymbol = Symbols.createInvokableTypeSymbol(33587228L, flags, env.enclPkg.symbol.pkgID, expType, env.scope.owner, expType.tsymbol.pos, SymbolOrigin.VIRTUAL);
        BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)expType.tsymbol;
        invokableTypeSymbol.params = tsymbol.params == null ? null : new ArrayList<BVarSymbol>(tsymbol.params);
        BType retType = expType.retType;
        BType matchingBoundType = this.getMatchingBoundType(retType, env, resolvedTypes);
        if (!hasDifferentType && this.isDifferentTypes(retType, matchingBoundType)) {
            hasDifferentType = true;
        }
        if (!hasDifferentType) {
            return expType;
        }
        BInvokableType invokableType = new BInvokableType(this.symTable.typeEnv(), paramTypes, restType, matchingBoundType, invokableTypeSymbol);
        invokableTypeSymbol.returnType = invokableType.retType;
        invokableType.tsymbol.isTypeParamResolved = true;
        invokableType.tsymbol.typeParamTSymbol = expType.tsymbol;
        if (Symbols.isFlagOn(flags, 0x20000000L)) {
            invokableType.addFlags(0x20000000L);
        }
        return invokableType;
    }

    private BType getMatchingObjectBoundType(BObjectType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        BType type;
        boolean hasDifferentType = false;
        BObjectTypeSymbol actObjectSymbol = Symbols.createObjectSymbol(expType.tsymbol.flags, expType.tsymbol.name, expType.tsymbol.pkgID, null, expType.tsymbol.scope.owner, expType.tsymbol.pos, SymbolOrigin.VIRTUAL);
        actObjectSymbol.originalName = expType.tsymbol.originalName;
        actObjectSymbol.isTypeParamResolved = true;
        actObjectSymbol.typeParamTSymbol = expType.tsymbol;
        BObjectType objectType = new BObjectType(this.symTable.typeEnv(), (BTypeSymbol)actObjectSymbol);
        actObjectSymbol.type = objectType;
        actObjectSymbol.scope = new Scope(actObjectSymbol);
        for (BField expField : expType.fields.values()) {
            type = expField.type;
            BType matchingBoundType = this.getMatchingBoundType(type, env, resolvedTypes);
            if (!hasDifferentType && this.isDifferentTypes(type, matchingBoundType)) {
                hasDifferentType = true;
            }
            BField field = new BField(expField.name, expField.pos, new BVarSymbol(expField.symbol.flags, expField.name, env.enclPkg.packageID, matchingBoundType, env.scope.owner, expField.pos, SymbolOrigin.VIRTUAL));
            objectType.fields.put(field.name.value, field);
            objectType.tsymbol.scope.define(expField.name, field.symbol);
        }
        for (BAttachedFunction expFunc : ((BObjectTypeSymbol)expType.tsymbol).attachedFuncs) {
            type = expFunc.type;
            BInvokableType matchType = this.getMatchingFunctionBoundType((BInvokableType)type, env, resolvedTypes);
            if (!hasDifferentType && this.isDifferentTypes(type, matchType)) {
                hasDifferentType = true;
            }
            BInvokableSymbol invokableSymbol = new BInvokableSymbol(expFunc.symbol.tag, expFunc.symbol.flags, expFunc.symbol.name, expFunc.symbol.getOriginalName(), env.enclPkg.packageID, (BType)matchType, (BSymbol)actObjectSymbol, expFunc.pos, SymbolOrigin.VIRTUAL);
            invokableSymbol.retType = invokableSymbol.getType().retType;
            BInvokableTypeSymbol typeSymbol = (BInvokableTypeSymbol)Symbols.createTypeSymbol(33587228L, invokableSymbol.flags, Names.EMPTY, env.enclPkg.symbol.pkgID, invokableSymbol.type, env.scope.owner, invokableSymbol.pos, SymbolOrigin.VIRTUAL);
            BInvokableTypeSymbol origTSymbol = (BInvokableTypeSymbol)invokableSymbol.type.tsymbol;
            typeSymbol.params = origTSymbol == null ? null : new ArrayList<BVarSymbol>(origTSymbol.params);
            matchType.tsymbol = typeSymbol;
            actObjectSymbol.attachedFuncs.add(this.duplicateAttachFunc(expFunc, matchType, invokableSymbol));
            String funcName = Symbols.getAttachedFuncSymbolName(actObjectSymbol.type.tsymbol.name.value, expFunc.funcName.value);
            actObjectSymbol.scope.define(Names.fromString(funcName), invokableSymbol);
        }
        if (!hasDifferentType) {
            return expType;
        }
        return objectType;
    }

    private BAttachedFunction duplicateAttachFunc(BAttachedFunction expFunc, BInvokableType matchType, BInvokableSymbol invokableSymbol) {
        if (expFunc instanceof BResourceFunction) {
            BResourceFunction resourceFunction = (BResourceFunction)expFunc;
            BResourceFunction newResourceFunc = new BResourceFunction(resourceFunction.funcName, invokableSymbol, matchType, resourceFunction.accessor, resourceFunction.pathParams, resourceFunction.restPathParam, expFunc.pos);
            newResourceFunc.pathSegmentSymbols = resourceFunction.pathSegmentSymbols;
            return newResourceFunc;
        }
        return new BAttachedFunction(expFunc.funcName, invokableSymbol, matchType, expFunc.pos);
    }

    private BType getMatchingOptionalBoundType(BUnionType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        boolean hasDifferentType = false;
        LinkedHashSet<BType> members = new LinkedHashSet<BType>();
        for (BType type : expType.getMemberTypes()) {
            BType boundType = this.getMatchingBoundType(type, env, resolvedTypes);
            if (boundType != this.symTable.noType) {
                members.add(boundType);
            }
            if (hasDifferentType || !this.isDifferentTypes(type, boundType)) continue;
            hasDifferentType = true;
        }
        if (!hasDifferentType) {
            return expType;
        }
        return BUnionType.create(this.symTable.typeEnv(), null, members);
    }

    private BType getMatchingErrorBoundType(BErrorType expType, SymbolEnv env, HashSet<BType> resolvedTypes) {
        if (expType == this.symTable.errorType) {
            return expType;
        }
        BType expDetailType = expType.detailType;
        BType detailType = this.getMatchingBoundType(expDetailType, env, resolvedTypes);
        if (!this.isDifferentTypes(expDetailType, detailType)) {
            return expType;
        }
        BErrorTypeSymbol typeSymbol = new BErrorTypeSymbol(294940L, this.symTable.errorType.tsymbol.flags, this.symTable.errorType.tsymbol.name, this.symTable.errorType.tsymbol.pkgID, null, null, this.symTable.builtinPos, SymbolOrigin.VIRTUAL);
        typeSymbol.isTypeParamResolved = true;
        typeSymbol.typeParamTSymbol = expType.tsymbol;
        BErrorType errorType = new BErrorType(this.symTable.typeEnv(), (BTypeSymbol)typeSymbol, detailType);
        typeSymbol.type = errorType;
        return errorType;
    }

    private static class FindTypeParamResult {
        boolean found = false;
        boolean isNew = false;

        private FindTypeParamResult() {
        }
    }
}

