/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.symbols;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.Symbol;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.util.Flags;

public class BSymbol
implements Symbol {
    public long tag;
    public long flags;
    public Name name;
    public Name originalName;
    public PackageID pkgID;
    public SymbolKind kind;
    public BType type;
    public BSymbol owner;
    public boolean tainted;
    public boolean closure;
    public MarkdownDocAttachment markdownDocumentation;
    public Location pos;
    public SymbolOrigin origin;
    public Scope scope;

    public BSymbol(long tag, long flags, Name name, PackageID pkgID, BType type, BSymbol owner, Location location, SymbolOrigin origin) {
        this.tag = tag;
        this.flags = flags;
        this.name = name;
        this.originalName = name;
        this.pkgID = pkgID;
        this.type = type;
        this.owner = owner;
        this.pos = location;
        this.origin = origin;
    }

    public BSymbol(long tag, long flags, Name name, Name originalName, PackageID pkgID, BType type, BSymbol owner, Location location, SymbolOrigin origin) {
        this.tag = tag;
        this.flags = flags;
        this.name = name;
        this.originalName = originalName;
        this.pkgID = pkgID;
        this.type = type;
        this.owner = owner;
        this.pos = location;
        this.origin = origin;
    }

    public MarkdownDocAttachment getMarkdownDocAttachment() {
        return this.markdownDocumentation;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public Name getOriginalName() {
        return this.originalName.getValue() != null ? this.originalName : this.name;
    }

    @Override
    public SymbolKind getKind() {
        return SymbolKind.OTHER;
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public Set<Flag> getFlags() {
        return Flags.unMask(this.flags);
    }

    @Override
    public BSymbol getEnclosingSymbol() {
        return this.owner;
    }

    public List<BSymbol> getEnclosedSymbols() {
        return new ArrayList<BSymbol>(0);
    }

    @Override
    public Location getPosition() {
        return this.pos;
    }

    @Override
    public SymbolOrigin getOrigin() {
        return this.origin;
    }

    public String toString() {
        return this.name.toString();
    }
}

