/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.CellAtomicType;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.definition.ListDefinition;
import java.util.List;
import org.ballerinalang.model.types.ArrayType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.util.BArrayState;

public class BArrayType
extends BType
implements ArrayType {
    private static final int NO_FIXED_SIZE = -1;
    public BType eType;
    private int size = -1;
    public BArrayState state = BArrayState.OPEN;
    public BArrayType mutableType;
    private final Env env;
    private ListDefinition ld = null;

    public BArrayType(Env env, BType elementType) {
        super(20, null);
        this.eType = elementType;
        this.env = env;
    }

    public BArrayType(Env env, BType elementType, BTypeSymbol tsymbol) {
        super(20, tsymbol);
        this.eType = elementType;
        this.env = env;
    }

    public BArrayType(Env env, BType elementType, BTypeSymbol tsymbol, int size, BArrayState state) {
        super(20, tsymbol);
        this.eType = elementType;
        this.size = size;
        this.state = state;
        this.env = env;
    }

    public BArrayType(Env env, BType elementType, BTypeSymbol tsymbol, int size, BArrayState state, long flags) {
        super(20, tsymbol, flags);
        this.eType = elementType;
        this.size = size;
        this.state = state;
        this.env = env;
    }

    protected void restLd() {
        this.ld = null;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (this.ld != null) {
            this.ld = null;
        }
        this.size = size;
    }

    @Override
    public BType getElementType() {
        return this.eType;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.ARRAY;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        String tempSize;
        StringBuilder sb = new StringBuilder(this.eType.toString());
        String string = tempSize = this.state == BArrayState.INFERRED ? "*" : String.valueOf(this.size);
        if (this.eType.tag == 20) {
            if (this.state != BArrayState.OPEN) {
                sb.insert(sb.indexOf("["), "[" + tempSize + "]");
            } else {
                sb.insert(sb.indexOf("["), "[]");
            }
        } else if (this.state != BArrayState.OPEN) {
            sb.append("[").append(tempSize).append("]");
        } else {
            sb.append("[]");
        }
        return !Symbols.isFlagOn(this.getFlags(), 32L) ? sb.toString() : sb.append(" & readonly").toString();
    }

    private boolean hasTypeHoles() {
        return this.eType instanceof BNoType;
    }

    @Override
    public void resetSemType() {
        this.ld = null;
    }

    @Override
    public SemType semType() {
        boolean isReadonly;
        CellAtomicType.CellMutability mut;
        if (this.ld != null) {
            return this.ld.getSemType(this.env);
        }
        this.ld = new ListDefinition();
        if (this.hasTypeHoles()) {
            return this.ld.defineListTypeWrapped(this.env, (SemType)PredefinedType.VAL);
        }
        SemType elementTypeSemType = this.eType.semType();
        if (elementTypeSemType == null) {
            elementTypeSemType = PredefinedType.NEVER;
        }
        CellAtomicType.CellMutability cellMutability = mut = (isReadonly = Symbols.isFlagOn(this.getFlags(), 32L)) ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
        if (this.size != -1) {
            return this.ld.defineListTypeWrapped(this.env, List.of(elementTypeSemType), Math.abs(this.size), (SemType)PredefinedType.NEVER, mut);
        }
        return this.ld.defineListTypeWrapped(this.env, List.of(), 0, elementTypeSemType, mut);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public void setFlags(long flags) {
        super.setFlags(flags);
        this.restLd();
    }

    @Override
    public void addFlags(long flags) {
        super.addFlags(flags);
        this.restLd();
    }
}

