/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.BooleanSubtype;
import io.ballerina.types.subtypedata.DecimalSubtype;
import io.ballerina.types.subtypedata.FloatSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.StringSubtype;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.StringJoiner;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.types.SemNamedType;
import org.wso2.ballerinalang.compiler.util.Names;

public class BFiniteType
extends BType {
    public SemNamedType[] valueSpace;

    public BFiniteType(BTypeSymbol tsymbol, SemNamedType[] valueSpace) {
        super(33, tsymbol, 32L);
        this.valueSpace = valueSpace;
        assert (this.validValueSpace(valueSpace));
    }

    public static BFiniteType newSingletonBFiniteType(BTypeSymbol tsymbol, SemType singletonSemType) {
        return new BFiniteType(tsymbol, new SemNamedType[]{new SemNamedType(singletonSemType, Optional.empty())});
    }

    private boolean validValueSpace(SemNamedType[] valueSpace) {
        for (SemNamedType semNamedType : valueSpace) {
            if (!Core.singleShape((SemType)semNamedType.semType()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.FINITE;
    }

    @Override
    public SemType semType() {
        if (this.semType == null) {
            this.semType = this.computeResultantSemType(this.valueSpace);
        }
        return this.semType;
    }

    private SemType computeResultantSemType(SemNamedType[] valueSpace) {
        BasicTypeBitSet s = PredefinedType.NEVER;
        for (SemNamedType semNamedType : valueSpace) {
            s = SemTypes.union((SemType)s, (SemType)semNamedType.semType());
        }
        return s;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner("|");
        for (SemNamedType semNamedType : this.valueSpace) {
            SemType semType = semNamedType.semType();
            Optional<String> name = semNamedType.optName();
            if (PredefinedType.NIL.equals((Object)semType)) {
                joiner.add(name.orElse(Names.NIL_VALUE.value));
                continue;
            }
            ComplexSemType cs = (ComplexSemType)semType;
            if (SemTypes.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.BOOLEAN)) {
                joiner.add(name.orElse((Boolean)BooleanSubtype.booleanSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_BOOLEAN)).get() != false ? Names.TRUE.value : Names.FALSE.value));
                continue;
            }
            if (SemTypes.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.INT)) {
                joiner.add(name.orElse(Long.toString((Long)IntSubtype.intSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_INT)).get())));
                continue;
            }
            if (SemTypes.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.FLOAT)) {
                joiner.add(name.orElse(Double.toString((Double)FloatSubtype.floatSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_FLOAT)).get())) + "f");
                continue;
            }
            if (SemTypes.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.DECIMAL)) {
                joiner.add(name.orElse(((BigDecimal)DecimalSubtype.decimalSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_DECIMAL)).get()).toPlainString()) + "d");
                continue;
            }
            if (SemTypes.isSubtypeSimple((SemType)semType, (BasicTypeBitSet)PredefinedType.STRING)) {
                joiner.add("\"" + name.orElse((String)StringSubtype.stringSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)cs, (BasicTypeCode)BasicTypeCode.BT_STRING)).get()) + "\"");
                continue;
            }
            throw new IllegalStateException("Unexpected value space type in BFiniteType: " + String.valueOf(semType));
        }
        return joiner.toString();
    }
}

