/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.definition.FunctionDefinition;
import io.ballerina.types.definition.FunctionQualifiers;
import io.ballerina.types.definition.ListDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.types.InvokableType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

public class BInvokableType
extends BType
implements InvokableType {
    public List<BType> paramTypes;
    public BType restType;
    public BType retType;
    private final Env env;
    private FunctionDefinition defn;

    public BInvokableType(Env env, List<BType> paramTypes, BType restType, BType retType, BTypeSymbol tsymbol) {
        super(17, tsymbol, 32L);
        this.paramTypes = Collections.unmodifiableList(paramTypes);
        assert (restType == null || restType instanceof BArrayType || restType.tag == 28);
        this.restType = restType;
        this.retType = retType;
        this.env = env;
    }

    public BInvokableType(Env env, List<BType> paramTypes, BType retType, BTypeSymbol tsymbol) {
        this(env, paramTypes, null, retType, tsymbol);
    }

    public BInvokableType(Env env, BTypeSymbol tSymbol) {
        super(17, tSymbol, 32L);
        this.paramTypes = List.of();
        this.env = env;
    }

    public void addParamType(BType type) {
        ArrayList<BType> newParams = new ArrayList<BType>(this.paramTypes);
        newParams.add(type);
        this.paramTypes = Collections.unmodifiableList(newParams);
    }

    public void setParamTypes(List<BType> paramTypes) {
        this.paramTypes = Collections.unmodifiableList(paramTypes);
    }

    public List<BType> getParameterTypes() {
        return this.paramTypes;
    }

    @Override
    public BType getReturnType() {
        return this.retType;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.FUNCTION;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        Object flagStr = "";
        if (Symbols.isFlagOn(this.getFlags(), 0x20000000L)) {
            flagStr = "isolated ";
        }
        if (Symbols.isFlagOn(this.getFlags(), 0x2000000L)) {
            flagStr = (String)flagStr + "transactional ";
        }
        if (Symbols.isFlagOn(this.getFlags(), 0x8000000000L)) {
            return (String)flagStr + "function";
        }
        return (String)flagStr + "function " + this.getTypeSignature();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BInvokableType)) {
            return false;
        }
        BInvokableType that = (BInvokableType)o;
        if (this.getFlags() != that.getFlags()) {
            return false;
        }
        if (this.paramTypes != null ? !this.paramTypes.equals(that.paramTypes) : that.paramTypes != null) {
            return false;
        }
        if (this.tsymbol != null ? !this.tsymbol.equals(that.tsymbol) : that.tsymbol != null) {
            return false;
        }
        if (this.retType != null ? !this.retType.equals(that.retType) : that.retType != null) {
            return false;
        }
        return this.restType != null ? this.restType.equals(that.restType) : that.restType == null;
    }

    public int hashCode() {
        int result = this.paramTypes != null ? this.paramTypes.hashCode() : 0;
        result = 31 * result + (this.retType != null ? this.retType.hashCode() : 0);
        return result;
    }

    public String getTypeSignature() {
        BType bType;
        Object retTypeWithParam = "()";
        if (this.retType != null && this.retType.getKind() != TypeKind.NIL) {
            retTypeWithParam = "(" + this.retType.toString() + ")";
        }
        Object restParam = "";
        if (this.restType != null && (bType = this.restType) instanceof BArrayType) {
            BArrayType bArrayType = (BArrayType)bType;
            if (!this.paramTypes.isEmpty()) {
                restParam = (String)restParam + ", ";
            }
            restParam = (String)restParam + String.valueOf(bArrayType.eType) + "...";
        }
        return "(" + (!this.paramTypes.isEmpty() ? BInvokableType.getBTypeListAsString(this.paramTypes) : "") + (String)restParam + ") returns " + (String)retTypeWithParam;
    }

    private static String getBTypeListAsString(List<BType> typeNames) {
        StringBuilder br = new StringBuilder();
        int i = 0;
        for (BType type : typeNames) {
            br.append(type);
            if (++i >= typeNames.size()) continue;
            br.append(",");
        }
        return br.toString();
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public void resetSemType() {
        this.defn = null;
    }

    @Override
    public SemType semType() {
        FunctionDefinition fd;
        if (this.isFunctionTop()) {
            if (Symbols.isFlagOn(this.getFlags(), 0x20000000L) || Symbols.isFlagOn(this.getFlags(), 0x2000000L)) {
                FunctionQualifiers qualifiers = FunctionQualifiers.from((Env)this.env, (boolean)Symbols.isFlagOn(this.getFlags(), 0x20000000L), (boolean)Symbols.isFlagOn(this.getFlags(), 0x2000000L));
                FunctionDefinition definition = new FunctionDefinition();
                return definition.define(this.env, (SemType)PredefinedType.NEVER, (SemType)PredefinedType.VAL, qualifiers);
            }
            return PredefinedType.FUNCTION;
        }
        if (this.defn != null) {
            return this.defn.getSemType(this.env);
        }
        this.defn = fd = new FunctionDefinition();
        List<SemType> params = this.paramTypes.stream().map(BInvokableType::from).toList();
        return this.getSemTypeWithParams(params, fd);
    }

    public SemType getSemTypeWithParams(List<SemType> params, FunctionDefinition fd) {
        BasicTypeBitSet rest;
        BType bType = this.restType;
        if (bType instanceof BArrayType) {
            BArrayType arrayType = (BArrayType)bType;
            rest = BInvokableType.from(arrayType.eType);
        } else {
            rest = PredefinedType.NEVER;
        }
        SemType returnType = this.resolveReturnType();
        ListDefinition paramListDefinition = new ListDefinition();
        SemType paramTypes = paramListDefinition.defineListTypeWrapped(this.env, params, params.size(), (SemType)rest, CellAtomicType.CellMutability.CELL_MUT_NONE);
        boolean isGeneric = Types.containsTypeParams(this);
        FunctionQualifiers qualifiers = FunctionQualifiers.from((Env)this.env, (boolean)Symbols.isFlagOn(this.getFlags(), 0x20000000L), (boolean)Symbols.isFlagOn(this.getFlags(), 0x2000000L));
        if (isGeneric) {
            return fd.defineGeneric(this.env, paramTypes, returnType, qualifiers);
        }
        return fd.define(this.env, paramTypes, returnType, qualifiers);
    }

    private SemType resolveReturnType() {
        if (this.retType == null) {
            return PredefinedType.NIL;
        }
        SemType innerType = BInvokableType.from(this.retType);
        ListDefinition ld = new ListDefinition();
        return ld.tupleTypeWrapped(this.env, new SemType[]{BInvokableType.isDependentlyTyped(this.retType, new HashSet<BType>()) ? SemTypes.booleanConst((boolean)true) : PredefinedType.BOOLEAN, innerType});
    }

    private static boolean isDependentlyTyped(BType returnType, Set<BType> visited) {
        if (visited.contains(returnType)) {
            return false;
        }
        visited.add(returnType);
        if (returnType instanceof BParameterizedType) {
            return true;
        }
        if (returnType instanceof BUnionType) {
            BUnionType unionType = (BUnionType)returnType;
            return unionType.getMemberTypes().stream().anyMatch(returnType1 -> BInvokableType.isDependentlyTyped(returnType1, visited));
        }
        if (returnType instanceof BMapType) {
            BMapType mapType = (BMapType)returnType;
            return BInvokableType.isDependentlyTyped(mapType.constraint, visited);
        }
        if (returnType instanceof BRecordType) {
            BRecordType recordType = (BRecordType)returnType;
            return recordType.fields.values().stream().anyMatch(field -> BInvokableType.isDependentlyTyped(field.type, visited)) || BInvokableType.isDependentlyTyped(recordType.restFieldType, visited);
        }
        if (returnType instanceof BArrayType) {
            BArrayType arrayType = (BArrayType)returnType;
            return BInvokableType.isDependentlyTyped(arrayType.eType, visited);
        }
        if (returnType instanceof BTupleType) {
            BTupleType tupleType = (BTupleType)returnType;
            return tupleType.getTupleTypes().stream().anyMatch(returnType1 -> BInvokableType.isDependentlyTyped(returnType1, visited));
        }
        if (returnType instanceof BInvokableType) {
            BInvokableType invokableType = (BInvokableType)returnType;
            return invokableType.paramTypes.stream().anyMatch(returnType1 -> BInvokableType.isDependentlyTyped(returnType1, visited)) || BInvokableType.isDependentlyTyped(invokableType.retType, visited) || BInvokableType.isDependentlyTyped(invokableType.restType, visited);
        }
        if (returnType instanceof BFutureType) {
            BFutureType futureType = (BFutureType)returnType;
            return BInvokableType.isDependentlyTyped(futureType.constraint, visited);
        }
        if (returnType instanceof BTableType) {
            BTableType tableType = (BTableType)returnType;
            return BInvokableType.isDependentlyTyped(tableType.constraint, visited);
        }
        if (returnType instanceof BStreamType) {
            BStreamType streamType = (BStreamType)returnType;
            return BInvokableType.isDependentlyTyped(streamType.constraint, visited);
        }
        return false;
    }

    private static SemType from(BType type) {
        SemType semType = type.semType();
        if (semType == null) {
            semType = PredefinedType.NEVER;
        }
        return semType;
    }

    private boolean isFunctionTop() {
        return this.paramTypes.isEmpty() && this.restType == null && this.retType == null;
    }
}

