/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import io.ballerina.types.CellAtomicType;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.definition.MappingDefinition;
import java.util.List;
import org.ballerinalang.model.types.ConstrainedType;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BMapType
extends BType
implements ConstrainedType,
SelectivelyImmutableReferenceType {
    public BType constraint;
    public BMapType mutableType;
    private final Env env;
    private MappingDefinition md = null;

    public BMapType(Env env, int tag, BType constraint, BTypeSymbol tsymbol) {
        super(tag, tsymbol);
        this.constraint = constraint;
        this.env = env;
    }

    public BMapType(Env env, int tag, BType constraint, BTypeSymbol tsymbol, long flags) {
        super(tag, tsymbol, flags);
        this.constraint = constraint;
        this.env = env;
    }

    protected void restMd() {
        this.md = null;
    }

    @Override
    public BType getConstraint() {
        return this.constraint;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.MAP;
    }

    @Override
    public String toString() {
        Object stringRep = this.constraint.tag == 18 ? super.toString() : super.toString() + "<" + String.valueOf(this.constraint) + ">";
        return !Symbols.isFlagOn(this.getFlags(), 32L) ? stringRep : ((String)stringRep).concat(" & readonly");
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    private boolean hasTypeHoles() {
        return this.constraint instanceof BNoType;
    }

    @Override
    public void resetSemType() {
        this.md = null;
    }

    @Override
    public SemType semType() {
        boolean isReadonly;
        if (this.md != null) {
            return this.md.getSemType(this.env);
        }
        this.md = new MappingDefinition();
        if (this.hasTypeHoles()) {
            return this.md.defineMappingTypeWrapped(this.env, List.of(), (SemType)PredefinedType.VAL);
        }
        SemType elementTypeSemType = this.constraint.semType();
        if (elementTypeSemType == null) {
            elementTypeSemType = PredefinedType.NEVER;
        }
        CellAtomicType.CellMutability mut = (isReadonly = Symbols.isFlagOn(this.getFlags(), 32L)) ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
        return this.md.defineMappingTypeWrapped(this.env, List.of(), elementTypeSemType, mut);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public void setFlags(long flags) {
        super.setFlags(flags);
        this.restMd();
    }

    @Override
    public void addFlags(long flags) {
        super.addFlags(flags);
        this.restMd();
    }
}

